/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.defaultmapping.collections;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.ArrayDequeContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.ArrayListContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.CollectionContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.DequeContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.EnumMapContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.EnumSetContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.HashSetContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.LinkedHashMapContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.LinkedHashSetContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.LinkedListContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.ListContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.MapContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.NavigableMapContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.NavigableSetContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.PriorityQueueContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.QueueContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.SetContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.SortedMapContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.SortedSetContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.TreeMapContainer;
import com.sun.ts.tests.jsonb.defaultmapping.collections.model.TreeSetContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;

public class CollectionsMappingTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        CollectionsMappingTest t = new CollectionsMappingTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testCollection() throws EETest.Fault {
        try {
            String jsonString = this.jsonb.toJson((Object)new CollectionContainer(){
                {
                    this.setInstance((Collection<String>)Arrays.asList("Test 1", "Test 2"));
                }
            });
            if (!jsonString.matches("\\{\\s*\"instance\"\\s*\\:\\s*\\[\\s*\"Test 1\"\\s*,\\s*\"Test 2\"\\s*\\]\\s*\\}")) {
                throw new EETest.Fault("Failed to get Collection attribute value.");
            }
        }
        catch (JsonbException x) {
            throw new EETest.Fault("An exception is not expected when marshalling a class with a Collection attribute.");
        }
        CollectionContainer unmarshalledObject = null;
        try {
            unmarshalledObject = (CollectionContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", CollectionContainer.class);
            if (!unmarshalledObject.getInstance().contains("Test 1") || !unmarshalledObject.getInstance().contains("Test 2")) {
                throw new EETest.Fault("Failed to marshal object with Collection attribute.");
            }
        }
        catch (JsonbException x) {
            System.out.append("Received:").println(Arrays.toString(unmarshalledObject.getInstance().toArray()));
            throw new EETest.Fault("An exception is not expected when unmarshalling a class with a Collection attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testMap() throws EETest.Fault {
        final HashMap<String, String> instance = new HashMap<String, String>(){
            {
                this.put("string1", "Test 1");
                this.put("string2", "Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new MapContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"string1\"\\s*:\\s*\"Test 1\"\\s*,\\s*\"string2\"\\s*:\\s*\"Test 2\"\\s*\\}\\s*\\}")) {
            throw new EETest.Fault("Failed to get Map attribute value.");
        }
        MapContainer unmarshalledObject = (MapContainer)this.jsonb.fromJson("{ \"instance\" : { \"string1\" : \"Test 1\", \"string2\" : \"Test 2\" } }", MapContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to marshal object with Map attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testSet() throws EETest.Fault {
        final HashSet<String> instance = new HashSet<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new SetContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test \\d\"\\s*,\\s*\"Test \\d\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to get Set attribute value.");
        }
        SetContainer unmarshalledObject = (SetContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", SetContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to marshal object with Set attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testHashSet() throws EETest.Fault {
        final HashSet<String> instance = new HashSet<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new HashSetContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test \\d\"\\s*,\\s*\"Test \\d\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to get HashSet attribute value.");
        }
        HashSetContainer unmarshalledObject = (HashSetContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", HashSetContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to marshal object with HashSet attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNavigableSet() throws EETest.Fault {
        final TreeSet<String> instance = new TreeSet<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new NavigableSetContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test \\d\"\\s*,\\s*\"Test \\d\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to get NavigableSet attribute value.");
        }
        NavigableSetContainer unmarshalledObject = (NavigableSetContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", NavigableSetContainer.class);
        if (!((Object)instance).equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to marshal object with NavigableSet attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testSortedSet() throws EETest.Fault {
        final TreeSet<String> instance = new TreeSet<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new SortedSetContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test \\d\"\\s*,\\s*\"Test \\d\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to get SortedSet attribute value.");
        }
        SortedSetContainer unmarshalledObject = (SortedSetContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", SortedSetContainer.class);
        if (!((Object)instance).equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to marshal object with SortedSet attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testTreeSet() throws EETest.Fault {
        final TreeSet<String> instance = new TreeSet<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new TreeSetContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test \\d\"\\s*,\\s*\"Test \\d\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to get TreeSet attribute value.");
        }
        TreeSetContainer unmarshalledObject = (TreeSetContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", TreeSetContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to marshal object with TreeSet attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testLinkedHashSet() throws EETest.Fault {
        final LinkedHashSet<String> instance = new LinkedHashSet<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new LinkedHashSetContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test \\d\"\\s*,\\s*\"Test \\d\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to get LinkedHashSet attribute value.");
        }
        LinkedHashSetContainer unmarshalledObject = (LinkedHashSetContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", LinkedHashSetContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to marshal object with LinkedHashSet attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testHashMap() throws EETest.Fault {
        final HashMap<String, String> instance = new HashMap<String, String>(){
            {
                this.put("string1", "Test 1");
                this.put("string2", "Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new MapContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"string1\"\\s*:\\s*\"Test 1\"\\s*,\\s*\"string2\"\\s*:\\s*\"Test 2\"\\s*\\}\\s*\\}")) {
            throw new EETest.Fault("Failed to get HashMap attribute value.");
        }
        MapContainer unmarshalledObject = (MapContainer)this.jsonb.fromJson("{ \"instance\" : { \"string1\" : \"Test 1\", \"string2\" : \"Test 2\" } }", MapContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to marshal object with HashMap attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNavigableMap() throws EETest.Fault {
        final TreeMap<String, String> instance = new TreeMap<String, String>(){
            {
                this.put("string1", "Test 1");
                this.put("string2", "Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new NavigableMapContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"string1\"\\s*:\\s*\"Test 1\"\\s*,\\s*\"string2\"\\s*:\\s*\"Test 2\"\\s*\\}\\s*\\}")) {
            throw new EETest.Fault("Failed to get NavigableMap attribute value.");
        }
        NavigableMapContainer unmarshalledObject = (NavigableMapContainer)this.jsonb.fromJson("{ \"instance\" : { \"string1\" : \"Test 1\", \"string2\" : \"Test 2\" } }", NavigableMapContainer.class);
        if (!((Object)instance).equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to marshal object with NavigableMap attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testSortedMap() throws EETest.Fault {
        final TreeMap<String, String> instance = new TreeMap<String, String>(){
            {
                this.put("string1", "Test 1");
                this.put("string2", "Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new SortedMapContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"string1\"\\s*:\\s*\"Test 1\"\\s*,\\s*\"string2\"\\s*:\\s*\"Test 2\"\\s*\\}\\s*\\}")) {
            throw new EETest.Fault("Failed to get SortedMap attribute value.");
        }
        SortedMapContainer unmarshalledObject = (SortedMapContainer)this.jsonb.fromJson("{ \"instance\" : { \"string1\" : \"Test 1\", \"string2\" : \"Test 2\" } }", SortedMapContainer.class);
        if (!((Object)instance).equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to marshal object with SortedMap attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testTreeMap() throws EETest.Fault {
        final TreeMap<String, String> instance = new TreeMap<String, String>(){
            {
                this.put("string1", "Test 1");
                this.put("string2", "Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new TreeMapContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"string1\"\\s*:\\s*\"Test 1\"\\s*,\\s*\"string2\"\\s*:\\s*\"Test 2\"\\s*\\}\\s*\\}")) {
            throw new EETest.Fault("Failed to get TreeMap attribute value.");
        }
        TreeMapContainer unmarshalledObject = (TreeMapContainer)this.jsonb.fromJson("{ \"instance\" : { \"string1\" : \"Test 1\", \"string2\" : \"Test 2\" } }", TreeMapContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to marshal object with TreeMap attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testLinkedHashMap() throws EETest.Fault {
        final LinkedHashMap<String, String> instance = new LinkedHashMap<String, String>(){
            {
                this.put("string1", "Test 1");
                this.put("string2", "Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new LinkedHashMapContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"string1\"\\s*:\\s*\"Test 1\"\\s*,\\s*\"string2\"\\s*:\\s*\"Test 2\"\\s*\\}\\s*\\}")) {
            throw new EETest.Fault("Failed to get LinkedHashMap attribute value.");
        }
        LinkedHashMapContainer unmarshalledObject = (LinkedHashMapContainer)this.jsonb.fromJson("{ \"instance\" : { \"string1\" : \"Test 1\", \"string2\" : \"Test 2\" } }", LinkedHashMapContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to marshal object with LinkedHashMap attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testList() throws EETest.Fault {
        final ArrayList<String> instance = new ArrayList<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new ListContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test \\d\"\\s*,\\s*\"Test \\d\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to get List attribute value.");
        }
        ListContainer unmarshalledObject = (ListContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", ListContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to marshal object with List attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testArrayList() throws EETest.Fault {
        final ArrayList<String> instance = new ArrayList<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new ArrayListContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test \\d\"\\s*,\\s*\"Test \\d\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to get ArrayList attribute value.");
        }
        ArrayListContainer unmarshalledObject = (ArrayListContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", ArrayListContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to marshal object with ArrayList attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testLinkedList() throws EETest.Fault {
        final LinkedList<String> instance = new LinkedList<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new LinkedListContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test \\d\"\\s*,\\s*\"Test \\d\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to get LinkedList attribute value.");
        }
        LinkedListContainer unmarshalledObject = (LinkedListContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", LinkedListContainer.class);
        if (!instance.equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to marshal object with LinkedList attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testDeque() throws EETest.Fault {
        final ArrayDeque<String> instance = new ArrayDeque<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new DequeContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test \\d\"\\s*,\\s*\"Test \\d\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to get Deque attribute value.");
        }
        DequeContainer unmarshalledObject = (DequeContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", DequeContainer.class);
        if (!Arrays.asList(instance.toArray()).equals(Arrays.asList(unmarshalledObject.getInstance().toArray()))) {
            throw new EETest.Fault("Failed to marshal object with Deque attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testArrayDeque() throws EETest.Fault {
        final ArrayDeque<String> instance = new ArrayDeque<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new ArrayDequeContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test \\d\"\\s*,\\s*\"Test \\d\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to get ArrayDeque attribute value.");
        }
        ArrayDequeContainer unmarshalledObject = (ArrayDequeContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", ArrayDequeContainer.class);
        if (!Arrays.asList(instance.toArray()).equals(Arrays.asList(((ArrayDeque)unmarshalledObject.getInstance()).toArray()))) {
            throw new EETest.Fault("Failed to marshal object with ArrayDeque attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testQueue() throws EETest.Fault {
        final LinkedList<String> instance = new LinkedList<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new QueueContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test \\d\"\\s*,\\s*\"Test \\d\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to get Queue attribute value.");
        }
        QueueContainer unmarshalledObject = (QueueContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", QueueContainer.class);
        if (!Arrays.asList(instance.toArray()).equals(Arrays.asList(unmarshalledObject.getInstance().toArray()))) {
            throw new EETest.Fault("Failed to marshal object with Queue attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testPriorityQueue() throws EETest.Fault {
        final PriorityQueue<String> instance = new PriorityQueue<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new PriorityQueueContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test \\d\"\\s*,\\s*\"Test \\d\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to get PriorityQueue attribute value.");
        }
        PriorityQueueContainer unmarshalledObject = (PriorityQueueContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", PriorityQueueContainer.class);
        if (!Arrays.asList(instance.toArray()).equals(Arrays.asList(((PriorityQueue)unmarshalledObject.getInstance()).toArray()))) {
            throw new EETest.Fault("Failed to marshal object with PriorityQueue attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testEnumSet() throws EETest.Fault {
        final EnumSet<EnumSetContainer.Enum> instance = EnumSet.allOf(EnumSetContainer.Enum.class);
        String jsonString = this.jsonb.toJson((Object)new EnumSetContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"ONE\"\\s*,\\s*\"TWO\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to get EnumSet attribute value.");
        }
        try {
            this.jsonb.fromJson("{ \"instance\" : [ \"ONE\", \"TWO\" ] }", EnumSetContainer.class);
            throw new EETest.Fault("An exception is expected when unmarshalling a class with an EnumSet attribute.");
        }
        catch (JsonbException x) {
            return Status.passed((String)"OK");
        }
    }

    public Status testEnumMap() throws EETest.Fault {
        final EnumMap<EnumSetContainer.Enum, String> instance = new EnumMap<EnumSetContainer.Enum, String>(EnumSetContainer.Enum.class){
            {
                this.put(EnumSetContainer.Enum.ONE, "Test 1");
                this.put(EnumSetContainer.Enum.TWO, "Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new EnumMapContainer(){
            {
                this.setInstance(instance);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"ONE\"\\s*:\\s*\"Test 1\"\\s*,\\s*\"TWO\"\\s*:\\s*\"Test 2\"\\s*\\}\\s*\\}")) {
            throw new EETest.Fault("Failed to get EnumMap attribute value.");
        }
        try {
            this.jsonb.fromJson("{ \"instance\" : { \"ONE\" : \"Test 1\", \"TWO\" : \"Test 2\" } }", EnumMapContainer.class);
            throw new EETest.Fault("An exception is expected when unmarshalling a class with an EnumMap attribute.");
        }
        catch (JsonbException x) {
            return Status.passed((String)"OK");
        }
    }
}

