/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.metamodelapi.identifiabletype;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.metamodelapi.identifiabletype.A;
import com.sun.ts.tests.jpa.core.metamodelapi.identifiabletype.Address;
import com.sun.ts.tests.jpa.core.metamodelapi.identifiabletype.DID2Employee;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void getId() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                SingularAttribute idAttrib = iType.getId(String.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.String")) {
                    TestUtil.logTrace((String)("Received expected: " + name));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected java.lang.String, actual:" + name));
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getId failed");
        }
    }

    public void getIdIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained A Entity");
                try {
                    iType.getId(Date.class);
                    TestUtil.logTrace((String)"Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getIdIllegalArgumentException failed");
        }
    }

    public void getVersion() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                SingularAttribute idAttrib = iType.getVersion(Integer.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.Integer")) {
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected java.lang.Integer, actual:" + name));
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getVersion failed");
        }
    }

    public void getVersionIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained A Entity");
                try {
                    iType.getVersion(Date.class);
                    TestUtil.logTrace((String)"Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getVersionIllegalArgumentException failed");
        }
    }

    public void getDeclaredId() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                TestUtil.logTrace((String)"entityType Name = A");
                SingularAttribute idAttrib = iType.getDeclaredId(String.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.String")) {
                    TestUtil.logTrace((String)("Received expected name:" + name));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected java.lang.String, actual:" + name));
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredId failed");
        }
    }

    public void getDeclaredIdIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained A IdentifiableType");
                try {
                    iType.getDeclaredId(Date.class);
                    TestUtil.logTrace((String)"Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredIdIllegalArgumentException failed");
        }
    }

    public void getDeclaredVersion() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            Set aSet = metaModel.getEntities();
            if (aSet != null) {
                TestUtil.logTrace((String)"Obtained Non-null Set of EntityType");
                EntityType iType = metaModel.entity(A.class);
                TestUtil.logTrace((String)("entityType Name = " + iType.getName()));
                SingularAttribute idAttrib = iType.getDeclaredVersion(Integer.class);
                String name = idAttrib.getName();
                if (name.equals("value")) {
                    TestUtil.logTrace((String)("Received:" + name));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: value, actual:" + name));
                }
            } else {
                TestUtil.logErr((String)"getEntities(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredVersion failed");
        }
    }

    public void getDeclaredVersionIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            Set aSet = metaModel.getEntities();
            if (aSet != null) {
                TestUtil.logTrace((String)"Obtained Non-null Set of EntityType");
                EntityType iType = metaModel.entity(A.class);
                TestUtil.logTrace((String)("entityType Name = " + iType.getName()));
                try {
                    iType.getDeclaredVersion(Date.class);
                    TestUtil.logTrace((String)"Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                }
            } else {
                TestUtil.logErr((String)"getEntities(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredVersionIllegalArgumentException failed");
        }
    }

    public void getSupertype() throws EETest.Fault {
        boolean pass = false;
        String expected = "com.sun.ts.tests.jpa.core.metamodelapi.identifiabletype.B";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)("entityType Name = " + iType.getName()));
                IdentifiableType idType = iType.getSupertype();
                String name = idType.getJavaType().getName();
                if (name.equals(expected)) {
                    TestUtil.logTrace((String)("getSuperType() returned:" + name));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: " + expected + ", actual:" + name));
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSupertype failed");
        }
    }

    public void hasSingleIdAttribute() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)("entityType Name = " + iType.getName()));
                boolean hasSingleIdAttribute = iType.hasSingleIdAttribute();
                if (hasSingleIdAttribute) {
                    pass = true;
                    TestUtil.logTrace((String)("hasSingleIdAttribute() returned" + hasSingleIdAttribute));
                } else {
                    TestUtil.logErr((String)("Expected: false, actual:" + hasSingleIdAttribute));
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("hasSingleIdAttribute failed");
        }
    }

    public void hasVersionAttribute() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)("entityType Name = " + iType.getName()));
                boolean hasVersionAttribute = iType.hasVersionAttribute();
                if (hasVersionAttribute) {
                    pass = true;
                    TestUtil.logTrace((String)("hasSingleIdAttribute() returned" + hasVersionAttribute));
                } else {
                    TestUtil.logErr((String)("Expected: false, actual:" + hasVersionAttribute));
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("hasVersionAttribute failed");
        }
    }

    public void getIdClassAttributes() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(DID2Employee.class);
            if (iType != null) {
                Set idClassAttribSet = iType.getIdClassAttributes();
                if (idClassAttribSet != null) {
                    for (SingularAttribute attrib : idClassAttribSet) {
                        TestUtil.logTrace((String)("attribute Name = " + attrib.getName()));
                    }
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getIdClassAttributes failed");
        }
    }

    public void getIdClassAttributesIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained A Entity");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getIdClassAttributes();
                    TestUtil.logTrace((String)"Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getIdClassAttributesIllegalArgumentException failed");
        }
    }

    public void getIdType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                Type idType = iType.getIdType();
                if (idType != null) {
                    TestUtil.logTrace((String)("idType Name = " + idType.getJavaType()));
                    String name = idType.getJavaType().getName();
                    if (name.equals("java.lang.String")) {
                        TestUtil.logTrace((String)("Received expected: " + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected java.lang.String, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getIdType() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getIdType failed");
        }
    }

    public void getAttribute() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                Attribute attrib = iType.getAttribute("id");
                if (attrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + attrib.getName()));
                    String name = attrib.getName();
                    if (name.equals("id")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: id, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getAttribute(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getAttribute failed");
        }
    }

    public void getAttributeIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                try {
                    iType.getAttribute("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getAttributeIllegalArgumentException failed");
        }
    }

    public void getAttributes() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cAddress");
        expected.add("cAddress_inherited");
        expected.add("id");
        expected.add("lAddress");
        expected.add("lAddress_inherited");
        expected.add("mAddress");
        expected.add("mAddress_inherited");
        expected.add("name");
        expected.add("sAddress");
        expected.add("sAddress_inherited");
        expected.add("value");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                Set set = iType.getAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            TestUtil.logTrace((String)"Received expected attributes");
                            for (String attribName : expected) {
                                TestUtil.logTrace((String)("attrib:" + attribName));
                            }
                            pass = true;
                        } else {
                            TestUtil.logErr((String)"Received unexpected attributes");
                            TestUtil.logErr((String)("Expected(" + expected.size() + "):"));
                            for (String attribName : expected) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                            TestUtil.logErr((String)("Actual(" + actual.size() + "):"));
                            for (String attribName : actual) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                        }
                    } else {
                        TestUtil.logErr((String)"getAttributes() returned 0 results");
                    }
                } else {
                    TestUtil.logErr((String)"getAttributes() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getAttributes failed");
        }
    }

    public void getCollectionStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                CollectionAttribute cAttrib = iType.getCollection("cAddress", Address.class);
                if (cAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + cAttrib.getName()));
                    String name = cAttrib.getName();
                    if (name.equals("cAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: cAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getCollection(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getCollectionStringClass failed");
        }
    }

    public void getCollectionStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getCollection("doesnotexist", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getCollectionStringClassIllegalArgumentException failed");
        }
    }

    public void getCollectionString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                CollectionAttribute cAttrib = iType.getCollection("cAddress");
                if (cAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + cAttrib.getName()));
                    String name = cAttrib.getName();
                    if (name.equals("cAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: cAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getCollection(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getCollectionString failed");
        }
    }

    public void getCollectionStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getCollection("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getCollectionStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredAttribute() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                Attribute attrib = iType.getDeclaredAttribute("cAddress");
                if (attrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + attrib.getName()));
                    String name = attrib.getName();
                    if (name.equals("cAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: cAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredAttribute(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredAttribute failed");
        }
    }

    public void getDeclaredAttributeIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredAttribute("cAddress_inherited");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredAttributeIllegalArgumentException failed");
        }
    }

    public void getDeclaredAttributes() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("cAddress");
        expected.add("lAddress");
        expected.add("mAddress");
        expected.add("sAddress");
        expected.add("value");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                Set set = iType.getDeclaredAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            TestUtil.logTrace((String)"Received expected attributes");
                            for (String attribName : expected) {
                                TestUtil.logTrace((String)("attrib:" + attribName));
                            }
                            pass = true;
                        } else {
                            TestUtil.logErr((String)"Received unexpected attributes");
                            TestUtil.logErr((String)("Expected(" + expected.size() + "):"));
                            for (String attribName : expected) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                            TestUtil.logErr((String)("Actual(" + actual.size() + "):"));
                            for (String attribName : actual) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                        }
                    } else {
                        TestUtil.logErr((String)"getAttributes() returned 0 results");
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredAttributes() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredAttributes failed");
        }
    }

    public void getDeclaredCollectionStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                CollectionAttribute cAttrib = iType.getCollection("cAddress", Address.class);
                if (cAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + cAttrib.getName()));
                    String name = cAttrib.getName();
                    if (name.equals("cAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: cAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getCollection(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredCollectionStringClass failed");
        }
    }

    public void getDeclaredCollectionStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredCollection("cAddress_inherited", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredCollectionStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredCollectionString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                CollectionAttribute cAttrib = iType.getCollection("cAddress", Address.class);
                if (cAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + cAttrib.getName()));
                    String name = cAttrib.getName();
                    if (name.equals("cAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: cAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getCollection(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredCollectionString failed");
        }
    }

    public void getDeclaredCollectionStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredCollection("cAddress_inherited", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredCollectionStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredListStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                ListAttribute lAttrib = iType.getDeclaredList("lAddress", Address.class);
                if (lAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + lAttrib.getName()));
                    String name = lAttrib.getName();
                    if (name.equals("lAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: lAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredList(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredListStringClass failed");
        }
    }

    public void getDeclaredListStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredList("lAddress_inherited", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredListStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredListString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                ListAttribute lAttrib = iType.getDeclaredList("lAddress");
                if (lAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + lAttrib.getName()));
                    String name = lAttrib.getName();
                    if (name.equals("lAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: lAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredList(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredListString failed");
        }
    }

    public void getDeclaredListStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredList("lAddress_inherited");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredListStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredMapStringClassClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                MapAttribute mAttrib = iType.getDeclaredMap("mAddress", Address.class, String.class);
                if (mAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + mAttrib.getName()));
                    String name = mAttrib.getName();
                    if (name.equals("mAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: mAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredMap(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredMapStringClassClass failed");
        }
    }

    public void getDeclaredMapStringClassClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredMap("mAddress_inherited", Address.class, String.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredMapStringClassClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredMapString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                MapAttribute mAttrib = iType.getDeclaredMap("mAddress");
                if (mAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + mAttrib.getName()));
                    String name = mAttrib.getName();
                    if (name.equals("mAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: mAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredMap(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredMapString failed");
        }
    }

    public void getDeclaredMapStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredMap("mAddress_inherited");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredMapStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredSetStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                SetAttribute sAttrib = iType.getDeclaredSet("sAddress", Address.class);
                if (sAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + sAttrib.getName()));
                    String name = sAttrib.getName();
                    if (name.equals("sAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: sAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredSet(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSetStringClass failed");
        }
    }

    public void getDeclaredSetStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredSet("sAddress_inherited", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSetStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredSetString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                SetAttribute sAttrib = iType.getDeclaredSet("sAddress");
                if (sAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + sAttrib.getName()));
                    String name = sAttrib.getName();
                    if (name.equals("sAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: sAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredSet(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSetString failed");
        }
    }

    public void getDeclaredSetStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredSet("sAddress_inherited");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSetStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredSingularAttributeStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                SingularAttribute singAttrib = iType.getDeclaredSingularAttribute("value", Integer.class);
                if (singAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + singAttrib.getName()));
                    String name = singAttrib.getName();
                    if (name.equals("value")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: value, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredSingularAttribute(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSingularAttributeStringClass failed");
        }
    }

    public void getDeclaredSingularAttributeStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                try {
                    iType.getDeclaredSingularAttribute("name", String.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSingularAttributeStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredSingularAttributeString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                SingularAttribute singAttrib = iType.getDeclaredSingularAttribute("value");
                if (singAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + singAttrib.getName()));
                    String name = singAttrib.getName();
                    if (name.equals("value")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: value, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredSingularAttribute(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSingularAttributeString failed");
        }
    }

    public void getDeclaredSingularAttributeStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                try {
                    iType.getDeclaredSingularAttribute("name");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSingularAttributeStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredSingularAttributes() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("name");
        expected.add("value");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                Set set = iType.getDeclaredSingularAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            TestUtil.logTrace((String)"Received expected attributes");
                            for (String attribName : expected) {
                                TestUtil.logTrace((String)("attrib:" + attribName));
                            }
                            pass = true;
                        } else {
                            TestUtil.logErr((String)"Received unexpected attributes");
                            TestUtil.logErr((String)("Expected(" + expected.size() + "):"));
                            for (String attribName : expected) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                            TestUtil.logErr((String)("Actual(" + actual.size() + "):"));
                            for (String attribName : actual) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                        }
                    } else {
                        TestUtil.logErr((String)"getDeclaredSingularAttributes() returned 0 results");
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredSingularAttributes() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSingularAttributes failed");
        }
    }

    public void getListStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                ListAttribute lAttrib = iType.getList("lAddress", Address.class);
                if (lAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + lAttrib.getName()));
                    String name = lAttrib.getName();
                    if (name.equals("lAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: lAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getList(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getListStringClass failed");
        }
    }

    public void getListStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getList("doesnotexist", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getListStringClassIllegalArgumentException failed");
        }
    }

    public void getListString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                ListAttribute lAttrib = iType.getList("lAddress");
                if (lAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + lAttrib.getName()));
                    String name = lAttrib.getName();
                    if (name.equals("lAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: lAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getList(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getListString failed");
        }
    }

    public void getListStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getDeclaredList("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getListStringIllegalArgumentException failed");
        }
    }

    public void getMapStringClassClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                MapAttribute mAttrib = iType.getMap("mAddress", Address.class, String.class);
                if (mAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + mAttrib.getName()));
                    String name = mAttrib.getName();
                    if (name.equals("mAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: mAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getMap(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getMapStringClassClass failed");
        }
    }

    public void getMapStringClassClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getMap("doesnotexist", Address.class, String.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getMapStringClassClassIllegalArgumentException failed");
        }
    }

    public void getMapString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                MapAttribute mAttrib = iType.getMap("mAddress");
                if (mAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + mAttrib.getName()));
                    String name = mAttrib.getName();
                    if (name.equals("mAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: mAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getMap(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getMapString failed");
        }
    }

    public void getMapStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getMap("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getMapStringIllegalArgumentException failed");
        }
    }

    public void getPluralAttributes() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cAddress");
        expected.add("cAddress_inherited");
        expected.add("lAddress");
        expected.add("lAddress_inherited");
        expected.add("mAddress");
        expected.add("mAddress_inherited");
        expected.add("sAddress");
        expected.add("sAddress_inherited");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                Set set = iType.getPluralAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            TestUtil.logTrace((String)"Received expected attributes");
                            for (String attribName : expected) {
                                TestUtil.logTrace((String)("attrib:" + attribName));
                            }
                            pass = true;
                        } else {
                            TestUtil.logErr((String)"Received unexpected attributes");
                            TestUtil.logErr((String)("Expected(" + expected.size() + "):"));
                            for (String attribName : expected) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                            TestUtil.logErr((String)("Actual(" + actual.size() + "):"));
                            for (String attribName : actual) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                        }
                    } else {
                        TestUtil.logErr((String)"getPluralAttributes() returned 0 results");
                    }
                } else {
                    TestUtil.logErr((String)"getPluralAttributes() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getPluralAttributes failed");
        }
    }

    public void getDeclaredPluralAttributes() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cAddress");
        expected.add("lAddress");
        expected.add("mAddress");
        expected.add("sAddress");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                Set set = iType.getDeclaredPluralAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            TestUtil.logTrace((String)"Received expected attributes");
                            for (String attribName : expected) {
                                TestUtil.logTrace((String)("attrib:" + attribName));
                            }
                            pass = true;
                        } else {
                            TestUtil.logErr((String)"Received unexpected attributes");
                            TestUtil.logErr((String)("Expected(" + expected.size() + "):"));
                            for (String attribName : expected) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                            TestUtil.logErr((String)("Actual(" + actual.size() + "):"));
                            for (String attribName : actual) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                        }
                    } else {
                        TestUtil.logErr((String)"getPluralAttributes() returned 0 results");
                    }
                } else {
                    TestUtil.logErr((String)"getPluralAttributes() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredPluralAttributes failed");
        }
    }

    public void getSetStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                SetAttribute sAttrib = iType.getSet("sAddress", Address.class);
                if (sAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + sAttrib.getName()));
                    String name = sAttrib.getName();
                    if (name.equals("sAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: sAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getSet(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSetStringClass failed");
        }
    }

    public void getSetStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getSet("doesnotexist", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSetStringClassIllegalArgumentException failed");
        }
    }

    public void getSetString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                SetAttribute sAttrib = iType.getSet("sAddress");
                if (sAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + sAttrib.getName()));
                    String name = sAttrib.getName();
                    if (name.equals("sAddress")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: sAddress, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getSet(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSetString failed");
        }
    }

    public void getSetStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                try {
                    iType.getSet("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSetStringIllegalArgumentException failed");
        }
    }

    public void getSingularAttributeStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                SingularAttribute singAttrib = iType.getSingularAttribute("name", String.class);
                if (singAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + singAttrib.getName()));
                    String name = singAttrib.getName();
                    if (name.equals("name")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: name, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getSingularAttribute(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSingularAttributeStringClass failed");
        }
    }

    public void getSingularAttributeStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                try {
                    iType.getSingularAttribute("doesnotexist", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSingularAttributeStringClassIllegalArgumentException failed");
        }
    }

    public void getSingularAttributeString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                SingularAttribute singAttrib = iType.getSingularAttribute("name");
                if (singAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + singAttrib.getName()));
                    String name = singAttrib.getName();
                    if (name.equals("name")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: name, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getSingularAttribute(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSingularAttributeString failed");
        }
    }

    public void getSingularAttributeStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                try {
                    iType.getSingularAttribute("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSingularAttributeStringIllegalArgumentException failed");
        }
    }

    public void getSingularAttributes() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("name");
        expected.add("value");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType iType = metaModel.entity(A.class);
            if (iType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity A");
                Set set = iType.getSingularAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            TestUtil.logTrace((String)"Received expected attributes");
                            for (String attribName : expected) {
                                TestUtil.logTrace((String)("attrib:" + attribName));
                            }
                            pass = true;
                        } else {
                            TestUtil.logErr((String)"Received unexpected attributes");
                            TestUtil.logErr((String)("Expected(" + expected.size() + "):"));
                            for (String attribName : expected) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                            TestUtil.logErr((String)("Actual(" + actual.size() + "):"));
                            for (String attribName : actual) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                        }
                    } else {
                        TestUtil.logErr((String)"getSingularAttributes() returned 0 results");
                    }
                } else {
                    TestUtil.logErr((String)"getSingularAttributes(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSingularAttributes failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

