/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.callStmt.callStmt4;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;

public class callStmtClient4
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.callStmt.callStmt4";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private rsSchema rsSch = null;
    private JDBCTestMsg msg = null;
    private String drManager = null;
    private Properties sqlp = null;
    private transient DatabaseMetaData dbmd = null;
    private CallableStatement cstmt = null;
    private Properties props = null;

    public static void main(String[] args) {
        callStmtClient4 theTests = new callStmtClient4();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.rsSch = new rsSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject21() throws EETest.Fault {
        Time oRetVal = null;
        Time nonNullTimeVal = null;
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Time_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 92);
            this.cstmt.registerOutParameter(2, 92);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            oRetVal = (Time)this.cstmt.getObject(1);
            String sRetStr = this.rsSch.extractVal("Time_Tab", 1, this.sqlp, this.conn);
            sRetStr = sRetStr.substring(sRetStr.indexOf(39) + 1, sRetStr.lastIndexOf(39));
            nonNullTimeVal = Time.valueOf(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(nonNullTimeVal)) {
                this.msg.setMsg("getObject returns the Break Time for type Time ");
            } else {
                this.msg.printTestError("getObject did not return the proper Break Time for type Time", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject22() throws EETest.Fault {
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Time_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 92);
            this.cstmt.registerOutParameter(2, 92);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("Calling CallableStatement.getObject(Time.NullValue)");
            this.msg.setMsg("invoke getObject method");
            Time oRetVal = (Time)this.cstmt.getObject(2);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the null value for type Time ");
            } else {
                this.msg.printTestError("getObject did not return the null value for type Time", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject23() throws EETest.Fault {
        Timestamp oRetVal = null;
        Timestamp nonNullTimestampVal = null;
        try {
            this.rsSch.createTab("Timestamp_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Timestamp_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 93);
            this.cstmt.registerOutParameter(2, 93);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            oRetVal = (Timestamp)this.cstmt.getObject(1);
            String sRetStr = this.rsSch.extractVal("Timestamp_Tab", 1, this.sqlp, this.conn);
            sRetStr = sRetStr.substring(sRetStr.indexOf(39) + 1, sRetStr.lastIndexOf(39));
            nonNullTimestampVal = Timestamp.valueOf(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(nonNullTimestampVal)) {
                this.msg.setMsg("getObject returns the In Time for type Timestamp " + oRetVal);
            } else {
                this.msg.printTestError("getObject did not return the proper In Time for type Timestamp", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject24() throws EETest.Fault {
        try {
            this.rsSch.createTab("Timestamp_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Timestamp_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 93);
            this.cstmt.registerOutParameter(2, 93);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("Calling CallableStatement.getObject(Timestamp.NullValue)");
            this.msg.setMsg("invoke getObject method");
            Timestamp oRetVal = (Timestamp)this.cstmt.getObject(2);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the null value for type Timestamp ");
            } else {
                this.msg.printTestError("getObject did not return the null value for type Timestamp", "test getObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject25() throws EETest.Fault {
        Date oRetVal = null;
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Date_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 91);
            this.cstmt.registerOutParameter(2, 91);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            oRetVal = (Date)this.cstmt.getObject(1);
            String sRetStr = this.rsSch.extractVal("Date_Tab", 1, this.sqlp, this.conn);
            sRetStr = sRetStr.substring(sRetStr.indexOf(39) + 1, sRetStr.lastIndexOf(39));
            sRetStr = sRetStr.trim();
            Date oExtVal = Date.valueOf(sRetStr);
            this.msg.addOutputMsg(oExtVal.toString(), oRetVal.toString());
            if (oRetVal.toString().equals(oExtVal.toString())) {
                this.msg.setMsg("getObject returns the proper Date for type Date ");
            } else {
                this.msg.printTestError("getObject did not return the proper Date for type Date", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject26() throws EETest.Fault {
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Date_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 91);
            this.cstmt.registerOutParameter(2, 91);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Date oRetVal = (Date)this.cstmt.getObject(2);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the null value for type Date ");
            } else {
                this.msg.printTestError("getObject did not return the null value for type Date", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject27() throws EETest.Fault {
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -6);
            this.cstmt.registerOutParameter(2, -6);
            this.cstmt.registerOutParameter(3, -6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Object obj = this.cstmt.getObject(1);
            Byte oRetVal = new Byte(obj.toString());
            String sRetStr = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            Byte oExtVal = new Byte(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.compareTo(oExtVal) == 0) {
                this.msg.setMsg("getObject returns the Maximum Value for type TINYINT ");
            } else {
                this.msg.printTestError("getObject did not return the Maximum Value for type TINYINT ", "test getObject failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject28() throws EETest.Fault {
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -6);
            this.cstmt.registerOutParameter(2, -6);
            this.cstmt.registerOutParameter(3, -6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Object obj = this.cstmt.getObject(2);
            Byte oRetVal = new Byte(obj.toString());
            String sRetStr = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            Byte oExtVal = new Byte(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.compareTo(oExtVal) == 0) {
                this.msg.setMsg("getObject returns the Minimum Value for type TINYINT " + oRetVal);
            } else {
                this.msg.printTestError("getObject did not return the Minimum Value for type TINYINT ", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject29() throws EETest.Fault {
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -6);
            this.cstmt.registerOutParameter(2, -6);
            this.cstmt.registerOutParameter(3, -6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Object oRetVal = this.cstmt.getObject(3);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the Null Value for type Byte(JDBC TINYINT) ");
            } else {
                this.msg.printTestError("getObject did not return the Null Value for type Byte(JDBC TINYINT)", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject30() throws EETest.Fault {
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 8);
            this.cstmt.registerOutParameter(2, 8);
            this.cstmt.registerOutParameter(3, 8);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Double oRetVal = (Double)this.cstmt.getObject(1);
            String sRetStr = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            Double oExtVal = new Double(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(oExtVal)) {
                this.msg.setMsg("getObject returns the Maximum Value for type Double(JDBC DOUBLE) ");
            } else {
                this.msg.printTestError("getObject did not return the Maximum Value for type Double(JDBC DOUBLE)", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject31() throws EETest.Fault {
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 8);
            this.cstmt.registerOutParameter(2, 8);
            this.cstmt.registerOutParameter(3, 8);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("Calling CallableStatement.getObject(Double.MinimumValue(JDBC DOUBLE))");
            this.msg.setMsg("invoke getObject method");
            Double oRetVal = (Double)this.cstmt.getObject(2);
            String sRetStr = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            Double oExtVal = new Double(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(oExtVal)) {
                this.msg.setMsg("getObject returns the Minimum Value for type Double(JDBC DOUBLE) ");
            } else {
                this.msg.printTestError("getObject did not return the Minimum Value for type Double(JDBC DOUBLE)", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject32() throws EETest.Fault {
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 8);
            this.cstmt.registerOutParameter(2, 8);
            this.cstmt.registerOutParameter(3, 8);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Double oRetVal = (Double)this.cstmt.getObject(3);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the Null Value for type Double(JDBC DOUBLE) ");
            } else {
                this.msg.printTestError("getObject did not return the Null Value for type Double(JDBC DOUBLE)", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject33() throws EETest.Fault {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Real_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 7);
            this.cstmt.registerOutParameter(2, 7);
            this.cstmt.registerOutParameter(3, 7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("Calling CallableStatement.getObject(Float.MaximumValue)");
            this.msg.setMsg("invoke getObject method");
            Float oRetVal = (Float)this.cstmt.getObject(1);
            String sRetStr = this.rsSch.extractVal("Real_Tab", 1, this.sqlp, this.conn);
            Float oExtVal = new Float(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(oExtVal)) {
                this.msg.setMsg("getObject returns the Maximum Value for type Float ");
            } else {
                this.msg.printTestError("getObject did not return the Maximum Value for type Float", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject34() throws EETest.Fault {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Real_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 7);
            this.cstmt.registerOutParameter(2, 7);
            this.cstmt.registerOutParameter(3, 7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Float oRetVal = (Float)this.cstmt.getObject(2);
            String sRetStr = this.rsSch.extractVal("Real_Tab", 2, this.sqlp, this.conn);
            Float oExtVal = new Float(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(oExtVal)) {
                this.msg.setMsg("getObject returns the Minimum Value for type Float ");
            } else {
                this.msg.printTestError("getObject did not return the Minimum Value for type Float", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject35() throws EETest.Fault {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Real_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 7);
            this.cstmt.registerOutParameter(2, 7);
            this.cstmt.registerOutParameter(3, 7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Float oRetVal = (Float)this.cstmt.getObject(3);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the Null Value for type Float ");
            } else {
                this.msg.printTestError("getObject did not return the Null Value for type Float", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject36() throws EETest.Fault {
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 12);
            this.cstmt.registerOutParameter(2, 12);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            String oRetVal = (String)this.cstmt.getObject(1);
            String oExtVal = this.rsSch.extractVal("Varchar_Tab", 1, this.sqlp, this.conn);
            oExtVal = oExtVal.trim();
            oRetVal = oRetVal.trim();
            this.msg.addOutputMsg(oExtVal, oRetVal);
            if (oRetVal.equals(oExtVal.substring(1, oExtVal.length() - 1))) {
                this.msg.setMsg("getObject returns the Name for type String(JDBC VARCHAR) ");
            } else {
                this.msg.printTestError("getObject did not return the Name for type String(JDBC VARCHAR)", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject37() throws EETest.Fault {
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 12);
            this.cstmt.registerOutParameter(2, 12);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            String oRetVal = (String)this.cstmt.getObject(2);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the null value for type String(JDBC VARCHAR) ");
            } else {
                this.msg.printTestError("getObject did not return the null value for type String(JDBC VARCHAR)", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject38() throws EETest.Fault {
        try {
            this.rsSch.createTab("Longvarchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Longvarchar_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            String oRetVal = (String)this.cstmt.getObject(1);
            String oExtVal = this.rsSch.extractVal("Longvarchar_Tab", 1, this.sqlp, this.conn);
            oExtVal = oExtVal.trim();
            oRetVal = oRetVal.trim();
            this.msg.addOutputMsg(oExtVal, oRetVal);
            if (oRetVal.equals(oExtVal.substring(1, oExtVal.length() - 1))) {
                this.msg.setMsg("getObject returns the Name for type String(JDBC LONGVARCHAR) ");
            } else {
                this.msg.printTestError("getObject did not return the Name for type String(JDBC LONGVARCHAR)", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject39() throws EETest.Fault {
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Lvarcharnull_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("Calling CallableStatement.getObject(String.NullValue(JDBC LONGVARCHAR))");
            this.msg.setMsg("invoke getObject method");
            String oRetVal = (String)this.cstmt.getObject(1);
            this.msg.addOutputMsg("null", oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the null value for type String(JDBC LONGVARCHAR) ");
            } else {
                this.msg.printTestError("getObject did not return the null value for type String(JDBC LONGVARCHAR)", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject40() throws EETest.Fault {
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Decimal_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 3, 15);
            this.cstmt.registerOutParameter(2, 3, 15);
            this.cstmt.registerOutParameter(3, 3, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            BigDecimal oRetVal = (BigDecimal)this.cstmt.getObject(1);
            String sRetStr = this.rsSch.extractVal("Decimal_Tab", 1, this.sqlp, this.conn);
            BigDecimal oExtVal = new BigDecimal(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.compareTo(oExtVal) == 0) {
                this.msg.setMsg("getObject returns the Maximum value for type BigDecimal(JDBC DECIMAL) ");
            } else {
                this.msg.printTestError("getObject did not return the Maximum value for type BigDecimal(JDBC DECIMAL)", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

