/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.api.Trigger;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.concurrency.api.common.CommonTriggers;
import com.sun.ts.tests.concurrency.common.counter.CounterRunnableTask;
import com.sun.ts.tests.concurrency.common.counter.StaticCounter;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.SkippedException;
import jakarta.enterprise.concurrent.Trigger;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.naming.InitialContext;

public class Client
extends ServiceEETest
implements Serializable {
    InitialContext context;
    ManagedScheduledExecutorService executorService;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            this.context = new InitialContext();
            this.executorService = (ManagedScheduledExecutorService)this.context.lookup("java:comp/DefaultManagedScheduledExecutorService");
            StaticCounter.reset();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
    }

    public void triggerGetNextRunTimeTest() throws EETest.Fault {
        ScheduledFuture sf = this.executorService.schedule((Runnable)new CounterRunnableTask(), (Trigger)new CommonTriggers.TriggerFixedRate(new Date(), 5000L));
        try {
            if (StaticCounter.getCount() != 0) {
                throw new RuntimeException("The first trigger is too fast.");
            }
            Thread.sleep(30000L);
            int result = StaticCounter.getCount();
            if (result < 5 || result > 7) {
                throw new RuntimeException("task run time should in range 5 to 7: yours is " + result);
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("triggerGetNextRunTimeTest failed", e);
        }
        finally {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void triggerSkipRunTest() throws EETest.Fault {
        ScheduledFuture sf = this.executorService.schedule(new Callable(){

            public Object call() {
                return "ok";
            }
        }, (Trigger)new CommonTriggers.OnceTriggerDelaySkip(5000L));
        long start = System.currentTimeMillis();
        while (!sf.isDone()) {
            try {
                sf.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (SkippedException se) {
                return;
            }
            catch (ExecutionException executionException) {
            }
            catch (InterruptedException | TimeoutException exception) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start <= 30000L) continue;
            throw new EETest.Fault("wait task timeout");
        }
        throw new EETest.Fault("SkippedException should be caught.");
    }
}

