/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.packaging.embed.classloader.annotated;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.lite.EJBLiteClientBase;
import com.sun.ts.tests.ejb30.lite.basic.common.GlobalJNDITest;
import com.sun.ts.tests.ejb30.lite.packaging.embed.classloader.annotated.LocalIF;
import com.sun.ts.tests.ejb30.lite.packaging.embed.classloader.annotated.TSDbUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class Client
extends EJBLiteClientBase {
    private Map<String, Object> containerInitProps = new HashMap<String, Object>();
    private String databaseName;
    private String driverName;
    private String databaseURL;
    private String databaseUser;
    private String databasePassword;
    private static final String APP_NAME = "root";

    @Override
    public Map<String, Object> getContainerInitProperties() {
        try {
            this.databaseName = TestUtil.getProperty((String)"jdbc.db");
            this.driverName = TestUtil.getProperty((String)(this.databaseName + ".driver"));
            this.databaseURL = TestUtil.getProperty((String)(this.databaseName + ".url"));
            this.databaseUser = TestUtil.getProperty((String)(this.databaseName + ".user"));
            this.databasePassword = TestUtil.getProperty((String)(this.databaseName + ".passwd"));
            TestUtil.logMsg((String)("Driver class Name =" + this.driverName));
            TestUtil.logMsg((String)("Database url =" + this.databaseURL));
            TestUtil.logMsg((String)("Database User = " + this.databaseUser));
            TestUtil.logMsg((String)("Database Password =" + this.databasePassword));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error reading properties");
        }
        this.containerInitProps.put("jakarta.ejb.embeddable.modules", this.getAdditionalModules());
        this.containerInitProps.put("jakarta.ejb.embeddable.appName", APP_NAME);
        return this.containerInitProps;
    }

    private URLClassLoader createClassLoader() {
        File[] modules = this.getAdditionalModules();
        if (modules == null || modules.length == 0) {
            Helper.getLogger().warning("additionalModules testArgs is null or empty: " + modules);
            return null;
        }
        Object[] urls = new URL[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            try {
                urls[i] = modules[i].toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        this.appendReason("Creating a classloader with additionalModule URLs: ", Arrays.toString(urls));
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = this.getClass().getClassLoader();
        }
        URLClassLoader cl = new URLClassLoader((URL[])urls, parent);
        return cl;
    }

    @Override
    public void setContextClassLoader() {
        URLClassLoader cl = this.createClassLoader();
        if (cl != null) {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void additionalModuleJar() throws Exception {
        this.additionalModule(this.getModuleName(), "ejbembed_two_ejb", "ejbembed_three_ejb");
    }

    public void additionalModuleDir() throws Exception {
        this.additionalModule(this.getModuleName(), "23", "23");
    }

    public void additionalModuleJarDir() throws Exception {
        this.additionalModule(this.getModuleName(), "2", "ejbembed_three_ejb");
    }

    protected void additionalModule(String moduleName1, String moduleName2, String moduleName3) throws Exception {
        File[] modPaths;
        this.appendReason("Created EJBContainer provider ", this.getContainer(), " with init properties: ");
        this.appendReason("jakarta.ejb.embeddable.appName = " + this.getContainerInitProperties().get("jakarta.ejb.embeddable.appName"));
        this.appendReason("jakarta.ejb.embeddable.modules = " + this.getContainerInitProperties().get("jakarta.ejb.embeddable.modules"));
        for (File f : modPaths = (File[])this.getContainerInitProperties().get("jakarta.ejb.embeddable.modules")) {
            this.appendReason(f.getAbsolutePath());
        }
        LocalIF oneBean = (LocalIF)this.lookup(GlobalJNDITest.getGlobalJNDIName(APP_NAME, moduleName1, "OneBean"), null, null);
        LocalIF twoBean = (LocalIF)this.lookup(GlobalJNDITest.getGlobalJNDIName(APP_NAME, moduleName2, "TwoBean"), null, null);
        LocalIF threeBean = (LocalIF)this.lookup(GlobalJNDITest.getGlobalJNDIName(APP_NAME, moduleName3, "ThreeBean"), null, null);
        List<String> expected2 = Arrays.asList("Setup called");
        this.assertEquals(null, expected2, oneBean.setupOneBean(this.databaseURL, this.databaseUser, this.databasePassword, this.driverName));
        List<String> expected = Arrays.asList("OneBean", "TwoBean", "ThreeBean");
        this.assertEquals(null, expected, oneBean.call123());
        this.assertEquals(null, expected, twoBean.call123());
        this.assertEquals(null, expected, threeBean.call123());
        this.appendReason(oneBean.lookupJNDINames(APP_NAME, moduleName1, moduleName2, moduleName3));
        this.appendReason(twoBean.lookupJNDINames(APP_NAME, moduleName1, moduleName2, moduleName3));
        this.appendReason(threeBean.lookupJNDINames(APP_NAME, moduleName1, moduleName2, moduleName3));
    }

    public void autoCloseTest() throws Exception {
        File[] modPaths;
        this.appendReason("Created EJBContainer provider ", this.getContainer(), " with init properties: ");
        this.appendReason("jakarta.ejb.embeddable.appName = " + this.getContainerInitProperties().get("jakarta.ejb.embeddable.appName"));
        this.appendReason("jakarta.ejb.embeddable.modules = " + this.getContainerInitProperties().get("jakarta.ejb.embeddable.modules"));
        for (File f : modPaths = (File[])this.getContainerInitProperties().get("jakarta.ejb.embeddable.modules")) {
            this.appendReason(f.getAbsolutePath());
        }
        LocalIF oneBean = (LocalIF)this.lookup(GlobalJNDITest.getGlobalJNDIName(APP_NAME, this.getModuleName(), "OneBean"), null, null);
        List<String> expected2 = Arrays.asList("Setup called");
        this.assertEquals(null, expected2, oneBean.setupOneBean(this.databaseURL, this.databaseUser, this.databasePassword, this.driverName));
        TSDbUtil tsDbUtil = new TSDbUtil(this.databaseURL, this.databaseUser, this.databasePassword, this.driverName);
        Connection connection = tsDbUtil.getConnection();
        String result = tsDbUtil.readFromDatabase(connection, "OneBean");
        TestUtil.logMsg((String)("Message read from Database =" + result));
        if (result == null || !result.equals("PreDestroy called")) {
            throw new EETest.Fault("autoCloseTest Failed for Embeddable EJB Container");
        }
        TestUtil.logMsg((String)"autoCloseTest Passed");
        tsDbUtil.deleteRecordFromDatabase(connection, "OneBean");
    }

    public void autoCloseTestWithArrayList() throws Exception {
        File[] modPaths;
        this.appendReason("Created EJBContainer provider ", this.getContainer(), " with init properties: ");
        this.appendReason("jakarta.ejb.embeddable.appName = " + this.getContainerInitProperties().get("jakarta.ejb.embeddable.appName"));
        this.appendReason("jakarta.ejb.embeddable.modules = " + this.getContainerInitProperties().get("jakarta.ejb.embeddable.modules"));
        for (File f : modPaths = (File[])this.getContainerInitProperties().get("jakarta.ejb.embeddable.modules")) {
            this.appendReason(f.getAbsolutePath());
        }
        LocalIF oneBean = (LocalIF)this.lookup(GlobalJNDITest.getGlobalJNDIName(APP_NAME, this.getModuleName(), "OneBean"), null, null);
        List<String> expected2 = Arrays.asList("Setup called");
        this.assertEquals(null, expected2, oneBean.setupOneBean(this.databaseURL, this.databaseUser, this.databasePassword, this.driverName));
        CopyOnWriteArrayList arrayList = new CopyOnWriteArrayList();
        List<String> expectedOutput = Arrays.asList("setupOneBeanWithArrayList called");
        this.assertEquals(null, expectedOutput, oneBean.setupOneBeanWithArrayList(arrayList));
        if (!arrayList.isEmpty()) {
            String tobeChecked = "OneBean PreDestroy called";
            boolean result = arrayList.contains(tobeChecked);
            if (!result) {
                TestUtil.logErr((String)"autoCloseTestWithArrayList Failed");
                throw new EETest.Fault("autoCloseTestWithArrayList Failed");
            }
        } else {
            TestUtil.logErr((String)"ArrayList empty : autoCloseTestWithArrayList Failed");
            throw new EETest.Fault("autoCloseTestWithArrayList Failed");
        }
        TestUtil.logMsg((String)"autoCloseTestWithArrayList Passed");
    }
}

