/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.assocoverride;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.assocoverride.Address;
import com.sun.ts.tests.jpa.core.annotations.assocoverride.PartTimeEmployee;
import java.sql.Date;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static PartTimeEmployee[] ptRef = new PartTimeEmployee[5];
    private static Address[] aRef = new Address[5];
    private final Date d1 = this.getSQLDate(2000, 2, 14);
    private final Date d2 = this.getSQLDate(2001, 6, 27);
    private final Date d3 = this.getSQLDate(2002, 7, 7);
    private final Date d4 = this.getSQLDate(2003, 3, 3);
    private final Date d5 = this.getSQLDate(2004, 4, 10);

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void associationOverride() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin AssociationOverride");
        boolean pass = false;
        try {
            PartTimeEmployee ptEmp1 = (PartTimeEmployee)this.getEntityManager().find(PartTimeEmployee.class, (Object)6);
            if (ptEmp1.getAddress().getStreet().equals("1 Network Drive")) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test2 failed");
        }
    }

    public void createTestData() {
        try {
            this.getEntityTransaction().begin();
            Client.ptRef[0] = new PartTimeEmployee(6, "Kellie", "Lee", this.d5, 60000.0f);
            Client.ptRef[1] = new PartTimeEmployee(7, "Nicole", "Martin", this.d4, 60000.0f);
            Client.ptRef[2] = new PartTimeEmployee(8, "Mark", "Francis", this.d3, 60000.0f);
            Client.ptRef[3] = new PartTimeEmployee(9, "Will", "Forrest", this.d2, 60000.0f);
            Client.ptRef[4] = new PartTimeEmployee(10, "Katy", "Hughes", this.d1, 60000.0f);
            Client.aRef[0] = new Address("100", "1 Network Drive", "Burlington", "MA", "01803");
            Client.aRef[1] = new Address("200", "4150 Network Drive", "Santa Clara", "CA", "95054");
            Client.aRef[2] = new Address("300", "2 Network Drive", "Burlington", "MA", "01803");
            Client.aRef[3] = new Address("400", "5150 Network Drive", "Santa Clara", "CA", "95054");
            Client.aRef[4] = new Address("500", "3 Network Drive", "Burlington", "MA", "01803");
            ptRef[0].setAddress(aRef[0]);
            ptRef[1].setAddress(aRef[1]);
            ptRef[2].setAddress(aRef[2]);
            ptRef[3].setAddress(aRef[3]);
            ptRef[4].setAddress(aRef[4]);
            TestUtil.logTrace((String)"Persist part time employees ");
            for (int i = 0; i < 5; ++i) {
                this.getEntityManager().persist((Object)aRef[i]);
                TestUtil.logTrace((String)("persisted Address " + aRef[i]));
                this.getEntityManager().persist((Object)ptRef[i]);
                TestUtil.logTrace((String)("persisted employee " + ptRef[i]));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception re) {
            TestUtil.logErr((String)"Unexpected Exception creating test data:", (Throwable)re);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception rolling back TX:", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from PARTTIMEEMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from ADDRESS").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

