/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedTopicSession;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import jakarta.jms.BytesMessage;
import jakarta.jms.IllegalStateException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;

public class ClosedTopicSessionTests
extends ServiceEETest {
    private static final String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
    private static final String testName = "com.sun.ts.tests.jms.core.closedTopicSession.ClosedTopicSessionTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String jmsUser;
    private String jmsPassword;
    private String mode;
    ArrayList connections = null;

    public static void main(String[] args) {
        ClosedTopicSessionTests theTests = new ClosedTopicSessionTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void createAndCloseSession(int type) throws Exception {
        if (type == 1 || type == 3) {
            this.tool = new JmsTool(type, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logMsg("Closing topic session");
            this.tool.getDefaultTopicSession().close();
        }
        this.logMsg("Session closed");
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            this.logMsg("Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.logTrace("In setup");
            this.jmsUser = p.getProperty("user");
            this.jmsPassword = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void closedTopicSessionCommitTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(3);
            this.logMsg("Try to call commit with closed session.");
            try {
                this.tool.getDefaultTopicSession().commit();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCommitTest");
        }
    }

    public void closedTopicSessionCloseTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to call close on closed session.");
            this.tool.getDefaultTopicSession().close();
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCloseTest");
        }
    }

    public void closedTopicSessionCreateDurableSubscriberTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create DurableSubscriber with closed session.");
            try {
                TopicSubscriber topicSubscriber = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "TestDurableSubscriber");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCreateDurableSubscriberTest");
        }
    }

    public void closedTopicSessionCreateDurableSubscriberMsgSelectorTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create DurableSubscriber with message selector using closed session.");
            try {
                TopicSubscriber topicSubscriber = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "TestDurableSubscriberMsgSelector", "TEST = 'test'", false);
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCreateDurableSubscriberMsgSelectorTest");
        }
    }

    public void closedTopicSessionCreateTopicTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create topic with closed session.");
            try {
                Topic topic = this.tool.getDefaultTopicSession().createTopic("closedTopicSessionCreateTopicTest");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCreateTopicTest");
        }
    }

    public void closedTopicSessionCreateSubscriberTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create Subscriber with closed session.");
            try {
                TopicSubscriber topicSubscriber = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic());
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCreateSubscriberTest");
        }
    }

    public void closedTopicSessionCreateSubscriberMsgSelectorTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create Subscriber with closed session.");
            try {
                TopicSubscriber topicSubscriber = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic(), "TEST = 'test'", false);
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCreateSubscriberMsgSelectorTest");
        }
    }

    public void closedTopicSessionCreatePublisherTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create Publisher with closed session.");
            try {
                TopicPublisher topicPublisher = this.tool.getDefaultTopicSession().createPublisher(this.tool.getDefaultTopic());
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCreatePublisherTest");
        }
    }

    public void closedTopicSessionCreateTempTopicTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create TemporaryTopic with closed session.");
            try {
                TemporaryTopic temporaryTopic = this.tool.getDefaultTopicSession().createTemporaryTopic();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCreateTempTopicTest");
        }
    }

    public void closedTopicSessionUnsubscribeTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to call unsubscribe with closed session.");
            try {
                this.tool.getDefaultTopicSession().unsubscribe("TestDurableSubscription");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionUnsubscribeTest");
        }
    }

    public void closedTopicSessionCreateMessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create message with closed session.");
            try {
                Message message = this.tool.getDefaultTopicSession().createMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCreateMessageTest");
        }
    }

    public void closedTopicSessionCreateBytesMessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create BytesMessage with closed session.");
            try {
                BytesMessage bytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCreateBytesMessageTest");
        }
    }

    public void closedTopicSessionCreateMapMessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create MapMessage with closed session.");
            try {
                MapMessage mapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCreateMapMessageTest");
        }
    }

    public void closedTopicSessionCreateObjectMessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create ObjectMessage with closed session.");
            try {
                ObjectMessage objectMessage = this.tool.getDefaultTopicSession().createObjectMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCreateObjectMessageTest");
        }
    }

    public void closedTopicSessionCreateObject2MessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create ObjectMessage(object) with closed session.");
            try {
                String s = "Simple object";
                ObjectMessage m = this.tool.getDefaultTopicSession().createObjectMessage((Serializable)((Object)s));
                if (m != null) {
                    this.logMsg("ObjectMessage=" + m);
                }
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCreateObject2MessageTest");
        }
    }

    public void closedTopicSessionCreateStreamMessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create StreamMessage with closed session.");
            try {
                StreamMessage streamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCreateStreamMessageTest");
        }
    }

    public void closedTopicSessionCreateTextMessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create TextMessage with closed session.");
            try {
                TextMessage textMessage = this.tool.getDefaultTopicSession().createTextMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCreateTextMessageTest");
        }
    }

    public void closedTopicSessionCreateText2MessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to create TextMessage with closed session.");
            try {
                TextMessage textMessage = this.tool.getDefaultTopicSession().createTextMessage("test message");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionCreateText2MessageTest");
        }
    }

    public void closedTopicSessionGetTransactedTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to call getTransacted() with closed session.");
            try {
                boolean bl = this.tool.getDefaultTopicSession().getTransacted();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionGetTransactedTest");
        }
    }

    public void closedTopicSessionRollbackTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to call rollback() with closed session.");
            try {
                this.tool.getDefaultTopicSession().rollback();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionRollbackTest");
        }
    }

    public void closedTopicSessionRecoverTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logMsg("Try to call recover() with closed session.");
            try {
                this.tool.getDefaultTopicSession().recover();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                passed = true;
            }
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedTopicSessionRecoverTest");
        }
    }

    public void closedTopicSessionSubscriberCloseTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call close again");
            this.tool.getDefaultTopicSubscriber().close();
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionSubscriberCloseTest", e);
        }
    }

    public void closedTopicSessionGetMessageSelectorTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getMessageSelector");
            try {
                String foo = this.tool.getDefaultTopicSubscriber().getMessageSelector();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionGetMessageSelectorTest", e);
        }
    }

    public void closedTopicSessionReceiveTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call receive");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receive();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionReceiveTest", e);
        }
    }

    public void closedTopicSessionReceiveTimeoutTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call receive(timeout)");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receive(this.timeout);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionReceiveTimeoutTest", e);
        }
    }

    public void closedTopicSessionReceiveNoWaitTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call receiveNoWait");
            try {
                Message foo = this.tool.getDefaultTopicSubscriber().receiveNoWait();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionReceiveNoWaitTest", e);
        }
    }

    public void closedTopicSessionGetNoLocalTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getNoLocal");
            try {
                boolean foo = this.tool.getDefaultTopicSubscriber().getNoLocal();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionGetNoLocalTest", e);
        }
    }

    public void closedTopicSessionSubscriberGetTopicTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getTopic");
            try {
                Topic foo = this.tool.getDefaultTopicSubscriber().getTopic();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionSubscriberGetTopicTest", e);
        }
    }

    public void closedTopicSessionPublisherCloseTest() throws EETest.Fault {
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call close again");
            this.tool.getDefaultTopicPublisher().close();
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionPublisherCloseTest", e);
        }
    }

    public void closedTopicSessionGetDeliveryModeTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getDeliveryMode");
            try {
                int foo = this.tool.getDefaultTopicPublisher().getDeliveryMode();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionGetDeliveryModeTest", e);
        }
    }

    public void closedTopicSessionGetDisableMessageIDTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getDisableMessageID");
            try {
                boolean foo = this.tool.getDefaultTopicPublisher().getDisableMessageID();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionGetDisableMessageIDTest", e);
        }
    }

    public void closedTopicSessionGetDisableMessageTimestampTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getDisableMessageTimestamp");
            try {
                boolean foo = this.tool.getDefaultTopicPublisher().getDisableMessageTimestamp();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionGetDisableMessageTimestampTest", e);
        }
    }

    public void closedTopicSessionGetPriorityTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getPriority");
            try {
                int foo = this.tool.getDefaultTopicPublisher().getPriority();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionGetPriorityTest", e);
        }
    }

    public void closedTopicSessionGetTimeToLiveTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getTimeToLive");
            try {
                long foo = this.tool.getDefaultTopicPublisher().getTimeToLive();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionGetTimeToLiveTest", e);
        }
    }

    public void closedTopicSessionSetDeliveryModeTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call setDeliveryMode");
            try {
                this.tool.getDefaultTopicPublisher().setDeliveryMode(2);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionSetDeliveryModeTest", e);
        }
    }

    public void closedTopicSessionSetDisableMessageIDTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call setDisableMessageID");
            try {
                this.tool.getDefaultTopicPublisher().setDisableMessageID(true);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionSetDisableMessageIDTest", e);
        }
    }

    public void closedTopicSessionSetDisableMessageTimestampTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call setDisableMessageTimestamp");
            try {
                this.tool.getDefaultTopicPublisher().setDisableMessageTimestamp(true);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionSetDisableMessageTimestampTest", e);
        }
    }

    public void closedTopicSessionSetPriorityTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call setPriority");
            try {
                this.tool.getDefaultTopicPublisher().setPriority(4);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionSetPriorityTest", e);
        }
    }

    public void closedTopicSessionSetTimeToLiveTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call setTimeToLive");
            try {
                this.tool.getDefaultTopicPublisher().setTimeToLive(0L);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionSetTimeToLiveTest", e);
        }
    }

    public void closedTopicSessionPublisherGetTopicTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call getTopic");
            try {
                Topic foo = this.tool.getDefaultTopicPublisher().getTopic();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionPublisherGetTopicTest", e);
        }
    }

    public void closedTopicSessionPublish1Test() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call publish(Message)");
            try {
                this.tool.getDefaultTopicPublisher().publish((Message)new MessageTestImpl());
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionPublish1Test", e);
        }
    }

    public void closedTopicSessionPublish2Test() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseSession(1);
            this.logTrace("Try to call publish(Message,int,int,long)");
            try {
                this.tool.getDefaultTopicPublisher().publish((Message)new MessageTestImpl(), 2, 4, 0L);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedTopicSessionPublish2Test", e);
        }
    }
}

