/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.jsonfilter;

import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JSONObjectFilter;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LessThanJSONObjectFilter
extends JSONObjectFilter {
    public static final String FILTER_TYPE = "lessThan";
    public static final String FIELD_FIELD_PATH = "field";
    public static final String FIELD_VALUE = "value";
    public static final String FIELD_ALLOW_EQUALS = "allowEquals";
    public static final String FIELD_MATCH_ALL_ELEMENTS = "matchAllElements";
    public static final String FIELD_CASE_SENSITIVE = "caseSensitive";
    private static final Set<String> REQUIRED_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("field", "value")));
    private static final Set<String> OPTIONAL_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("allowEquals", "matchAllElements", "caseSensitive")));
    private static final long serialVersionUID = -6023453566718838004L;
    private volatile boolean allowEquals;
    private volatile boolean caseSensitive;
    private volatile boolean matchAllElements;
    private volatile JSONValue value;
    private volatile List<String> field;

    LessThanJSONObjectFilter() {
        this.field = null;
        this.value = null;
        this.allowEquals = false;
        this.matchAllElements = false;
        this.caseSensitive = false;
    }

    private LessThanJSONObjectFilter(List<String> field, JSONValue value, boolean allowEquals, boolean matchAllElements, boolean caseSensitive) {
        this.field = field;
        this.value = value;
        this.allowEquals = allowEquals;
        this.matchAllElements = matchAllElements;
        this.caseSensitive = caseSensitive;
    }

    public LessThanJSONObjectFilter(String field, long value) {
        this(Collections.singletonList(field), (JSONValue)new JSONNumber(value));
    }

    public LessThanJSONObjectFilter(String field, double value) {
        this(Collections.singletonList(field), (JSONValue)new JSONNumber(value));
    }

    public LessThanJSONObjectFilter(String field, String value) {
        this(Collections.singletonList(field), (JSONValue)new JSONString(value));
    }

    public LessThanJSONObjectFilter(String field, JSONValue value) {
        this(Collections.singletonList(field), value);
    }

    public LessThanJSONObjectFilter(List<String> field, JSONValue value) {
        Validator.ensureNotNull(field);
        Validator.ensureFalse(field.isEmpty());
        Validator.ensureNotNull(value);
        Validator.ensureTrue(value instanceof JSONNumber || value instanceof JSONString);
        this.field = Collections.unmodifiableList(new ArrayList<String>(field));
        this.value = value;
        this.allowEquals = false;
        this.matchAllElements = false;
        this.caseSensitive = false;
    }

    public List<String> getField() {
        return this.field;
    }

    public void setField(String ... field) {
        this.setField(StaticUtils.toList(field));
    }

    public void setField(List<String> field) {
        Validator.ensureNotNull(field);
        Validator.ensureFalse(field.isEmpty());
        this.field = Collections.unmodifiableList(new ArrayList<String>(field));
    }

    public JSONValue getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.setValue(new JSONNumber(value));
    }

    public void setValue(double value) {
        this.setValue(new JSONNumber(value));
    }

    public void setValue(String value) {
        Validator.ensureNotNull(value);
        this.setValue(new JSONString(value));
    }

    public void setValue(JSONValue value) {
        Validator.ensureNotNull(value);
        Validator.ensureTrue(value instanceof JSONNumber || value instanceof JSONString);
        this.value = value;
    }

    public boolean allowEquals() {
        return this.allowEquals;
    }

    public void setAllowEquals(boolean allowEquals) {
        this.allowEquals = allowEquals;
    }

    public boolean matchAllElements() {
        return this.matchAllElements;
    }

    public void setMatchAllElements(boolean matchAllElements) {
        this.matchAllElements = matchAllElements;
    }

    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public String getFilterType() {
        return FILTER_TYPE;
    }

    @Override
    protected Set<String> getRequiredFieldNames() {
        return REQUIRED_FIELD_NAMES;
    }

    @Override
    protected Set<String> getOptionalFieldNames() {
        return OPTIONAL_FIELD_NAMES;
    }

    @Override
    public boolean matchesJSONObject(JSONObject o) {
        List<JSONValue> candidates = LessThanJSONObjectFilter.getValues(o, this.field);
        if (candidates.isEmpty()) {
            return false;
        }
        for (JSONValue v : candidates) {
            if (v instanceof JSONArray) {
                boolean matchOne = false;
                boolean matchAll = true;
                for (JSONValue arrayValue : ((JSONArray)v).getValues()) {
                    if (this.matches(arrayValue)) {
                        if (!this.matchAllElements) {
                            return true;
                        }
                        matchOne = true;
                        continue;
                    }
                    matchAll = false;
                    if (!this.matchAllElements) continue;
                    break;
                }
                if (!this.matchAllElements || !matchOne || !matchAll) continue;
                return true;
            }
            if (!this.matches(v)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(JSONValue v) {
        if (v instanceof JSONNumber && this.value instanceof JSONNumber) {
            BigDecimal targetValue = ((JSONNumber)this.value).getValue();
            BigDecimal objectValue = ((JSONNumber)v).getValue();
            if (this.allowEquals) {
                return objectValue.compareTo(targetValue) <= 0;
            }
            return objectValue.compareTo(targetValue) < 0;
        }
        if (v instanceof JSONString && this.value instanceof JSONString) {
            String targetValue = ((JSONString)this.value).stringValue();
            String objectValue = ((JSONString)v).stringValue();
            if (this.allowEquals) {
                if (this.caseSensitive) {
                    return objectValue.compareTo(targetValue) <= 0;
                }
                return objectValue.compareToIgnoreCase(targetValue) <= 0;
            }
            if (this.caseSensitive) {
                return objectValue.compareTo(targetValue) < 0;
            }
            return objectValue.compareToIgnoreCase(targetValue) < 0;
        }
        return false;
    }

    @Override
    public JSONObject toJSONObject() {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>(6);
        fields.put("filterType", new JSONString(FILTER_TYPE));
        if (this.field.size() == 1) {
            fields.put(FIELD_FIELD_PATH, new JSONString(this.field.get(0)));
        } else {
            ArrayList<JSONString> fieldNameValues = new ArrayList<JSONString>(this.field.size());
            for (String s : this.field) {
                fieldNameValues.add(new JSONString(s));
            }
            fields.put(FIELD_FIELD_PATH, new JSONArray(fieldNameValues));
        }
        fields.put(FIELD_VALUE, this.value);
        if (this.allowEquals) {
            fields.put(FIELD_ALLOW_EQUALS, JSONBoolean.TRUE);
        }
        if (this.matchAllElements) {
            fields.put(FIELD_MATCH_ALL_ELEMENTS, JSONBoolean.TRUE);
        }
        if (this.caseSensitive) {
            fields.put(FIELD_CASE_SENSITIVE, JSONBoolean.TRUE);
        }
        return new JSONObject(fields);
    }

    @Override
    protected LessThanJSONObjectFilter decodeFilter(JSONObject filterObject) throws JSONException {
        List<String> fieldPath = this.getStrings(filterObject, FIELD_FIELD_PATH, false, null);
        boolean isAllowEquals = this.getBoolean(filterObject, FIELD_ALLOW_EQUALS, false);
        boolean isMatchAllElements = this.getBoolean(filterObject, FIELD_MATCH_ALL_ELEMENTS, false);
        boolean isCaseSensitive = this.getBoolean(filterObject, FIELD_CASE_SENSITIVE, false);
        return new LessThanJSONObjectFilter(fieldPath, filterObject.getField(FIELD_VALUE), isAllowEquals, isMatchAllElements, isCaseSensitive);
    }
}

