/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.common;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class dbSchema
extends ServiceEETest {
    private String pTableName = null;
    private String fTableName = null;
    private Properties props = null;

    public void createData(Properties p, Connection conn) throws RemoteException {
        TestUtil.logTrace((String)"createData");
        this.pTableName = p.getProperty("ptable", "");
        this.fTableName = p.getProperty("ftable", "");
        try {
            this.props = p;
            this.createTable(p, conn);
            TestUtil.logTrace((String)("Initialized the tables " + this.pTableName + " and " + this.fTableName));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.dbUnConnect(conn);
            throw new RemoteException(e.getMessage());
        }
    }

    public void destroyData(Connection conn) throws RemoteException {
        TestUtil.logTrace((String)"destroyData");
        try {
            this.dropTables(conn);
            TestUtil.logTrace((String)("Deleted all rows from tables " + this.pTableName + " and " + this.fTableName));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception while attempting to Delete all rows from tables " + this.pTableName + " and " + this.fTableName), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public void dbUnConnect(Connection conn) throws RemoteException {
        TestUtil.logTrace((String)"dbUnConnect");
        try {
            conn.close();
            TestUtil.logMsg((String)"Closed the database connection");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occured while trying to close the DB connection", (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    private void createTable(Properties testProps, Connection conn) throws RemoteException {
        TestUtil.logTrace((String)"createTable");
        try {
            this.dropTables(conn);
            TestUtil.logTrace((String)("Deleted all rows from Tables " + this.pTableName + " and " + this.fTableName + " dropped"));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("SQLException encountered while deleting rows for Tables " + this.pTableName + " and " + this.fTableName), (Throwable)e);
        }
        String strTabSize = testProps.getProperty("cofSize");
        TestUtil.logTrace((String)("strTabSize: " + strTabSize));
        Integer intTabSize = new Integer(strTabSize);
        TestUtil.logTrace((String)("intTabSize: " + intTabSize.toString()));
        this.logTrace("intTabSize: " + intTabSize.toString());
        int tSize = intTabSize;
        TestUtil.logTrace((String)("tSize: " + tSize));
        String strTabTypeSize = testProps.getProperty("cofTypeSize");
        TestUtil.logTrace((String)("strTabTypeSize: " + strTabTypeSize));
        Integer intTabTypeSize = new Integer(strTabTypeSize);
        TestUtil.logTrace((String)("intTabTypeSize: " + intTabTypeSize.toString()));
        this.logTrace("intTabTypeSize: " + intTabTypeSize.toString());
        int tTypeSize = intTabTypeSize;
        TestUtil.logTrace((String)("tTypeSize: " + tTypeSize));
        try {
            TestUtil.logTrace((String)("Adding the " + this.pTableName + " table rows"));
            String updateString1 = testProps.getProperty("Dbschema_Tab2_Insert", "");
            PreparedStatement pStmt1 = conn.prepareStatement(updateString1);
            int j = 1;
            while (j <= tTypeSize) {
                String sTypeDesc = "Type-" + j;
                int newType = j++;
                pStmt1.setInt(1, newType);
                pStmt1.setString(2, sTypeDesc);
                pStmt1.executeUpdate();
            }
            TestUtil.logTrace((String)("Adding the " + this.fTableName + " table rows"));
            String updateString = testProps.getProperty("Dbschema_Tab1_Insert", "");
            PreparedStatement pStmt = conn.prepareStatement(updateString);
            for (int i = 1; i <= tSize; ++i) {
                int newKey = i;
                String newName = this.fTableName + "-" + i;
                float newPrice = (float)i + 0.0f;
                int newType = i % 5;
                if (newType == 0) {
                    newType = 5;
                }
                pStmt.setInt(1, newKey);
                pStmt.setString(2, newName);
                pStmt.setFloat(3, newPrice);
                pStmt.setInt(4, newType);
                pStmt.executeUpdate();
            }
            pStmt.close();
            pStmt1.close();
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException creating " + this.fTableName + " or " + this.pTableName + " table"), (Throwable)e);
            this.dropTables(conn);
            throw new RemoteException(e.getMessage());
        }
    }

    private void dropTables(Connection conn) throws RemoteException {
        TestUtil.logTrace((String)"dropTables");
        String removeString = this.props.getProperty("Dbschema_Tab1_Delete", "");
        String removeString1 = this.props.getProperty("Dbschema_Tab2_Delete", "");
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(removeString);
            stmt.close();
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RemoteException(e.getMessage());
        }
        finally {
            try {
                Statement stmt = conn.createStatement();
                stmt.executeUpdate(removeString1);
                stmt.close();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new RemoteException(e.getMessage());
            }
        }
    }
}

