/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.integration.session.servletejbjdbc;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.EETest;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class URLClient
extends EETest {
    private static final String TESTNAME = "Teller";
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "adfsys";
    private static final int PORTNUM = 8000;
    private static final String SERVLET = "/int_S_servletejbjdbc_servlet_web/ntierservlettest";
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String EXPECTED_BALANCE = "10490.75";
    private static final String EXPECTED_DEPOSIT = "10590.75";
    private static final String EXPECTED_WITHDRAW = "10540.75";
    private TSURL ctsurl = new TSURL();
    private URL url = null;
    private URLConnection urlConn = null;
    private Properties props = null;

    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
        String hostname = HOSTNAME;
        int portnum = 8000;
        boolean pass = true;
        try {
            hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (hostname == null) {
                pass = false;
            } else if (hostname.equals("")) {
                pass = false;
            }
            try {
                portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            if (pass) {
                this.url = this.ctsurl.getURL(PROTOCOL, hostname, portnum, SERVLET);
                this.urlConn = TestUtil.sendPostData((Properties)p, (URL)this.url);
            }
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new Exception("Setup failed:");
        }
    }

    public void test1() throws Exception {
        try {
            boolean pass = true;
            TestUtil.logMsg((String)("Getting response from url connection: " + this.url.toString()));
            TestUtil.logMsg((String)"Response is ................");
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            TestUtil.list((Properties)p);
            String balance = p.getProperty("Balance");
            String deposit = p.getProperty("Deposit");
            String withdraw = p.getProperty("Withdraw");
            if (!balance.equals(EXPECTED_BALANCE)) {
                TestUtil.logErr((String)("Balance of account incorrect: expected: 10490.75 Received: " + balance));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Balance of account is correct: " + balance));
            }
            if (!deposit.equals(EXPECTED_DEPOSIT)) {
                TestUtil.logErr((String)("Deposit of account incorrect: expected: 10590.75 Received: " + deposit));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Deposit of account is correct: " + deposit));
            }
            if (!withdraw.equals(EXPECTED_WITHDRAW)) {
                TestUtil.logErr((String)("Withdraw of account incorrect: expected: 10540.75 Received: " + withdraw));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Withdraw of account is correct: " + withdraw));
            }
            if (!pass) {
                throw new Exception("test1 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test1 failed", e);
        }
    }

    public void cleanup() throws Exception {
        this.logMsg("cleanup ok");
    }
}

