/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.webservice.wscontext;

import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.Stateless;
import jakarta.jws.WebService;
import jakarta.xml.ws.WebServiceContext;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.handler.MessageContext;
import java.security.Principal;

@WebService(name="Hello", serviceName="HelloService")
@Stateless
@DeclareRoles(value={"Administrator"})
public class HelloImpl {
    @Resource
    private WebServiceContext wsContext;

    @RolesAllowed(value={"Administrator"})
    public String sayHelloProtected(String param) throws WebServiceException {
        Object output = "";
        MessageContext msgContext = this.wsContext.getMessageContext();
        if (!(msgContext instanceof MessageContext)) {
            throw new WebServiceException("MessageContext not an instance of jakarta.xml.ws.handler.MessageContext");
        }
        output = (String)output + " 1. MessageContext is an instance of jakarta.xml.ws.handler.MessageContext ";
        Principal invocationPrincipal = this.wsContext.getUserPrincipal();
        String principalName = invocationPrincipal.getName();
        if (invocationPrincipal == null) {
            throw new WebServiceException("UnExpected user principal");
        }
        output = (String)output + " 2. Web Service invoked by user " + principalName;
        if (!this.wsContext.isUserInRole("Administrator")) {
            throw new WebServiceException("User not in role Administrator");
        }
        output = (String)output + " 3. User j2ee is in role Administrator ";
        return "Hello " + param + (String)output;
    }
}

