/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.timer.mdb;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.timer.common.TimerImpl;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import java.util.Properties;

public class Client
extends EETest {
    private static final String sendQueueLookup = "java:comp/env/jms/SendQueue";
    private static final String recvQueueLookup = "java:comp/env/jms/RecvQueue";
    private static final String factoryLookup = "java:comp/env/jms/MyQueueConnectionFactory";
    private Properties props = new Properties();
    private TSNamingContext jctx;
    private Queue sendQueue;
    private Queue recvQueue;
    private QueueConnection qConnect;
    private QueueConnectionFactory qFactory;
    private QueueSender qSender;
    private QueueReceiver qReceiver;
    private QueueSession session;
    private long ejbTimeout;
    private long messageTimeout;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("Setup tests");
        this.props = p;
        this.logMsg("ejb_timeout is " + this.props.getProperty("ejb_timeout"));
        this.logMsg("ejb_wait is " + this.props.getProperty("ejb_wait"));
        try {
            this.jctx = new TSNamingContext();
            this.logMsg("initializing JMS messaging");
            this.sendQueue = (Queue)this.jctx.lookup(sendQueueLookup);
            this.recvQueue = (Queue)this.jctx.lookup(recvQueueLookup);
            this.qFactory = (QueueConnectionFactory)this.jctx.lookup(factoryLookup);
            this.qConnect = this.qFactory.createQueueConnection();
            this.session = this.qConnect.createQueueSession(false, 1);
            this.qConnect.start();
            this.ejbTimeout = Long.parseLong(TestUtil.getProperty((String)"ejb_timeout"));
            this.messageTimeout = Long.parseLong(TestUtil.getProperty((String)"ejb_wait"));
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void getInfoStrAndCancelSingleEventTest() throws EETest.Fault {
        try {
            boolean testResult = false;
            this.logMsg("Execute MsgBean:getInfoStrAndCancel");
            this.qSender = this.session.createSender(this.sendQueue);
            this.sendMdbMessage(this.qSender, 1, "getInfoStrAndCancel");
            this.qReceiver = this.session.createReceiver(this.recvQueue);
            String message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
            testResult = message.equals(TestUtil.getProperty((String)"testName"));
            if (!testResult) {
                this.logMsg(message);
                throw new EETest.Fault("getInfoStrAndCancelSingleEventTest failed");
            }
            this.logMsg("getInfoStrAndCancelSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("getInfoStrAndCancelSingleEventTest failed", e);
        }
        finally {
            try {
                this.sendMdbMessage(this.qSender, 0, "cancelAllTimers");
            }
            catch (Exception e) {
                TimerImpl.handleException("Error in finally block", e);
            }
        }
    }

    public void getInfoClassAndCancelSingleEventTest() throws EETest.Fault {
        try {
            boolean testResult = false;
            this.logMsg("Execute MsgBean:getInfoClassAndCancel");
            this.qSender = this.session.createSender(this.sendQueue);
            this.sendMdbMessage(this.qSender, 1, "getInfoClassAndCancel");
            this.qReceiver = this.session.createReceiver(this.recvQueue);
            String message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
            testResult = message.equals(TestUtil.getProperty((String)"testName"));
            if (!testResult) {
                this.logMsg(message);
                throw new EETest.Fault("getInfoClassAndCancelSingleEventTest failed");
            }
            this.logMsg("getInfoClassAndCancelSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("getInfoClassAndCancelSingleEventTest failed", e);
        }
        finally {
            try {
                this.sendMdbMessage(this.qSender, 0, "cancelAllTimers");
            }
            catch (Exception e) {
                TimerImpl.handleException("Error in finally block", e);
            }
        }
    }

    public void verifyTimeoutCallSingleEventTest() throws EETest.Fault {
        try {
            boolean testResult = false;
            this.logMsg("Execute MsgBean:verifyTimeoutCall");
            this.qSender = this.session.createSender(this.sendQueue);
            this.sendMdbMessage(this.qSender, 1, "verifyTimeoutCall");
            this.qReceiver = this.session.createReceiver(this.recvQueue);
            String message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
            testResult = message.equals("hello from ejbTimeout");
            if (!testResult) {
                this.logMsg(message);
                throw new EETest.Fault("verifyTimeoutCallSingleEventTest failed");
            }
            this.logMsg("verifyTimeoutCallSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("verifyTimeoutCallSingleEventTest failed", e);
        }
        finally {
            try {
                this.sendMdbMessage(this.qSender, 0, "cancelAllTimers");
            }
            catch (Exception e) {
                TimerImpl.handleException("Error in finally block", e);
            }
        }
    }

    public void checkedMethodAccessSingleEventTest() throws EETest.Fault {
        try {
            boolean testResult = false;
            this.logMsg("Execute MsgBean:checkedMethodAccess");
            this.qSender = this.session.createSender(this.sendQueue);
            this.sendMdbMessage(this.qSender, 1, "checkedMethodAccess");
            this.qReceiver = this.session.createReceiver(this.recvQueue);
            String message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
            testResult = message.equals("checked method successfully accessed in ejbTimeout");
            if (!testResult) {
                this.logMsg(message);
                throw new EETest.Fault("checkedMethodAccessSingleEventTest failed");
            }
            this.logMsg("checkedMethodAccessSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("checkedMethodAccessSingleEventTest failed", e);
        }
        finally {
            try {
                this.sendMdbMessage(this.qSender, 0, "cancelAllTimers");
            }
            catch (Exception e) {
                TimerImpl.handleException("Error in finally block", e);
            }
        }
    }

    public void rollbackTxOnCreationSingleEventTest() throws EETest.Fault {
        try {
            boolean testResult = false;
            this.qSender = this.session.createSender(this.sendQueue);
            this.logMsg("Execute MsgBean:initializeFlagStoreBean");
            this.sendMdbMessage(this.qSender, 0, "initializeFlagStoreBean");
            this.qReceiver = this.session.createReceiver(this.recvQueue);
            String message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
            testResult = message.equals("FlagStore bean successfully created");
            if (!testResult) {
                this.logMsg(message);
                throw new EETest.Fault("rollbackTxOnCreationSingleEventTest failed");
            }
            this.logMsg("Execute MsgBean:createAndRollback");
            this.sendMdbMessage(this.qSender, 1, "createAndRollback");
            message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
            testResult = message.equals("Rollback occurred as expected");
            if (!testResult) {
                this.logMsg(message);
                throw new EETest.Fault("rollbackTxOnCreationSingleEventTest failed");
            }
            this.sendMdbMessage(this.qSender, 0, "verifyTimerIsGone");
            message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
            testResult = message.equals("no timer found");
            if (!testResult) {
                throw new EETest.Fault("rollbackTxOnCreationSingleEventTest failed");
            }
            this.logMsg("rollbackTxOnCreationSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("rollbackTxOnCreationSingleEventTest failed", e);
        }
        finally {
            try {
                this.sendMdbMessage(this.qSender, 0, "cancelAllTimers");
            }
            catch (Exception e) {
                TimerImpl.handleException("Error in finally block", e);
            }
        }
    }

    public void ejbTimeoutRetrySingleEventTest() throws EETest.Fault {
        try {
            boolean testResult = false;
            this.logMsg("Execute MsgBean:ejbTimeoutRetry");
            this.qSender = this.session.createSender(this.sendQueue);
            this.sendMdbMessage(this.qSender, 1, "ejbTimeoutRetry");
            this.qReceiver = this.session.createReceiver(this.recvQueue);
            String message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
            testResult = message.equals("ejbTimeout has been successfully retried");
            if (!testResult) {
                this.logMsg(message);
                throw new EETest.Fault("ejbTimeoutRetrySingleEventTest failed");
            }
            this.logMsg("ejbTimeoutRetrySingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("ejbTimeoutRetrySingleEventTest failed", e);
        }
        finally {
            try {
                this.sendMdbMessage(this.qSender, 0, "cancelAllTimers");
            }
            catch (Exception e) {
                TimerImpl.handleException("Error in finally block", e);
            }
        }
    }

    public void rollbackTxInEjbTimeoutSingleEventTest() throws EETest.Fault {
        try {
            boolean testResult = false;
            this.logMsg("Execute MsgBean:rollbackTxInEjbTimeout");
            this.qSender = this.session.createSender(this.sendQueue);
            this.sendMdbMessage(this.qSender, 1, "rollbackTxInEjbTimeout");
            this.qReceiver = this.session.createReceiver(this.recvQueue);
            String message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
            testResult = message.equals("Transaction has been successfully rolled back in ejbTimeout");
            if (!testResult) {
                this.logMsg(message);
                throw new EETest.Fault("rollbackTxInEjbTimeoutSingleEventTest failed");
            }
            this.logMsg("rollbackTxInEjbTimeoutSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("rollbackTxInEjbTimeoutSingleEventTest failed", e);
        }
        finally {
            try {
                this.sendMdbMessage(this.qSender, 0, "cancelAllTimers");
            }
            catch (Exception e) {
                TimerImpl.handleException("Error in finally block", e);
            }
        }
    }

    public void checkSerializationSingleEventTest() throws EETest.Fault {
        try {
            boolean testResult = false;
            this.logMsg("Execute MsgBean:checkSerialization");
            this.qSender = this.session.createSender(this.sendQueue);
            this.sendMdbMessage(this.qSender, 1, "checkSerialization");
            this.qReceiver = this.session.createReceiver(this.recvQueue);
            String message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
            testResult = message.equals(TestUtil.getProperty((String)"testName"));
            if (!testResult) {
                this.logMsg(message);
                throw new EETest.Fault("checkSerializationSingleEventTest failed");
            }
            this.logMsg("checkSerializationSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("checkSerializationSingleEventTest failed", e);
        }
        finally {
            try {
                this.sendMdbMessage(this.qSender, 0, "cancelAllTimers");
            }
            catch (Exception e) {
                TimerImpl.handleException("Error in finally block", e);
            }
        }
    }

    public void checkSerializationInEjbTimeoutSingleEventTest() throws EETest.Fault {
        try {
            boolean testResult = false;
            this.logMsg("Execute MsgBean:checkSerializationInEjbTimeout");
            this.qSender = this.session.createSender(this.sendQueue);
            this.sendMdbMessage(this.qSender, 1, "checkSerializationInEjbTimeout");
            this.qReceiver = this.session.createReceiver(this.recvQueue);
            String message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
            testResult = message.equals("Timer handle successfully serialized in ejbTimeout");
            if (!testResult) {
                this.logMsg(message);
                throw new EETest.Fault("checkSerializationInEjbTimeoutSingleEventTest failed");
            }
            this.logMsg("checkSerializationInEjbTimeoutSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("checkSerializationInEjbTimeoutSingleEventTest failed", e);
        }
        finally {
            try {
                this.sendMdbMessage(this.qSender, 0, "cancelAllTimers");
            }
            catch (Exception e) {
                TimerImpl.handleException("Error in finally block", e);
            }
        }
    }

    public void cancelAndRollbackSingleEventTest() throws EETest.Fault {
        try {
            boolean testResult = false;
            this.logMsg("Execute MsgBean:initializeTimerAndFlagStoreBean");
            this.qSender = this.session.createSender(this.sendQueue);
            this.sendMdbMessage(this.qSender, 1, "initializeTimerAndFlagStoreBean");
            this.qReceiver = this.session.createReceiver(this.recvQueue);
            String message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
            testResult = message.equals(TestUtil.getProperty((String)"testName"));
            if (testResult) {
                this.sendMdbMessage(this.qSender, 0, "cancelAndRollback");
                message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
                testResult = message.equals("hello from ejbTimeout");
            }
            if (!testResult) {
                this.logMsg(message);
                throw new EETest.Fault("cancelAndRollbackSingleEventTest failed");
            }
            this.logMsg("cancelAndRollbackSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("cancelAndRollbackSingleEventTest failed", e);
        }
        finally {
            try {
                this.sendMdbMessage(this.qSender, 0, "cancelAllTimers");
            }
            catch (Exception e) {
                TimerImpl.handleException("Error in finally block", e);
            }
        }
    }

    public void goneOnExpirationSingleEventTest() throws EETest.Fault {
        try {
            boolean testResult = false;
            this.logMsg("Execute MsgBean:initializeTimerAndNotify");
            this.qSender = this.session.createSender(this.sendQueue);
            this.sendMdbMessage(this.qSender, 1, "initializeTimerAndNotify");
            this.qReceiver = this.session.createReceiver(this.recvQueue);
            String message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
            testResult = message.equals(TestUtil.getProperty((String)"testName"));
            if (testResult && (testResult = (message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout)).equals("hello from ejbTimeout"))) {
                Thread.currentThread();
                Thread.sleep((this.messageTimeout - this.ejbTimeout) / 2L);
                this.sendMdbMessage(this.qSender, 0, "verifyTimerIsGone");
                message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
                testResult = message.equals("no timer found");
            }
            if (!testResult) {
                this.logMsg(message);
                throw new EETest.Fault("goneOnExpirationSingleEventTest failed");
            }
            this.logMsg("goneOnExpirationSingleEventTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("goneOnExpirationSingleEventTest failed", e);
        }
        finally {
            try {
                this.sendMdbMessage(this.qSender, 0, "cancelAllTimers");
            }
            catch (Exception e) {
                TimerImpl.handleException("Error in finally block", e);
            }
        }
    }

    public void goneOnCancellationIntervalTest() throws EETest.Fault {
        try {
            boolean testResult = false;
            this.logMsg("Execute MsgBean:initializeTimerAndNotify");
            this.qSender = this.session.createSender(this.sendQueue);
            this.sendMdbMessage(this.qSender, 2, "initializeTimerAndNotify");
            this.qReceiver = this.session.createReceiver(this.recvQueue);
            String message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
            testResult = message.equals(TestUtil.getProperty((String)"testName"));
            if (testResult) {
                this.sendMdbMessage(this.qSender, 0, "cancelAllTimers");
                Thread.currentThread();
                Thread.sleep(this.ejbTimeout);
                this.sendMdbMessage(this.qSender, 0, "verifyTimerIsGone");
                message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
                testResult = message.equals("no timer found");
                if (testResult) {
                    message = TimerImpl.getMessage(this.qReceiver, this.messageTimeout);
                    testResult = message.equals("no valid message received");
                }
            }
            if (!testResult) {
                this.logMsg(message);
                throw new EETest.Fault("goneOnCancellationIntervalTest failed");
            }
            this.logMsg("goneOnCancellationIntervalTest passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("goneOnCancellationIntervalTest failed", e);
        }
        finally {
            try {
                this.sendMdbMessage(this.qSender, 0, "cancelAllTimers");
            }
            catch (Exception e) {
                TimerImpl.handleException("Error in finally block", e);
            }
        }
    }

    public void cleanup() throws EETest.Fault {
        if (this.qConnect != null) {
            try {
                this.logMsg("closing connection");
                this.qConnect.close();
            }
            catch (Exception e) {
                TimerImpl.handleException("Error close connection", e);
            }
        }
        try {
            TimerImpl.flushQueue(this.recvQueue, this.qFactory);
        }
        catch (Exception e) {
            TimerImpl.handleException("Error cleanup Queue", e);
        }
        this.logMsg("cleanup ok");
    }

    private void sendMdbMessage(QueueSender sender, int timerType, String message) {
        try {
            TextMessage msg = this.session.createTextMessage();
            this.addPropsToMessage((Message)msg, timerType);
            msg.setText(message);
            this.logMsg("Sending message at " + System.currentTimeMillis() + ": " + message);
            sender.send((Message)msg);
        }
        catch (Exception e) {
            TimerImpl.handleException("Error sending message", e);
        }
    }

    private void addPropsToMessage(Message message, int timerType) {
        Properties props = null;
        String key = null;
        String notValid = ".";
        try {
            message.setIntProperty("timer_type", timerType);
            props = TestUtil.getProperties();
            message.setStringProperty("harnesshost", props.getProperty("harness.host"));
            message.setStringProperty("harnesslogtraceflag", props.getProperty("harness.log.traceflag"));
            message.setStringProperty("harnesslogport", props.getProperty("harness.log.port"));
            message.setStringProperty("testName", props.getProperty("testName"));
            Enumeration<?> e = props.propertyNames();
            key = null;
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (key.indexOf(notValid) != -1 || key.indexOf("***") != -1) continue;
                message.setStringProperty(key, props.getProperty(key));
            }
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            TestUtil.logMsg((String)("key was: " + key));
            TestUtil.logMsg((String)("props was: " + props.getProperty(key)));
            TestUtil.logMsg((String)"Error setting properties");
        }
    }
}

