/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.bmp.entitycontexttest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOException;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.common.dao.coffee.CoffeeBean;
import com.sun.ts.tests.common.dao.coffee.CoffeeDAO;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.entitycontexttest.TestBeanHome;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EJBObject;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.FinderException;
import jakarta.ejb.RemoveException;
import jakarta.ejb.TimerService;
import jakarta.transaction.UserTransaction;
import java.security.Principal;
import java.util.Properties;
import javax.naming.NamingException;

public class TestBeanEJB
implements EntityBean {
    private CoffeeBean cache;
    private CoffeeDAO dao = null;
    private static final String[] dataPropKey = new String[]{"user", "password", "server", "jdbcPoolName"};
    private static final String[] dataPropVal = new String[]{"cts1", "cts1", "JDBCTEST", "sessionContextPool"};
    private EntityContext ectx = null;
    private TSNamingContext nctx = null;
    private UserTransaction ut = null;

    public Integer ejbCreate(Properties p, int cofID, String cofName, float cofPrice) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"DAO Init");
            if (null == this.dao) {
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logMsg((String)"Get DB Connection");
            this.dao.startSession();
            TestUtil.logTrace((String)"DAO: Create new row...");
            this.dao.create(cofID, cofName, cofPrice);
            this.cache = new CoffeeBean(cofID, cofName, cofPrice);
            TestUtil.logMsg((String)"Get DB connection");
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
        return new Integer(cofID);
    }

    public void ejbPostCreate(Properties p, int cofID, String cofName, float cofPrice) {
        TestUtil.logTrace((String)"ejbPostCreate");
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = c;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.logErr((String)("NamingException ... " + e), (Throwable)e);
            throw new EJBException("unable to obtain naming context");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception ... " + e), (Throwable)e);
            throw new EJBException("Exception in setEntityContext");
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            TestUtil.logTrace((String)"Start DAO session...");
            this.dao.startSession();
            TestUtil.logTrace((String)"Remove row...");
            this.dao.delete((Integer)this.ectx.getPrimaryKey());
        }
        catch (DAOException e) {
            throw new RemoveException("Caught DAOException" + e);
        }
        catch (Exception e) {
            throw new RemoveException("Caught exception: " + e);
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }

    public Integer ejbFindTheBean(Properties p, Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindTheBean");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (DAOException de) {
                throw new FinderException("DAOException " + de);
            }
            catch (Exception e) {
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public Integer ejbFindByPrimaryKey(Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrimaryKey");
        try {
            if (null == this.dao) {
                TestUtil.logMsg((String)"Get DAO...");
                this.dao = DAOFactory.getInstance().getCoffeeDAO();
            }
            this.dao.startSession();
            if (this.dao.exists(key)) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (DAOException de) {
                throw new FinderException("DAOException " + de);
            }
            catch (Exception e) {
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            if (null != this.dao) {
                this.dao.stopSession();
            }
        }
    }

    public boolean getEJBObjectTest() {
        TestUtil.logTrace((String)"getEJBObjectTest");
        try {
            EJBObject object = this.ectx.getEJBObject();
            if (object != null) {
                TestUtil.logMsg((String)"getEJBObject() returned EJBObject reference");
                return true;
            }
            TestUtil.logErr((String)"getEJBObject() returned null reference");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean getEJBHomeTest() {
        TestUtil.logTrace((String)"getEJBHomeTest");
        try {
            TestBeanHome home = (TestBeanHome)this.ectx.getEJBHome();
            if (home != null) {
                TestUtil.logMsg((String)"getEJBHome() returned EJBHome reference");
                return true;
            }
            TestUtil.logErr((String)"getEJBHome() returned null reference");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean getEnvironmentTest() {
        TestUtil.logTrace((String)"getEnvironmentTest");
        int failures = 0;
        try {
            for (int i = 0; i < dataPropKey.length; ++i) {
                String envProp = "java:comp/env/" + dataPropKey[i];
                TestUtil.logMsg((String)("lookup: " + envProp));
                String propVal = (String)this.nctx.lookup(envProp);
                TestUtil.logMsg((String)("propVal=" + propVal));
                if (propVal == null) {
                    TestUtil.logErr((String)("property name " + dataPropKey[i] + " not found in environment"));
                    ++failures;
                    continue;
                }
                if (!propVal.equals(dataPropVal[i])) {
                    TestUtil.logErr((String)("property value " + propVal + " not equal to " + dataPropVal[i]));
                    ++failures;
                    continue;
                }
                TestUtil.logMsg((String)"property values are equal");
            }
            return failures <= 0;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean getCallerPrincipalTest(String s) {
        TestUtil.logTrace((String)"getCallerPrincipalTest");
        try {
            Principal principal = this.ectx.getCallerPrincipal();
            if (principal != null) {
                TestUtil.logMsg((String)("getCallerPrincipal() returned Principal: " + principal));
                String name = principal.getName();
                if (name.indexOf(s) < 0) {
                    TestUtil.logErr((String)("principal - expected: " + s + ", received: " + name));
                    return false;
                }
                return true;
            }
            TestUtil.logErr((String)"getCallerPrincipal() returned null reference");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public boolean isCallerInRoleTest(String s) {
        TestUtil.logTrace((String)"isCallerInRoleTest");
        String role = s;
        try {
            boolean inRole = this.ectx.isCallerInRole(role);
            if (inRole) {
                TestUtil.logMsg((String)("isCallerInRole(" + role + ") is true"));
            } else {
                TestUtil.logMsg((String)("isCallerInRole(" + role + ") is false"));
            }
            return inRole;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public boolean getUserTransactionTest() {
        TestUtil.logTrace((String)"getUserTransactionTest");
        boolean pass = true;
        TestUtil.logMsg((String)"invoke EntityContext.getUserTransaction() method");
        try {
            UserTransaction ut = this.ectx.getUserTransaction();
            TestUtil.logErr((String)"IllegalStateException not received - unexpected");
            pass = false;
        }
        catch (IllegalStateException e) {
            TestUtil.logMsg((String)"IllegalStateException received - expected");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    public boolean setRollbackOnlyTest() {
        TestUtil.logTrace((String)"setRollbackOnlyTest");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"get rollback status");
            if (this.ectx.getRollbackOnly()) {
                TestUtil.logMsg((String)"transaction marked for rollback - unexpected");
                return false;
            }
            TestUtil.logMsg((String)"transaction not marked for rollback - expected");
            TestUtil.logMsg((String)"mark transaction for rollback");
            this.ectx.setRollbackOnly();
            TestUtil.logMsg((String)"get rollback status");
            if (this.ectx.getRollbackOnly()) {
                TestUtil.logMsg((String)"transaction marked for rollback - expected");
            } else {
                TestUtil.logMsg((String)"transaction not marked for rollback - unexpected");
                pass = false;
            }
            return pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean getRollbackOnlyTest() {
        TestUtil.logTrace((String)"getRollbackOnlyTest");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"get rollback status");
            if (this.ectx.getRollbackOnly()) {
                TestUtil.logMsg((String)"transaction marked for rollback - unexpected");
                return false;
            }
            TestUtil.logMsg((String)"transaction not marked for rollback - expected");
            TestUtil.logMsg((String)"mark transaction for rollback");
            this.ectx.setRollbackOnly();
            TestUtil.logMsg((String)"get rollback status");
            if (this.ectx.getRollbackOnly()) {
                TestUtil.logMsg((String)"transaction marked for rollback - expected");
            } else {
                TestUtil.logMsg((String)"transaction not marked for rollback - unexpected");
                pass = false;
            }
            return pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean getPrimaryKeyTest(Integer pk) {
        TestUtil.logTrace((String)"getPrimaryKeyTest");
        try {
            Object o = this.ectx.getPrimaryKey();
            if (o == null) {
                TestUtil.logErr((String)"primary key returned null");
                return false;
            }
            if (!(o instanceof Integer)) {
                TestUtil.logErr((String)"primary key is not an instance of integer");
                return false;
            }
            Integer i = (Integer)o;
            if (i.equals(pk)) {
                TestUtil.logMsg((String)("primaryKey match, expected: " + pk + " received: " + i));
                return true;
            }
            TestUtil.logErr((String)("primaryKey mismatch, expected: " + pk + " received: " + i));
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean getTimerServiceTest() {
        TestUtil.logTrace((String)"getTimerServiceTest");
        try {
            TimerService ts = this.ectx.getTimerService();
            if (ts instanceof TimerService) {
                TestUtil.logMsg((String)"getTimerService() returned Timer Service reference");
                return true;
            }
            TestUtil.logErr((String)"getTimerService() returned invalid reference");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }
}

