/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.mapkeyenumerated;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.mapkeyenumerated.Department;
import com.sun.ts.tests.jpa.core.annotations.mapkeyenumerated.Department2;
import com.sun.ts.tests.jpa.core.annotations.mapkeyenumerated.Department3;
import com.sun.ts.tests.jpa.core.annotations.mapkeyenumerated.Department4;
import com.sun.ts.tests.jpa.core.annotations.mapkeyenumerated.EmbeddedEmployee;
import com.sun.ts.tests.jpa.core.annotations.mapkeyenumerated.Employee;
import com.sun.ts.tests.jpa.core.annotations.mapkeyenumerated.Employee2;
import com.sun.ts.tests.jpa.core.annotations.mapkeyenumerated.Employee3;
import com.sun.ts.tests.jpa.core.annotations.mapkeyenumerated.Employee4;
import com.sun.ts.tests.jpa.core.annotations.mapkeyenumerated.Numbers;
import com.sun.ts.tests.jpa.core.annotations.mapkeyenumerated.Offices;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 20L;
    private static Employee[] empRef = new Employee[5];
    private static Employee2[] empRef2 = new Employee2[5];
    private static Employee3[] empRef3 = new Employee3[5];
    private static Employee4[] empRef4 = new Employee4[5];

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void mapKeyEnumeratedTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<Offices> expected = new HashSet<Offices>();
        expected.add(Offices.OFF000);
        expected.add(Offices.OFF002);
        expected.add(Offices.OFF004);
        try {
            this.getEntityTransaction().begin();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            TestUtil.logTrace((String)("Name:" + emp.getFirstName() + " " + emp.getLastName()));
            Department dept = emp.getDepartment();
            TestUtil.logTrace((String)("Dept=" + dept.getName()));
            Map emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry entry : emps.entrySet()) {
                    TestUtil.logTrace((String)("map:" + entry.getKey() + ", " + ((Employee)entry.getValue()).getId() + " " + ((Employee)entry.getValue()).getFirstName() + " " + ((Employee)entry.getValue()).getLastName()));
                }
            }
            Set keys = emps.keySet();
            for (Offices key : keys) {
                TestUtil.logTrace((String)("key:" + key));
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                TestUtil.logTrace((String)"Received expected keys");
                pass1 = true;
            } else {
                TestUtil.logErr((String)"Did not received expected keys");
                TestUtil.logErr((String)"Expected:");
                for (Offices key : expected) {
                    TestUtil.logTrace((String)("key:" + key));
                }
                TestUtil.logErr((String)"Actual:");
                for (Offices key : keys) {
                    TestUtil.logTrace((String)("key:" + key));
                }
            }
            HashSet<Employee> hashSet = new HashSet<Employee>();
            hashSet.add(empRef[0]);
            hashSet.add(empRef[1]);
            hashSet.add(empRef[2]);
            Collection employees = emps.values();
            for (Employee e : employees) {
                TestUtil.logTrace((String)("values:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName()));
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                TestUtil.logTrace((String)"Received expected values");
                pass2 = true;
            } else {
                TestUtil.logErr((String)"Did not received expected values");
                TestUtil.logErr((String)"Expected:");
                for (Employee e : hashSet) {
                    TestUtil.logTrace((String)("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName()));
                }
                TestUtil.logErr((String)"Actual:");
                for (Employee e : employees) {
                    TestUtil.logTrace((String)("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName()));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)ex);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("mapKeyEnumeratedTest failed");
        }
    }

    public void mapKeyEnumeratedDefaultTypeTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<Offices> expected = new HashSet<Offices>();
        expected.add(Offices.OFF001);
        expected.add(Offices.OFF003);
        try {
            this.getEntityTransaction().begin();
            Employee2 emp = (Employee2)this.getEntityManager().find(Employee2.class, (Object)2);
            TestUtil.logTrace((String)("Name:" + emp.getFirstName() + " " + emp.getLastName()));
            Department2 dept = emp.getDepartment();
            TestUtil.logTrace((String)("Dept=" + dept.getName()));
            Map emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry entry : emps.entrySet()) {
                    TestUtil.logTrace((String)("map:" + entry.getKey() + ", " + ((Employee2)entry.getValue()).getId() + " " + ((Employee2)entry.getValue()).getFirstName() + " " + ((Employee2)entry.getValue()).getLastName()));
                }
            }
            Set keys = emps.keySet();
            for (Offices key : keys) {
                TestUtil.logTrace((String)("key:" + key));
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                TestUtil.logTrace((String)"Received expected keys");
                pass1 = true;
            } else {
                TestUtil.logErr((String)"Did not received expected keys");
                TestUtil.logErr((String)"Expected:");
                for (Offices key : expected) {
                    TestUtil.logTrace((String)("key:" + key));
                }
                TestUtil.logErr((String)"Actual:");
                for (Offices key : keys) {
                    TestUtil.logTrace((String)("key:" + key));
                }
            }
            HashSet<Employee2> hashSet = new HashSet<Employee2>();
            hashSet.add(empRef2[0]);
            hashSet.add(empRef2[1]);
            Collection employees = emps.values();
            for (Employee2 e : employees) {
                TestUtil.logTrace((String)("values:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName()));
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                TestUtil.logTrace((String)"Received expected values");
                pass2 = true;
            } else {
                TestUtil.logErr((String)"Did not received expected values");
                TestUtil.logErr((String)"Expected:");
                for (Employee2 e : hashSet) {
                    TestUtil.logTrace((String)("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName()));
                }
                TestUtil.logErr((String)"Actual:");
                for (Employee2 e : employees) {
                    TestUtil.logTrace((String)("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName()));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)ex);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("mapKeyEnumeratedDefaultTypeTest failed");
        }
    }

    public void mapKeyEnumeratedWithMayKeyAnnotationTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<Offices> expected = new HashSet<Offices>();
        expected.add(Offices.OFF001);
        expected.add(Offices.OFF003);
        try {
            this.getEntityTransaction().begin();
            Employee3 emp = (Employee3)this.getEntityManager().find(Employee3.class, (Object)6);
            TestUtil.logTrace((String)("Name:" + emp.getFirstName() + " " + emp.getLastName()));
            Department3 dept = emp.getDepartment();
            TestUtil.logTrace((String)("Dept=" + dept.getName()));
            Map emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry entry : emps.entrySet()) {
                    TestUtil.logTrace((String)("map:" + entry.getKey() + ", " + ((Employee3)entry.getValue()).getId() + " " + ((Employee3)entry.getValue()).getFirstName() + " " + ((Employee3)entry.getValue()).getLastName()));
                }
            }
            Set keys = emps.keySet();
            for (Offices key : keys) {
                TestUtil.logTrace((String)("key:" + key));
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                TestUtil.logTrace((String)"Received expected keys");
                pass1 = true;
            } else {
                TestUtil.logErr((String)"Did not received expected keys");
                TestUtil.logErr((String)"Expected:");
                for (Offices key : expected) {
                    TestUtil.logTrace((String)("key:" + key));
                }
                TestUtil.logErr((String)"Actual:");
                for (Offices key : keys) {
                    TestUtil.logTrace((String)("key:" + key));
                }
            }
            HashSet<Employee3> hashSet = new HashSet<Employee3>();
            hashSet.add(empRef3[0]);
            hashSet.add(empRef3[1]);
            Collection employees = emps.values();
            for (Employee3 e : employees) {
                TestUtil.logTrace((String)("values:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName()));
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                TestUtil.logTrace((String)"Received expected values");
                pass2 = true;
            } else {
                TestUtil.logErr((String)"Did not received expected values");
                TestUtil.logErr((String)"Expected:");
                for (Employee3 e : hashSet) {
                    TestUtil.logTrace((String)("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName()));
                }
                TestUtil.logErr((String)"Actual:");
                for (Employee3 e : employees) {
                    TestUtil.logTrace((String)("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName()));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)ex);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("mapKeyEnumeratedWithMayKeyAnnotationTest failed");
        }
    }

    public void elementCollectionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<Numbers> expected = new HashSet<Numbers>();
        expected.add(Numbers.one);
        expected.add(Numbers.two);
        try {
            this.getEntityTransaction().begin();
            Employee4 emp = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            TestUtil.logTrace((String)("Name:" + emp.getLastName()));
            Department4 dept = emp.getDepartment();
            TestUtil.logTrace((String)("Dept=" + dept.getName()));
            Map emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry entry : emps.entrySet()) {
                    TestUtil.logTrace((String)("map:" + entry.getKey() + ", " + ((EmbeddedEmployee)entry.getValue()).employeeId + " " + ((EmbeddedEmployee)entry.getValue()).employeeName));
                }
            }
            Set keys = emps.keySet();
            for (Numbers key : keys) {
                TestUtil.logTrace((String)("key:" + key));
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                TestUtil.logTrace((String)"Received expected keys");
                pass1 = true;
            } else {
                TestUtil.logErr((String)"Did not received expected keys");
                TestUtil.logErr((String)"Expected:");
                for (Numbers key : expected) {
                    TestUtil.logTrace((String)("key:" + key));
                }
                TestUtil.logErr((String)"Actual:");
                for (Numbers key : keys) {
                    TestUtil.logTrace((String)("key:" + key));
                }
            }
            HashSet<Employee4> hashSet = new HashSet<Employee4>();
            hashSet.add(empRef4[0]);
            hashSet.add(empRef4[1]);
            Collection employees = emps.values().stream().flatMap(a -> Stream.of(new Employee4(a.employeeId, a.employeeName))).collect(Collectors.toList());
            for (Employee4 e : employees) {
                TestUtil.logTrace((String)("values:" + e.getId() + " " + e.getLastName()));
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                TestUtil.logTrace((String)"Received expected values");
                pass2 = true;
            } else {
                TestUtil.logErr((String)"Did not received expected values");
                TestUtil.logErr((String)"Expected:");
                for (Employee4 e : hashSet) {
                    TestUtil.logTrace((String)("Employee:" + e.getId() + " " + e.getLastName()));
                }
                TestUtil.logErr((String)"Actual:");
                for (Employee4 e : employees) {
                    TestUtil.logTrace((String)("Employee:" + e.getId() + " " + e.getLastName()));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)ex);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("elementCollectionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        TestUtil.logTrace((String)"createTestData");
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create 2 - Departments");
            Department[] deptRef = new Department[]{new Department(1, "Marketing"), new Department(2, "Administration")};
            TestUtil.logTrace((String)"Persist departments ");
            for (Department dept : deptRef) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                TestUtil.logTrace((String)("persisted department " + dept.getName()));
            }
            TestUtil.logTrace((String)"Create 2 - Department2");
            Department2[] deptRef2 = new Department2[]{new Department2(3, "Development"), new Department2(4, "Release")};
            TestUtil.logTrace((String)"Persist Department2s ");
            for (Department2 dept : deptRef2) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                TestUtil.logTrace((String)("persisted department2 " + dept.getName()));
            }
            TestUtil.logTrace((String)"Create 2 - Department3");
            Department3[] deptRef3 = new Department3[]{new Department3(5, "Shipping"), new Department3(6, "Receiving")};
            TestUtil.logTrace((String)"Persist Department2s ");
            for (Department3 dept : deptRef3) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                TestUtil.logTrace((String)("persisted department3 " + dept.getName()));
            }
            TestUtil.logTrace((String)"Create 2 - Department4");
            Department4[] deptRef4 = new Department4[]{new Department4(7, "Accounts_Receivable"), new Department4(8, "Accounts_Payable")};
            TestUtil.logTrace((String)"Persist Department4 ");
            for (Department4 dept : deptRef4) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                TestUtil.logTrace((String)("persisted department4 " + dept.getName()));
            }
            TestUtil.logTrace((String)"Create 5 - Employee");
            Client.empRef[0] = new Employee(1, "Alan", "Frechette");
            empRef[0].setDepartment(deptRef[0]);
            Client.empRef[1] = new Employee(3, "Shelly", "McGowan");
            empRef[1].setDepartment(deptRef[0]);
            Client.empRef[2] = new Employee(5, "Stephen", "DMilla");
            empRef[2].setDepartment(deptRef[0]);
            Client.empRef2[0] = new Employee2(2, "Arthur", "Frechette");
            empRef2[0].setDepartment(deptRef2[0]);
            Client.empRef2[1] = new Employee2(4, "Robert", "Bissett");
            empRef2[1].setDepartment(deptRef2[0]);
            Client.empRef3[0] = new Employee3(6, "Douglas", "Donahue");
            empRef3[0].setDepartment(deptRef3[0]);
            Client.empRef3[1] = new Employee3(7, "Kellie", "Sanborn");
            empRef3[1].setDepartment(deptRef3[0]);
            Client.empRef4[0] = new Employee4(8, "Grace");
            empRef4[0].setDepartment(deptRef4[0]);
            Client.empRef4[1] = new Employee4(9, "Bender");
            empRef4[1].setDepartment(deptRef4[1]);
            HashMap<Offices, Employee> link = new HashMap<Offices, Employee>();
            link.put(Offices.OFF000, empRef[0]);
            link.put(Offices.OFF002, empRef[1]);
            link.put(Offices.OFF004, empRef[2]);
            deptRef[0].setLastNameEmployees(link);
            HashMap<Offices, Employee2> link2 = new HashMap<Offices, Employee2>();
            link2.put(Offices.OFF001, empRef2[0]);
            link2.put(Offices.OFF003, empRef2[1]);
            deptRef2[0].setLastNameEmployees(link2);
            HashMap<Offices, Employee3> link3 = new HashMap<Offices, Employee3>();
            link3.put(Offices.OFF001, empRef3[0]);
            link3.put(Offices.OFF003, empRef3[1]);
            deptRef3[0].setLastNameEmployees(link3);
            HashMap<Numbers, EmbeddedEmployee> link4 = new HashMap<Numbers, EmbeddedEmployee>();
            link4.put(Numbers.one, new EmbeddedEmployee(empRef4[0]));
            link4.put(Numbers.two, new EmbeddedEmployee(empRef4[1]));
            deptRef4[0].setLastNameEmployees(link4);
            TestUtil.logTrace((String)"Persist Employee ");
            for (Employee employee : empRef) {
                if (employee == null) continue;
                this.getEntityManager().persist((Object)employee);
                TestUtil.logTrace((String)("persisted Employee " + employee.getId()));
            }
            TestUtil.logTrace((String)"Persist Employee2 ");
            for (Employee employee : empRef2) {
                if (employee == null) continue;
                this.getEntityManager().persist((Object)employee);
                TestUtil.logTrace((String)("persisted Employee2 " + employee.getId()));
            }
            TestUtil.logTrace((String)"Persist Employee3 ");
            for (Employee employee : empRef3) {
                if (employee == null) continue;
                this.getEntityManager().persist((Object)employee);
                TestUtil.logTrace((String)("persisted Employee3 " + employee.getId()));
            }
            TestUtil.logTrace((String)"Persist Employee4 ");
            for (Employee employee : empRef4) {
                if (employee == null) continue;
                this.getEntityManager().persist((Object)employee);
                TestUtil.logTrace((String)("persisted Employee4 " + employee.getId()));
            }
            TestUtil.logTrace((String)"Merge Department ");
            for (Employee employee : deptRef) {
                if (employee == null) continue;
                this.getEntityManager().merge((Object)employee);
                TestUtil.logTrace((String)("merged Department " + employee.getName()));
            }
            TestUtil.logTrace((String)"Merge Department2 ");
            for (Employee employee : deptRef2) {
                if (employee == null) continue;
                this.getEntityManager().merge((Object)employee);
                TestUtil.logTrace((String)("merged Department2 " + employee.getName()));
            }
            TestUtil.logTrace((String)"Merge Department3 ");
            for (Employee employee : deptRef3) {
                if (employee == null) continue;
                this.getEntityManager().merge((Object)employee);
                TestUtil.logTrace((String)("merged Department3 " + employee.getName()));
            }
            TestUtil.logTrace((String)"Merge Department4 ");
            for (Employee employee : deptRef4) {
                if (employee == null) continue;
                this.getEntityManager().merge((Object)employee);
                TestUtil.logTrace((String)("merged Department4 " + employee.getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMP_MAPKEYCOL").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from EMP_MAPKEYCOL2").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

