/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateful.handletest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.common.EJBHandleObjectInputStream;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.handletest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.handletest.TestBeanHome;
import jakarta.ejb.EJBObject;
import jakarta.ejb.Handle;
import jakarta.ejb.HomeHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.rmi.PortableRemoteObject;

public class Client
extends EETest {
    private static final String testName = "HandleTest";
    private static final String testLookup = "java:comp/env/ejb/TestBean";
    private static final String testProps = "handletest.properties";
    private static final String testDir = System.getProperty("user.dir");
    private TestBean beanRef = null;
    private TestBeanHome beanHome = null;
    private Properties props = null;
    private TSNamingContext nctx = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testLookup, TestBeanHome.class);
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props);
            this.logMsg("get handle for object");
            Handle handle = this.beanRef.getHandle();
            boolean pass = true;
            if (handle == null) {
                pass = false;
                this.logErr("getHandle() returned null reference");
            } else if (!(handle instanceof Serializable)) {
                pass = false;
                this.logErr("getHandle() is not serializable");
            } else {
                this.logMsg("got handle and handle is serializable");
            }
            if (!pass) {
                throw new EETest.Fault("test1 failed");
            }
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test1 failed", e);
        }
    }

    public void test2() throws EETest.Fault {
        ObjectInputStream is = null;
        ObjectOutputStream os = null;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props);
            this.logMsg("ping object");
            int pingCount = this.beanRef.ping(1);
            this.logMsg("get handle for object");
            Handle handle = this.beanRef.getHandle();
            this.logMsg("write object output stream to byte array");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(baos);
            os.writeObject(handle);
            this.logMsg("read object output stream from byte array");
            byte[] b = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            is = new EJBHandleObjectInputStream(bais);
            Handle deserializedHandle = (Handle)is.readObject();
            this.logMsg("create object reference from deserialized handle");
            EJBObject ejbObject = deserializedHandle.getEJBObject();
            TestBean beanRef2 = (TestBean)PortableRemoteObject.narrow((Object)ejbObject, TestBean.class);
            boolean pass = true;
            if (!this.beanRef.isIdentical(beanRef2)) {
                this.logErr("bean references not equal - unexpected");
                pass = false;
            } else {
                this.logMsg("bean references equal - expected");
            }
            this.logMsg("ping object via deserialized object reference");
            int ping2Count = beanRef2.ping(0);
            if (ping2Count != pingCount && pingCount != 1) {
                this.logMsg("ping count: expected " + pingCount + ", received " + ping2Count);
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("test2 failed");
            }
            beanRef2.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test2 failed", e);
        }
        finally {
            try {
                this.logMsg("closing object streams");
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void test3() throws EETest.Fault {
        ObjectInputStream is = null;
        ObjectOutputStream os = null;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props);
            this.logMsg("ping object");
            this.beanRef.ping(0);
            this.logMsg("get handle for object");
            Handle handle = this.beanRef.getHandle();
            this.logMsg("write object output stream to byte array");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(baos);
            os.writeObject(handle);
            this.logMsg("removing object instance of EJB");
            this.beanRef.remove();
            this.logMsg("read object output stream from byte array");
            byte[] b = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            is = new EJBHandleObjectInputStream(bais);
            Handle deserializedHandle = (Handle)is.readObject();
            boolean pass = true;
            try {
                this.logMsg("create object reference from deserialized handle");
                EJBObject ejbObject = deserializedHandle.getEJBObject();
                TestBean beanRef2 = (TestBean)PortableRemoteObject.narrow((Object)ejbObject, TestBean.class);
                this.logMsg("ping object via deserialized object reference");
                int ping2Count = beanRef2.ping(0);
                this.logErr("No exception occurred - unexpected");
                pass = false;
            }
            catch (NoSuchObjectException e) {
                this.logMsg("Caught NoSuchObjectException - expected");
            }
            catch (RemoteException e) {
                this.logMsg("Caught RemoteException - expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Unexpected exception - " + e);
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("test3 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test3 failed", e);
        }
        finally {
            try {
                this.logMsg("closing object streams");
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void test4() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("get handle for home");
            HomeHandle handle = this.beanHome.getHomeHandle();
            if (handle == null) {
                pass = false;
                this.logErr("getHomeHandle() returned null reference");
            } else if (!(handle instanceof Serializable)) {
                pass = false;
                this.logErr("getHomeHandle() is not serializable");
            } else {
                this.logMsg("got home handle and handle is serializable");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test4 failed");
        }
    }

    public void test5() throws EETest.Fault {
        ObjectInputStream is = null;
        ObjectOutputStream os = null;
        boolean pass = true;
        try {
            this.logMsg("get handle for home");
            HomeHandle handle = this.beanHome.getHomeHandle();
            this.logMsg("write object output stream to byte array");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(baos);
            os.writeObject(handle);
            this.logMsg("read object output stream from byte array");
            byte[] b = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            is = new EJBHandleObjectInputStream(bais);
            this.logMsg("deserialize home handle");
            HomeHandle deserializedHandle = (HomeHandle)is.readObject();
            this.logMsg("getEJBHome from HomeHandle");
            TestBeanHome beanHome2 = (TestBeanHome)PortableRemoteObject.narrow((Object)deserializedHandle.getEJBHome(), TestBeanHome.class);
            this.logMsg("Create EJB instance from deserialized home handle");
            this.beanRef = beanHome2.create(this.props);
            this.logMsg("ping object");
            this.beanRef.ping(0);
            this.logMsg("remove object");
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test5 failed", e);
        }
        finally {
            try {
                this.logMsg("closing object streams");
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("test5 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

