/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedQueueConnection;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.IllegalStateException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;

public class ClosedQueueConnectionTests
extends ServiceEETest {
    private static final String TestName = "com.sun.ts.tests.jms.core.closedQueueConnection.ClosedQueueConnectionTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    boolean jmsOptionalApisSupported;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        ClosedQueueConnectionTests theTests = new ClosedQueueConnectionTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void createAndCloseConnection(int type) throws Exception {
        if (type == 0 || type == 2) {
            this.tool = new JmsTool(type, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Closing queue Connection");
            this.tool.getDefaultQueueConnection().close();
        }
        this.logTrace("Connection closed");
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'users' in ts.jte must not be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing QueueConnections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void closedQueueConnectionCommitTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(2);
            this.logTrace("Try to call commit with closed connection.");
            try {
                this.tool.getDefaultQueueSession().commit();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("closedQueueConnectionCommitTest");
        }
    }

    public void closedQueueConnectionGetTransactedTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call getTransacted() with closed connection.");
            try {
                boolean b = this.tool.getDefaultQueueSession().getTransacted();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionGetTransactedTest", e);
        }
    }

    public void closedQueueConnectionRollbackTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call rollback() with closed connection.");
            try {
                this.tool.getDefaultQueueSession().rollback();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionRollbackTest", e);
        }
    }

    public void closedQueueConnectionRecoverTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call recover() with closed connection.");
            try {
                this.tool.getDefaultQueueSession().recover();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionRecoverTest", e);
        }
    }

    public void closedQueueConnectionCloseTest() throws EETest.Fault {
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call close again");
            this.tool.getDefaultQueueConnection().close();
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCloseTest", e);
        }
    }

    public void closedQueueConnectionGetClientIDTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call getClientID");
            try {
                String foo = this.tool.getDefaultQueueConnection().getClientID();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionGetClientIDTest", e);
        }
    }

    public void closedQueueConnectionGetMetaDataTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call getMetaData");
            try {
                ConnectionMetaData foo = this.tool.getDefaultQueueConnection().getMetaData();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionGetMetaDataTest", e);
        }
    }

    public void closedQueueConnectionStartTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call start");
            try {
                this.tool.getDefaultQueueConnection().start();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionStartTest", e);
        }
    }

    public void closedQueueConnectionCreateQueueSessionTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call createQueueSession");
            try {
                QueueSession foo = this.tool.getDefaultQueueConnection().createQueueSession(true, 1);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Fail: wrong exception was returned", (Throwable)e);
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateQueueSessionTest", e);
        }
    }

    public void closedQueueConnectionSessionCloseTest() throws EETest.Fault {
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to close session again.");
            this.tool.getDefaultQueueSession().close();
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionSessionCloseTest", e);
        }
    }

    public void closedQueueConnectionCreateBrowserTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to create QueueBrowser with closed connection.");
            try {
                QueueBrowser qB = this.tool.getDefaultQueueSession().createBrowser(this.tool.getDefaultQueue());
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateBrowserTest", e);
        }
    }

    public void closedQueueConnectionCreateBrowserMsgSelectorTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to create QueueBrowser with closed Connection.");
            try {
                QueueBrowser qB = this.tool.getDefaultQueueSession().createBrowser(this.tool.getDefaultQueue(), "TEST = 'test'");
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateBrowserMsgSelectorTest", e);
        }
    }

    public void closedQueueConnectionCreateQueueTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to create queue with closed Connection.");
            try {
                Queue q = this.tool.getDefaultQueueSession().createQueue("closedQueueConnectionCreateQueueTest");
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateQueueTest", e);
        }
    }

    public void closedQueueConnectionCreateReceiverTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to create Receiver with closed Connection.");
            try {
                QueueReceiver qR = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateReceiverTest", e);
        }
    }

    public void closedQueueConnectionCreateReceiverMsgSelectorTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to create Receiver with closed Connection.");
            try {
                QueueReceiver qR = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue(), "TEST = 'test'");
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateReceiverMsgSelectorTest", e);
        }
    }

    public void closedQueueConnectionCreateSenderTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to create Sender with closed Connection.");
            try {
                QueueSender qS = this.tool.getDefaultQueueSession().createSender(this.tool.getDefaultQueue());
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateSenderTest", e);
        }
    }

    public void closedQueueConnectionCreateTempQueueTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to create TemporaryQueue with closed connection.");
            try {
                TemporaryQueue tQ = this.tool.getDefaultQueueSession().createTemporaryQueue();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateTempQueueTest", e);
        }
    }

    public void closedQueueConnectionCreateMessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to create message with closed connection.");
            try {
                Message m = this.tool.getDefaultQueueSession().createMessage();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateMessageTest", e);
        }
    }

    public void closedQueueConnectionCreateBytesMessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to create BytesMessage with closed connection.");
            try {
                BytesMessage m = this.tool.getDefaultQueueSession().createBytesMessage();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateBytesMessageTest", e);
        }
    }

    public void closedQueueConnectionCreateMapMessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to create MapMessage with closed connection.");
            try {
                MapMessage m = this.tool.getDefaultQueueSession().createMapMessage();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateMapMessageTest", e);
        }
    }

    public void closedQueueConnectionCreateObjectMessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to create ObjectMessage with closed connection.");
            try {
                ObjectMessage m = this.tool.getDefaultQueueSession().createObjectMessage();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateObjectMessageTest", e);
        }
    }

    public void closedQueueConnectionCreateObject2MessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to create ObjectMessage(object) with closed connection.");
            try {
                String s = "Simple object";
                ObjectMessage m = this.tool.getDefaultQueueSession().createObjectMessage((Serializable)((Object)s));
                if (m != null) {
                    this.logTrace("m=" + m);
                }
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateObject2MessageTest", e);
        }
    }

    public void closedQueueConnectionCreateStreamMessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to create StreamMessage with closed connection.");
            try {
                StreamMessage m = this.tool.getDefaultQueueSession().createStreamMessage();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateStreamMessageTest", e);
        }
    }

    public void closedQueueConnectionCreateTextMessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to create TextMessage with closed connection.");
            try {
                TextMessage m = this.tool.getDefaultQueueSession().createTextMessage();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateTextMessageTest", e);
        }
    }

    public void closedQueueConnectionCreateText2MessageTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to create TextMessage with closed connection.");
            try {
                TextMessage m = this.tool.getDefaultQueueSession().createTextMessage("test message");
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionCreateText2MessageTest", e);
        }
    }

    public void closedQueueConnectionReceiverCloseTest() throws EETest.Fault {
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call close again");
            this.tool.getDefaultQueueReceiver().close();
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionReceiverCloseTest", e);
        }
    }

    public void closedQueueConnectionGetMessageSelectorTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call getMessageSelector");
            try {
                String foo = this.tool.getDefaultQueueReceiver().getMessageSelector();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionGetMessageSelectorTest", e);
        }
    }

    public void closedQueueConnectionReceiveTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call receive");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receive();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionReceiveTest", e);
        }
    }

    public void closedQueueConnectionReceiveTimeoutTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call receive(timeout)");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receive(this.timeout);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionReceiveTimeoutTest", e);
        }
    }

    public void closedQueueConnectionReceiveNoWaitTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call receiveNoWait");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receiveNoWait();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionReceiveNoWaitTest", e);
        }
    }

    public void closedQueueConnectionReceiverGetQueueTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call getQueue");
            try {
                Queue foo = this.tool.getDefaultQueueReceiver().getQueue();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionReceiverGetQueueTest", e);
        }
    }

    public void closedQueueConnectionSenderCloseTest() throws EETest.Fault {
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call close again");
            this.tool.getDefaultQueueSender().close();
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionSenderCloseTest", e);
        }
    }

    public void closedQueueConnectionGetDeliveryModeTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call getDeliveryMode");
            try {
                int foo = this.tool.getDefaultQueueSender().getDeliveryMode();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionGetDeliveryModeTest", e);
        }
    }

    public void closedQueueConnectionGetDisableMessageIDTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call getDisableMessageID");
            try {
                boolean foo = this.tool.getDefaultQueueSender().getDisableMessageID();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionGetDisableMessageIDTest", e);
        }
    }

    public void closedQueueConnectionGetDisableMessageTimestampTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call getDisableMessageTimestamp");
            try {
                boolean foo = this.tool.getDefaultQueueSender().getDisableMessageTimestamp();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionGetDisableMessageTimestampTest", e);
        }
    }

    public void closedQueueConnectionGetPriorityTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call getPriority");
            try {
                int foo = this.tool.getDefaultQueueSender().getPriority();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionGetPriorityTest", e);
        }
    }

    public void closedQueueConnectionGetTimeToLiveTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call getTimeToLive");
            try {
                long foo = this.tool.getDefaultQueueSender().getTimeToLive();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionGetTimeToLiveTest", e);
        }
    }

    public void closedQueueConnectionSetDeliveryModeTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call setDeliveryMode");
            try {
                this.tool.getDefaultQueueSender().setDeliveryMode(2);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionSetDeliveryModeTest", e);
        }
    }

    public void closedQueueConnectionSetDisableMessageIDTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call setDisableMessageID");
            try {
                this.tool.getDefaultQueueSender().setDisableMessageID(true);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionSetDisableMessageIDTest", e);
        }
    }

    public void closedQueueConnectionSetDisableMessageTimestampTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call setDisableMessageTimestamp");
            try {
                this.tool.getDefaultQueueSender().setDisableMessageTimestamp(true);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionSetDisableMessageTimestampTest", e);
        }
    }

    public void closedQueueConnectionSetPriorityTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call setPriority");
            try {
                this.tool.getDefaultQueueSender().setPriority(4);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionSetPriorityTest", e);
        }
    }

    public void closedQueueConnectionSetTimeToLiveTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call setTimeToLive");
            try {
                this.tool.getDefaultQueueSender().setTimeToLive(0L);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionSetTimeToLiveTest", e);
        }
    }

    public void closedQueueConnectionSenderGetQueueTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call getQueue");
            try {
                Queue foo = this.tool.getDefaultQueueSender().getQueue();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionSenderGetQueueTest", e);
        }
    }

    public void closedQueueConnectionSend1Test() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call send(Message)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl());
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionSend1Test", e);
        }
    }

    public void closedQueueConnectionSend2Test() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call send(Message,int,int,long)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl(), 2, 4, 0L);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionSend2Test", e);
        }
    }

    public void closedQueueConnectionSend3Test() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call send(Queue,Message)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl());
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionSend3Test", e);
        }
    }

    public void closedQueueConnectionSend4Test() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            this.logTrace("Try to call send(Queue,Message,int,int,long)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl(), 2, 4, 0L);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueConnectionSend4Test", e);
        }
    }
}

