/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.logging;

import com.sun.javatest.logging.FileEvent;
import com.sun.javatest.logging.FileListener;
import com.sun.javatest.logging.LogModel;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogRecord;

public class ObservedFile
extends File {
    private static final boolean debug = false;
    private final List<FileListener> list = new ArrayList<FileListener>();
    private String recordInexName;
    private String loggersInexName;

    public ObservedFile(String name) {
        super(name);
        this.recordInexName = name + ".rec.index";
        this.loggersInexName = name + ".log.index";
    }

    public synchronized void addFileListener(FileListener listener) {
        if (listener != null) {
            this.list.add(listener);
        }
    }

    public synchronized void removeFileListener(FileListener listener) {
        if (listener != null) {
            this.list.remove(listener);
        }
    }

    synchronized void fireFileEvent(FileEvent fileEvent) {
        for (FileListener aFl : this.list) {
            aFl.fileModified(fileEvent);
        }
    }

    public synchronized boolean backup() {
        File to = new File(this.getAbsolutePath() + "~");
        File toRecInd = new File(this.getRecordInexName() + "~");
        File toLogInd = new File(this.getLoggersInexName() + "~");
        to.delete();
        toRecInd.delete();
        toLogInd.delete();
        this.renameTo(to);
        this.getRecordInexFile().renameTo(toRecInd);
        this.getLoggersInexFile().renameTo(toLogInd);
        return !this.exists() && !this.getRecordInexFile().exists() && !this.getLoggersInexFile().exists();
    }

    private String getRecordInexName() {
        return this.recordInexName;
    }

    private String getLoggersInexName() {
        return this.loggersInexName;
    }

    File getRecordInexFile() {
        return new File(this.recordInexName);
    }

    File getLoggersInexFile() {
        return new File(this.loggersInexName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addToIndex(LogRecord record, long startOff, long endOff, String logName) {
        int logNum = -1;
        String line = "";
        boolean found = false;
        RandomAccessFile logs = null;
        RandomAccessFile recs = null;
        try {
            logs = new RandomAccessFile(this.getLoggersInexFile(), "rw");
            while (line != null && logs.getFilePointer() < logs.length()) {
                line = logs.readUTF();
                ++logNum;
                if (!logName.equals(line)) continue;
                found = true;
                break;
            }
            if (!found) {
                ++logNum;
                logs.writeUTF(logName);
            }
            logs.close();
            recs = new RandomAccessFile(this.getRecordInexFile(), "rw");
            recs.seek(recs.length());
            recs.writeInt(logNum);
            recs.writeLong(record.getMillis());
            recs.writeInt(record.getLevel().intValue());
            recs.writeLong(startOff);
            recs.writeLong(endOff);
            recs.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (logs != null) {
                    logs.close();
                }
                if (recs != null) {
                    recs.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    synchronized void readLoggers(List<String> loggers) {
        String line = "";
        try {
            RandomAccessFile logs = new RandomAccessFile(this.getLoggersInexFile(), "r");
            while (line != null && logs.getFilePointer() < logs.length()) {
                line = logs.readUTF();
                loggers.add(line);
            }
            logs.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void readRecords(List<LogModel.LiteLogRecord> records) {
        try {
            RandomAccessFile recs = new RandomAccessFile(this.getRecordInexFile(), "r");
            while (recs.getFilePointer() < recs.length()) {
                LogModel.LiteLogRecord r = new LogModel.LiteLogRecord();
                r.loggerID = recs.readInt();
                r.time = recs.readLong();
                r.severety = recs.readInt();
                r.startOff = recs.readLong();
                r.endOff = recs.readLong();
                records.add(r);
            }
            recs.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean needToBackup() {
        return this.length() != 0L || this.getLoggersInexFile().length() != 0L || this.getRecordInexFile().length() != 0L;
    }
}

