/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.ResourceLoader;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class ProductInfo {
    private static final DateFormat BUILD_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    private static Properties info;
    private static File javatestClassDir;

    public static String getName() {
        return "JT Harness";
    }

    public static String getVersion() {
        return ProductInfo.getProperty("version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDetailedVersion() {
        StringBuilder sb = new StringBuilder(ProductInfo.getVersion()).append('-').append(ProductInfo.getMilestone()).append('+').append(ProductInfo.getBuildNumber());
        Date buildDate = ProductInfo.getBuildDate();
        if (buildDate != null) {
            String buildDateString;
            DateFormat dateFormat = BUILD_DATE_FORMAT;
            synchronized (dateFormat) {
                buildDateString = BUILD_DATE_FORMAT.format(buildDate);
            }
            sb.append('-').append(buildDateString);
        }
        sb.append('-').append(ProductInfo.getSourceCommitID());
        return sb.toString();
    }

    public static boolean isSameVersionOrNewer(String ver) {
        int[] verProd = ProductInfo.parseVersion(ProductInfo.getVersion());
        int[] verCheck = ProductInfo.parseVersion(ver);
        for (int i = 0; i < verProd.length; ++i) {
            if (verProd[i] < verCheck[i]) {
                return false;
            }
            if (verProd[i] <= verCheck[i]) continue;
            return true;
        }
        return true;
    }

    private static int[] parseVersion(String v) {
        int[] arr = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(v, ".");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        int size = list.size();
        if (size > arr.length) {
            size = arr.length;
        }
        for (int i = 0; i < size; ++i) {
            try {
                arr[i] = Integer.parseInt(((String)list.get(i)).toString());
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(v);
            }
        }
        return arr;
    }

    public static String getMilestone() {
        return ProductInfo.getProperty("milestone");
    }

    public static String getBuildNumber() {
        return ProductInfo.getProperty("build");
    }

    public static String getSourceCommitID() {
        return ProductInfo.getProperty("commit");
    }

    public static String getBuildJavaVersion() {
        return ProductInfo.getProperty("java");
    }

    public static Date getBuildDate() {
        DateFormat endf = DateFormat.getDateInstance(1, Locale.US);
        Date date = null;
        try {
            date = endf.parse(ProductInfo.getProperty("date"));
        }
        catch (ParseException pe) {
            date = null;
        }
        return date;
    }

    public static File getJavaTestClassDir() {
        if (javatestClassDir == null) {
            javatestClassDir = ProductInfo.findJavaTestClassDir(System.err);
        }
        return javatestClassDir;
    }

    public static String getPackagingType() {
        return ProductInfo.getProperty("bundle-type");
    }

    public static String getHarnessVariety() {
        return ProductInfo.getProperty("harness-variety");
    }

    private static File findJavaTestClassDir(PrintStream log) {
        String VERBOSE_CLASSDIR_PROPNAME = "verbose_javatestClassDir";
        String CLASSDIR_PROPNAME = "javatestClassDir";
        boolean verbose = log == null ? false : Boolean.getBoolean(VERBOSE_CLASSDIR_PROPNAME);
        I18NResourceBundle i18n = verbose ? I18NResourceBundle.getBundleForClass(ProductInfo.class) : null;
        String jc = System.getProperty(CLASSDIR_PROPNAME);
        if (jc != null) {
            File javatestClassDir = new File(new File(jc).getAbsolutePath());
            if (verbose) {
                log.println("  " + CLASSDIR_PROPNAME + " = " + javatestClassDir);
            }
            return javatestClassDir;
        }
        try {
            String className = ProductInfo.class.getName();
            String classEntry = "/" + className.replace('.', '/') + ".class";
            URL url = ProductInfo.class.getResource(classEntry);
            if (url.getProtocol().equals("jar")) {
                String path = url.getPath();
                int sep = path.lastIndexOf(33);
                path = path.substring(0, sep);
                url = new URL(path);
            }
            if (url.getProtocol().equals("file")) {
                if (url.toString().endsWith(classEntry)) {
                    String urlString = url.toString();
                    url = new URL(urlString.substring(0, urlString.lastIndexOf(classEntry)));
                }
                if (verbose && i18n != null) {
                    log.println(i18n.getString("pi.jcd.result", (Object)javatestClassDir));
                }
                String defaultEnc = new InputStreamReader(System.in).getEncoding();
                return new File(URLDecoder.decode(url.getPath(), defaultEnc));
            }
        }
        catch (UnsupportedEncodingException | MalformedURLException iOException) {
            // empty catch block
        }
        if (verbose && i18n != null) {
            log.println(i18n.getString("pi.jcd.cant"));
        }
        if (i18n == null) {
            i18n = I18NResourceBundle.getBundleForClass(ProductInfo.class);
        }
        throw new IllegalStateException(i18n.getString("pi.jcd.noInstallDir", VERBOSE_CLASSDIR_PROPNAME, CLASSDIR_PROPNAME));
    }

    private static String getProperty(String name) {
        if (info == null) {
            info = new Properties();
            try {
                InputStream in = ResourceLoader.getResourceAsStream("/META-INF/buildInfo.txt", ProductInfo.class);
                if (in != null) {
                    info.load(in);
                    in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return info.getProperty(name, "unset");
    }
}

