/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices12.ejb.annotations.WSEjbAsyncTest.client;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.webservices12.ejb.annotations.WSEjbAsyncTest.client.Hello;
import com.sun.ts.tests.webservices12.ejb.annotations.WSEjbAsyncTest.client.HelloRequest;
import com.sun.ts.tests.webservices12.ejb.annotations.WSEjbAsyncTest.client.HelloResponse;
import com.sun.ts.tests.webservices12.ejb.annotations.WSEjbAsyncTest.client.HelloService;
import com.sun.ts.tests.webservices12.ejb.annotations.WSEjbAsyncTest.client.ObjectFactory;
import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Response;
import jakarta.xml.ws.WebServiceRef;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.namespace.QName;

public class Client
extends EETest {
    private static final ObjectFactory of = new ObjectFactory();
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    String modeProperty = null;
    private static final String PKG_NAME = "com.sun.ts.tests.webservices12.ejb.annotations.WSEjbAsyncTest.client.";
    private static final String NAMESPACEURI = "http://helloservice.org/wsdl";
    private static final String SERVICE_NAME = "HelloService";
    private static final String PORT_NAME = "HelloPort";
    private QName SERVICE_QNAME = new QName("http://helloservice.org/wsdl", "HelloService");
    private QName PORT_QNAME = new QName("http://helloservice.org/wsdl", "HelloPort");
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    Hello port = null;
    @WebServiceRef(name="service/wsejbasynctest")
    static HelloService service = null;

    private void getPortJavaEE() throws Exception {
        TestUtil.logMsg((String)"Obtaining service via WebServiceRef annotation");
        TestUtil.logMsg((String)("service=" + service));
        this.port = (Hello)service.getPort(Hello.class);
        TestUtil.logMsg((String)("port=" + this.port));
        TestUtil.logMsg((String)"Obtained port");
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.getPortJavaEE();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void invokeSynchronousTest() throws EETest.Fault {
        TestUtil.logTrace((String)"invokeSynchronousTest");
        boolean pass = true;
        String reqStr = "foo";
        String resStr = "Hello, foo!";
        try {
            HelloRequest helloReq = of.createHelloRequest();
            helloReq.setString(reqStr);
            HelloResponse helloRes = this.port.hello(helloReq);
            String result = helloRes.getResult();
            TestUtil.logMsg((String)("result=" + result));
            if (!result.equals(resStr)) {
                TestUtil.logErr((String)("expected: " + resStr + ", received: " + result));
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            e.printStackTrace();
        }
        if (!pass) {
            throw new EETest.Fault("invokeSynchronousTest failed");
        }
    }

    public void invokeAsyncPollTest() throws EETest.Fault {
        TestUtil.logTrace((String)"invokeAsyncPollTest");
        boolean pass = true;
        String reqStr = "foo";
        String resStr = "Hello, foo!";
        try {
            HelloRequest helloReq = of.createHelloRequest();
            helloReq.setString(reqStr);
            Response<HelloResponse> response = this.port.helloAsync(helloReq);
            TestUtil.logMsg((String)"Polling and waiting for data ...");
            while (!response.isDone()) {
            }
            HelloResponse helloRes = (HelloResponse)response.get();
            String result = helloRes.getResult();
            TestUtil.logMsg((String)("result=" + result));
            if (!result.equals(resStr)) {
                TestUtil.logErr((String)("expected: " + resStr + ", received: " + result));
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            e.printStackTrace();
        }
        if (!pass) {
            throw new EETest.Fault("invokeAsyncPollTest failed");
        }
    }

    public void invokeAsyncCallbackTest() throws EETest.Fault {
        TestUtil.logTrace((String)"invokeAsyncCallbackTest");
        boolean pass = true;
        String reqStr = "foo";
        String resStr = "Hello, foo!";
        try {
            HelloRequest helloReq = of.createHelloRequest();
            helloReq.setString(reqStr);
            HelloCallbackHandler callbackHandler = new HelloCallbackHandler();
            Future<?> response = this.port.helloAsync(helloReq, callbackHandler);
            TestUtil.logMsg((String)"Waiting for Callback to complete to obtain data ...");
            while (!response.isDone()) {
            }
            HelloResponse helloRes = callbackHandler.getResponse();
            String result = helloRes.getResult();
            TestUtil.logMsg((String)("result=" + result));
            if (!result.equals(resStr)) {
                TestUtil.logErr((String)("expected: " + resStr + ", received: " + result));
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            e.printStackTrace();
        }
        if (!pass) {
            throw new EETest.Fault("invokeAsyncCallbackTest failed");
        }
    }

    private static class HelloCallbackHandler
    implements AsyncHandler<HelloResponse> {
        private HelloResponse output;

        private HelloCallbackHandler() {
        }

        public void handleResponse(Response<HelloResponse> response) {
            try {
                this.output = (HelloResponse)response.get();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        HelloResponse getResponse() {
            return this.output;
        }
    }
}

