/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.bytesMsgQueue;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageNotWriteableException;
import java.util.ArrayList;
import java.util.Properties;

public class BytesMsgQueueTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.bytesMsgQueue.BytesMsgQueueTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        BytesMsgQueueTests theTests = new BytesMsgQueueTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.queues = new ArrayList(2);
            this.connections = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void bytesMsgNullStreamQTest() throws EETest.Fault {
        boolean pass = true;
        int nInt = 1000;
        try {
            BytesMessage messageSentBytesMessage = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            try {
                this.logMsg("Writing a null stream to byte message should throw a NullPointerException");
                messageSentBytesMessage = this.tool.getDefaultQueueSession().createBytesMessage();
                messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "bytesMsgNullStreamQTest");
                messageSentBytesMessage.writeObject(null);
                this.logMsg("Fail: message did not throw NullPointerException exception as expected");
                pass = false;
            }
            catch (NullPointerException np) {
                this.logTrace("Pass: NullPointerException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: bytesMsgNullStreamQTest test failure");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("bytesMsgNullStreamQTest");
        }
    }

    public void bytesMessageQTestsFullMsg() throws EETest.Fault {
        try {
            BytesMessage messageSent = null;
            BytesMessage messageReceived = null;
            boolean pass = true;
            boolean booleanValue = false;
            byte byteValue = 127;
            byte byteValue1 = -12;
            int byteValue2 = 244;
            byte[] bytesValue = new byte[]{127, -127, 1, 0};
            byte[] bytesValueRecvd = new byte[]{0, 0, 0, 0};
            char charValue = 'Z';
            double doubleValue = 6.02E23;
            float floatValue = 6.02E23f;
            int intValue = Integer.MAX_VALUE;
            long longValue = Long.MAX_VALUE;
            Integer nInteger = new Integer(Integer.MIN_VALUE);
            short shortValue = Short.MIN_VALUE;
            short shortValue1 = -28679;
            int shortValue2 = 36857;
            String utfValue = "what";
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "bytesMessageQTestsFullMsg");
            this.logMsg("Writing one of each primitive type to the message");
            messageSent.writeBoolean(booleanValue);
            messageSent.writeByte(byteValue);
            messageSent.writeByte(byteValue1);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(doubleValue);
            messageSent.writeFloat(floatValue);
            messageSent.writeInt(intValue);
            messageSent.writeLong(longValue);
            messageSent.writeObject((Object)nInteger);
            messageSent.writeShort(shortValue);
            messageSent.writeShort(shortValue1);
            messageSent.writeUTF(utfValue);
            messageSent.writeBytes(bytesValue);
            messageSent.writeBytes(bytesValue, 0, 1);
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            try {
                if (messageReceived.readBoolean() == booleanValue) {
                    this.logTrace("Pass: boolean returned ok");
                } else {
                    this.logMsg("Fail: boolean not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readByte() == byteValue) {
                    this.logTrace("Pass: Byte returned ok");
                } else {
                    this.logMsg("Fail: Byte not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                int tmp = messageReceived.readUnsignedByte();
                if (tmp == byteValue2) {
                    this.logTrace("Pass: Byte returned ok: " + byteValue2);
                } else {
                    this.logMsg("Fail: readUnsignedByte not returned expected value: " + tmp);
                    pass = false;
                }
            }
            catch (Exception e) {
                this.logErr("Error: unexpected exceptionwas thrown", e);
                pass = false;
            }
            try {
                if (messageReceived.readChar() == charValue) {
                    this.logTrace("Pass: correct char");
                } else {
                    this.logMsg("Fail: char not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readDouble() == doubleValue) {
                    this.logTrace("Pass: correct double");
                } else {
                    this.logMsg("Fail: double not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readFloat() == floatValue) {
                    this.logTrace("Pass: correct float");
                } else {
                    this.logMsg("Fail: float not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readInt() == intValue) {
                    this.logTrace("Pass: correct int");
                } else {
                    this.logMsg("Fail: int not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readLong() == longValue) {
                    this.logTrace("Pass: correct long");
                } else {
                    this.logMsg("Fail: long not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readInt() == nInteger.intValue()) {
                    this.logTrace("Pass: correct Integer returned");
                } else {
                    this.logMsg("Fail: Integer not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readShort() == shortValue) {
                    this.logTrace("Pass: correct short");
                } else {
                    this.logMsg("Fail: short not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                int tmps = messageReceived.readUnsignedShort();
                if (tmps == shortValue2) {
                    this.logTrace("Pass: correct value returned by readUnsignedShort=" + shortValue2);
                } else {
                    this.logErr("Fail: readUnsignedShort did not return expected value: " + tmps);
                    pass = false;
                }
            }
            catch (Exception e) {
                this.logErr("Error: unexpected exception was thrown", e);
                pass = false;
            }
            try {
                if (messageReceived.readUTF().equals(utfValue)) {
                    this.logTrace("Pass: correct UTF");
                } else {
                    this.logMsg("Fail: UTF not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                int nCount = messageReceived.readBytes(bytesValueRecvd);
                for (int i = 0; i < nCount; ++i) {
                    if (bytesValueRecvd[i] != bytesValue[i]) {
                        this.logMsg("Fail: bytes value incorrect");
                        pass = false;
                        continue;
                    }
                    this.logTrace("Pass: byte value " + i + " ok");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                int nCount = messageReceived.readBytes(bytesValueRecvd);
                this.logTrace("count returned " + nCount);
                if (bytesValueRecvd[0] != bytesValue[0]) {
                    this.logMsg("Fail: bytes value incorrect");
                    pass = false;
                } else {
                    this.logTrace("Pass: byte value ok");
                }
                if (nCount == 1) {
                    this.logTrace("Pass: correct count");
                } else {
                    this.logMsg("Fail: count not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                long length = 37L;
                long tmpl = messageReceived.getBodyLength();
                if (tmpl < length) {
                    this.logErr("getBodyLength test failed with incorrect length=" + tmpl);
                    pass = false;
                }
            }
            catch (Exception e) {
                this.logErr("Error: getBodyLength test threw unexpected exception", e);
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("bytesMessageQTestsFullMsg", e);
        }
    }

    public void bytesMessageQNotWriteable() throws EETest.Fault {
        try {
            BytesMessage messageSent = null;
            BytesMessage messageReceived = null;
            boolean pass = true;
            byte bValue = 127;
            byte[] bbValue = new byte[]{127, -127, 1, 0};
            char cValue = 'Z';
            double dValue = 6.02E23;
            float fValue = 6.02E23f;
            int iValue = Integer.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            short sValue = Short.MIN_VALUE;
            String ssValue = "what";
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "bytesMessageQNotWriteable");
            messageSent.writeBytes(bbValue);
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("Writing a boolean ... ");
            try {
                messageReceived.writeBoolean(pass);
                this.logErr("Shouldn't get here");
                throw new EETest.Fault("Error: test failed to be able to writeBoolean");
            }
            catch (MessageNotWriteableException e) {
                this.logMsg("Got Expected MessageNotWriteableException with writeBoolean");
                this.logMsg("Writing a byte ... ");
                try {
                    messageReceived.writeByte(bValue);
                    this.logErr("Shouldn't get here");
                    throw new EETest.Fault("Error: test failed to be able to writeByte");
                }
                catch (MessageNotWriteableException e2) {
                    this.logMsg("Got Expected MessageNotWriteableException with writeByte");
                    this.logMsg("Writing a short ... ");
                    try {
                        messageReceived.writeShort(sValue);
                        this.logErr("Shouldn't get here");
                        throw new EETest.Fault("Error: test failed to be able to writeShort");
                    }
                    catch (MessageNotWriteableException e3) {
                        this.logMsg("Got Expected MessageNotWriteableException with writeShort");
                        this.logMsg("Writing a char ... ");
                        try {
                            messageReceived.writeChar(cValue);
                            this.logErr("Shouldn't get here");
                            throw new EETest.Fault("Error: test failed to be able to writeChar");
                        }
                        catch (MessageNotWriteableException e4) {
                            this.logMsg("Got Expected MessageNotWriteableException with writeChar");
                            this.logMsg("Writing a int ... ");
                            try {
                                messageReceived.writeInt(iValue);
                                this.logErr("Shouldn't get here");
                                throw new EETest.Fault("Error: test failed to be able to writeInt");
                            }
                            catch (MessageNotWriteableException e5) {
                                this.logMsg("Got Expected MessageNotWriteableException with writeInt");
                                this.logMsg("Writing a long ... ");
                                try {
                                    messageReceived.writeLong(lValue);
                                    this.logErr("Shouldn't get here");
                                    throw new EETest.Fault("Error: test failed to be able to writeLong");
                                }
                                catch (MessageNotWriteableException e6) {
                                    this.logMsg("Got Expected MessageNotWriteableException with writeLong");
                                    this.logMsg("Writing a float ... ");
                                    try {
                                        messageReceived.writeFloat(fValue);
                                        this.logErr("Shouldn't get here");
                                        throw new EETest.Fault("Error: test failed to be able to writeFloat");
                                    }
                                    catch (MessageNotWriteableException e7) {
                                        this.logMsg("Got Expected MessageNotWriteableException with writeFloat");
                                        this.logMsg("Writing a double ... ");
                                        try {
                                            messageReceived.writeDouble(dValue);
                                            this.logErr("Shouldn't get here");
                                            throw new EETest.Fault("Error: test failed to be able to writeDouble");
                                        }
                                        catch (MessageNotWriteableException e8) {
                                            this.logMsg("Got Expected MessageNotWriteableException with writeDouble");
                                            this.logMsg("Writing a bytes... ");
                                            try {
                                                messageReceived.writeBytes(bbValue);
                                                this.logErr("Shouldn't get here");
                                                throw new EETest.Fault("Error: test failed to be able to writeBytes");
                                            }
                                            catch (MessageNotWriteableException e9) {
                                                this.logMsg("Got Expected MessageNotWriteableException with writeBytes");
                                                this.logMsg("Writing a bytes... ");
                                                try {
                                                    messageReceived.writeBytes(bbValue, 0, 2);
                                                    this.logErr("Shouldn't get here");
                                                    throw new EETest.Fault("Error: test failed to be able to writeBytes");
                                                }
                                                catch (MessageNotWriteableException e10) {
                                                    this.logMsg("Got Expected MessageNotWriteableException with writeBytes");
                                                    this.logMsg("Writing a UTF ... ");
                                                    try {
                                                        messageReceived.writeUTF(ssValue);
                                                        this.logErr("Shouldn't get here");
                                                        throw new EETest.Fault("Error: test failed to be able to writeUTF");
                                                    }
                                                    catch (MessageNotWriteableException e11) {
                                                        this.logMsg("Got Expected MessageNotWriteableException with writeUTF");
                                                        this.logMsg("Writing a object ... ");
                                                        try {
                                                            messageReceived.writeObject((Object)new Integer(iValue));
                                                            this.logErr("Shouldn't get here");
                                                            throw new EETest.Fault("Error: test failed to be able to writeObject");
                                                        }
                                                        catch (MessageNotWriteableException e12) {
                                                            this.logMsg("Got Expected MessageNotWriteableException with writeObject");
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("BytesMessageQueueNotWriteable", e);
        }
    }
}

