/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.xa.event;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import com.sun.ts.tests.connector.util.DBSupport;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class eventClient1
extends ServiceEETest
implements Serializable {
    private TSNamingContext nctx = null;
    private TSConnection con = null;
    private String whitebox_xa = null;
    private TSDataSource ds1 = null;
    private DBSupport dbutil = null;

    public static void main(String[] args) {
        eventClient1 theTests = new eventClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.whitebox_xa = p.getProperty("whitebox-xa");
        this.logMsg("Using: " + this.whitebox_xa);
        try {
            this.dbutil = new DBSupport();
        }
        catch (Exception e) {
            throw new EETest.Fault("Exception constructing DBSupport object: " + e.getMessage(), e);
        }
        try {
            this.nctx = new TSNamingContext();
            this.ds1 = (TSDataSource)this.nctx.lookup(this.whitebox_xa);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("Exception during JNDI lookup: " + e.getMessage()));
        }
    }

    public void testConnectionEventListener() throws EETest.Fault {
        boolean b = false;
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logMsg((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        try {
            this.ds1.setLogFlag(true);
            this.con.close();
            this.ds1.setLogFlag(false);
            String toCheck = "TSConnectionEventListener.sendEvent:CONNECTION_CLOSED:";
            Vector log = this.ds1.getLog();
            if (log.contains(toCheck)) {
                b = true;
            }
            TestUtil.logTrace((String)log.toString());
            if (!b) {
                throw new EETest.Fault("CONNECTION_CLOSED event was not called.");
            }
            TestUtil.logMsg((String)"CONNECTION_CLOSED called correctly.");
            this.ds1.clearLog();
        }
        catch (Exception e) {
            TestUtil.logMsg((String)"Exception caught on closing connection:");
            throw new EETest.Fault(e.getMessage(), e);
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"Cleanup");
        try {
            this.ds1.clearLog();
            TestUtil.logTrace((String)"Closing connection in cleanup.");
            this.con.close();
        }
        catch (Exception sqle) {
            TestUtil.logErr((String)("Exception on cleanup: " + sqle.getMessage()), (Throwable)sqle);
        }
    }
}

