/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ee4j.jakartaeetck.tools.jtreportparser;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.ee4j.jakartaeetck.tools.jtreportparser.TestStatus;

public class TestCase {
    private final String testName;
    private final String className;
    private final long duration;
    private final TestStatus status;
    private final String sysoutFile;
    private String errorMsg;

    public TestCase(String testName, String className, long duration, TestStatus status, String sysoutFile) {
        this.testName = testName;
        this.className = className;
        this.duration = duration;
        this.status = status;
        this.sysoutFile = sysoutFile;
    }

    public TestStatus getStatus() {
        return this.status;
    }

    public void setErrorMsg(String msg) {
        String value = msg;
        value = value.replaceAll("\"", "&#34;");
        value = value.replaceAll("&", "&#38;");
        value = value.replaceAll("'", "&#39;");
        value = value.replaceAll("<", "&lt;");
        this.errorMsg = value = value.replaceAll(">", "&gt;");
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getName() {
        return "" + this.className + "#" + this.testName;
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder("  <testcase ");
        sb.append(" name=\"").append(this.testName).append("\"");
        sb.append(" classname=\"").append(this.className).append("\"");
        sb.append(" time=\"").append(this.duration).append("\"");
        sb.append(" status=\"").append(this.status.getStatus()).append("\"");
        sb.append(">");
        sb.append(System.getProperty("line.separator"));
        if (this.status == TestStatus.ERROR) {
            sb.append("<error type=\"Error\" message=\"").append(this.errorMsg).append("\">").append(this.errorMsg).append("</error>");
        }
        if (this.status == TestStatus.FAILED) {
            sb.append("<failure type=\"AssertionFailure\" message=\"").append(this.errorMsg).append("\">").append(this.errorMsg).append("</failure>");
        }
        if (this.status == TestStatus.EXCLUDED) {
            sb.append("<skipped />");
        }
        sb.append("<system-out>");
        sb.append(System.getProperty("line.separator"));
        sb.append(this.sysoutFile);
        sb.append(System.getProperty("line.separator"));
        sb.append("</system-out>");
        sb.append(System.getProperty("line.separator"));
        sb.append("</testcase>");
        return sb.toString();
    }

    public void toXML(PrintWriter writer) {
        writer.println("  <testcase ");
        writer.println(" name=\"" + this.testName + "\"");
        writer.println(" classname=\"" + this.className + "\"");
        writer.println(" time=\"" + this.duration + "\"");
        writer.println(" status=\"" + this.status.getStatus() + "\"");
        writer.println(">");
        if (this.status == TestStatus.ERROR) {
            writer.println("<error type=\"Error\" message=\"" + this.errorMsg + "\">" + this.errorMsg + "</error>");
        }
        if (this.status == TestStatus.FAILED) {
            writer.println("<failure type=\"AssertionFailure\" message=\"" + this.errorMsg + "\">" + this.errorMsg + "</failure>");
        }
        if (this.status == TestStatus.EXCLUDED) {
            writer.println("<skipped />");
        }
        writer.println("<system-out>");
        boolean embedSysoutFlag = Boolean.parseBoolean(System.getProperty("junit.embed.sysout", "false"));
        if (embedSysoutFlag && this.status != TestStatus.PASSED) {
            File outputFile = new File(this.sysoutFile);
            if (outputFile.exists() && outputFile.isFile() && outputFile.canRead()) {
                try (Stream<String> stream = Files.lines(Paths.get(this.sysoutFile, new String[0]));){
                    stream.forEach(x -> writer.println(StringEscapeUtils.escapeXml11(x)));
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        } else {
            writer.println(this.sysoutFile);
        }
        writer.println("</system-out>");
        writer.println("</testcase>");
        writer.flush();
    }

    public String toString() {
        return "TestCase{testName=" + this.testName + ", className=" + this.className + ", status=" + (Object)((Object)this.status) + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.testName);
        hash = 67 * hash + Objects.hashCode(this.className);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestCase other = (TestCase)obj;
        if (!Objects.equals(this.testName, other.testName)) {
            return false;
        }
        return Objects.equals(this.className, other.className);
    }
}

