/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jacc.web.containerContracts;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSHttpsURLConnection;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.BASE64Encoder;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jacc.util.LogFileProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class Client
extends ServiceEETest {
    private Properties props = null;
    private String hostname = null;
    private int portnum = 0;
    private String pageBase = "/jacc_web_containerContracts_web";
    private String securedPage = "/secured.jsp";
    private String sslProtectedPage = "/sslprotected.jsp";
    private String authusername = "";
    private String authpassword = "";
    private String username = "";
    private String password = "";
    private int securedPortNum = 0;
    private TSNamingContext nctx = null;
    private LogFileProcessor logProcessor = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.hostname = p.getProperty("webServerHost");
            this.portnum = Integer.parseInt(p.getProperty("webServerPort"));
            this.securedPortNum = Integer.parseInt(p.getProperty("securedWebServicePort"));
            this.authusername = p.getProperty("authuser");
            this.authpassword = p.getProperty("authpassword");
            this.username = p.getProperty("user");
            this.password = p.getProperty("password");
            this.nctx = new TSNamingContext();
            this.logProcessor = new LogFileProcessor(this.props);
            this.logProcessor.fetchLogs("pullAllLogRecords|fullLog");
        }
        catch (Exception e) {
            this.logErr("Error: got exception: ", e);
        }
    }

    public void cleanup() throws EETest.Fault {
    }

    public void IsUserInRole() throws EETest.Fault {
        TSURL ctsurl = new TSURL();
        String url = ctsurl.getURLString("http", this.hostname, this.portnum, this.pageBase + this.securedPage);
        try {
            String line;
            URL newURL = new URL(url);
            String authData = this.authusername + ":" + this.authpassword;
            TestUtil.logMsg((String)("authData : " + authData));
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedAuthData = encoder.encode(authData.getBytes());
            TestUtil.logMsg((String)("encoded authData : " + encodedAuthData));
            URLConnection urlConn = newURL.openConnection();
            TestUtil.logMsg((String)("HttpURLconnection established to :" + newURL.toString()));
            urlConn.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            InputStream content = urlConn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(content));
            Object output = "";
            while ((line = in.readLine()) != null) {
                output = (String)output + line;
                TestUtil.logMsg((String)line);
            }
            TestUtil.logMsg((String)("Data received" + (String)output));
            String stringToSearch = this.authusername;
            if (((String)output).indexOf(stringToSearch) == -1) {
                throw new EETest.Fault("PermissionToRole: getRemoteUser(): - did not find \"" + stringToSearch + "\" in log.");
            }
            TestUtil.logMsg((String)"User javajoe accessed secured.jsp");
        }
        catch (Exception e) {
            TestUtil.logErr((String)e.getMessage(), (Throwable)e);
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("IsUserInRole : FAILED", e);
        }
    }

    public void WebUserDataPermission() throws EETest.Fault {
        boolean verified = false;
        TSURL ctsurl = new TSURL();
        String url = ctsurl.getURLString("https", this.hostname, this.securedPortNum, this.pageBase + this.sslProtectedPage);
        try {
            String line;
            URL newURL = new URL(url);
            String authData = this.authusername + ":" + this.authpassword;
            TestUtil.logMsg((String)("authData : " + authData));
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedAuthData = encoder.encode(authData.getBytes());
            TestUtil.logMsg((String)("encoded authData : " + encodedAuthData));
            TSHttpsURLConnection httpsURLConn = new TSHttpsURLConnection();
            if (httpsURLConn == null) {
                throw new EETest.Fault("Error opening httsURLConnection");
            }
            TestUtil.logMsg((String)("WebUserDataPermission():  hostname = " + this.hostname));
            TestUtil.logMsg((String)("WebUserDataPermission():  securedPortNum = " + this.securedPortNum));
            TestUtil.logMsg((String)("WebUserDataPermission():  pageBase = " + this.pageBase));
            TestUtil.logMsg((String)("WebUserDataPermission():  sslProtectedPage = " + this.sslProtectedPage));
            TestUtil.logMsg((String)("WebUserDataPermission():  url.toString() = " + url.toString()));
            TestUtil.logMsg((String)("WebUserDataPermission():  newURL.toString() = " + newURL.toString()));
            TestUtil.logMsg((String)("Opening https url connection to: " + newURL.toString()));
            httpsURLConn.init(newURL);
            httpsURLConn.setDoInput(true);
            httpsURLConn.setDoOutput(true);
            httpsURLConn.setUseCaches(false);
            httpsURLConn.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            InputStream content = httpsURLConn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(content));
            Object output = "";
            while ((line = in.readLine()) != null) {
                output = (String)output + line;
                TestUtil.logMsg((String)line);
            }
            String stringToSearch = this.authusername;
            if (((String)output).indexOf(stringToSearch) == -1) {
                throw new EETest.Fault("PermissionToRole: getRemoteUser(): - did not find \"" + stringToSearch + "\" in log.");
            }
            TestUtil.logMsg((String)"User javajoe accessed sslprotected.jsp");
        }
        catch (Exception e) {
            throw new EETest.Fault("WebUserDataPermission : FAILED", e);
        }
    }

    public void WebResourcePermission() throws EETest.Fault {
        TSURL ctsurl = new TSURL();
        String url = ctsurl.getURLString("http", this.hostname, this.portnum, this.pageBase + this.securedPage);
        try {
            String line;
            URL newURL = new URL(url);
            String authData = this.username + ":" + this.password;
            TestUtil.logMsg((String)("authData : " + authData));
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedAuthData = encoder.encode(authData.getBytes());
            TestUtil.logMsg((String)("encoded authData : " + encodedAuthData));
            URLConnection urlConn = newURL.openConnection();
            urlConn.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            InputStream content = urlConn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(content));
            Object output = "";
            while ((line = in.readLine()) != null) {
                output = (String)output + line;
                TestUtil.logMsg((String)line);
            }
            throw new EETest.Fault("WebResourcePermission test failed :User j2ee allowed to access secured.jsp");
        }
        catch (IOException e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)"Got expected IOException : user j2ee not allowed to access secured.jsp ");
            TestUtil.logMsg((String)"WebResourcePermission test passed");
            return;
        }
    }
}

