/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.temporal;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.temporal.A2_Field;
import com.sun.ts.tests.jpa.core.annotations.temporal.A2_Property;
import com.sun.ts.tests.jpa.core.annotations.temporal.A_Field;
import com.sun.ts.tests.jpa.core.annotations.temporal.A_Property;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 21L;
    Date date = null;
    Date date2 = null;
    Calendar calendar = null;
    Calendar calendar2 = null;
    A_Field aFieldRef;
    A_Property aPropertyRef;
    A2_Field a2FieldRef;
    A2_Property a2PropertyRef;
    List<Date> expectedDates;
    List<Calendar> expectedCalendars;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setupData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void basicFieldTest() throws EETest.Fault {
        boolean pass = false;
        try {
            A_Field a = (A_Field)this.getEntityManager().find(A_Field.class, (Object)"1");
            if (a != null) {
                if (this.aFieldRef.equals((Object)a)) {
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected:" + this.aFieldRef.toString() + ", actual:" + a.toString()));
                }
            } else {
                TestUtil.logErr((String)"Find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("basicFieldTest failed");
        }
    }

    public void basicPropertyTest() throws EETest.Fault {
        boolean pass = false;
        try {
            A_Property a = (A_Property)this.getEntityManager().find(A_Property.class, (Object)"2");
            if (a != null) {
                if (this.aPropertyRef.equals((Object)a)) {
                    TestUtil.logTrace((String)("Received expected entity:" + a.toString()));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected:" + this.aPropertyRef.toString() + ", actual:" + a.toString()));
                }
            } else {
                TestUtil.logErr((String)"Find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("basicPropertyTest failed");
        }
    }

    public void fieldElementCollectionTemporalTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find the previously persisted Customer and Country and verify them");
            A_Field a = (A_Field)this.getEntityManager().find(A_Field.class, (Object)"1");
            if (a != null) {
                TestUtil.logTrace((String)("Found A: " + a.toString()));
                if (a.getDates().containsAll(this.expectedDates) && this.expectedDates.containsAll(a.getDates()) && a.getDates().size() == this.expectedDates.size()) {
                    TestUtil.logTrace((String)"Received expected Dates:");
                    for (Date d : a.getDates()) {
                        TestUtil.logTrace((String)("date:" + d));
                    }
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Did not get expected results.");
                    for (Date d : this.expectedDates) {
                        TestUtil.logErr((String)("expected:" + d));
                    }
                    TestUtil.logErr((String)"actual:");
                    for (Date d : a.getDates()) {
                        TestUtil.logErr((String)("actual:" + d));
                    }
                }
            } else {
                TestUtil.logErr((String)"Find returned null A");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("fieldElementCollectionTemporalTest failed");
        }
    }

    public void propertyElementCollectionTemporalTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find the previously persisted Customer and Country and verify them");
            A_Property a = (A_Property)this.getEntityManager().find(A_Property.class, (Object)"2");
            if (a != null) {
                TestUtil.logTrace((String)("Found A2: " + a.toString()));
                if (a.getDates().containsAll(this.expectedCalendars) && this.expectedCalendars.containsAll(a.getDates()) && a.getDates().size() == this.expectedCalendars.size()) {
                    TestUtil.logTrace((String)"Received expected Dates:");
                    for (Calendar d : a.getDates()) {
                        TestUtil.logTrace((String)("date:" + d));
                    }
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Did not get expected results.");
                    for (Comparable<Date> d : this.expectedDates) {
                        TestUtil.logErr((String)("expected:" + d));
                    }
                    TestUtil.logErr((String)"actual:");
                    for (Comparable<Date> d : a.getDates()) {
                        TestUtil.logErr((String)("actual:" + (Calendar)d));
                    }
                }
            } else {
                TestUtil.logErr((String)"Find returned null A2");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("propertyElementCollectionTemporalTest failed");
        }
    }

    public void idFieldTest() throws EETest.Fault {
        boolean pass = false;
        try {
            A2_Field a = (A2_Field)this.getEntityManager().find(A2_Field.class, (Object)this.date2);
            if (a != null) {
                if (this.a2FieldRef.equals((Object)a)) {
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected:" + this.a2FieldRef.toString() + ", actual:" + a.toString()));
                }
            } else {
                TestUtil.logErr((String)"Find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("idFieldTest failed");
        }
    }

    public void idPropertyTest() throws EETest.Fault {
        boolean pass = false;
        try {
            A2_Property a = (A2_Property)this.getEntityManager().find(A2_Property.class, (Object)this.calendar2);
            if (a != null) {
                if (this.a2PropertyRef.equals((Object)a)) {
                    TestUtil.logTrace((String)("Received expected entity:" + a.toString()));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected:" + this.a2PropertyRef.toString() + ", actual:" + a.toString()));
                }
            } else {
                TestUtil.logErr((String)"Find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("idPropertyTest failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestData() {
        TestUtil.logTrace((String)"createTestData");
        try {
            this.getEntityTransaction().begin();
            this.date = this.getSQLDate();
            LocalDate localDate = ((java.sql.Date)this.date).toLocalDate();
            this.date2 = this.getUtilDate("2000-02-14");
            String sDate2 = "2000-02-14";
            this.calendar = Calendar.getInstance();
            this.calendar.clear();
            this.calendar.set(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
            this.calendar2 = this.getCalDate(2001, 6, 27);
            String sCalendar2 = "2001-06-27";
            this.expectedDates = new ArrayList<Date>();
            this.expectedDates.add(this.getUtilDate("2000-02-14"));
            this.expectedDates.add(this.getUtilDate("2001-06-27"));
            this.expectedDates.add(this.getUtilDate("2002-07-07"));
            this.aFieldRef = new A_Field("1", this.date, this.calendar, this.expectedDates);
            this.expectedCalendars = new ArrayList<Calendar>();
            this.expectedCalendars.add(this.getCalDate(2000, 2, 14));
            this.expectedCalendars.add(this.getCalDate(2001, 6, 27));
            this.expectedCalendars.add(this.getCalDate(2002, 7, 7));
            this.aPropertyRef = new A_Property("2", this.date, this.calendar, this.expectedCalendars);
            this.getEntityManager().persist((Object)this.aFieldRef);
            this.getEntityManager().persist((Object)this.aPropertyRef);
            this.a2FieldRef = new A2_Field(this.date2, sDate2);
            this.a2PropertyRef = new A2_Property(this.calendar2, sCalendar2);
            this.getEntityManager().persist((Object)this.a2FieldRef);
            this.getEntityManager().persist((Object)this.a2PropertyRef);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM A_BASIC").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATE_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATES_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

