/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.cmp.complexpktest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp.complexpktest.ComplexPK;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp.complexpktest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp.complexpktest.TestBeanHome;
import jakarta.ejb.FinderException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.rmi.PortableRemoteObject;

public class Client
extends EETest {
    private static final String testBean = "java:comp/env/ejb/TestBean";
    private TestBean beanRef = null;
    private Properties props = new Properties();
    private TestBeanHome beanHome = null;
    private TSNamingContext nctx = null;
    private boolean setupOK = false;
    private static final int NUMEJBS = 4;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testBean, TestBeanHome.class);
            this.setupOK = true;
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        boolean pass = false;
        TestBean[] beanRef = new TestBean[4];
        TestBean testRef1 = null;
        TestBean testRef2 = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance test1");
            beanRef[0] = this.beanHome.create(1, "Hazelnut", 1.0, 1, "USA");
            beanRef[0].initLogging(this.props);
            beanRef[1] = this.beanHome.create(1, "Villacreme", 1.25, 2, "Columbia");
            beanRef[1].initLogging(this.props);
            beanRef[2] = this.beanHome.create(1, "MochoJava", 1.5, 3, "Brazil");
            beanRef[2].initLogging(this.props);
            beanRef[3] = this.beanHome.create(2, "Hazelnut", 1.75, 4, "USA");
            beanRef[3].initLogging(this.props);
            testRef1 = this.beanHome.findByPrimaryKey(new ComplexPK(1, "Hazelnut"));
            testRef2 = this.beanHome.findByPrimaryKey(new ComplexPK(1, "Villacreme"));
            if (testRef1.isIdentical(beanRef[0]) && testRef2.isIdentical(beanRef[1])) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test1: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test1 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 4; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test1 failed");
        }
    }

    public void test3() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[4];
        TestBean[] testRef = new TestBean[4];
        try {
            TestUtil.logMsg((String)"Create EJB instance test3");
            beanRef[0] = this.beanHome.create(1, "Hazelnut", 1.0, 1, "USA");
            beanRef[0].initLogging(this.props);
            beanRef[1] = this.beanHome.create(1, "Villacreme", 1.25, 2, "Columbia");
            beanRef[1].initLogging(this.props);
            beanRef[2] = this.beanHome.create(1, "MochoJava", 1.5, 3, "Brazil");
            beanRef[2].initLogging(this.props);
            beanRef[3] = this.beanHome.create(2, "Hazelnut", 1.75, 4, "USA");
            beanRef[3].initLogging(this.props);
            Collection c = this.beanHome.findByName("Hazelnut");
            TestUtil.logMsg((String)"Check if we found the correct EJB references");
            TestUtil.logMsg((String)("Number of EJB references returned = " + c.size()));
            Iterator i = c.iterator();
            int j = 0;
            while (i.hasNext()) {
                testRef[j++] = (TestBean)PortableRemoteObject.narrow(i.next(), TestBean.class);
            }
            if (c.size() != 2) {
                TestUtil.logErr((String)("findByName returned " + c.size() + " references, expected 2 references"));
                pass = false;
            } else {
                for (int k = 0; k < c.size(); ++k) {
                    boolean found = false;
                    for (int l = 0; l < 4; ++l) {
                        if (!beanRef[l].isIdentical(testRef[k])) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        TestUtil.logErr((String)("findByName returned incorrect reference for k=" + k));
                        pass = false;
                        continue;
                    }
                    TestUtil.logMsg((String)("findByName returned correct reference for k=" + k));
                }
                if (testRef[0].isIdentical(testRef[1])) {
                    TestUtil.logErr((String)"findByName returned references not all unique");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test3: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test3 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 4; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test3 failed");
        }
    }

    public void test4() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[4];
        TestBean[] testRef = new TestBean[4];
        try {
            TestUtil.logMsg((String)"Create EJB instance test4");
            beanRef[0] = this.beanHome.create(1, "Hazelnut", 1.0, 1, "USA");
            beanRef[0].initLogging(this.props);
            beanRef[1] = this.beanHome.create(1, "Villacreme", 1.25, 2, "Columbia");
            beanRef[1].initLogging(this.props);
            beanRef[2] = this.beanHome.create(1, "MochoJava", 1.5, 3, "Brazil");
            beanRef[2].initLogging(this.props);
            beanRef[3] = this.beanHome.create(2, "Hazelnut", 1.75, 4, "USA");
            beanRef[3].initLogging(this.props);
            Collection c = this.beanHome.findById(new Integer(1));
            TestUtil.logMsg((String)"Check if we found the correct EJB references");
            TestUtil.logMsg((String)("Number of EJB references returned = " + c.size()));
            Iterator i = c.iterator();
            int j = 0;
            while (i.hasNext()) {
                testRef[j++] = (TestBean)PortableRemoteObject.narrow(i.next(), TestBean.class);
            }
            if (c.size() != 3) {
                TestUtil.logErr((String)("findById returned " + c.size() + " references, expected 3 references"));
                pass = false;
            } else {
                for (int k = 0; k < c.size(); ++k) {
                    boolean found = false;
                    for (int l = 0; l < 4; ++l) {
                        if (!beanRef[l].isIdentical(testRef[k])) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        TestUtil.logErr((String)("findById returned incorrect reference for k=" + k));
                        pass = false;
                        continue;
                    }
                    TestUtil.logMsg((String)("findById returned correct reference for k=" + k));
                }
                if (testRef[0].isIdentical(testRef[1]) || testRef[1].isIdentical(testRef[2]) || testRef[0].isIdentical(testRef[2])) {
                    TestUtil.logErr((String)"findById returned references not all unique");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test4: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test4 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 4; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test4 failed");
        }
    }

    public void test5() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[4];
        TestBean testRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance test5");
            beanRef[0] = this.beanHome.create(1, "Hazelnut", 1.0, 1, "USA");
            beanRef[0].initLogging(this.props);
            beanRef[1] = this.beanHome.create(1, "Villacreme", 1.25, 2, "Columbia");
            beanRef[1].initLogging(this.props);
            beanRef[2] = this.beanHome.create(1, "MochoJava", 1.5, 3, "Brazil");
            beanRef[2].initLogging(this.props);
            beanRef[3] = this.beanHome.create(2, "Hazelnut", 1.75, 4, "USA");
            beanRef[3].initLogging(this.props);
            Collection c = this.beanHome.findByPrice(1.25);
            TestUtil.logMsg((String)"Check if we found the correct EJB references");
            TestUtil.logMsg((String)("Number of EJB references returned = " + c.size()));
            if (c.size() != 1) {
                TestUtil.logErr((String)("findByPrice returned " + c.size() + " references, expected 1 reference"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check if we found the correct EJB reference");
                Iterator i = c.iterator();
                testRef = (TestBean)PortableRemoteObject.narrow(i.next(), TestBean.class);
                if (beanRef[1].isIdentical(testRef)) {
                    TestUtil.logMsg((String)"findByPrice returned correct reference");
                    pass = true;
                } else {
                    TestUtil.logErr((String)"findByPrice returned incorrect reference");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test5: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test5 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 4; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test5 failed");
        }
    }

    public void test6() throws EETest.Fault {
        boolean pass = false;
        TestBean[] beanRef = new TestBean[4];
        TestBean testRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance test6");
            beanRef[0] = this.beanHome.create(1, "Hazelnut", 1.0, 1, "USA");
            beanRef[0].initLogging(this.props);
            beanRef[1] = this.beanHome.create(1, "Villacreme", 1.25, 2, "Columbia");
            beanRef[1].initLogging(this.props);
            beanRef[2] = this.beanHome.create(1, "MochoJava", 1.5, 3, "Brazil");
            beanRef[2].initLogging(this.props);
            beanRef[3] = this.beanHome.create(2, "Hazelnut", 1.75, 4, "USA");
            beanRef[3].initLogging(this.props);
            testRef = this.beanHome.findByPrimaryKey(new ComplexPK(1, "foo"));
            TestUtil.logErr((String)"No finder exception occurred");
            pass = false;
        }
        catch (FinderException fe) {
            TestUtil.logMsg((String)("Caught FinderException as expected: " + fe));
            pass = true;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test6 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 4; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test6 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

