/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entitytest.cascadeall.oneXmany;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entitytest.cascadeall.oneXmany.A;
import com.sun.ts.tests.jpa.core.entitytest.cascadeall.oneXmany.B;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1XMTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAll1XMTest1");
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"New instances");
            B b1 = new B("1", "b1", 1);
            B b2 = new B("2", "b2", 1);
            B b3 = new B("3", "b3", 1);
            B b4 = new B("4", "b4", 1);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("1", "bean1", 1, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                pass = true;
            } else {
                TestUtil.logErr((String)"Test failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1XMTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1XMTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAll1XMTest2");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            A a1 = new A("2", "a2", 2);
            B bRef = new B("2", "bean2", 2, a1);
            this.getEntityManager().persist((Object)bRef);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (IllegalStateException e) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected.  Validate the entity did not get persisted");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1XMTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1XMTest3() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAll1XMTest3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("1", "b1", 3);
            B b2 = new B("2", "b2", 3);
            B b3 = new B("3", "b3", 3);
            B b4 = new B("4", "b4", 3);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            TestUtil.logTrace((String)"New A instance");
            A a1 = new A("3", "bean3", 3, v1);
            this.getEntityManager().persist((Object)a1);
            Collection newCol = a1.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.size() != 0 && this.getEntityManager().contains((Object)b1) && this.getEntityManager().contains((Object)b2) && this.getEntityManager().contains((Object)b3) && this.getEntityManager().contains((Object)b4)) {
                pass = this.getInstanceStatus(a1);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1XMTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1XMTest4() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("4", "b4", 4);
            B bRef = new B("4", "bean4", 4, a1);
            pass = !this.getEntityManager().contains((Object)bRef) && !this.getEntityManager().contains((Object)a1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1XMTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1XMTest5() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("5", "b5", 5);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            A aRef = new A("5", "bean5", 5);
            this.getEntityManager().persist((Object)aRef);
            if (this.getEntityManager().contains((Object)aRef)) {
                A aRef1 = this.findA("5");
                aRef1.setBCol(v1);
                this.getEntityManager().persist((Object)aRef1);
                TestUtil.logTrace((String)"try to find B");
                B b2 = this.findB("5");
                if (null != b2) {
                    TestUtil.logTrace((String)"b2 is not null");
                    pass = this.getEntityManager().contains((Object)b2);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1XMTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1XMTest6() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            B b1 = new B("6", "b6", 6);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            A aRef = new A("6", "bean6", 6, v1);
            this.getEntityManager().persist((Object)aRef);
            A a2 = this.findA("6");
            if (null != a2 && this.getEntityManager().contains((Object)a2)) {
                Collection result = a2.getBInfoFromA();
                this.dumpCollectionDataB(result);
                pass = true;
            } else {
                TestUtil.logErr((String)"Entity not managed - test fails.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1XMTest6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1XMTest7() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"New instances");
            this.getEntityTransaction().begin();
            B b1 = new B("7", "b7", 7);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            A aRef = new A("7", "bean7", 7, v1);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            pass = this.getEntityManager().contains((Object)b1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception :", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1XMTest7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1XMTest8() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            A a1 = new A("8", "a8", 8);
            B bRef = new B("8", "bean8", 8, a1);
            this.getEntityManager().persist((Object)bRef);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("Exception Caught as Expected:" + e.getMessage()));
            pass = true;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1XMTest8 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1XMTest9() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            A a1 = new A("9", "a9", 9);
            this.getEntityManager().persist((Object)a1);
            B bRef = new B("9", "bean9", 9, a1);
            this.getEntityManager().persist((Object)bRef);
            this.getEntityManager().flush();
            B b2 = this.findB("9");
            A newA = b2.getA1();
            newA.setAName("newA");
            this.getEntityManager().flush();
            if (b2.isA() && newA.getAName().equals("newA")) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1XMTest9 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1XMTest10() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAll1XMTest10");
        boolean pass = false;
        this.getEntityTransaction().begin();
        B b1 = new B("1", "b1", 10);
        this.getEntityManager().persist((Object)b1);
        B b2 = new B("2", "b2", 10);
        this.getEntityManager().persist((Object)b2);
        B b3 = new B("3", "b3", 10);
        this.getEntityManager().persist((Object)b3);
        B b4 = new B("4", "b4", 10);
        this.getEntityManager().persist((Object)b4);
        Vector<B> v1 = new Vector<B>();
        v1.add(b1);
        v1.add(b2);
        v1.add(b3);
        v1.add(b4);
        A aRef = new A("10", "bean10", 10, v1);
        this.getEntityManager().persist((Object)aRef);
        Collection newCol = aRef.getBCol();
        this.dumpCollectionDataB(newCol);
        try {
            TestUtil.logTrace((String)"get Instance Status ");
            if (this.getInstanceStatus(aRef) && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                try {
                    TestUtil.logTrace((String)"Status is true as expected, try remove()");
                    this.getEntityManager().remove((Object)this.findA("10"));
                    TestUtil.logTrace((String)"Remove is immediately visible to the contains method");
                    if (!(this.getEntityManager().contains((Object)aRef) || this.getEntityManager().contains((Object)b1) || this.getEntityManager().contains((Object)b2) || this.getEntityManager().contains((Object)b3) || this.getEntityManager().contains((Object)b4))) {
                        pass = true;
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logTrace((String)"Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1XMTest10 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1XMTest11() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAll1XMTest11");
        boolean pass = false;
        this.getEntityTransaction().begin();
        B b1 = new B("1", "b1", 11);
        this.getEntityManager().persist((Object)b1);
        B b2 = new B("2", "b2", 11);
        this.getEntityManager().persist((Object)b2);
        B b3 = new B("3", "b3", 11);
        this.getEntityManager().persist((Object)b3);
        B b4 = new B("4", "b4", 11);
        this.getEntityManager().persist((Object)b4);
        Vector<B> v1 = new Vector<B>();
        v1.add(b1);
        v1.add(b2);
        v1.add(b3);
        v1.add(b4);
        A aRef = new A("11", "bean11", 11, v1);
        this.getEntityManager().persist((Object)aRef);
        Collection newCol = aRef.getBCol();
        this.dumpCollectionDataB(newCol);
        try {
            TestUtil.logTrace((String)"get Instance Status ");
            if (this.getInstanceStatus(aRef) && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                try {
                    TestUtil.logTrace((String)"Status is true as expected, try remove()");
                    this.getEntityManager().remove((Object)this.findA("11"));
                    if (!(this.getEntityManager().contains((Object)aRef) || this.getEntityManager().contains((Object)b1) || this.getEntityManager().contains((Object)b2) || this.getEntityManager().contains((Object)b3) || this.getEntityManager().contains((Object)b4))) {
                        pass = true;
                    }
                }
                catch (Exception e) {
                    TestUtil.logTrace((String)("Expected Exception :" + e));
                }
            } else {
                TestUtil.logTrace((String)"Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1XMTest11 failed");
        }
    }

    private void createA(A a) {
        TestUtil.logTrace((String)"Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    private A findA(String id) {
        TestUtil.logTrace((String)"Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private B findB(String id) {
        TestUtil.logTrace((String)"Entered findB method");
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    private boolean getInstanceStatus(Object o) {
        TestUtil.logTrace((String)"Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    private void dumpCollectionDataB(Collection c) {
        TestUtil.logTrace((String)"collection Data");
        TestUtil.logTrace((String)"---------------");
        TestUtil.logTrace((String)("- size=" + c.size()));
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            B v = (B)i.next();
            TestUtil.logTrace((String)("- Element #" + elem++));
            TestUtil.logTrace((String)("  id=" + v.getBId() + ", name=" + v.getBName() + ", value=" + v.getBValue()));
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

