/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.HandlerTracker;
import com.sun.ts.tests.jaxws.common.Handler_Util;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

public class SOAPHandlerBase2
implements SOAPHandler<SOAPMessageContext> {
    private int doingHandlerWork = 0;
    private int destroyCalled = 0;
    private String whichHandlerType = null;
    private String handlerName = null;

    public void setWhichHandlerType(String w) {
        this.whichHandlerType = w;
    }

    public String getWhichHandlerType() {
        return this.whichHandlerType;
    }

    public void setHandlerName(String h) {
        this.handlerName = h;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public void preinvoke() {
        ++this.doingHandlerWork;
        if (this.destroyCalled > 0) {
            HandlerTracker.reportThrowable((Handler)this, new Exception("Violation of Handler Lifecycle - Handler used after destroy called"));
        }
    }

    public void postinvoke() {
        this.doingHandlerWork = 0;
    }

    @PostConstruct
    public void myInit() {
        TestUtil.logTrace((String)("in " + this + ":myInit"));
        HandlerTracker.reportInit((Handler)this, "myInit");
    }

    @PreDestroy
    public void myDestroy() {
        TestUtil.logTrace((String)("in " + this + ":myDestroy"));
        if (this.doingHandlerWork > 0) {
            HandlerTracker.reportThrowable((Handler)this, new Exception("Violation of Handler Lifecycle - destroy called during handler usage"));
        }
        HandlerTracker.reportDestroy((Handler)this, "myDestroy");
        ++this.destroyCalled;
    }

    public Set<QName> getHeaders() {
        HandlerTracker.reportGetHeaders((Handler)this);
        return new HashSet<QName>();
    }

    public boolean handleMessage(SOAPMessageContext context) {
        System.out.println("in " + this + ":handleMessage");
        TestUtil.logTrace((String)("in " + this + ":handleMessage"));
        try {
            this.preinvoke();
            Handler_Util.setTraceFlag(Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnesslogtraceflag"));
            Handler_Util.initTestUtil((Handler)this, Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnessloghost"), Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnesslogport"), Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnesslogtraceflag"));
            String direction = Handler_Util.getDirection((MessageContext)context);
            if (!Handler_Util.checkForMsg((Handler)this, (MessageContext)context, "GetTrackerData")) {
                HandlerTracker.reportHandleMessage((Handler)this, direction);
            } else {
                TestUtil.logTrace((String)"found GetTrackerData message, handler will ignore");
            }
        }
        finally {
            this.postinvoke();
        }
        System.out.println("exiting " + this + ":handleMessage");
        TestUtil.logTrace((String)("exiting " + this + ":handleMessage"));
        return true;
    }

    public void close(MessageContext context) {
        TestUtil.logTrace((String)("in " + this + ":close"));
        try {
            this.preinvoke();
            HandlerTracker.reportClose((Handler)this);
        }
        finally {
            this.postinvoke();
        }
    }

    public boolean handleFault(SOAPMessageContext context) {
        System.out.println("in " + this + ":handleFault");
        TestUtil.logTrace((String)("in " + this + ":handleFault"));
        try {
            this.preinvoke();
            HandlerTracker.reportHandleFault((Handler)this);
        }
        finally {
            this.postinvoke();
        }
        System.out.println("exiting " + this + ":handleFault");
        TestUtil.logTrace((String)("exiting " + this + ":handleFault"));
        return true;
    }
}

