/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entitytest.cascadeall.oneXone;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entitytest.cascadeall.oneXone.A;
import com.sun.ts.tests.jpa.core.entitytest.cascadeall.oneXone.B;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"Entering Setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1X1Test1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAll1X1Test1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            A a1 = new A("1", "a1", 1);
            B bRef = new B("1", "bean1", 1, a1);
            this.getEntityManager().persist((Object)bRef);
            TestUtil.logTrace((String)"getA1");
            A a2 = bRef.getA1();
            if (a1 == a2 && this.getEntityManager().contains((Object)bRef)) {
                pass = true;
            } else {
                TestUtil.logErr((String)"Unexpected results - test fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1X1Test1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1X1Test2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAll1X1Test2");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("2", "a2", 2);
            B bRef = new B("2", "b2", 2, a1);
            TestUtil.logTrace((String)"Persist Instance");
            this.getEntityManager().persist((Object)bRef);
            TestUtil.logTrace((String)"get Instance Status ");
            if (this.getInstanceStatus(this.findB("2"))) {
                try {
                    TestUtil.logTrace((String)"entity is managed, remove it ");
                    this.getEntityManager().remove((Object)this.findB("2"));
                    this.getEntityManager().flush();
                    TestUtil.logTrace((String)"Persist a removed entity");
                    this.getEntityManager().persist((Object)bRef);
                    pass = this.getInstanceStatus(bRef);
                }
                catch (Exception ee) {
                    TestUtil.logErr((String)"Unexpected exception trying to persist a removed entity", (Throwable)ee);
                    pass = false;
                }
            } else {
                TestUtil.logTrace((String)"Instance is not already persisted. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1X1Test2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1X1Test3() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAll1X1Test3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            A a1 = new A("3", "a3", 3);
            B bRef = new B("3", "bean3", 3, a1);
            this.getEntityManager().persist((Object)bRef);
            A a2 = bRef.getA1();
            if (a1 == a2 && this.getEntityManager().contains((Object)a2)) {
                pass = true;
            } else {
                TestUtil.logErr((String)"Unexpected results received - test failed");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1X1Test3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1X1Test4() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAll1X1Test4");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            A a1 = new A("4", "a4", 4);
            B bRef = new B("4", "bean4", 4, a1);
            this.getEntityManager().persist((Object)bRef);
            TestUtil.logTrace((String)"bref created, try find");
            A newA = this.findA("4");
            if (null != newA) {
                pass = this.getEntityManager().contains((Object)newA);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1X1Test4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1X1Test5() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAll1X1Test5");
        boolean pass1 = true;
        boolean pass2 = true;
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            B b1 = new B("5", "b5", 5);
            A aRef = new A("5", "bean5", 5, b1);
            pass1 = this.getEntityManager().contains((Object)b1);
            pass2 = this.getEntityManager().contains((Object)aRef);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (pass1 || pass2 || !pass) {
            TestUtil.logErr((String)("pass=" + pass + ", pass1=" + pass1 + ", pass2=" + pass2));
            throw new EETest.Fault("cascadeAll1X1Test5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1X1Test6() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAll1X1Test6");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            A a1 = new A("6", "a6", 6);
            B bRef = new B("6", "bean6", 6);
            this.getEntityManager().persist((Object)bRef);
            if (this.getEntityManager().contains((Object)bRef)) {
                B bRef1 = this.findB("6");
                bRef1.setA1(a1);
                this.getEntityManager().persist((Object)bRef1);
                this.getEntityManager().flush();
                TestUtil.logTrace((String)"try to find A");
                A a2 = this.findA("6");
                if (null != a2) {
                    TestUtil.logTrace((String)"A2 is not null");
                    pass = this.getEntityManager().contains((Object)a2);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1X1Test6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1X1Test7() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAll1X1Test7");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            B b1 = new B("7", "b7", 7);
            A aRef = new A("7", "bean7", 7, b1);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("IllegalArgumentException caught as expected:" + e));
            pass = true;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (IllegalStateException fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1X1Test7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1X1Test8() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAll1X1Test8");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("8", "a8", 8);
            B bRef = new B("8", "a8", 8, a1);
            this.getEntityManager().persist((Object)bRef);
            A a2 = bRef.getA1();
            if (this.getInstanceStatus(bRef) && a2 == a1) {
                try {
                    A stillExists;
                    TestUtil.logTrace((String)"Status is true as expected, try remove()");
                    this.getEntityManager().remove((Object)this.findB("8"));
                    TestUtil.logTrace((String)"Remove is immediately visible to the contains method");
                    if (!this.getEntityManager().contains((Object)a2) && !this.getEntityManager().contains((Object)bRef)) {
                        this.getEntityManager().flush();
                    }
                    if ((stillExists = this.findA("8")) == null) {
                        pass = true;
                    }
                }
                catch (Exception onfe) {
                    TestUtil.logTrace((String)("Expected Exception :" + onfe));
                }
            } else {
                TestUtil.logTrace((String)"Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1X1Test8 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1X1Test9() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAll1X1Test9");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("9", "a9", 9);
            B bRef = new B("9", "a9", 9, a1);
            this.getEntityManager().persist((Object)bRef);
            TestUtil.logTrace((String)"get Instance ");
            A a2 = bRef.getA1();
            if (this.getInstanceStatus(bRef) && a2 == a1) {
                try {
                    TestUtil.logTrace((String)"Status is true as expected, try remove()");
                    B newB = this.findB("9");
                    this.getEntityManager().remove((Object)newB);
                    if (!this.getEntityManager().contains((Object)a2)) {
                        pass = true;
                    }
                }
                catch (Exception onfe) {
                    TestUtil.logErr((String)("Unexpected Exception :" + onfe));
                }
            } else {
                TestUtil.logTrace((String)"Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1X1Test9 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAll1X1Test10() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAll1X1Test10");
        boolean pass = false;
        boolean status = true;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("10", "a10", 10);
            this.getEntityManager().persist((Object)a1);
            B bRef = new B("10", "b10", 10, a1);
            if (this.getInstanceStatus(a1)) {
                try {
                    TestUtil.logTrace((String)"entity is new, remove ignored on bRef, a1 should be removed");
                    this.getEntityManager().remove((Object)bRef);
                    status = this.getEntityManager().contains((Object)a1);
                    this.getEntityManager().flush();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                    pass = false;
                }
            } else {
                TestUtil.logTrace((String)"Instance is not managed- Unexpected");
                pass = false;
            }
            A stillExists = this.findA("10");
            if (!status && stillExists == null) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAll1X1Test10 failed");
        }
    }

    private A findA(String id) {
        TestUtil.logTrace((String)"Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private B findB(String id) {
        TestUtil.logTrace((String)"Entered findB method");
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    private boolean getInstanceStatus(Object o) {
        TestUtil.logTrace((String)"Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

