/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.properties.descriptors;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.gmf.runtime.diagram.ui.internal.util.FontHelper;
import org.eclipse.gmf.runtime.diagram.ui.properties.descriptors.FlattenedContainmentListPropertyValue;
import org.eclipse.gmf.runtime.diagram.ui.properties.descriptors.GradientCellEditor;
import org.eclipse.gmf.runtime.diagram.ui.properties.descriptors.NotationItemLabelProvider;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesMessages;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.ui.properties.descriptors.EMFCompositeSourcePropertyDescriptor;
import org.eclipse.gmf.runtime.emf.ui.properties.descriptors.EObjectContainmentListPropertyValue;
import org.eclipse.gmf.runtime.notation.GradientStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class NotationPropertyDescriptor
extends EMFCompositeSourcePropertyDescriptor {
    public NotationPropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor, String category) {
        super(object, itemPropertyDescriptor, category);
    }

    protected CellEditor createDataTypeCellEditor(Composite composite) {
        if (this.isColor()) {
            return new ColorCellEditor(composite);
        }
        if (this.isGradient()) {
            return new GradientCellEditor(composite);
        }
        CellEditor cellEditor = super.createDataTypeCellEditor(composite);
        if (this.isFontHeight()) {
            cellEditor.setValidator(this.getPositiveIntegerValidator());
        }
        if (this.getFeature() == NotationPackage.eINSTANCE.getFillStyle_Transparency()) {
            cellEditor.setValidator(this.getIntegerIntervalValidator());
        }
        return cellEditor;
    }

    private ICellEditorValidator getPositiveIntegerValidator() {
        ICellEditorValidator cellValidator = new ICellEditorValidator(){

            public String isValid(Object value) {
                String error = null;
                if (value instanceof String) {
                    String strValue = (String)value;
                    try {
                        if (Integer.parseInt(strValue) <= 0) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        error = DiagramUIPropertiesMessages.Positive_Number_Error;
                    }
                }
                return error;
            }
        };
        return cellValidator;
    }

    private ICellEditorValidator getIntegerIntervalValidator() {
        ICellEditorValidator cellValidator = new ICellEditorValidator(){

            public String isValid(Object value) {
                String error = null;
                if (value instanceof String) {
                    String strValue = (String)value;
                    boolean valid = false;
                    try {
                        int intValue = Integer.parseInt(strValue);
                        if (intValue >= 0 && intValue <= 100) {
                            valid = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (!valid) {
                        error = DiagramUIPropertiesMessages.Number_Interval_Error;
                    }
                }
                return error;
            }
        };
        return cellValidator;
    }

    private boolean isFontHeight() {
        return this.getFeature() == NotationPackage.eINSTANCE.getFontStyle_FontHeight();
    }

    protected CellEditor createComboBoxCellEditor(Composite composite) {
        this.propertyEditor = new ExtendedComboBoxCellEditor(composite, this.getChoiceOfValues(), this.getLabelProvider(), false, 0);
        this.propertyEditor.setValidator(this.getValidator());
        return this.propertyEditor;
    }

    public Object getPropertyValue() {
        if (this.getFeature() == NotationPackage.eINSTANCE.getView_Styles()) {
            if (this.getEditableValue() instanceof EObjectContainmentEList) {
                EObjectContainmentEList list = (EObjectContainmentEList)this.getEditableValue();
                FlattenedContainmentListPropertyValue value = new FlattenedContainmentListPropertyValue(list);
                return value;
            }
            return this.getEditableValue();
        }
        if (this.isColor()) {
            Integer color = (Integer)this.getEditableValue();
            return FigureUtilities.integerToRGB((Integer)color);
        }
        if (this.isGradient()) {
            GradientData gradient = (GradientData)this.getEditableValue();
            if (gradient != null) {
                StringBuffer sf = new StringBuffer();
                sf.append(FigureUtilities.integerToRGB((Integer)gradient.getGradientColor1()));
                sf.append(',');
                sf.append(FigureUtilities.integerToRGB((Integer)gradient.getGradientColor2()));
                sf.append(',');
                sf.append(GradientStyle.get((int)gradient.getGradientStyle()));
                return sf.toString();
            }
            return null;
        }
        return this.getEditableValue();
    }

    public ILabelProvider getLabelProvider() {
        return new NotationItemLabelProvider(super.getLabelProvider(), (EStructuralFeature)this.getFeature());
    }

    public void setPropertyValue(Object value) {
        if (value instanceof EObjectContainmentListPropertyValue) {
            super.setPropertyValue((Object)((EObjectContainmentListPropertyValue)value).getTarget());
            return;
        }
        if (this.isColor()) {
            RGB rgb = (RGB)value;
            super.setPropertyValue((Object)FigureUtilities.colorToInteger((Color)new Color((Device)Display.getCurrent(), rgb)));
            return;
        }
        super.setPropertyValue(value);
    }

    private boolean isColor() {
        return this.getFeature() == NotationPackage.eINSTANCE.getFillStyle_FillColor() || this.getFeature() == NotationPackage.eINSTANCE.getLineStyle_LineColor() || this.getFeature() == NotationPackage.eINSTANCE.getFontStyle_FontColor();
    }

    private boolean isGradient() {
        return this.getFeature() == NotationPackage.eINSTANCE.getFillStyle_Gradient();
    }

    public List getChoiceOfValues() {
        if (this.getFeature() == NotationPackage.eINSTANCE.getFontStyle_FontName()) {
            return Arrays.asList(FontHelper.getFontNames());
        }
        return super.getChoiceOfValues();
    }
}

