/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.di;

import com.google.common.base.Preconditions;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.glsp.server.actions.ActionRegistry;
import org.eclipse.glsp.server.di.DiagramModule;
import org.eclipse.glsp.server.di.GLSPModule;
import org.eclipse.glsp.server.di.scope.DiagramGlobalScope;
import org.eclipse.glsp.server.gson.ServerGsonConfigurator;
import org.eclipse.glsp.server.internal.actions.DefaultActionRegistry;
import org.eclipse.glsp.server.internal.di.scope.DefaultDiagramGlobalScope;
import org.eclipse.glsp.server.internal.gson.DefaultServerGsonConfigurator;
import org.eclipse.glsp.server.internal.session.DefaultClientSessionFactory;
import org.eclipse.glsp.server.internal.session.DefaultClientSessionManager;
import org.eclipse.glsp.server.protocol.DefaultGLSPServer;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.protocol.GLSPServer;
import org.eclipse.glsp.server.session.ClientSessionFactory;
import org.eclipse.glsp.server.session.ClientSessionManager;
import org.eclipse.glsp.server.utils.ModuleUtil;

public class ServerModule
extends GLSPModule {
    public static final String DIAGRAM_MODULES = "Diagram_Modules";
    private final Map<String, Module> diagramModules = new HashMap<String, Module>();

    public ServerModule configureDiagramModule(DiagramModule diagramModule, Module ... mixinModules) {
        String diagramType = diagramModule.getDiagramType();
        Preconditions.checkState((!this.diagramModules.containsKey(diagramType) ? 1 : 0) != 0, (Object)("A module configuration is already present for diagram type: " + diagramType));
        Module combinedModule = ModuleUtil.mixin((Module)diagramModule, mixinModules);
        this.diagramModules.put(diagramType, combinedModule);
        return this;
    }

    @Override
    protected void configureBase() {
        this.bindDiagramModules();
        this.bind(ServerGsonConfigurator.class).to(this.bindGsonConfigurator()).in(Singleton.class);
        this.bind(GLSPServer.class).to(this.bindGLSPServer()).in(Singleton.class);
        this.bind(ClientSessionFactory.class).to(this.bindClientSessionFactory()).in(Singleton.class);
        this.bind(ClientSessionManager.class).to(this.bindClientSessionManager()).in(Singleton.class);
        this.bind(ActionRegistry.class).to(this.bindActionRegistry()).in(Singleton.class);
        this.bind(DiagramGlobalScope.class).to(this.bindDiagramGlobalScope()).in(Singleton.class);
    }

    protected void bindDiagramModules() {
        this.bind((TypeLiteral)new TypeLiteral<Map<String, Module>>(){}).annotatedWith((Annotation)Names.named((String)DIAGRAM_MODULES)).toInstance(this.diagramModules);
    }

    protected Class<? extends ServerGsonConfigurator> bindGsonConfigurator() {
        return DefaultServerGsonConfigurator.class;
    }

    protected Class<? extends GLSPServer> bindGLSPServer() {
        return DefaultGLSPServer.class;
    }

    protected Class<? extends ClientSessionFactory> bindClientSessionFactory() {
        return DefaultClientSessionFactory.class;
    }

    protected Class<? extends ClientSessionManager> bindClientSessionManager() {
        return DefaultClientSessionManager.class;
    }

    protected Class<? extends ActionRegistry> bindActionRegistry() {
        return DefaultActionRegistry.class;
    }

    protected Class<? extends DiagramGlobalScope> bindDiagramGlobalScope() {
        return DefaultDiagramGlobalScope.class;
    }

    @Provides
    protected GLSPClient getGLSPClient(GLSPServer glspServer) {
        return glspServer.getClient();
    }
}

