/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.core.model;

import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.eclipse.glsp.server.actions.AbstractActionHandler;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.features.core.model.ModelSourceLoader;
import org.eclipse.glsp.server.features.core.model.ModelSubmissionHandler;
import org.eclipse.glsp.server.features.core.model.RequestModelAction;
import org.eclipse.glsp.server.features.modelsourcewatcher.ModelSourceWatcher;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.utils.ServerMessageUtil;
import org.eclipse.glsp.server.utils.ServerStatusUtil;

public class RequestModelActionHandler
extends AbstractActionHandler<RequestModelAction> {
    @Inject
    protected ModelSourceLoader sourceModelLoader;
    @Inject
    protected ActionDispatcher actionDispatcher;
    @Inject
    protected Optional<ModelSourceWatcher> modelSourceWatcher;
    @Inject
    protected ModelSubmissionHandler modelSubmissionHandler;
    @Inject
    protected GModelState modelState;

    @Override
    public List<Action> executeAction(RequestModelAction action) {
        this.modelState.setClientOptions(action.getOptions());
        this.notifyStartLoading();
        this.sourceModelLoader.loadSourceModel(action);
        this.notifyFinishedLoading();
        this.modelSourceWatcher.ifPresent(watcher -> watcher.startWatching());
        return this.modelSubmissionHandler.submitModel();
    }

    protected void notifyStartLoading() {
        this.actionDispatcher.dispatch(ServerStatusUtil.info("Model loading in progress!"));
        this.actionDispatcher.dispatch(ServerMessageUtil.info("Model loading in progress!"));
    }

    protected void notifyFinishedLoading() {
        this.actionDispatcher.dispatch(ServerStatusUtil.clear());
        this.actionDispatcher.dispatch(ServerMessageUtil.clear());
    }
}

