/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout.provider;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.geometry.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNodeOperation;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.tools.api.layout.PinHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEditPart;
import org.eclipse.sirius.diagram.ui.internal.operation.RegionContainerUpdateLayoutOperation;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.borderednode.CanonicalDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.figure.locator.DBorderItemLocator;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.AbstractLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.SnapCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.policies.ChangeBoundRequestRecorder;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.ArrangeAllWithAutoSize;
import org.eclipse.sirius.diagram.ui.tools.internal.part.SiriusDiagramGraphicalViewer;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class BorderItemAwareLayoutProvider
extends AbstractLayoutProvider {
    public static final int MARGIN = 16;
    private static final int MAX_ITERATIONS = 10;
    AbstractLayoutProvider initialLayoutProvider;
    boolean launchNormalArrange;
    Map<IBorderItemEditPart, BorderItemLayoutData> previousIterationDatasbyEditPart = new HashMap<IBorderItemEditPart, BorderItemLayoutData>();
    private Predicate<Object> validateAllElementInArrayListAreIDiagramElementEditPart = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input instanceof IDiagramElementEditPart;
        }
    };

    public BorderItemAwareLayoutProvider(AbstractLayoutProvider clp) {
        this.initialLayoutProvider = clp;
    }

    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        return this.layoutEditParts(selectedObjects, layoutHint, true);
    }

    @Override
    public boolean provides(IOperation operation) {
        boolean result = true;
        if (operation instanceof ILayoutNodeOperation) {
            ILayoutNodeOperation layoutNodeOperation = (ILayoutNodeOperation)operation;
            for (ILayoutNode layoutNode : layoutNodeOperation.getLayoutNodes()) {
                Node node = layoutNode.getNode();
                EObject semanticElement = ViewUtil.resolveSemanticElement((View)node);
                if (semanticElement instanceof DDiagramElement) {
                    DDiagram diagram = ((DDiagramElement)semanticElement).getParentDiagram();
                    if (diagram.getDescription().getLayout() == null) continue;
                    result = false;
                    continue;
                }
                if (semanticElement instanceof DSemanticDecorator) continue;
                result = false;
            }
        }
        return result;
    }

    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint, boolean normalArrangeMustBeCalled) {
        Command layoutBorderItems;
        EditPartViewer root;
        this.launchNormalArrange = normalArrangeMustBeCalled;
        if (selectedObjects.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand result = new CompoundCommand();
        if (this.launchNormalArrange && (root = ((EditPart)selectedObjects.get(0)).getViewer()) instanceof SiriusDiagramGraphicalViewer) {
            ChangeBoundRequestRecorder recorder = ((SiriusDiagramGraphicalViewer)root).getChangeBoundRequestRecorder();
            recorder.startRecording();
            result.add(this.lauchPrimaryArrangeAll(selectedObjects, layoutHint));
            recorder.stopRecording();
            this.registerChangeBoundsCommand(recorder);
            recorder.dispose();
        }
        ArrayList elementsToKeepFixed = new ArrayList();
        if (layoutHint.getAdapter(Collection.class) instanceof ArrayList && Iterables.all((Iterable)((ArrayList)layoutHint.getAdapter(Collection.class)), this.validateAllElementInArrayListAreIDiagramElementEditPart)) {
            elementsToKeepFixed = (ArrayList)layoutHint.getAdapter(Collection.class);
        }
        if ((layoutBorderItems = this.layoutBorderItems(selectedObjects, 1, elementsToKeepFixed)) != null && layoutBorderItems.canExecute()) {
            result.add(layoutBorderItems);
        }
        this.resetBoundsOfPinnedElements(selectedObjects, result, elementsToKeepFixed);
        this.getViewsToChangeBoundsRequest().clear();
        if (result.size() == 0) {
            result = null;
        }
        return result;
    }

    protected Command lauchPrimaryArrangeAll(List selectedObjects, IAdaptable layoutHint) {
        return this.initialLayoutProvider.layoutEditParts(selectedObjects, layoutHint);
    }

    protected void registerChangeBoundsCommand(ChangeBoundRequestRecorder recorder) {
        for (Map.Entry entry : recorder.getAllRequests().entries()) {
            ChangeBoundsRequest cbr;
            List editParts;
            EditPart editPart = (EditPart)entry.getKey();
            if (!(editPart instanceof IGraphicalEditPart) || (editParts = (cbr = (ChangeBoundsRequest)entry.getValue()).getEditParts()) == null) continue;
            for (EditPart ep : editParts) {
                View v = ((IGraphicalEditPart)ep).getNotationView();
                List<Request> requests = this.getViewsToChangeBoundsRequest().get(v);
                if (requests == null) {
                    requests = new LinkedList<Request>();
                    this.getViewsToChangeBoundsRequest().put(v, requests);
                }
                requests.add((Request)cbr);
            }
        }
    }

    private void resetBoundsOfPinnedElements(List selectedObjects, CompoundCommand compoundCommand, ArrayList<IDiagramElementEditPart> elementsToKeepFixed) {
        for (IGraphicalEditPart graphicalEditPart : Iterables.filter((Iterable)selectedObjects, IGraphicalEditPart.class)) {
            DDiagramElement dDiagramElement;
            EObject semanticElement = graphicalEditPart.resolveSemanticElement();
            if (!(semanticElement instanceof DDiagramElement) || !new PinHelper().isPinned(dDiagramElement = (DDiagramElement)semanticElement) && (elementsToKeepFixed == null || !elementsToKeepFixed.contains(graphicalEditPart))) continue;
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)semanticElement);
            View notationView = graphicalEditPart.getNotationView();
            if (notationView instanceof Node) {
                Node node = (Node)notationView;
                this.resetBounds(compoundCommand, node, editingDomain);
            }
            if (!(graphicalEditPart instanceof IDiagramContainerEditPart) || !(dDiagramElement instanceof DNodeContainer) || !new DNodeContainerExperimentalQuery((DNodeContainer)dDiagramElement).isRegionContainer()) continue;
            AbstractDNodeContainerCompartmentEditPart comp = (AbstractDNodeContainerCompartmentEditPart)Iterables.getFirst((Iterable)Iterables.filter((Iterable)graphicalEditPart.getChildren(), AbstractDNodeContainerCompartmentEditPart.class), null);
            if (comp != null && comp.getNotationView() != null) {
                for (Node region : Iterables.filter((Iterable)comp.getChildren(), Node.class)) {
                    this.resetBounds(compoundCommand, region, editingDomain);
                }
            }
            compoundCommand.add((Command)new ICommandProxy(CommandFactory.createICommand(graphicalEditPart.getEditingDomain(), new RegionContainerUpdateLayoutOperation((Node)graphicalEditPart.getModel()))));
        }
    }

    private void resetBounds(CompoundCommand compoundCommand, Node node, TransactionalEditingDomain editingDomain) {
        EObjectAdapter objectAdapter = new EObjectAdapter((EObject)node);
        LayoutConstraint layoutConstraint = node.getLayoutConstraint();
        if (layoutConstraint instanceof Bounds) {
            Bounds bounds = (Bounds)layoutConstraint;
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(editingDomain, Messages.BorderItemAwareLayoutProvider_setBoundsCommandLabel, (IAdaptable)objectAdapter, new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight()));
            compoundCommand.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
        } else if (layoutConstraint instanceof Location) {
            Location location = (Location)layoutConstraint;
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(editingDomain, Messages.BorderItemAwareLayoutProvider_setBoundsCommandLabel, (IAdaptable)objectAdapter, new Point(location.getX(), location.getY()));
            compoundCommand.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
        } else if (layoutConstraint instanceof Size) {
            Size size = (Size)layoutConstraint;
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(editingDomain, Messages.BorderItemAwareLayoutProvider_setBoundsCommandLabel, (IAdaptable)objectAdapter, new Dimension(size.getWidth(), size.getHeight()));
            compoundCommand.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
        }
    }

    protected Command getBendpointsChangedCommand(Connection connection, Edge edge, TransactionalEditingDomain editingDomain) {
        Point ptRef1 = connection.getSourceAnchor().getReferencePoint();
        connection.translateToRelative((Translatable)ptRef1);
        Point ptRef2 = connection.getTargetAnchor().getReferencePoint();
        connection.translateToRelative((Translatable)ptRef2);
        SetConnectionBendpointsCommand sbbCommand = new SetConnectionBendpointsCommand(editingDomain);
        sbbCommand.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)edge));
        sbbCommand.setNewPointList(connection.getPoints(), ptRef1, ptRef2);
        return new ICommandProxy((ICommand)sbbCommand);
    }

    private Command layoutBorderItems(List<?> selectedObjects, int nbIterations, ArrayList<IDiagramElementEditPart> elementsToKeepFixed) {
        CompoundCommand cc = new CompoundCommand();
        for (Object obj : selectedObjects) {
            Command layoutBorderItems;
            if (!(obj instanceof GraphicalEditPart) || (layoutBorderItems = this.layoutBorderItems((GraphicalEditPart)obj, elementsToKeepFixed)) == null || !layoutBorderItems.canExecute()) continue;
            cc.add(layoutBorderItems);
        }
        if (this.hasBeenMovedBorderItemsDuringLastIteration() && nbIterations < 10) {
            this.removeRequestsOfThisCommand(cc);
            cc = (CompoundCommand)this.layoutBorderItems(selectedObjects, nbIterations + 1, elementsToKeepFixed);
        }
        for (Map.Entry entry : this.getViewsToChangeBoundsRequest().entrySet()) {
            View view = (View)entry.getKey();
            Option<IBorderItemEditPart> optionalPart = this.getCorrespondingEditPart(view);
            if (!optionalPart.some()) continue;
            IBorderItemEditPart borderItemEditPart = (IBorderItemEditPart)optionalPart.get();
            List requests = (List)entry.getValue();
            if (view.getSourceEdges().isEmpty() && view.getTargetEdges().isEmpty()) continue;
            for (Object obj : view.getSourceEdges()) {
                if (!(obj instanceof Edge)) continue;
                Edge sourceEdge = (Edge)obj;
                this.resetBendpoints(sourceEdge, cc, borderItemEditPart, requests, true);
            }
            for (Object obj : view.getTargetEdges()) {
                if (!(obj instanceof Edge)) continue;
                Edge targetEdge = (Edge)obj;
                this.resetBendpoints(targetEdge, cc, borderItemEditPart, requests, false);
            }
        }
        this.clearBorderItemLocations();
        return cc;
    }

    public void resetBendpoints(Edge edge, CompoundCommand cc, IBorderItemEditPart borderItemEditPart, List<Request> requests, boolean sourceEdge) {
        Point firstAnchorLocation = sourceEdge ? GraphicalHelper.getAnchorPoint((GraphicalEditPart)borderItemEditPart, (Anchor)edge.getSourceAnchor()) : GraphicalHelper.getAnchorPoint((GraphicalEditPart)borderItemEditPart, (Anchor)edge.getTargetAnchor());
        for (Request request : requests) {
            if (!(request instanceof ChangeBoundsRequest)) continue;
            firstAnchorLocation.translate(((ChangeBoundsRequest)request).getMoveDelta());
        }
        View edgeOtherExtremityView = sourceEdge ? edge.getTarget() : edge.getSource();
        Option<IBorderItemEditPart> optionalOtherExtremityPart = this.getCorrespondingEditPart(edgeOtherExtremityView);
        if (!optionalOtherExtremityPart.some()) {
            optionalOtherExtremityPart = GMFHelper.getGraphicalEditPart(edgeOtherExtremityView);
        }
        if (optionalOtherExtremityPart.some()) {
            Point secondAnchorLocation = sourceEdge ? GraphicalHelper.getAnchorPoint((GraphicalEditPart)((GraphicalEditPart)optionalOtherExtremityPart.get()), (Anchor)edge.getTargetAnchor()) : GraphicalHelper.getAnchorPoint((GraphicalEditPart)((GraphicalEditPart)optionalOtherExtremityPart.get()), (Anchor)edge.getSourceAnchor());
            boolean otherExtremityMove = this.getViewsToChangeBoundsRequest().keySet().contains(edgeOtherExtremityView);
            if (otherExtremityMove) {
                for (Request request : this.getViewsToChangeBoundsRequest().get(edgeOtherExtremityView)) {
                    if (!(request instanceof ChangeBoundsRequest)) continue;
                    secondAnchorLocation.translate(((ChangeBoundsRequest)request).getMoveDelta());
                }
            }
            if (sourceEdge || !sourceEdge && !otherExtremityMove) {
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)edge.getElement());
                SetConnectionBendpointsCommand resetBendpoinsCmd = new SetConnectionBendpointsCommand(editingDomain);
                resetBendpoinsCmd.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)edge));
                PointList newPointList = new PointList(2);
                newPointList.addPoint(firstAnchorLocation);
                newPointList.addPoint(secondAnchorLocation);
                resetBendpoinsCmd.setNewPointList(newPointList, firstAnchorLocation, secondAnchorLocation);
                cc.add((Command)new ICommandProxy((ICommand)resetBendpoinsCmd));
            }
        }
    }

    private void removeRequestsOfThisCommand(CompoundCommand cc) {
        for (Object childCommand : cc.getCommands()) {
            List<Request> requests;
            AbstractLayoutProvider.CommandWrapper wrap;
            if (childCommand instanceof CompoundCommand) {
                this.removeRequestsOfThisCommand((CompoundCommand)childCommand);
                continue;
            }
            if (!(childCommand instanceof AbstractLayoutProvider.CommandWrapper) || !((wrap = (AbstractLayoutProvider.CommandWrapper)((Object)childCommand)).getEditPart() instanceof IGraphicalEditPart) || (requests = this.getViewsToChangeBoundsRequest().get(((IGraphicalEditPart)wrap.getEditPart()).getNotationView())) == null) continue;
            requests.remove(wrap.getRequest());
        }
    }

    private boolean hasBeenMovedBorderItemsDuringLastIteration() {
        for (IBorderItemEditPart borderItemEditPart : this.previousIterationDatasbyEditPart.keySet()) {
            if (!this.previousIterationDatasbyEditPart.get(borderItemEditPart).isMoved()) continue;
            return true;
        }
        return false;
    }

    private void clearBorderItemLocations() {
        this.previousIterationDatasbyEditPart.clear();
    }

    private Option<IBorderItemEditPart> getCorrespondingEditPart(View view) {
        for (IBorderItemEditPart borderItemEditPart : this.previousIterationDatasbyEditPart.keySet()) {
            if (!view.equals(borderItemEditPart.getModel())) continue;
            return Options.newSome((Object)borderItemEditPart);
        }
        return Options.newNone();
    }

    private Command layoutBorderItems(GraphicalEditPart graphicalEditPart, ArrayList<IDiagramElementEditPart> elementsToKeepFixed) {
        Command layoutBorderItems;
        IBorderedShapeEditPart borderedEditPart;
        CompoundCommand result = new CompoundCommand();
        if (graphicalEditPart instanceof IBorderedShapeEditPart && (borderedEditPart = (IBorderedShapeEditPart)graphicalEditPart).getBorderedFigure() != null && !borderedEditPart.getBorderedFigure().getBorderItemContainer().getChildren().isEmpty() && (layoutBorderItems = this.layoutBorderItems(borderedEditPart, elementsToKeepFixed)) != null && layoutBorderItems.canExecute()) {
            result.add(layoutBorderItems);
        }
        for (Object editPart : graphicalEditPart.getChildren()) {
            Command layoutBorderItems2;
            if (!(editPart instanceof GraphicalEditPart) || (layoutBorderItems2 = this.layoutBorderItems((GraphicalEditPart)editPart, elementsToKeepFixed)) == null || !layoutBorderItems2.canExecute()) continue;
            result.add(layoutBorderItems2);
        }
        return result;
    }

    private Command layoutBorderItems(IBorderedShapeEditPart borderedShapeEditPart, ArrayList<IDiagramElementEditPart> elementsToKeepFixed) {
        CompoundCommand resCommand = null;
        if (borderedShapeEditPart instanceof IGraphicalEditPart) {
            IGraphicalEditPart castedEditPart = (IGraphicalEditPart)borderedShapeEditPart;
            if (borderedShapeEditPart.getMainFigure() != null) {
                Command leftCommand;
                Command rightCommand;
                Command bottomCommand;
                resCommand = new CompoundCommand();
                double scale = 1.0;
                if (castedEditPart.getRoot() instanceof DiagramRootEditPart) {
                    ZoomManager zoomManager = ((DiagramRootEditPart)castedEditPart.getRoot()).getZoomManager();
                    scale = zoomManager.getZoom();
                }
                Rectangle containerBoundsAfterArrangeAll = this.getBounds(castedEditPart, scale);
                Point containerCenterAfterArrangeAll = containerBoundsAfterArrangeAll.getCenter();
                HashMap<IBorderItemEditPart, Vector> headings = new HashMap<IBorderItemEditPart, Vector>();
                for (Object child : castedEditPart.getChildren()) {
                    if (!(child instanceof IBorderItemEditPart) || this.isPinned((IGraphicalEditPart)((IBorderItemEditPart)child)) || elementsToKeepFixed != null && elementsToKeepFixed.contains(child)) continue;
                    this.computeHeading((IBorderItemEditPart)child, containerCenterAfterArrangeAll, scale, headings);
                }
                Point topLeft = containerBoundsAfterArrangeAll.getTopLeft();
                double absoluteCos = Math.abs(BorderItemAwareLayoutProvider.cos(new Vector((double)Math.abs(containerCenterAfterArrangeAll.x - topLeft.x), (double)Math.abs(containerCenterAfterArrangeAll.y - topLeft.y))));
                double absoluteSin = Math.abs(BorderItemAwareLayoutProvider.sin(new Vector((double)Math.abs(containerCenterAfterArrangeAll.x - topLeft.x), (double)Math.abs(containerCenterAfterArrangeAll.y - topLeft.y))));
                List<IBorderItemEditPart> tops = this.getBorderItems(1, headings, absoluteCos, scale, containerCenterAfterArrangeAll);
                List<IBorderItemEditPart> bottoms = this.getBorderItems(4, headings, absoluteCos, scale, containerCenterAfterArrangeAll);
                List<IBorderItemEditPart> rights = this.getBorderItems(16, headings, absoluteSin, scale, containerCenterAfterArrangeAll);
                List<IBorderItemEditPart> lefts = this.getBorderItems(8, headings, absoluteSin, scale, containerCenterAfterArrangeAll);
                this.unfixLocator(tops);
                this.unfixLocator(bottoms);
                this.unfixLocator(rights);
                this.unfixLocator(lefts);
                Command topCommand = this.layoutItems(tops, containerBoundsAfterArrangeAll, 1, scale);
                if (topCommand != null && topCommand.canExecute()) {
                    resCommand.add(topCommand);
                }
                if ((bottomCommand = this.layoutItems(bottoms, containerBoundsAfterArrangeAll, 4, scale)) != null && bottomCommand.canExecute()) {
                    resCommand.add(bottomCommand);
                }
                if ((rightCommand = this.layoutItems(rights, containerBoundsAfterArrangeAll, 16, scale)) != null && rightCommand.canExecute()) {
                    resCommand.add(rightCommand);
                }
                if ((leftCommand = this.layoutItems(lefts, containerBoundsAfterArrangeAll, 8, scale)) != null && leftCommand.canExecute()) {
                    resCommand.add(leftCommand);
                }
                for (IBorderItemEditPart topBorderItemEditPart : tops) {
                    DEdgeEditPart viewEdgeEditPart;
                    Object connection;
                    if (topBorderItemEditPart.getSourceConnections().size() > 0) {
                        connection = topBorderItemEditPart.getSourceConnections().get(0);
                        if (!(connection instanceof DEdgeEditPart)) continue;
                        viewEdgeEditPart = (DEdgeEditPart)connection;
                        viewEdgeEditPart.getPrimaryShape().refreshLine();
                        continue;
                    }
                    if (topBorderItemEditPart.getTargetConnections().size() <= 0 || !((connection = topBorderItemEditPart.getTargetConnections().get(0)) instanceof DEdgeEditPart)) continue;
                    viewEdgeEditPart = (DEdgeEditPart)connection;
                    viewEdgeEditPart.refresh();
                }
                List<IBorderItemEditPart> allBorderNodes = Stream.concat(Stream.concat(tops.stream(), bottoms.stream()), Stream.concat(lefts.stream(), rights.stream())).collect(Collectors.toList());
                this.addSnapCommand(resCommand, allBorderNodes);
            }
        }
        return resCommand;
    }

    private void addSnapCommand(CompoundCommand resCommand, List<IBorderItemEditPart> allBorderNodes) {
        IPreferenceStore preferenceStore;
        if (!allBorderNodes.isEmpty() && allBorderNodes.get(0).getViewer() instanceof DiagramGraphicalViewer && (preferenceStore = ((DiagramGraphicalViewer)allBorderNodes.get(0).getViewer()).getWorkspaceViewerPreferenceStore()) != null && preferenceStore.getBoolean("rulergrid.snaptogrid")) {
            for (IBorderItemEditPart editPart : allBorderNodes) {
                resCommand.add((Command)new ICommandProxy((ICommand)new SnapCommand(editPart.getEditingDomain(), Collections.singletonList(editPart))));
            }
        }
    }

    private void computeHeading(IBorderItemEditPart borderItemEditPart, Point containerCenterAfterArrangeAll, double scale, Map<IBorderItemEditPart, Vector> headings) {
        Vector heading = this.getHeading(borderItemEditPart, containerCenterAfterArrangeAll, scale);
        if (heading != null) {
            headings.put(borderItemEditPart, heading);
        }
    }

    protected Command layoutItems(List<IBorderItemEditPart> items, Rectangle containerBounds, int position, double zoomScale) {
        CompoundCommand res = new CompoundCommand();
        boolean width = position == 1 || position == 4;
        int availableSpace = width ? containerBounds.width : containerBounds.height;
        int between = (int)((float)(availableSpace - this.getSize(items, width, zoomScale) - 16) / (float)items.size());
        int current = 8;
        for (IBorderItemEditPart borderItemEditPart : items) {
            Point newLocation;
            ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
            switch (position) {
                case 1: {
                    newLocation = new Point(current, 0);
                    break;
                }
                case 4: {
                    newLocation = new Point(current, containerBounds.height);
                    break;
                }
                case 16: {
                    newLocation = new Point(containerBounds.width, current);
                    break;
                }
                case 8: {
                    newLocation = new Point(0, current);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Messages.BorderItemAwareLayoutProvider_invalidItemsPosition);
                }
            }
            newLocation = newLocation.getTranslated(containerBounds.getTopLeft());
            if (borderItemEditPart.getModel() instanceof Node && ((Node)borderItemEditPart.getModel()).eContainer() instanceof Node) {
                Node borderNode = (Node)borderItemEditPart.getModel();
                Node parentNode = (Node)borderNode.eContainer();
                CanonicalDBorderItemLocator borderItemLocator = new CanonicalDBorderItemLocator(parentNode, position);
                borderItemLocator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                borderItemLocator.setParentBorderBounds(containerBounds);
                newLocation = borderItemLocator.getValidLocation(new Rectangle(newLocation, borderItemEditPart.getFigure().getSize()), (Node)borderItemEditPart.getModel(), (Collection<Node>)parentNode.getChildren());
            }
            this.addBorderItemData(borderItemEditPart, newLocation);
            request.setEditParts((EditPart)borderItemEditPart);
            request.setLocation(newLocation);
            Rectangle boundsBorderItem = this.getBounds((IGraphicalEditPart)borderItemEditPart, zoomScale);
            Dimension difference = newLocation.getDifference(boundsBorderItem.getTopLeft());
            request.setMoveDelta(new Point(difference.width, difference.height));
            Command command = this.buildCommandWrapper((Request)request, (EditPart)borderItemEditPart);
            res.add(command);
            current += between + (int)((double)(width ? boundsBorderItem.width : boundsBorderItem.height) * zoomScale);
        }
        return res;
    }

    private void addBorderItemData(IBorderItemEditPart borderItemEditPart, Point newLocation) {
        BorderItemLayoutData data = this.previousIterationDatasbyEditPart.get(borderItemEditPart);
        if (data == null) {
            data = new BorderItemLayoutData();
            data.setMoved(true);
            data.setPreviousCenterLocation(newLocation);
        } else {
            boolean alreadyUsedLocation = data.getPreviousCenterLocation().equals((Object)newLocation);
            if (!alreadyUsedLocation) {
                alreadyUsedLocation = data.getPreviousPreviousCenterLocation() != null && data.getPreviousPreviousCenterLocation().equals((Object)newLocation);
            }
            data.setPreviousCenterLocation(newLocation);
            if (alreadyUsedLocation) {
                data.setMoved(false);
            } else {
                data.setMoved(true);
            }
        }
        this.previousIterationDatasbyEditPart.put(borderItemEditPart, data);
    }

    private void unfixLocator(List<IBorderItemEditPart> editParts) {
        for (IBorderItemEditPart borderItemEditPart : editParts) {
            IBorderItemLocator borderItemLocator = borderItemEditPart.getBorderItemLocator();
            if (!(borderItemLocator instanceof DBorderItemLocator)) continue;
            ((DBorderItemLocator)borderItemLocator).unfix();
        }
    }

    private int getSize(List<IBorderItemEditPart> tops, boolean width, double zoomScale) {
        int size = 0;
        for (IBorderItemEditPart editPart : tops) {
            int editPartSize = (int)((double)editPart.getFigure().getBounds().width * zoomScale);
            if (!width) {
                editPartSize = (int)((double)editPart.getFigure().getBounds().height * zoomScale);
            }
            size += editPartSize;
        }
        return size;
    }

    private static double cos(Vector ray) {
        return ray.x / Math.sqrt(Math.pow(ray.x, 2.0) + Math.pow(ray.y, 2.0));
    }

    private static double sin(Vector ray) {
        return ray.y / Math.sqrt(Math.pow(ray.x, 2.0) + Math.pow(ray.y, 2.0));
    }

    private Map<IBorderItemEditPart, BorderItemOppositeElementData> getOppositeElementsData(List<IBorderItemEditPart> parts, double scale) {
        HashMap<IBorderItemEditPart, BorderItemOppositeElementData> targetPoints = new HashMap<IBorderItemEditPart, BorderItemOppositeElementData>();
        for (IBorderItemEditPart borderItemEditPart : parts) {
            BorderItemOppositeElementData oppositeElementData = this.getOppositeElementData(borderItemEditPart, scale);
            if (oppositeElementData == null) continue;
            targetPoints.put(borderItemEditPart, oppositeElementData);
        }
        return targetPoints;
    }

    private List<IBorderItemEditPart> getBorderItems(int side, Map<IBorderItemEditPart, Vector> headings, double containerAbsoluteCosOrSin, double scale, Point containerCenter) {
        LinkedList<IBorderItemEditPart> parts = new LinkedList<IBorderItemEditPart>();
        for (Map.Entry<IBorderItemEditPart, Vector> entry : headings.entrySet()) {
            Vector ray = entry.getValue();
            if (side == 1 || side == 4) {
                if (!this.isOnNorthOrSouth(side, containerAbsoluteCosOrSin, entry, ray)) continue;
                parts.add(entry.getKey());
                continue;
            }
            if (!this.isOnWestOrEast(side, containerAbsoluteCosOrSin, entry, ray)) continue;
            parts.add(entry.getKey());
        }
        if (!parts.isEmpty()) {
            Map<IBorderItemEditPart, BorderItemOppositeElementData> oppositeElementsDataByEditPart = this.getOppositeElementsData(parts, scale);
            if (side == 1) {
                Collections.sort(parts, new NorthCoordinateComparator(oppositeElementsDataByEditPart));
            } else if (side == 4) {
                Collections.sort(parts, new SouthCoordinateComparator(oppositeElementsDataByEditPart));
            } else if (side == 8) {
                Collections.sort(parts, new WestCoordinateComparator(oppositeElementsDataByEditPart));
            } else if (side == 16) {
                Collections.sort(parts, new EastCoordinateComparator(oppositeElementsDataByEditPart));
            }
        }
        return parts;
    }

    private boolean isOnNorthOrSouth(int side, double containerAbsoluteCos, Map.Entry<IBorderItemEditPart, Vector> entry, Vector ray) {
        double cos;
        boolean result = false;
        if (ray.y != 0.0 && Math.abs(cos = BorderItemAwareLayoutProvider.cos(ray)) < containerAbsoluteCos) {
            if (side == 1) {
                if (ray.y < 0.0) {
                    result = true;
                }
            } else if (ray.y > 0.0) {
                result = true;
            }
        }
        return result;
    }

    private boolean isOnWestOrEast(int side, double containerAbsoluteSin, Map.Entry<IBorderItemEditPart, Vector> entry, Vector ray) {
        double sin;
        boolean result = false;
        if (ray.x != 0.0 && Math.abs(sin = BorderItemAwareLayoutProvider.sin(ray)) < containerAbsoluteSin) {
            if (side == 8) {
                if (ray.x < 0.0) {
                    result = true;
                }
            } else if (ray.x > 0.0) {
                result = true;
            }
        }
        return result;
    }

    private Vector getHeading(IBorderItemEditPart editPart, Point containerCenterAfterArrange, double scale) {
        Point targetPoint = this.getTargetPoint(editPart, scale);
        if (targetPoint != null) {
            return new Vector(new PrecisionPoint(containerCenterAfterArrange), new PrecisionPoint(targetPoint));
        }
        return null;
    }

    private Point getTargetPoint(IBorderItemEditPart editPart, double scale) {
        Point targetPoint = null;
        GraphicalEditPart target = this.getTarget(editPart);
        if (target != null && editPart != target && !this.isAncestor((EditPart)editPart, (EditPart)target) && !this.isAncestor((EditPart)target, (EditPart)editPart)) {
            targetPoint = this.previousIterationDatasbyEditPart.get(target) != null ? this.previousIterationDatasbyEditPart.get(target).getPreviousCenterLocation() : this.getBounds((IGraphicalEditPart)target, scale).getCenter();
        }
        return targetPoint;
    }

    private BorderItemOppositeElementData getOppositeElementData(IBorderItemEditPart editPart, double scale) {
        BorderItemOppositeElementData oppositeElementData = null;
        GraphicalEditPart target = this.getTarget(editPart);
        if (target != null && editPart != target && !this.isAncestor((EditPart)editPart, (EditPart)target) && !this.isAncestor((EditPart)target, (EditPart)editPart)) {
            Point targetPoint = this.previousIterationDatasbyEditPart.get(target) != null ? this.previousIterationDatasbyEditPart.get(target).getPreviousCenterLocation() : this.getBounds((IGraphicalEditPart)target, scale).getCenter();
            oppositeElementData = target instanceof IBorderItemEditPart ? new BorderItemOppositeElementData(targetPoint, DBorderItemLocator.findClosestSideOfParent(new Rectangle(targetPoint, new Dimension(1, 1)), this.getBounds((IGraphicalEditPart)target.getParent(), scale))) : new BorderItemOppositeElementData(targetPoint);
        }
        return oppositeElementData;
    }

    private GraphicalEditPart getTarget(IBorderItemEditPart editPart) {
        GraphicalEditPart target = null;
        if (editPart.getSourceConnections().size() == 1 && editPart.getTargetConnections().isEmpty()) {
            target = (GraphicalEditPart)((ConnectionEditPart)editPart.getSourceConnections().get(0)).getTarget();
        } else if (editPart.getSourceConnections().isEmpty() && editPart.getTargetConnections().size() == 1) {
            target = (GraphicalEditPart)((ConnectionEditPart)editPart.getTargetConnections().get(0)).getSource();
        }
        return target;
    }

    private boolean isAncestor(EditPart childCandidate, EditPart parentCandidate) {
        EditPart currentParent = childCandidate.getParent();
        while (currentParent != null) {
            if (currentParent == parentCandidate) {
                return true;
            }
            currentParent = currentParent.getParent();
        }
        return false;
    }

    protected Rectangle getBounds(IGraphicalEditPart graphicalEditPart, double scale) {
        return this.getBounds(graphicalEditPart, scale, null);
    }

    protected Rectangle getBounds(IGraphicalEditPart graphicalEditPart, double scale, Dimension parentMoveDelta) {
        return this.getBounds(graphicalEditPart, scale, parentMoveDelta, true, true);
    }

    protected Rectangle getBounds(IGraphicalEditPart graphicalEditPart, double scale, Dimension parentMoveDelta, boolean processX, boolean processY) {
        Dimension moveDelta;
        DDiagramElement dDiagramElement;
        Rectangle bounds = null;
        boolean isPinned = false;
        Dimension parentBorderSize = this.getBorder(graphicalEditPart).getSize();
        if (graphicalEditPart.resolveSemanticElement() instanceof DDiagramElement && (isPinned = new PinHelper().isPinned(dDiagramElement = (DDiagramElement)graphicalEditPart.resolveSemanticElement()))) {
            bounds = graphicalEditPart.getFigure().getBounds().getCopy();
        }
        if (!isPinned && (bounds = this.getBounds(graphicalEditPart)) != null) {
            moveDelta = bounds.getTopLeft().getDifference(graphicalEditPart.getFigure().getBounds().getTopLeft());
            moveDelta.scale(1.0 / scale);
            bounds = new Rectangle(graphicalEditPart.getFigure().getBounds()).translate(new Point(moveDelta.width, moveDelta.height));
        }
        if (parentMoveDelta != null) {
            bounds = bounds.getTranslated(new Point(parentMoveDelta.width, parentMoveDelta.height));
        } else if (!(graphicalEditPart.getParent() instanceof IDDiagramEditPart) && bounds != null) {
            IGraphicalEditPart parent = (IGraphicalEditPart)graphicalEditPart.getParent();
            Rectangle parentBounds = this.getBounds(parent, scale);
            if (!this.isPinned(parent)) {
                Dimension moveDelta2 = this.getScaledMoveDelta(parent, parentBounds, scale);
                bounds = bounds.getTranslated(new Point(moveDelta2.width, moveDelta2.height));
            }
        }
        graphicalEditPart.getFigure().translateToAbsolute((Translatable)bounds);
        bounds.setSize(parentBorderSize);
        if (!isPinned && this.launchNormalArrange) {
            moveDelta = this.getScaledMoveDelta(graphicalEditPart, bounds, scale);
            Dimension sizeWithAutoSize = this.getSizeAfterAutoSize(graphicalEditPart, bounds, scale, moveDelta, processX, processY);
            bounds.setSize(sizeWithAutoSize);
        }
        return bounds;
    }

    protected Rectangle getBorder(IGraphicalEditPart graphicalEditPart) {
        IFigure figure = graphicalEditPart.getFigure();
        Rectangle bounds = figure.getBounds().getCopy();
        if (figure instanceof NodeFigure) {
            bounds = ((NodeFigure)figure).getHandleBounds().getCopy();
        }
        return bounds;
    }

    private Dimension getScaledMoveDelta(IGraphicalEditPart part, Rectangle targetBounds, double scale) {
        Point topLeft = part.getFigure().getBounds().getTopLeft();
        part.getFigure().translateToAbsolute((Translatable)topLeft);
        Dimension moveDelta = targetBounds.getTopLeft().getDifference(topLeft);
        moveDelta.scale(1.0 / scale);
        return moveDelta;
    }

    private Dimension getSizeAfterAutoSize(IGraphicalEditPart part, Rectangle actualBounds, double scale, Dimension moveDelta, boolean processX, boolean processY) {
        Node node;
        LayoutConstraint layoutConstraint;
        boolean shouldWidthAutoSized;
        Dimension result = new Dimension(actualBounds.getSize());
        boolean shouldHeightAutoSized = shouldWidthAutoSized = ArrangeAllWithAutoSize.shouldBeAutosized(part) || part instanceof ShapeCompartmentEditPart;
        if (!shouldWidthAutoSized && !shouldHeightAutoSized && part.getNotationView() instanceof Node && (layoutConstraint = (node = (Node)part.getNotationView()).getLayoutConstraint()) instanceof Size) {
            Size size = (Size)layoutConstraint;
            shouldWidthAutoSized = size.getWidth() == -1;
            shouldHeightAutoSized = size.getHeight() == -1;
        }
        Dimension defaultSize = new Dimension(0, 0);
        IFigure f = part.getFigure();
        if (f instanceof BorderedNodeFigure && ((BorderedNodeFigure)f).getMainFigure() instanceof DefaultSizeNodeFigure) {
            defaultSize = ((DefaultSizeNodeFigure)((BorderedNodeFigure)f).getMainFigure()).getDefaultSize();
        }
        if (shouldWidthAutoSized && processX) {
            int rightSizeXCoordinate = this.getRightSizeXCoordinateOfRightMostChild(part, scale, moveDelta);
            result.width = Math.max(defaultSize.width, rightSizeXCoordinate - actualBounds.x);
        }
        if (shouldHeightAutoSized && processY) {
            int bottomSizeYCoordinate = this.getBottomSizeYCoordinateOfLowestChild(part, scale, moveDelta);
            result.height = Math.max(defaultSize.height, bottomSizeYCoordinate - actualBounds.y);
        }
        return result;
    }

    private int getRightSizeXCoordinateOfRightMostChild(IGraphicalEditPart part, double scale, Dimension moveDelta) {
        int result = 0;
        Collection children = Collections2.filter((Collection)part.getChildren(), (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(IGraphicalEditPart.class), Predicates.not((Predicate)Predicates.instanceOf(AbstractDiagramBorderNodeEditPart.class)), Predicates.not((Predicate)Predicates.instanceOf(AbstractDiagramNameEditPart.class))}));
        for (IGraphicalEditPart child : children) {
            if (child instanceof ShapeCompartmentEditPart) {
                Collection grandchildren = Collections2.filter((Collection)child.getChildren(), (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(IGraphicalEditPart.class), Predicates.not((Predicate)Predicates.instanceOf(AbstractDiagramBorderNodeEditPart.class)), Predicates.not((Predicate)Predicates.instanceOf(AbstractDiagramNameEditPart.class))}));
                for (IGraphicalEditPart grandchild : grandchildren) {
                    Rectangle bounds = this.getBounds(grandchild, scale, moveDelta, true, false);
                    int rightSizeXCoordinate = bounds.x + bounds.width;
                    if (result >= rightSizeXCoordinate) continue;
                    result = rightSizeXCoordinate;
                }
                continue;
            }
            Rectangle bounds = this.getBounds(child, scale, moveDelta, true, false);
            int rightSizeXCoordinate = bounds.x + bounds.width;
            if (result >= rightSizeXCoordinate) continue;
            result = rightSizeXCoordinate;
        }
        return result;
    }

    private int getBottomSizeYCoordinateOfLowestChild(IGraphicalEditPart part, double scale, Dimension moveDelta) {
        int result = 0;
        Collection children = Collections2.filter((Collection)part.getChildren(), (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(IGraphicalEditPart.class), Predicates.not((Predicate)Predicates.instanceOf(AbstractDiagramBorderNodeEditPart.class)), Predicates.not((Predicate)Predicates.instanceOf(AbstractDiagramNameEditPart.class))}));
        for (IGraphicalEditPart child : children) {
            if (child instanceof ShapeCompartmentEditPart) {
                Collection grandchildren = Collections2.filter((Collection)child.getChildren(), (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(IGraphicalEditPart.class), Predicates.not((Predicate)Predicates.instanceOf(AbstractDiagramBorderNodeEditPart.class)), Predicates.not((Predicate)Predicates.instanceOf(AbstractDiagramNameEditPart.class))}));
                for (IGraphicalEditPart grandchild : grandchildren) {
                    Rectangle bounds = this.getBounds(grandchild, scale, moveDelta, false, true);
                    int bottomSizeYCoordinate = bounds.y + bounds.height;
                    if (result >= bottomSizeYCoordinate) continue;
                    result = bottomSizeYCoordinate;
                }
                continue;
            }
            Rectangle bounds = this.getBounds(child);
            int bottomSizeYCoordinate = bounds.y + bounds.height;
            if (result >= bottomSizeYCoordinate) continue;
            result = bottomSizeYCoordinate;
        }
        return result;
    }

    private abstract class AbstractCoordinateComparator
    implements Comparator<IBorderItemEditPart> {
        Map<IBorderItemEditPart, BorderItemOppositeElementData> oppositeElementsDataByEditPart;

        AbstractCoordinateComparator(Map<IBorderItemEditPart, BorderItemOppositeElementData> oppositeElementsDataByEditPart) {
            this.oppositeElementsDataByEditPart = oppositeElementsDataByEditPart;
        }
    }

    private static class BorderItemLayoutData {
        Point previousCenterLocation;
        Point previousPreviousCenterLocation;
        boolean isMoved;

        private BorderItemLayoutData() {
        }

        protected Point getPreviousPreviousCenterLocation() {
            return this.previousPreviousCenterLocation;
        }

        protected void setPreviousPreviousCenterLocation(Point previousPreviousCenterLocation) {
            this.previousPreviousCenterLocation = previousPreviousCenterLocation;
        }

        protected Point getPreviousCenterLocation() {
            return this.previousCenterLocation;
        }

        protected void setPreviousCenterLocation(Point newCenterLocation) {
            this.setPreviousPreviousCenterLocation(this.getPreviousCenterLocation());
            this.previousCenterLocation = newCenterLocation;
        }

        protected boolean isMoved() {
            return this.isMoved;
        }

        protected void setMoved(boolean moved) {
            this.isMoved = moved;
        }

        public String toString() {
            if (this.isMoved) {
                return MessageFormat.format(Messages.BorderItemLayoutData_movedBorderItemSincePreviousLayout, this.getPreviousCenterLocation());
            }
            return MessageFormat.format(Messages.BorderItemLayoutData_unmovedBorderItemSincePreviousLayout, this.getPreviousCenterLocation());
        }
    }

    private static class BorderItemOppositeElementData {
        Point center;
        int side;

        BorderItemOppositeElementData(Point centerPoint) {
            this(centerPoint, 0);
        }

        BorderItemOppositeElementData(Point centerPoint, int side) {
            this.center = centerPoint;
            this.side = side;
        }
    }

    private class EastCoordinateComparator
    extends AbstractCoordinateComparator {
        EastCoordinateComparator(Map<IBorderItemEditPart, BorderItemOppositeElementData> oppositeElementsDataByEditPart) {
            super(oppositeElementsDataByEditPart);
        }

        @Override
        public int compare(IBorderItemEditPart o1, IBorderItemEditPart o2) {
            int result = 0;
            BorderItemOppositeElementData p1 = (BorderItemOppositeElementData)this.oppositeElementsDataByEditPart.get(o1);
            BorderItemOppositeElementData p2 = (BorderItemOppositeElementData)this.oppositeElementsDataByEditPart.get(o2);
            result = p1.center.y == p2.center.y ? (p1.side == 1 ? (p1.center.x < p2.center.x ? 1 : -1) : (p1.center.x > p2.center.x ? 1 : -1)) : (p1.center.y > p2.center.y ? 1 : -1);
            return result;
        }
    }

    private class NorthCoordinateComparator
    extends AbstractCoordinateComparator {
        NorthCoordinateComparator(Map<IBorderItemEditPart, BorderItemOppositeElementData> targetPointsByEditPart) {
            super(targetPointsByEditPart);
        }

        @Override
        public int compare(IBorderItemEditPart o1, IBorderItemEditPart o2) {
            int result = 0;
            BorderItemOppositeElementData p1 = (BorderItemOppositeElementData)this.oppositeElementsDataByEditPart.get(o1);
            BorderItemOppositeElementData p2 = (BorderItemOppositeElementData)this.oppositeElementsDataByEditPart.get(o2);
            result = p1.center.x == p2.center.x ? (p1.side == 8 ? (p1.center.y > p2.center.y ? 1 : -1) : (p1.center.y < p2.center.y ? 1 : -1)) : (p1.center.x > p2.center.x ? 1 : -1);
            return result;
        }
    }

    private class SouthCoordinateComparator
    extends AbstractCoordinateComparator {
        SouthCoordinateComparator(Map<IBorderItemEditPart, BorderItemOppositeElementData> targetPointsByEditPart) {
            super(targetPointsByEditPart);
        }

        @Override
        public int compare(IBorderItemEditPart o1, IBorderItemEditPart o2) {
            int result = 0;
            BorderItemOppositeElementData p1 = (BorderItemOppositeElementData)this.oppositeElementsDataByEditPart.get(o1);
            BorderItemOppositeElementData p2 = (BorderItemOppositeElementData)this.oppositeElementsDataByEditPart.get(o2);
            result = p1.center.x == p2.center.x ? (p1.side == 8 ? (p1.center.y < p2.center.y ? 1 : -1) : (p1.center.y > p2.center.y ? 1 : -1)) : (p1.center.x > p2.center.x ? 1 : -1);
            return result;
        }
    }

    private class WestCoordinateComparator
    extends AbstractCoordinateComparator {
        WestCoordinateComparator(Map<IBorderItemEditPart, BorderItemOppositeElementData> targetPointsByEditPart) {
            super(targetPointsByEditPart);
        }

        @Override
        public int compare(IBorderItemEditPart o1, IBorderItemEditPart o2) {
            int result = 0;
            BorderItemOppositeElementData p1 = (BorderItemOppositeElementData)this.oppositeElementsDataByEditPart.get(o1);
            BorderItemOppositeElementData p2 = (BorderItemOppositeElementData)this.oppositeElementsDataByEditPart.get(o2);
            result = p1.center.y == p2.center.y ? (p1.side == 1 ? (p1.center.x > p2.center.x ? 1 : -1) : (p1.center.x < p2.center.x ? 1 : -1)) : (p1.center.y > p2.center.y ? 1 : -1);
            return result;
        }
    }
}

