/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.aql.business.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.sirius.common.tools.api.interpreter.IVariableStatusListener;
import org.eclipse.sirius.common.tools.api.interpreter.JavaExtensionsManager;
import org.eclipse.sirius.common.tools.api.interpreter.VariableManager;
import org.eclipse.sirius.common.tools.internal.interpreter.AbstractInterpreter;

public abstract class AcceleoAbstractInterpreter
extends AbstractInterpreter {
    protected JavaExtensionsManager javaExtensions;
    private VariableManager variables;
    private final Set<IVariableStatusListener> variableStatusListeners = new HashSet<IVariableStatusListener>();

    public AcceleoAbstractInterpreter() {
        this.javaExtensions = JavaExtensionsManager.createManagerWithOverride();
        this.variables = new VariableManager();
    }

    public void addVariableStatusListener(IVariableStatusListener newListener) {
        this.variableStatusListeners.add(newListener);
    }

    public void clearVariables() {
        this.variables.clearVariables();
        this.notifyVariableListeners();
    }

    public void dispose() {
        this.variables.clearVariables();
        this.variableStatusListeners.clear();
        this.javaExtensions.dispose();
    }

    public Object getVariable(String name) {
        return this.variables.getVariable(name);
    }

    public Map<String, Object> getVariables() {
        return this.variables.getVariables();
    }

    private void notifyVariableListeners() {
        for (IVariableStatusListener variableStatusListener : this.variableStatusListeners) {
            variableStatusListener.notifyChanged(this.getVariables());
        }
    }

    public void removeVariableStatusListener(IVariableStatusListener listener) {
        this.variableStatusListeners.remove(listener);
    }

    public void setProperty(Object key, Object value) {
        if ("files".equals(key)) {
            this.javaExtensions.updateScope((Collection)value);
        }
    }

    public void setVariable(String name, Object value) {
        this.variables.setVariable(name, value);
    }

    public void unSetVariable(String name) {
        this.variables.unSetVariable(name);
        this.notifyVariableListeners();
    }

    public void addImport(String dependency) {
        this.javaExtensions.addImport(dependency);
    }

    public void removeImport(String dependency) {
        this.javaExtensions.removeImport(dependency);
    }

    public Collection<String> getImports() {
        return this.javaExtensions.getImports();
    }

    public void clearImports() {
        this.javaExtensions.clearImports();
    }
}

