/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.opsemanticsview.gen.k3;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Set;
import opsemanticsview.ExecutionToASEntry;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.OpsemanticsviewFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gemoc.xdsmlframework.commons.DynamicAnnotationHelper;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class K3DynamicElementsFinder {
    private final EPackage abstractSyntax;
    private final EPackage executionMetamodel;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    private OperationalSemanticsView view;

    public K3DynamicElementsFinder(EPackage abstractSyntax, EPackage executionMetamodel, OperationalSemanticsView view) {
        this.abstractSyntax = abstractSyntax;
        this.executionMetamodel = executionMetamodel;
        this.view = view;
    }

    public void find() {
        boolean _notEquals;
        this.findDynamicParts();
        boolean bl = _notEquals = !Objects.equal((Object)this.abstractSyntax, null);
        if (_notEquals) {
            this.findMappingAsToExe();
        }
    }

    private void findDynamicParts() {
        Set _set = IteratorExtensions.toSet((Iterator)Iterators.filter((Iterator)this.executionMetamodel.eAllContents(), EClass.class));
        for (EClass c : _set) {
            boolean _not;
            boolean _isDynamic = DynamicAnnotationHelper.isDynamic((EClass)c);
            boolean bl = _not = !_isDynamic;
            if (_not) {
                Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

                    public Boolean apply(EStructuralFeature p) {
                        return DynamicAnnotationHelper.isDynamic((EStructuralFeature)p);
                    }
                };
                Iterable mutableProperties = IterableExtensions.filter((Iterable)c.getEStructuralFeatures(), (Functions.Function1)_function);
                if (Objects.equal((Object)mutableProperties, null) || IterableExtensions.isEmpty((Iterable)mutableProperties)) continue;
                for (EStructuralFeature p : mutableProperties) {
                    this.view.getDynamicProperties().add((Object)p);
                }
                continue;
            }
            this.view.getDynamicClasses().add((Object)c);
            EList _eStructuralFeatures = c.getEStructuralFeatures();
            for (EStructuralFeature p_1 : _eStructuralFeatures) {
                this.view.getDynamicProperties().add((Object)p_1);
            }
        }
    }

    private void findMappingAsToExe() {
        this.explorePackageRecursively(this.abstractSyntax, this.executionMetamodel);
    }

    private void explorePackageRecursively(EPackage asPackage, EPackage exePackage) {
        Iterable _filter = Iterables.filter((Iterable)asPackage.getEClassifiers(), EClass.class);
        for (final EClass asClass : _filter) {
            Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass exeC) {
                    return asClass.getName().equals(exeC.getName());
                }
            };
            final EClass exeClass = (EClass)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)exePackage.getEClassifiers(), EClass.class), (Functions.Function1)_function);
            ExecutionToASEntry _createExecutionToASEntry = OpsemanticsviewFactory.eINSTANCE.createExecutionToASEntry();
            Procedures.Procedure1<ExecutionToASEntry> _function_1 = new Procedures.Procedure1<ExecutionToASEntry>(){

                public void apply(ExecutionToASEntry it) {
                    it.setASclass(asClass);
                    it.setExecutionClass(exeClass);
                }
            };
            ExecutionToASEntry mappingEntry = (ExecutionToASEntry)ObjectExtensions.operator_doubleArrow((Object)_createExecutionToASEntry, (Procedures.Procedure1)_function_1);
            this.view.getExecutionToASmapping().add((Object)mappingEntry);
        }
        EList _eSubpackages = asPackage.getESubpackages();
        for (final EPackage asSubPackage : _eSubpackages) {
            Functions.Function1<EPackage, Boolean> _function = new Functions.Function1<EPackage, Boolean>(){

                public Boolean apply(EPackage p) {
                    return p.getName().equals(asSubPackage.getName());
                }
            };
            EPackage exeSubPackage = (EPackage)IterableExtensions.findFirst((Iterable)asPackage.getESubpackages(), (Functions.Function1)_function);
            this.explorePackageRecursively(asSubPackage, exeSubPackage);
        }
    }

    @Pure
    public OperationalSemanticsView getView() {
        return this.view;
    }

    protected void setView(OperationalSemanticsView view) {
        this.view = view;
    }
}

