/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.moccml.mapping.moccml_mapping;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EventKind implements Enumerator
{
    UNDEFINED(0, "undefined", "undefined"),
    START(1, "start", "start"),
    FINISH(2, "finish", "finish"),
    SEND(3, "send", "send"),
    RECEIVE(4, "receive", "receive"),
    CONSUME(6, "consume", "consume"),
    PRODUCE(5, "produce", "produce"),
    CREATE(7, "create", "create"),
    DESTROY(8, "destroy", "destroy"),
    SUSPEND(9, "suspend", "suspend"),
    RESUME(10, "resume", "resume"),
    CALL(11, "call", "call");

    public static final int UNDEFINED_VALUE = 0;
    public static final int START_VALUE = 1;
    public static final int FINISH_VALUE = 2;
    public static final int SEND_VALUE = 3;
    public static final int RECEIVE_VALUE = 4;
    public static final int CONSUME_VALUE = 6;
    public static final int PRODUCE_VALUE = 5;
    public static final int CREATE_VALUE = 7;
    public static final int DESTROY_VALUE = 8;
    public static final int SUSPEND_VALUE = 9;
    public static final int RESUME_VALUE = 10;
    public static final int CALL_VALUE = 11;
    private static final EventKind[] VALUES_ARRAY;
    public static final List<EventKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EventKind[]{UNDEFINED, START, FINISH, SEND, RECEIVE, CONSUME, PRODUCE, CREATE, DESTROY, SUSPEND, RESUME, CALL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EventKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventKind get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return START;
            }
            case 2: {
                return FINISH;
            }
            case 3: {
                return SEND;
            }
            case 4: {
                return RECEIVE;
            }
            case 6: {
                return CONSUME;
            }
            case 5: {
                return PRODUCE;
            }
            case 7: {
                return CREATE;
            }
            case 8: {
                return DESTROY;
            }
            case 9: {
                return SUSPEND;
            }
            case 10: {
                return RESUME;
            }
            case 11: {
                return CALL;
            }
        }
        return null;
    }

    private EventKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

