/*******************************************************************************
 * Copyright (c) 2017 INRIA and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     INRIA - initial API and implementation
 *     I3S Laboratory - API update and bug fix
 *******************************************************************************/
package org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core;

import java.util.Collection;

import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.ICodeExecutor;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dse.IMSEStateController;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionPlatform;

public interface IConcurrentExecutionPlatform extends IExecutionPlatform
{

	/**
	 * @return The code executor to use for the model execution.
	 */
	ICodeExecutor getCodeExecutor();
	
	/**
	 * return this if this is an IConcurrentExecutionPlatform, null otherwise 
	 * @return
	 */
	IConcurrentExecutionPlatform asConcurrentExecutionPlatform();
	
	Collection<IMSEStateController> getMSEStateControllers();

}
