/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.pde.ui;

import java.util.ArrayList;
import org.eclipse.gemoc.commons.eclipse.logging.ILoggingBackend;
import org.eclipse.gemoc.commons.eclipse.logging.ILoggingEntity;
import org.eclipse.gemoc.commons.eclipse.logging.backends.DefaultLoggingBackend;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public abstract class GemocUIPlugin
extends AbstractUIPlugin
implements ILoggingEntity {
    private ArrayList<ILoggingBackend> _loggingBackends = new ArrayList();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DefaultLoggingBackend backend = this.resolveLoggingBackend();
        if (backend != null) {
            this.addLoggingBackend((ILoggingBackend)backend);
        }
    }

    public abstract DefaultLoggingBackend resolveLoggingBackend();

    public abstract String getId();

    public String getName() {
        return (String)this.getBundle().getHeaders().get("Bundle-Name");
    }

    private void addLoggingBackend(ILoggingBackend backend) {
        if (backend == null) {
            throw new IllegalArgumentException("backend");
        }
        this._loggingBackends.add(backend);
    }

    public void debug(String message) {
        for (ILoggingBackend b : this._loggingBackends) {
            b.debug(message);
        }
    }

    public void error(String message) {
        for (ILoggingBackend b : this._loggingBackends) {
            b.error(message);
        }
    }

    public void info(String message) {
        for (ILoggingBackend b : this._loggingBackends) {
            b.info(message);
        }
    }

    public void warn(String message) {
        for (ILoggingBackend b : this._loggingBackends) {
            b.warn(message);
        }
    }

    public void error(String message, Throwable e) {
        for (ILoggingBackend b : this._loggingBackends) {
            b.error(message, e);
        }
    }

    public void warn(String message, Throwable e) {
        for (ILoggingBackend b : this._loggingBackends) {
            b.warn(message, e);
        }
    }

    public void info(String message, Throwable e) {
        for (ILoggingBackend b : this._loggingBackends) {
            b.info(message, e);
        }
    }
}

