/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.TemplateListSelectionPage;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.WizardElement;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.BaseProjectWizardFields;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.elements.IPDEElement;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractNewProjectWizardWithTemplates
extends Wizard {
    public static final String PLUGIN_POINT = "projectContent";
    public static final String TAG_WIZARD = "wizard";
    public TemplateListSelectionPage templateSelectionPage;

    public TemplateListSelectionPage getTemplateListSelectionPage(BaseProjectWizardFields context) {
        if (this.templateSelectionPage == null) {
            this.templateSelectionPage = new TemplateListSelectionPage(this.getAvailableCodegenWizards(), context, "&Available Templates:");
        }
        return this.templateSelectionPage;
    }

    protected WizardElement createWizardElement(IConfigurationElement config) {
        String name = config.getAttribute("name");
        String id = config.getAttribute("id");
        String className = config.getAttribute("class");
        if (name == null || id == null || className == null) {
            return null;
        }
        WizardElement element = new WizardElement(config);
        element.id = id;
        String imageName = config.getAttribute("icon");
        if (imageName != null) {
            String pluginID = config.getNamespaceIdentifier();
            Image image = PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(pluginID, imageName);
            element.setImage(image);
        }
        return element;
    }

    public ElementList getAvailableCodegenWizards() {
        ElementList wizards = new ElementList("CodegenWizards");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.gemoc.commons.eclipse.pde", PLUGIN_POINT);
        if (point == null) {
            return wizards;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                WizardElement element;
                String targetPluginId;
                if (elements[j].getName().equals(TAG_WIZARD) && ((targetPluginId = elements[j].getAttribute("targetPluginId")) == null || targetPluginId.equals(this.getTargetPluginId())) && (element = this.createWizardElement(elements[j])) != null) {
                    wizards.add((IPDEElement)element);
                }
                ++j;
            }
            ++i;
        }
        return wizards;
    }

    public abstract String getTargetPluginId();
}

