/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.Activator;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.ConsoleIO;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.message.ConsoleMessage;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal.console.message.WarningMessage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class EclipseConsoleIO
extends ConsoleIO
implements IPropertyChangeListener {
    public boolean notAlreadyUsed = true;
    public static final int CONSOLE_MAX_WIDTH = 5000;
    public static final int LARGE_MESSAGE_SIZE = 10000;
    public static final int MIN_CHARS = 1000;
    protected IOConsole console = null;

    public EclipseConsoleIO(IOConsole console) {
        this.console = console;
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.updateOutputLimit();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = this.console.newOutputStream();
        }
        return this.outputStream;
    }

    @Override
    public BufferedReader getReader() {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.console.getInputStream()));
        }
        return this.reader;
    }

    @Override
    public String promptAndRead(String prompt) {
        this.console.activate();
        this.print(prompt);
        return this.read();
    }

    @Override
    public void clear() {
        this.console.clearConsole();
    }

    @Override
    public void print(final ConsoleMessage message) {
        if (this.notAlreadyUsed) {
            ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this.console);
            this.console.activate();
            this.notAlreadyUsed = false;
        }
        if (message.getMessage().length() > 10000) {
            Job myJob = new Job("Writing a large string to the console"){

                public IStatus run(IProgressMonitor monitor) {
                    EclipseConsoleIO.this.safePrint(message.getMessage(), message.getColor(), message.getStyle(), monitor);
                    return new Status(0, "fr.irisa.triskell.eclipse.utils", "large message printed to the console");
                }
            };
            myJob.schedule();
            try {
                myJob.join();
            }
            catch (InterruptedException e) {
                this.print(new WarningMessage("writing of large message to the console interrupted"));
            }
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    EclipseConsoleIO.this.changeStyle(message.getColor(), message.getStyle());
                    String justifiedMsg = EclipseConsoleIO.justifyMessage(message.getMessage());
                    if (!((IOConsoleOutputStream)EclipseConsoleIO.this.getOutputStream()).isClosed()) {
                        try {
                            ((IOConsoleOutputStream)EclipseConsoleIO.this.getOutputStream()).write(justifiedMsg);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            };
            ConsolePlugin.getStandardDisplay().asyncExec(r);
        }
    }

    protected void safePrint(String message, Color c, int style, IProgressMonitor monitor) {
        try {
            String justifiedMsg = EclipseConsoleIO.justifyMessage(message);
            if (justifiedMsg.length() > 10000) {
                int nbChunk = justifiedMsg.length() / 10000;
                monitor.beginTask("writing large string to the console", nbChunk + 1);
                int end = 0;
                int i = 0;
                while (i < nbChunk) {
                    int start = 10000 * i;
                    end = 10000 * i + 10000;
                    this.changeStream();
                    this.safeChangeStyle(c, style);
                    ((IOConsoleOutputStream)this.getOutputStream()).write(justifiedMsg.substring(start, end));
                    monitor.worked(1);
                    ++i;
                }
                this.changeStream();
                this.safeChangeStyle(c, style);
                ((IOConsoleOutputStream)this.getOutputStream()).write(justifiedMsg.substring(end, justifiedMsg.length()));
                monitor.done();
            } else {
                this.safeChangeStyle(c, style);
                ((IOConsoleOutputStream)this.getOutputStream()).write(justifiedMsg);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void changeColor(Color c) {
        Color previousColor = ((IOConsoleOutputStream)this.getOutputStream()).getColor();
        if (c == null && c != previousColor || c != null && !c.equals((Object)previousColor)) {
            this.changeStream();
            ((IOConsoleOutputStream)this.getOutputStream()).setColor(c);
        }
    }

    @Override
    public void changeStyle(Color c, int style) {
        Color previousColor = ((IOConsoleOutputStream)this.getOutputStream()).getColor();
        int previousStyle = ((IOConsoleOutputStream)this.getOutputStream()).getFontStyle();
        if (c == null && c != previousColor || c != null && !c.equals((Object)previousColor) || style != previousStyle) {
            this.changeStream();
            ((IOConsoleOutputStream)this.getOutputStream()).setColor(c);
            ((IOConsoleOutputStream)this.getOutputStream()).setFontStyle(style);
        }
    }

    protected void safeChangeStyle(final Color c, final int style) {
        Color previousColor = ((IOConsoleOutputStream)this.getOutputStream()).getColor();
        int previousStyle = ((IOConsoleOutputStream)this.getOutputStream()).getFontStyle();
        if (c == null && c != previousColor || c != null && !c.equals((Object)previousColor) || style != previousStyle) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    EclipseConsoleIO.this.changeStream();
                    ((IOConsoleOutputStream)EclipseConsoleIO.this.getOutputStream()).setColor(c);
                    ((IOConsoleOutputStream)EclipseConsoleIO.this.getOutputStream()).setFontStyle(style);
                }
            });
        }
    }

    @Override
    public void changeFontStyle(int style) {
        int previousStyle = ((IOConsoleOutputStream)this.getOutputStream()).getFontStyle();
        if (style != previousStyle) {
            this.changeStream();
            ((IOConsoleOutputStream)this.getOutputStream()).setFontStyle(style);
        }
    }

    public void changeStream() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.outputStream = null;
    }

    @Override
    public void println(final ConsoleMessage message) {
        this.print(message);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                EclipseConsoleIO.this.changeStyle(message.getColor(), message.getStyle());
                if (!((IOConsoleOutputStream)EclipseConsoleIO.this.getOutputStream()).isClosed()) {
                    try {
                        ((IOConsoleOutputStream)EclipseConsoleIO.this.getOutputStream()).write("\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        ConsolePlugin.getStandardDisplay().asyncExec(r);
    }

    private void updateOutputLimit() {
        int nMaxChars = Activator.getDefault().getPreferenceStore().getInt("max_console_output_Preference");
        int nMinChars = Math.min(1000, nMaxChars - 1);
        this.console.setWaterMarks(Math.max(-1, nMinChars), Math.max(-1, nMaxChars));
    }

    public static String justifyMessage(String message) {
        StringBuffer justifiedMessage = new StringBuffer(message);
        int lastNLIndex = 0;
        int index = 0;
        while (index < justifiedMessage.length()) {
            if (justifiedMessage.charAt(index) == '\n' || index == justifiedMessage.length() - 1) {
                if (index - lastNLIndex > 5000) {
                    justifiedMessage.insert(lastNLIndex + 5000, '\n');
                    lastNLIndex += 5000;
                } else {
                    lastNLIndex = index;
                }
            }
            ++index;
        }
        return justifiedMessage.toString();
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        this.updateOutputLimit();
    }

    public void showConsole() {
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this.console);
        this.console.activate();
    }
}

