/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.compare.INavigatable;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Logger;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IPresenceDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EElementRelativePresence;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.diffdata.EMergeableDifference;
import org.eclipse.emf.diffmerge.diffdata.EValuePresence;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.diffuidata.ComparisonSelection;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.ComparisonSelectionImpl;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.MatchAndFeatureImpl;
import org.eclipse.emf.diffmerge.ui.log.CompareLogEvent;
import org.eclipse.emf.diffmerge.ui.log.DiffMergeLogger;
import org.eclipse.emf.diffmerge.ui.log.MergeLogEvent;
import org.eclipse.emf.diffmerge.ui.setup.ComparisonSetupManager;
import org.eclipse.emf.diffmerge.ui.setup.EMFDiffMergeEditorInput;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethod;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.util.DelegatingLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.util.InconsistencyDialog;
import org.eclipse.emf.diffmerge.ui.util.MiscUtil;
import org.eclipse.emf.diffmerge.ui.util.SymmetricMatchComparer;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.CategoryDialog;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonSideViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonTreeViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedComparisonSideViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedComparisonTreeViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedFeaturesViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedValuesViewer;
import org.eclipse.emf.diffmerge.ui.viewers.FeaturesViewer;
import org.eclipse.emf.diffmerge.ui.viewers.HeaderViewer;
import org.eclipse.emf.diffmerge.ui.viewers.IgnoreChoiceData;
import org.eclipse.emf.diffmerge.ui.viewers.IgnoreChoicesDialog;
import org.eclipse.emf.diffmerge.ui.viewers.MergeChoiceData;
import org.eclipse.emf.diffmerge.ui.viewers.MergeChoicesDialog;
import org.eclipse.emf.diffmerge.ui.viewers.MergeImpactMessageDialog;
import org.eclipse.emf.diffmerge.ui.viewers.MergeImpactViewer;
import org.eclipse.emf.diffmerge.ui.viewers.SelectionBridge;
import org.eclipse.emf.diffmerge.ui.viewers.ValuesViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ComparisonViewer
extends AbstractComparisonViewer {
    public static final String PROPERTY_FILTERING = "PROPERTY_FILTERING";
    public static final String PROPERTY_ACTIVATION_DELETE_LEFT = "PROPERTY_ACTIVATION_DELETE_LEFT";
    public static final String PROPERTY_ACTIVATION_DELETE_RIGHT = "PROPERTY_ACTIVATION_DELETE_RIGHT";
    public static final String PROPERTY_ACTIVATION_MERGE_TO_LEFT = "PROPERTY_ACTIVATION_MERGE_TO_LEFT";
    public static final String PROPERTY_ACTIVATION_MERGE_TO_RIGHT = "PROPERTY_ACTIVATION_MERGE_TO_RIGHT";
    public static final String PROPERTY_ACTIVATION_IGNORE_LEFT = "PROPERTY_ACTIVATION_IGNORE_LEFT";
    public static final String PROPERTY_ACTIVATION_IGNORE_RIGHT = "PROPERTY_ACTIVATION_IGNORE_RIGHT";
    protected EnhancedComparisonTreeViewer _viewerSynthesisMain;
    protected EnhancedComparisonSideViewer _viewerSynthesisLeft;
    protected EnhancedComparisonSideViewer _viewerSynthesisRight;
    protected EnhancedFeaturesViewer _viewerFeatures;
    protected EnhancedValuesViewer _viewerValuesLeft;
    protected EnhancedValuesViewer _viewerValuesRight;
    protected ViewerFilter _filterMoveOrigins;
    protected ViewerFilter _filterUnchangedElements;
    protected ViewerComparator _sorterSynthesis;
    protected boolean _isLeftRightSynced;
    private ComparisonSelection _lastUserSelection;
    protected SelectionBridge.SingleSource _multiViewerSelectionProvider;
    protected FilterSelectionListener _filterSelectionListener;

    public ComparisonViewer(Composite parent_p) {
        this(parent_p, null);
    }

    public ComparisonViewer(Composite parent_p, IActionBars actionBars_p) {
        super(parent_p, actionBars_p);
    }

    protected boolean acceptContextMenuAdditions(Viewer viewer_p) {
        return true;
    }

    protected void addDifferencesToMerge(List<IDifference> toMerge_p, IMatch match_p, Role destination_p, boolean incrementalMode_p) {
        for (IDifference difference : match_p.getAllDifferences()) {
            if (this.getInput().getCategoryManager().isFiltered(difference) || incrementalMode_p && (!(difference instanceof IPresenceDifference) || ((IPresenceDifference)difference).getPresenceRole() == destination_p)) continue;
            toMerge_p.add(difference);
        }
    }

    protected void addDifferencesToMergeRec(List<IDifference> toMerge_p, IMatch match_p, Role destination_p, boolean incrementalMode_p) {
        this.addDifferencesToMerge(toMerge_p, match_p, destination_p, incrementalMode_p);
        for (IMatch child : this.getInput().getCategoryManager().getChildrenForMerge(match_p)) {
            this.addDifferencesToMergeRec(toMerge_p, child, destination_p, incrementalMode_p);
        }
    }

    protected ComparisonSelection asComparisonSelection(IStructuredSelection selection_p) {
        EComparison comparison;
        ArrayList<IMatch> matches = new ArrayList<IMatch>();
        EMFDiffNode input = this.getInput();
        if (input != null && (comparison = this.getComparison()) != null) {
            Role mainRole = input.getDrivingRole();
            Object[] objectArray = selection_p.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selected = objectArray[n2];
                if (selected instanceof EObject) {
                    EObject selectedElement = (EObject)selected;
                    IMatch match = comparison.getMapping().getMatchFor(selectedElement, mainRole);
                    if (match == null) {
                        match = comparison.getMapping().getMatchFor(selectedElement, mainRole.opposite());
                    }
                    if (match != null) {
                        matches.add(match);
                    }
                }
                ++n2;
            }
        }
        ComparisonSelectionImpl result = new ComparisonSelectionImpl(matches, null, input);
        return result;
    }

    protected boolean canAddToTheLeft(DifferenceKind originKind_p) {
        List<DifferenceKind> allowed = Arrays.asList(DifferenceKind.CONFLICT, DifferenceKind.MODIFIED, DifferenceKind.FROM_BOTH, DifferenceKind.FROM_RIGHT, DifferenceKind.FROM_RIGHT_ADD, DifferenceKind.FROM_LEFT_DEL);
        return allowed.contains((Object)originKind_p);
    }

    protected boolean canAddToTheRight(DifferenceKind originKind_p) {
        List<DifferenceKind> allowed = Arrays.asList(DifferenceKind.CONFLICT, DifferenceKind.MODIFIED, DifferenceKind.FROM_BOTH, DifferenceKind.FROM_LEFT, DifferenceKind.FROM_LEFT_ADD, DifferenceKind.FROM_RIGHT_DEL);
        return allowed.contains((Object)originKind_p);
    }

    @Override
    public void compareInputChanged(final ICompareInput source_p) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (source_p instanceof EMFDiffNode) {
                    EMFDiffNode node = (EMFDiffNode)source_p;
                    boolean isFiltering = node.getCategoryManager().isUIMoreFilteringThanDefault();
                    ComparisonViewer.this.firePropertyChangeEvent(ComparisonViewer.PROPERTY_FILTERING, isFiltering);
                }
                ComparisonViewer.this.refresh();
            }
        });
    }

    @Override
    protected Composite createControls(Composite parent_p) {
        this.initialize();
        SashForm result = new SashForm(parent_p, 512);
        SashForm upperPart = this.createRowUpper((Composite)result);
        SashForm lowerPart = this.createRowLower((Composite)result);
        this.setupColumns(upperPart, lowerPart);
        result.setWeights(this.getDefaultRowWeights());
        this.setupToolBars();
        return result;
    }

    protected Item createItemCollapse(ToolBar context_p) {
        ToolItem result = new ToolItem(context_p, 8);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.COLLAPSEALL));
        result.setToolTipText(Messages.ComparisonViewer_CollapseTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                BusyIndicator.showWhile((Display)ComparisonViewer.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((ComparisonTreeViewer)((Object)(this).ComparisonViewer.this._viewerSynthesisMain.getInnerViewer())).collapseAll();
                    }
                });
            }
        });
        return result;
    }

    protected Item createItemDelete(ToolBar context_p, final boolean onLeft_p) {
        final ToolItem result = new ToolItem(context_p, 8);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.DELETE));
        result.setToolTipText(onLeft_p ? Messages.ComparisonViewer_DeleteLeftTooltip : Messages.ComparisonViewer_DeleteRightTooltip);
        result.setEnabled(false);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Object newValue;
                if ((onLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_DELETE_LEFT.equals(event_p.getProperty()) || !onLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_DELETE_RIGHT.equals(event_p.getProperty())) && (newValue = event_p.getNewValue()) instanceof Boolean) {
                    result.setEnabled(((Boolean)newValue).booleanValue());
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.merge(onLeft_p, false);
            }
        });
        return result;
    }

    protected Item createItemExpand(ToolBar context_p) {
        ToolItem result = new ToolItem(context_p, 8);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.EXPANDALL));
        result.setToolTipText(Messages.ComparisonViewer_ExpandTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                BusyIndicator.showWhile((Display)ComparisonViewer.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((ComparisonTreeViewer)((Object)(this).ComparisonViewer.this._viewerSynthesisMain.getInnerViewer())).expandAll();
                    }
                });
            }
        });
        return result;
    }

    protected Item createItemFilter(Widget context_p) {
        assert (context_p instanceof ToolBar || context_p instanceof Menu);
        Item result = UIUtil.itemCreate(context_p, 32, null);
        String text = context_p instanceof ToolBar ? Messages.ComparisonViewer_FilterToolTip : Messages.ComparisonViewer_FilterText;
        UIUtil.itemSetText(result, text);
        UIUtil.itemSetToolTipText(result, Messages.ComparisonViewer_EnhancedFilterToolTip);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.FILTER));
        UIUtil.itemSetSelection(result, false);
        if (this._filterSelectionListener == null) {
            this._filterSelectionListener = new FilterSelectionListener();
        }
        this._filterSelectionListener.addItem(result);
        return result;
    }

    protected Item createItemIgnore(ToolBar context_p, final boolean onLeft_p) {
        final ToolItem result = new ToolItem(context_p, 8);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.CHECKED));
        result.setToolTipText(onLeft_p ? Messages.ComparisonViewer_IgnoreLeftTooltip : Messages.ComparisonViewer_IgnoreRightTooltip);
        result.setEnabled(false);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Object newValue;
                if ((onLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_IGNORE_LEFT.equals(event_p.getProperty()) || !onLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_IGNORE_RIGHT.equals(event_p.getProperty())) && (newValue = event_p.getNewValue()) instanceof Boolean) {
                    result.setEnabled(((Boolean)newValue).booleanValue());
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.ignore(onLeft_p);
            }
        });
        return result;
    }

    protected Item createItemInconsistency(ToolBar context_p) {
        final ToolItem result = new ToolItem(context_p, 8);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.WARNING));
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                final Shell shell = ComparisonViewer.this.getShell();
                final EComparison comparison = ComparisonViewer.this.getComparison();
                if (shell != null && comparison != null) {
                    shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            InconsistencyDialog dialog = new InconsistencyDialog(shell, (IComparison)comparison);
                            dialog.open();
                        }
                    });
                }
            }
        });
        result.setDisabledImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.EMPTY));
        result.setEnabled(false);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty())) {
                    EComparison comparison = ComparisonViewer.this.getComparison();
                    boolean enabled = comparison != null && !comparison.isConsistent();
                    result.setEnabled(enabled);
                    result.setToolTipText(enabled ? Messages.ComparisonViewer_InconsistencyTooltip : null);
                }
            }
        });
        return result;
    }

    protected Item createItemLock(ToolBar context_p, final boolean onLeft_p) {
        final ToolItem result = new ToolItem(context_p, 32);
        final Image openLockImage = EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.LOCK_OPEN);
        final Image closedLockImage = EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.LOCK_CLOSED);
        result.setImage(openLockImage);
        final String lockedTooltip = Messages.ComparisonViewer_LockTooltip_Locked;
        final String unlockedTooltip = Messages.ComparisonViewer_LockTooltip_Unlocked;
        result.setToolTipText(unlockedTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                boolean editable = !result.getSelection();
                ComparisonViewer.this.getInput().setEditable(editable, onLeft_p);
                result.setImage(editable ? openLockImage : closedLockImage);
                result.setToolTipText(editable ? unlockedTooltip : lockedTooltip);
                ComparisonViewer.this.refreshTools();
            }
        });
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null) {
                    boolean editable = input.isEditable(onLeft_p);
                    result.setSelection(!editable);
                    result.setImage(editable ? openLockImage : closedLockImage);
                    result.setToolTipText(editable ? unlockedTooltip : lockedTooltip);
                    result.setEnabled(input.isEditionPossible(onLeft_p));
                }
            }
        });
        return result;
    }

    protected Item createItemLogEvents(Menu context_p) {
        final MenuItem result = new MenuItem(context_p, 32);
        result.setText(Messages.ComparisonViewer_LogEventsMenuItem);
        String tooltip = Messages.ComparisonViewer_LogTooltipNoFile;
        Logger logger = this.getLogger();
        if (logger instanceof DiffMergeLogger) {
            IPath logFile = ((DiffMergeLogger)logger).getLogFile();
            tooltip = String.format(Messages.ComparisonViewer_LogTooltipFile, logFile.toOSString());
        }
        result.setToolTipText(tooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null && !result.isDisposed()) {
                    result.setSelection(input.isLogEvents());
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                boolean logEvents = result.getSelection();
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setLogEvents(logEvents);
                    if (logEvents) {
                        ComparisonViewer.this.getLogger().log((Object)new CompareLogEvent(ComparisonViewer.this.getEditingDomain(), input));
                    }
                }
            }
        });
        return result;
    }

    protected Item createItemMerge(ToolBar toolbar_p, final boolean toLeft_p) {
        final ToolItem result = new ToolItem(toolbar_p, 8);
        EMFDiffMergeUIPlugin.ImageID imageID = toLeft_p ? EMFDiffMergeUIPlugin.ImageID.CHECKOUT_ACTION : EMFDiffMergeUIPlugin.ImageID.CHECKIN_ACTION;
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(imageID));
        result.setToolTipText(toLeft_p ? Messages.ComparisonViewer_MergeLeftTooltip : Messages.ComparisonViewer_MergeRightTooltip);
        result.setEnabled(false);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Object newValue;
                if ((toLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_MERGE_TO_LEFT.equals(event_p.getProperty()) || !toLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_MERGE_TO_RIGHT.equals(event_p.getProperty())) && (newValue = event_p.getNewValue()) instanceof Boolean) {
                    result.setEnabled(((Boolean)newValue).booleanValue());
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.merge(toLeft_p, true);
            }
        });
        return result;
    }

    protected Item createItemNavigationNext(ToolBar toolbar_p) {
        ToolItem result = new ToolItem(toolbar_p, 8);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.NEXT_DIFF_NAV));
        result.setToolTipText(Messages.ComparisonViewer_NextTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.navigate(true);
            }
        });
        return result;
    }

    protected Item createItemNavigationPrevious(ToolBar context_p) {
        ToolItem result = new ToolItem(context_p, 8);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.PREV_DIFF_NAV));
        result.setToolTipText(Messages.ComparisonViewer_PreviousTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.navigate(false);
            }
        });
        return result;
    }

    protected Item createItemRestart(Menu context_p) {
        final MenuItem result = new MenuItem(context_p, 8);
        result.setText(Messages.ComparisonViewer_ToolUpdate);
        result.setToolTipText(Messages.ComparisonViewer_ToolUpdate_Tooltip);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.UPDATE));
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ComparisonViewer.this.restart();
            }
        });
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty())) {
                    boolean enable = false;
                    EMFDiffNode input = ComparisonViewer.this.getInput();
                    if (input != null && !result.isDisposed()) {
                        enable = input.getEditorInput() != null;
                    }
                    result.setEnabled(enable);
                }
            }
        });
        return result;
    }

    protected Item createItemShowAllFeatures(Menu context_p) {
        MenuItem result = new MenuItem(context_p, 16);
        result.setText(Messages.ComparisonViewer_ShowAllFeatures);
        result.setToolTipText(Messages.ComparisonViewer_ShowAllFeaturesTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ((FeaturesViewer)ComparisonViewer.this._viewerFeatures.getInnerViewer()).setDifferenceAgnostic(true);
                ((ValuesViewer)ComparisonViewer.this._viewerValuesLeft.getInnerViewer()).setDifferenceAgnostic(true);
                ((ValuesViewer)ComparisonViewer.this._viewerValuesRight.getInnerViewer()).setDifferenceAgnostic(true);
            }
        });
        return result;
    }

    protected Item createItemShowAllValues(Menu context_p) {
        MenuItem result = new MenuItem(context_p, 16);
        result.setText(Messages.ComparisonViewer_ShowAllValues);
        result.setToolTipText(Messages.ComparisonViewer_ShowAllValuesTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ((FeaturesViewer)ComparisonViewer.this._viewerFeatures.getInnerViewer()).setDifferenceAgnostic(false);
                ((ValuesViewer)ComparisonViewer.this._viewerValuesLeft.getInnerViewer()).setDifferenceAgnostic(true);
                ((ValuesViewer)ComparisonViewer.this._viewerValuesRight.getInnerViewer()).setDifferenceAgnostic(true);
            }
        });
        return result;
    }

    protected Item createItemShowDifferenceNumbers(Menu context_p) {
        final MenuItem result = new MenuItem(context_p, 32);
        result.setText(Messages.ComparisonViewer_ShowDifferenceNumbersMenuItem);
        result.setToolTipText(Messages.ComparisonViewer_ShowDifferenceNumbersTooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null && !result.isDisposed()) {
                    result.setSelection(!input.isHideDifferenceNumbers());
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                boolean showDiffNumbers = result.getSelection();
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setHideDifferenceNumbers(!showDiffNumbers);
                    ComparisonViewer.this.refresh();
                }
            }
        });
        return result;
    }

    protected Item createItemShowDiffValues(Menu context_p) {
        MenuItem result = new MenuItem(context_p, 16);
        result.setText(Messages.ComparisonViewer_ShowValueDiffs);
        result.setToolTipText(Messages.ComparisonViewer_ShowValueDiffsTooltip);
        result.setSelection(true);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ((FeaturesViewer)ComparisonViewer.this._viewerFeatures.getInnerViewer()).setDifferenceAgnostic(false);
                ((ValuesViewer)ComparisonViewer.this._viewerValuesLeft.getInnerViewer()).setDifferenceAgnostic(false);
                ((ValuesViewer)ComparisonViewer.this._viewerValuesRight.getInnerViewer()).setDifferenceAgnostic(false);
            }
        });
        return result;
    }

    protected Item createItemShowImpact(Menu context_p) {
        final MenuItem result = new MenuItem(context_p, 32);
        result.setText(Messages.ComparisonViewer_ImpactMenuItem);
        result.setToolTipText(Messages.ComparisonViewer_ImpactMenuItemTooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null && !result.isDisposed()) {
                    result.setSelection(input.isShowMergeImpact());
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                boolean showImpact = result.getSelection();
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setShowMergeImpact(showImpact);
                    input.setDefaultShowImpact(showImpact);
                }
            }
        });
        return result;
    }

    protected Item createItemShowSides(Menu context_p) {
        final MenuItem result = new MenuItem(context_p, 32);
        result.setText(Messages.ComparisonViewer_ShowSidesMenuItem);
        result.setToolTipText(Messages.ComparisonViewer_ShowSidesMenuItemTooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null && !result.isDisposed()) {
                    boolean isShowSidesPossible = input.isShowSidesPossible();
                    result.setSelection(isShowSidesPossible);
                    result.setEnabled(isShowSidesPossible);
                    ComparisonViewer.this.showSides(isShowSidesPossible);
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                boolean show = result.getSelection();
                ComparisonViewer.this.showSides(show);
            }
        });
        return result;
    }

    protected Item createItemShowUncounted(Menu context_p) {
        final MenuItem result = new MenuItem(context_p, 32);
        result.setText(Messages.ComparisonViewer_ShowUncountedMenuItem);
        result.setToolTipText(Messages.ComparisonViewer_ShowUncountedMenuItemTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                if (result.getSelection()) {
                    ((ComparisonTreeViewer)((Object)ComparisonViewer.this._viewerSynthesisMain.getInnerViewer())).removeFilter(ComparisonViewer.this._filterUnchangedElements);
                } else {
                    ((ComparisonTreeViewer)((Object)ComparisonViewer.this._viewerSynthesisMain.getInnerViewer())).addFilter(ComparisonViewer.this._filterUnchangedElements);
                }
            }
        });
        return result;
    }

    protected Item createItemSupportUndoRedo(Menu context_p) {
        final MenuItem result = new MenuItem(context_p, 32);
        result.setText(Messages.ComparisonViewer_SupportUndoRedoMenuItem);
        result.setToolTipText(Messages.ComparisonViewer_SupportUndoRedoMenuItemTooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null && !result.isDisposed()) {
                    result.setSelection(input.isUndoRedoSupported());
                    result.setEnabled(input.getEditingDomain() != null);
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setUndoRedoSupported(result.getSelection());
                }
            }
        });
        return result;
    }

    protected Item createItemSort(Menu context_p) {
        final MenuItem result = new MenuItem(context_p, 32);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.SORT));
        result.setText(Messages.ComparisonViewer_SortTooltip);
        result.setToolTipText(Messages.ComparisonViewer_EnhancedSortTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                if (result.getSelection()) {
                    ((ComparisonTreeViewer)((Object)ComparisonViewer.this._viewerSynthesisMain.getInnerViewer())).setComparator(ComparisonViewer.this._sorterSynthesis);
                } else {
                    ((ComparisonTreeViewer)((Object)ComparisonViewer.this._viewerSynthesisMain.getInnerViewer())).setComparator(null);
                }
            }
        });
        return result;
    }

    protected Item createItemSync(Menu context_p) {
        MenuItem result = new MenuItem(context_p, 64);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.SYNCED));
        result.setText(Messages.ComparisonViewer_LinkViews);
        Menu innerMenu = new Menu(result);
        this.createItemSyncInternal(innerMenu);
        this.createItemSyncExternal(innerMenu);
        result.setMenu(innerMenu);
        return result;
    }

    protected Item createItemSyncExternal(Menu context_p) {
        final MenuItem result = new MenuItem(context_p, 32);
        result.setText(Messages.ComparisonViewer_LinkViewsExternal);
        result.setToolTipText(Messages.ComparisonViewer_LinkViewsExternalToolTip);
        result.setSelection(this._isExternallySynced);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                boolean synced;
                ComparisonViewer.this._isExternallySynced = synced = result.getSelection();
            }
        });
        return result;
    }

    protected Item createItemSyncInternal(Menu context_p) {
        final MenuItem result = new MenuItem(context_p, 32);
        result.setText(Messages.ComparisonViewer_LinkViewsInternal);
        result.setToolTipText(Messages.ComparisonViewer_LinkViewsInternalTooltip);
        result.setSelection(this._isLeftRightSynced);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                boolean synced;
                ComparisonViewer.this._isLeftRightSynced = synced = result.getSelection();
                if (ComparisonViewer.this._isLeftRightSynced) {
                    BusyIndicator.showWhile((Display)ComparisonViewer.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ITreeSelection selection = (this).ComparisonViewer.this._viewerSynthesisMain.getSelection();
                            (this).ComparisonViewer.this._viewerSynthesisLeft.setSelection((ISelection)ComparisonViewer.this.getSelectionAsSide((IStructuredSelection)selection, true), true);
                            (this).ComparisonViewer.this._viewerSynthesisRight.setSelection((ISelection)ComparisonViewer.this.getSelectionAsSide((IStructuredSelection)selection, false), true);
                        }
                    });
                }
            }
        });
        return result;
    }

    protected Item createItemUseCustomIcons(Menu context_p) {
        final MenuItem result = new MenuItem(context_p, 32);
        result.setText(Messages.ComparisonViewer_IconsMenuItem);
        result.setToolTipText(Messages.ComparisonViewer_IconsMenuItemTooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null && !result.isDisposed()) {
                    result.setSelection(input.usesCustomIcons());
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setUseCustomIcons(result.getSelection());
                    ComparisonViewer.this._viewerSynthesisMain.refresh();
                    ComparisonViewer.this._viewerFeatures.refresh();
                    ComparisonViewer.this._viewerValuesLeft.refresh();
                    ComparisonViewer.this._viewerValuesRight.refresh();
                }
            }
        });
        return result;
    }

    protected Item createItemUseCustomLabels(Menu context_p) {
        final MenuItem result = new MenuItem(context_p, 32);
        result.setText(Messages.ComparisonViewer_LabelsMenuItem);
        result.setToolTipText(Messages.ComparisonViewer_LabelsMenuItemTooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null && !result.isDisposed()) {
                    result.setSelection(input.usesCustomLabels());
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setUseCustomLabels(result.getSelection());
                    ComparisonViewer.this._viewerSynthesisMain.refresh();
                    ComparisonViewer.this._viewerFeatures.refresh();
                    ComparisonViewer.this._viewerValuesLeft.refresh();
                    ComparisonViewer.this._viewerValuesRight.refresh();
                }
            }
        });
        return result;
    }

    protected Item createItemUseTechnicalRepresentation(Menu context_p) {
        final MenuItem result = new MenuItem(context_p, 32);
        result.setText(Messages.ComparisonViewer_UseTechnicalRepresentation);
        result.setToolTipText(Messages.ComparisonViewer_UseTechnicalRepresentationTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ((FeaturesViewer)ComparisonViewer.this._viewerFeatures.getInnerViewer()).setTechnical(result.getSelection());
            }
        });
        return result;
    }

    @Override
    protected INavigatable createNavigatable() {
        INavigatable result = new INavigatable(){

            public Object getInput() {
                return ComparisonViewer.this.getInput();
            }

            public boolean hasChange(int changeFlag_p) {
                return true;
            }

            public boolean openSelectedChange() {
                return false;
            }

            public boolean selectChange(int changeFlag_p) {
                boolean innerResult = false;
                switch (changeFlag_p) {
                    case 1: {
                        innerResult = ComparisonViewer.this.navigate(true);
                        break;
                    }
                    case 2: {
                        innerResult = ComparisonViewer.this.navigate(false);
                    }
                }
                return innerResult;
            }
        };
        return result;
    }

    protected SashForm createRowLower(Composite parent_p) {
        SashForm result = new SashForm(parent_p, 256);
        this._viewerFeatures = this.createViewerFeatures((Composite)result);
        this._viewerValuesLeft = this.createViewerValues((Composite)result, true);
        this._viewerValuesRight = this.createViewerValues((Composite)result, false);
        return result;
    }

    protected SashForm createRowUpper(Composite parent_p) {
        SashForm result = new SashForm(parent_p, 256);
        this._viewerSynthesisMain = this.createViewerSynthesis((Composite)result);
        this._viewerSynthesisLeft = this.createViewerSynthesisSide((Composite)result, true);
        this._viewerSynthesisRight = this.createViewerSynthesisSide((Composite)result, false);
        return result;
    }

    protected MenuManager createViewerContextMenus(HeaderViewer<?> viewer_p, boolean useLocalSelectionProvider_p) {
        IWorkbenchPartSite site;
        MenuManager result = new MenuManager();
        result.setRemoveAllWhenShown(true);
        Control control = viewer_p.getInnerViewer().getControl();
        Menu contextMenu = result.createContextMenu(control);
        control.setMenu(contextMenu);
        Object selectionProvider = useLocalSelectionProvider_p ? viewer_p.getInnerViewer() : this.getMultiViewerSelectionProvider();
        this.populateContextMenu(result, viewer_p, (ISelectionProvider)selectionProvider);
        if (this.acceptContextMenuAdditions(viewer_p) && (site = this.getSite()) != null) {
            result.add((IContributionItem)new GroupMarker("additions"));
            site.registerContextMenu(result, selectionProvider);
        }
        return result;
    }

    protected EnhancedFeaturesViewer createViewerFeatures(Composite parent_p) {
        final EnhancedFeaturesViewer result = this.doCreateViewerFeatures(parent_p);
        result.addSWTSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                IStructuredSelection selection = result.getSelection();
                if (selection.size() == 1) {
                    IMatch match;
                    IMatch iMatch = match = result.getInput() == null ? null : result.getInput().getMatch();
                    if (match instanceof EMatch) {
                        EStructuralFeature feature = (EStructuralFeature)selection.getFirstElement();
                        MatchAndFeatureImpl newInputDetails = new MatchAndFeatureImpl((EMatch)match, feature);
                        ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(newInputDetails, ComparisonViewer.this.getDrivingRole(), ComparisonViewer.this.getInput()), true, (Viewer)result.getInnerViewer());
                    }
                }
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ISelection rawSelection = event_p.getSelection();
                Object source = event_p.getSource();
                if (rawSelection instanceof ComparisonSelection && source != result.getInnerViewer()) {
                    ComparisonSelection selection = (ComparisonSelection)rawSelection;
                    if (selection.getSelectedMatches().size() <= 1) {
                        EMatch match = selection.asMatch();
                        if (match != null) {
                            EStructuralFeature firstFeature;
                            EStructuralFeature feature;
                            boolean changeInput;
                            FeaturesViewer.FeaturesInput newInput = new FeaturesViewer.FeaturesInput(ComparisonViewer.this.getInput(), (IMatch)match);
                            boolean bl = changeInput = !newInput.equals(result.getInput());
                            if (changeInput) {
                                result.setInput(newInput);
                            }
                            if ((feature = selection.asFeature()) != null) {
                                StructuredSelection newSelection = new StructuredSelection((Object)feature);
                                result.setSelection((ISelection)newSelection, true);
                            } else if (changeInput && (firstFeature = ((FeaturesViewer)result.getInnerViewer()).getFirstIn(newInput)) != null) {
                                result.setSelection((ISelection)new StructuredSelection((Object)firstFeature));
                            }
                        } else {
                            result.setInput(null);
                        }
                    } else {
                        result.setInput(null);
                    }
                }
            }
        });
        return result;
    }

    protected EnhancedComparisonTreeViewer createViewerSynthesis(Composite parent_p) {
        final EnhancedComparisonTreeViewer result = this.doCreateViewerSynthesis(parent_p);
        ((ComparisonTreeViewer)((Object)result.getInnerViewer())).addFilter(this._filterUnchangedElements);
        ((ComparisonTreeViewer)((Object)result.getInnerViewer())).addFilter(this._filterMoveOrigins);
        ((ComparisonTreeViewer)((Object)result.getInnerViewer())).setComparer(new SymmetricMatchComparer());
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Boolean filtered;
                if (ComparisonViewer.PROPERTY_FILTERING.equals(event_p.getProperty()) && (filtered = (Boolean)event_p.getNewValue()) != null) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(result.getDefaultHeaderText());
                    if (filtered.booleanValue()) {
                        builder.append(Messages.ComparisonViewer_Filtered);
                    }
                    result.getTextLabel().setText(builder.toString());
                }
            }
        });
        result.addSWTSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ITreeSelection selection = result.getSelection();
                if (!selection.isEmpty()) {
                    ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(selection.toList(), ComparisonViewer.this.getDrivingRole(), ComparisonViewer.this.getInput()), true, (Viewer)result.getInnerViewer());
                }
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ISelection rawSelection = event_p.getSelection();
                Object source = event_p.getSource();
                if (rawSelection instanceof ComparisonSelection && source != result.getInnerViewer()) {
                    ComparisonSelection selection = (ComparisonSelection)rawSelection;
                    StructuredSelection newSelection = StructuredSelection.EMPTY;
                    int matchesSize = selection.getSelectedMatches().size();
                    if (matchesSize > 1) {
                        newSelection = new StructuredSelection(selection.getSelectedMatches());
                    } else {
                        TreePath path = selection.asMatchPath();
                        if (path != null) {
                            newSelection = new TreeSelection(path);
                        } else {
                            EMatch match = selection.asMatch();
                            if (match != null) {
                                newSelection = new StructuredSelection((Object)match);
                            }
                        }
                    }
                    result.setSelection((ISelection)newSelection, true);
                }
            }
        });
        this.createViewerContextMenus(result, false);
        return result;
    }

    protected EnhancedComparisonSideViewer createViewerSynthesisSide(Composite parent_p, final boolean isLeftSide_p) {
        final EnhancedComparisonSideViewer result = this.doCreateViewerSynthesisSide(parent_p, isLeftSide_p);
        result.addSWTSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                if (ComparisonViewer.this._isLeftRightSynced) {
                    ITreeSelection selection = result.getSelection();
                    Role sideRole = ComparisonViewer.this.getInput().getRoleForSide(isLeftSide_p);
                    IStructuredSelection synthesisSelection = ComparisonViewer.this.getSelectionAsSynthesis((IStructuredSelection)selection, isLeftSide_p);
                    if (!synthesisSelection.isEmpty()) {
                        ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(synthesisSelection.toList(), sideRole, ComparisonViewer.this.getInput()), true, (Viewer)result.getInnerViewer());
                    }
                }
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ISelection rawSelection = event_p.getSelection();
                Object source = event_p.getSource();
                if (rawSelection instanceof ComparisonSelection && source != result.getInnerViewer() && (source != ComparisonViewer.this._viewerSynthesisMain.getInnerViewer() || ComparisonViewer.this._isLeftRightSynced)) {
                    ComparisonSelection selection = (ComparisonSelection)rawSelection;
                    StructuredSelection newSelection = StructuredSelection.EMPTY;
                    int matchesSize = selection.getSelectedMatches().size();
                    if (matchesSize > 1) {
                        newSelection = new StructuredSelection(selection.getSelectedMatches());
                    } else {
                        TreePath path = selection.asMatchPath();
                        if (path != null) {
                            newSelection = new TreeSelection(path);
                        } else {
                            EMatch match = selection.asMatch();
                            if (match != null) {
                                newSelection = new StructuredSelection((Object)match);
                            }
                        }
                    }
                    result.setSelection((ISelection)ComparisonViewer.this.getSelectionAsSide((IStructuredSelection)newSelection, isLeftSide_p), true);
                }
            }
        });
        ((ComparisonSideViewer)result.getInnerViewer()).getControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e_p) {
                ComparisonViewer.this._multiViewerSelectionProvider.setSource((ISelectionProvider)result.getInnerViewer());
            }

            public void focusLost(FocusEvent e_p) {
                ComparisonViewer.this._multiViewerSelectionProvider.setSource((ISelectionProvider)ComparisonViewer.this);
            }
        });
        this.createViewerContextMenus(result, true);
        return result;
    }

    protected EnhancedValuesViewer createViewerValues(Composite parent_p, final boolean isLeftSide_p) {
        final EnhancedValuesViewer result = this.doCreateViewerValues(parent_p, isLeftSide_p);
        result.addSWTSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                IStructuredSelection selection = result.getSelection();
                if (!selection.isEmpty() && selection.getFirstElement() instanceof EObject) {
                    IReferenceValuePresence rvp;
                    boolean containment;
                    EObject selectedElement;
                    Object match;
                    ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(selection.toList(), ComparisonViewer.this.getInput().getRoleForSide(isLeftSide_p), ComparisonViewer.this.getInput()), true, (Viewer)result.getInnerViewer());
                    if (selection.size() == 1 && (match = (selectedElement = (EObject)selection.getFirstElement()) instanceof IMatch ? (IMatch)selectedElement : (selectedElement instanceof IReferenceValuePresence ? ((containment = (rvp = (IReferenceValuePresence)selectedElement).isContainment()) ? rvp.getElementMatch() : rvp.getValueMatch()) : null)) != null) {
                        ComparisonViewer.this.getModelScopeViewer(isLeftSide_p).setSelection((ISelection)new StructuredSelection((Object)match.get(ComparisonViewer.this.getInput().getRoleForSide(isLeftSide_p))));
                    }
                }
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ISelection rawSelection = event_p.getSelection();
                Object source = event_p.getSource();
                if (rawSelection instanceof ComparisonSelection && source != result.getInnerViewer()) {
                    ComparisonSelection selection = (ComparisonSelection)rawSelection;
                    EStructuralFeature feature = selection.asFeature();
                    if (feature != null) {
                        MatchAndFeatureImpl mnf = new MatchAndFeatureImpl(selection.asMatch(), feature);
                        ValuesViewer.ValuesInput newInput = new ValuesViewer.ValuesInput(ComparisonViewer.this.getInput(), mnf);
                        if (!newInput.equals(result.getInput())) {
                            result.setInput(newInput);
                        }
                        EList<EValuePresence> values = selection.getSelectedValuePresences();
                        result.setSelection((ISelection)new StructuredSelection(values), true);
                    } else {
                        EMatch newMatch;
                        ValuesViewer.ValuesInput newInput = null;
                        if (selection.getSelectedMatches().size() <= 1 && ComparisonViewer.this.getInput() != null && (newMatch = selection.asMatch()) != null) {
                            EMatch currentMatch = null;
                            ValuesViewer.ValuesInput currentInput = result.getInput();
                            if (currentInput != null && currentInput.getMatchAndFeature() != null) {
                                currentMatch = currentInput.getMatchAndFeature().getMatch();
                            }
                            if (newMatch != currentMatch) {
                                HeaderViewer<?> rawFeaturesViewer = ComparisonViewer.this.getFeaturesViewer();
                                if (rawFeaturesViewer instanceof EnhancedFeaturesViewer) {
                                    EnhancedFeaturesViewer featuresViewer = (EnhancedFeaturesViewer)rawFeaturesViewer;
                                    FeaturesViewer.FeaturesInput featuresInput = new FeaturesViewer.FeaturesInput(ComparisonViewer.this.getInput(), (IMatch)newMatch);
                                    EStructuralFeature firstFeature = ((FeaturesViewer)featuresViewer.getInnerViewer()).getFirstIn(featuresInput);
                                    if (firstFeature != null) {
                                        newInput = new ValuesViewer.ValuesInput(ComparisonViewer.this.getInput(), new MatchAndFeatureImpl(newMatch, firstFeature));
                                    }
                                }
                            } else {
                                newInput = currentInput;
                            }
                        }
                        result.setInput(newInput);
                    }
                }
            }
        });
        return result;
    }

    protected EnhancedFeaturesViewer doCreateViewerFeatures(Composite parent_p) {
        return new EnhancedFeaturesViewer(parent_p);
    }

    protected EnhancedComparisonTreeViewer doCreateViewerSynthesis(Composite parent_p) {
        return new EnhancedComparisonTreeViewer(parent_p);
    }

    protected EnhancedComparisonSideViewer doCreateViewerSynthesisSide(Composite parent_p, boolean isLeftSide_p) {
        return new EnhancedComparisonSideViewer(parent_p, isLeftSide_p);
    }

    protected EnhancedValuesViewer doCreateViewerValues(Composite parent_p, boolean isLeftSide_p) {
        return new EnhancedValuesViewer(parent_p, isLeftSide_p);
    }

    protected int[] getDefaultColumnWeights() {
        return new int[]{3, 2, 2};
    }

    protected int[] getDefaultRowWeights() {
        return new int[]{5, 2};
    }

    protected List<IDifference> getDifferencesToMerge(final List<EMatch> selectedMatches_p, final Role destination_p, final boolean coverChildren_p, final boolean incrementalMode_p) {
        final ArrayList result = new ArrayList();
        IProgressService progress = PlatformUI.getWorkbench().getProgressService();
        try {
            progress.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                    for (EMatch selectedMatch : selectedMatches_p) {
                        if (coverChildren_p) {
                            ComparisonViewer.this.addDifferencesToMergeRec(result, (IMatch)selectedMatch, destination_p, incrementalMode_p);
                            continue;
                        }
                        ComparisonViewer.this.addDifferencesToMerge(result, (IMatch)selectedMatch, destination_p, incrementalMode_p);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.unmodifiableList(result);
    }

    public Role getDrivingRole() {
        return this.getInput() == null ? null : this.getInput().getDrivingRole();
    }

    public HeaderViewer<?> getFeaturesViewer() {
        return this._viewerFeatures;
    }

    protected Collection<Viewer> getInnerViewers() {
        return Arrays.asList(this._viewerSynthesisMain.getInnerViewer(), this._viewerSynthesisLeft.getInnerViewer(), this._viewerSynthesisRight.getInnerViewer(), this._viewerFeatures.getInnerViewer(), this._viewerValuesLeft.getInnerViewer(), this._viewerValuesRight.getInnerViewer());
    }

    protected Logger getLogger() {
        return EMFDiffMergeUIPlugin.getDefault().getDiffMergeLogger();
    }

    public EnhancedComparisonSideViewer getModelScopeViewer(boolean left_p) {
        EnhancedComparisonSideViewer result = left_p ? this._viewerSynthesisLeft : this._viewerSynthesisRight;
        return result;
    }

    @Override
    protected ISelectionProvider getMultiViewerSelectionProvider() {
        return this._multiViewerSelectionProvider;
    }

    protected List<EMatch> getSelectedMatchesForInteractions(ComparisonSelection selection_p) {
        EList<EMatch> treePath;
        Object selectedMatches = selection_p.getSelectedMatches();
        if (selectedMatches.isEmpty() && !(treePath = selection_p.getSelectedTreePath()).isEmpty()) {
            selectedMatches = Collections.singletonList((EMatch)treePath.get(treePath.size() - 1));
        }
        return selectedMatches;
    }

    public ComparisonSelection getSelection() {
        return this._lastUserSelection;
    }

    protected IStructuredSelection getSelectionAsSide(IStructuredSelection selection_p, boolean onLeft_p) {
        FArrayList result = new FArrayList();
        if (this.getInput() != null) {
            Role role = this.getInput().getRoleForSide(onLeft_p);
            Object[] objectArray = selection_p.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                EObject element;
                Object selected = objectArray[n2];
                if (selected instanceof IMatch && (element = ((IMatch)selected).get(role)) != null) {
                    result.add(element);
                }
                ++n2;
            }
        }
        return new StructuredSelection((List)result);
    }

    protected IStructuredSelection getSelectionAsSynthesis(IStructuredSelection selection_p, boolean onLeft_p) {
        EComparison comparison;
        FArrayList result = new FArrayList();
        EMFDiffNode input = this.getInput();
        if (input != null && (comparison = input.getActualComparison()) != null) {
            Role role = input.getRoleForSide(onLeft_p);
            Object[] objectArray = selection_p.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMatch match;
                Object selected = objectArray[n2];
                if (selected instanceof EObject && (match = comparison.getMapping().getMatchFor((EObject)selected, role)) != null) {
                    result.add(match);
                }
                ++n2;
            }
        }
        return new StructuredSelection((List)result);
    }

    public EnhancedComparisonTreeViewer getSynthesisViewer() {
        return this._viewerSynthesisMain;
    }

    public EnhancedValuesViewer getValuesViewer(boolean left_p) {
        EnhancedValuesViewer result = left_p ? this._viewerValuesLeft : this._viewerValuesRight;
        return result;
    }

    @Override
    protected void handleDispose() {
        super.handleDispose();
        this._lastUserSelection = null;
        this._viewerSynthesisLeft = null;
        this._viewerSynthesisRight = null;
        this._viewerValuesLeft = null;
        this._viewerValuesRight = null;
        this._viewerSynthesisMain = null;
        this._viewerFeatures = null;
        this._sorterSynthesis = null;
        this._filterUnchangedElements = null;
        this._filterMoveOrigins = null;
    }

    protected void ignore(boolean onLeft_p) {
        List<IDifference> toIgnore;
        final ComparisonSelection selection = this.getSelection();
        if (selection == null) {
            return;
        }
        EMFDiffNode input = this.getInput();
        List<EMatch> selectedMatches = this.getSelectedMatchesForInteractions(selection);
        IgnoreChoiceData choices = new IgnoreChoiceData(input.isDefaultCoverChildren(), false);
        this.makeIgnoreChoices(choices, input, selectedMatches);
        if (!choices.isProceed()) {
            return;
        }
        List<IDifference> list = toIgnore = !selectedMatches.isEmpty() ? this.getDifferencesToMerge(selectedMatches, input.getRoleForSide(onLeft_p), choices.isCoverChildren(), choices.isSideExclusive()) : this.getInput().getCategoryManager().getPendingDifferencesFiltered((Iterable<? extends IDifference>)selection.asDifferencesToMerge());
        if (!toIgnore.isEmpty()) {
            this.executeOnModel(new Runnable(){

                @Override
                public void run() {
                    for (IDifference diff : toIgnore) {
                        IReferenceValuePresence symmetricalOwnership;
                        if (!(diff instanceof EElementRelativePresence)) continue;
                        EElementRelativePresence presence = (EElementRelativePresence)diff;
                        ComparisonViewer.this.getUIComparison().getDifferencesToIgnore().add((Object)presence);
                        if (!(diff instanceof EValuePresence)) continue;
                        IValuePresence symmetrical = ((EValuePresence)diff).getSymmetrical();
                        if (symmetrical instanceof EMergeableDifference) {
                            ComparisonViewer.this.getUIComparison().getDifferencesToIgnore().add((Object)((EMergeableDifference)symmetrical));
                        }
                        if (!(diff instanceof IReferenceValuePresence) || !((symmetricalOwnership = ((IReferenceValuePresence)diff).getSymmetricalOwnership()) instanceof EMergeableDifference)) continue;
                        ComparisonViewer.this.getUIComparison().getDifferencesToIgnore().add((Object)((EMergeableDifference)symmetricalOwnership));
                    }
                    ComparisonViewer.this.getUIComparison().setLastActionSelection(selection);
                }
            }, onLeft_p);
            this.firePropertyChangeEvent("DIRTY_STATE", new Boolean(true));
            input.updateDifferenceNumbers();
        }
    }

    protected void initialize() {
        this._isLeftRightSynced = true;
        this._lastUserSelection = null;
        this._multiViewerSelectionProvider = new SelectionBridge.SingleSource();
        this._multiViewerSelectionProvider.setSource((ISelectionProvider)this);
        this._sorterSynthesis = new ViewerComparator();
        this._filterUnchangedElements = new ViewerFilter(){

            public boolean select(Viewer viewer_p, Object parentElement_p, Object element_p) {
                EMatch match = (EMatch)element_p;
                return ComparisonViewer.this.getInput().getCategoryManager().getDifferenceNumber((IMatch)match) > 0;
            }
        };
        this._filterMoveOrigins = new ViewerFilter(){

            public boolean select(Viewer viewer_p, Object parentElement_p, Object element_p) {
                TreePath path = parentElement_p instanceof TreePath ? ((TreePath)parentElement_p).createChildPath(element_p) : new TreePath(new Object[]{element_p});
                return !ComparisonViewer.this.getInput().getCategoryManager().isMoveOrigin(path);
            }
        };
    }

    protected boolean interactionsRequiredForIgnore(IgnoreChoiceData choices_p, EMFDiffNode input_p, List<EMatch> selectedMatches) {
        boolean childrenForMerge = false;
        boolean ownDifferences = false;
        for (EMatch selectedMatch : selectedMatches) {
            boolean bl = ownDifferences = ownDifferences || !input_p.getCategoryManager().getDifferenceKind((IMatch)selectedMatch).isNeutral();
            if (childrenForMerge && ownDifferences) break;
            boolean bl2 = childrenForMerge = childrenForMerge || input_p.getCategoryManager().hasChildrenForMergeFiltered((IMatch)selectedMatch);
            if (childrenForMerge && ownDifferences) break;
        }
        if (!ownDifferences && childrenForMerge) {
            choices_p.setCoverChildren(true);
        }
        return ownDifferences && childrenForMerge;
    }

    protected boolean interactionsRequiredForMerge(MergeChoiceData choices_p, EMFDiffNode input_p, List<EMatch> selectedMatches) {
        boolean result;
        boolean bl = result = !selectedMatches.isEmpty();
        if (result && selectedMatches.size() == 1) {
            EMatch selectedMatch = selectedMatches.get(0);
            if (!input_p.getCategoryManager().hasChildrenForMergeFiltered((IMatch)selectedMatch)) {
                DifferenceKind kind = input_p.getCategoryManager().getDifferenceKind((IMatch)selectedMatch);
                result = !kind.isAddition() && !kind.isDeletion();
            }
        }
        return result;
    }

    @Override
    protected void inputChanged(Object input_p, Object oldInput_p) {
        super.inputChanged(input_p, oldInput_p);
        this._viewerFeatures.setInput(null);
        this._viewerValuesLeft.setInput(null);
        this._viewerValuesRight.setInput(null);
        this._viewerSynthesisMain.setInput(input_p);
        this._viewerSynthesisLeft.setInput(input_p);
        this._viewerSynthesisRight.setInput(input_p);
        EMFDiffNode input = this.getInput();
        if (input != null && input.isLogEvents()) {
            this.getLogger().log((Object)new CompareLogEvent(this.getEditingDomain(), input));
        }
    }

    protected void makeIgnoreChoices(IgnoreChoiceData choices_p, EMFDiffNode input_p, List<EMatch> selectedMatches_p) {
        boolean requiresInteractions = this.interactionsRequiredForIgnore(choices_p, input_p, selectedMatches_p);
        if (requiresInteractions) {
            IgnoreChoicesDialog choicesDialog = new IgnoreChoicesDialog(this.getShell(), Messages.ComparisonViewer_IgnoreCommandName, choices_p);
            choicesDialog.open();
            if (choices_p.isProceed()) {
                this.getInput().setDefaultCoverChildren(choices_p.isCoverChildren());
            }
        }
    }

    protected void makeMergeChoices(MergeChoiceData choices_p, EMFDiffNode input_p, List<EMatch> selectedMatches_p, boolean acceptIncrementalMode_p) {
        boolean requiresInteractions = this.interactionsRequiredForMerge(choices_p, input_p, selectedMatches_p);
        if (requiresInteractions) {
            boolean mayAskAboutChildren = false;
            for (EMatch selectedMatch : selectedMatches_p) {
                if (input_p.getCategoryManager().getDifferenceKind((IMatch)selectedMatch) == DifferenceKind.COUNTED) {
                    choices_p.setCoverChildren(true);
                    break;
                }
                if (!input_p.getCategoryManager().hasChildrenForMergeFiltered((IMatch)selectedMatch)) continue;
                mayAskAboutChildren = true;
                break;
            }
            MergeChoicesDialog choicesDialog = new MergeChoicesDialog(this.getShell(), Messages.ComparisonViewer_MergeHeader, choices_p, mayAskAboutChildren, acceptIncrementalMode_p);
            choicesDialog.open();
            if (choices_p.isProceed()) {
                if (mayAskAboutChildren) {
                    input_p.setDefaultCoverChildren(choices_p.isCoverChildren());
                }
                input_p.setDefaultIncrementalMode(choices_p.isIncrementalMode());
                input_p.setDefaultShowImpact(choices_p.isShowImpact());
            }
        }
    }

    protected void merge(boolean toLeft_p, boolean acceptIncrementalMode_p) {
        this.merge(toLeft_p, acceptIncrementalMode_p, this.getSelection());
    }

    protected void merge(boolean toLeft_p, boolean acceptIncrementalMode_p, final ComparisonSelection selection_p) {
        if (selection_p == null) {
            return;
        }
        EMFDiffNode input = this.getInput();
        List<EMatch> selectedMatches = this.getSelectedMatchesForInteractions(selection_p);
        MergeChoiceData choices = new MergeChoiceData(input.isDefaultCoverChildren(), input.isDefaultIncrementalMode() && acceptIncrementalMode_p, input.isDefaultShowImpact());
        this.makeMergeChoices(choices, input, selectedMatches, acceptIncrementalMode_p);
        if (!choices.isProceed()) {
            return;
        }
        final Role destination = input.getRoleForSide(toLeft_p);
        final List<IDifference> toMerge = !selectedMatches.isEmpty() ? this.getDifferencesToMerge(selectedMatches, destination, choices.isCoverChildren(), choices.isIncrementalMode()) : input.getCategoryManager().getPendingDifferencesFiltered((Iterable<? extends IDifference>)selection_p.asDifferencesToMerge());
        final ArrayList merged = new ArrayList();
        boolean done = false;
        if (!toMerge.isEmpty()) {
            boolean proceed = true;
            if (choices.isShowImpact()) {
                proceed = this.showMergeImpact(toMerge, toLeft_p, input);
            }
            if (proceed) {
                this.executeOnModel(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                        merged.addAll(ComparisonViewer.this.getComparison().merge(toMerge, destination, true, monitor_p));
                        ComparisonViewer.this.getUIComparison().setLastActionSelection(selection_p);
                    }
                }, toLeft_p);
                done = true;
            }
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ComparisonViewer_MergeHeader, (String)Messages.ComparisonViewer_NoDiffsToMerge);
        }
        if (!merged.isEmpty() && done) {
            input.setModified(true, toLeft_p);
            this.firePropertyChangeEvent("DIRTY_STATE", new Boolean(true));
            input.updateDifferenceNumbers();
            if (input.isLogEvents()) {
                this.getLogger().log((Object)new MergeLogEvent(input, merged, toLeft_p));
            }
        }
    }

    protected boolean navigate(boolean next_p) {
        TreePath newPath;
        ComparisonTreeViewer treeViewer = (ComparisonTreeViewer)((Object)this._viewerSynthesisMain.getInnerViewer());
        ITreeSelection selection = treeViewer.getSelection();
        TreePath current = selection == null || selection.isEmpty() ? TreePath.EMPTY : selection.getPaths()[0];
        TreePath treePath = newPath = next_p ? treeViewer.getNextUserDifference(current) : treeViewer.getPreviousUserDifference(current);
        if (newPath != null) {
            this.setSelection((ISelection)new ComparisonSelectionImpl(newPath, this.getDrivingRole(), this.getInput()), true);
        }
        return newPath == null;
    }

    protected void populateContextMenu(MenuManager menuManager_p, Viewer viewer_p, ISelectionProvider selectionProvider_p) {
    }

    @Override
    public void refresh() {
        this._viewerSynthesisLeft.refresh();
        this._viewerSynthesisRight.refresh();
        this._viewerValuesLeft.refresh();
        this._viewerValuesRight.refresh();
        this._viewerFeatures.refresh();
        this._viewerSynthesisMain.refresh();
        super.refresh();
    }

    @Override
    protected void refreshTools() {
        ComparisonSelection selection = this.getSelection();
        EMFDiffNode input = this.getInput();
        boolean onLeft = false;
        boolean onRight = false;
        boolean allowDeletion = false;
        boolean allowIgnoring = false;
        if (selection != null && input != null) {
            EList<EMatch> matches;
            allowIgnoring = true;
            EValuePresence presence = selection.asValuePresence();
            if (presence != null && !presence.isMerged()) {
                DifferenceKind kind = input.getCategoryManager().getDifferenceKind((IDifference)presence);
                onLeft = this.canAddToTheRight(kind);
                onRight = this.canAddToTheLeft(kind);
                allowDeletion = input.getCategoryManager().isMany((IDifference)presence) && !input.getCategoryManager().isOwnership((IDifference)presence);
            } else if (selection.asFeature() == null && !(matches = selection.asMatches()).isEmpty()) {
                if (matches.size() > 1) {
                    allowDeletion = true;
                    Iterator it = matches.iterator();
                    while (it.hasNext() && (!onLeft || !onRight || allowDeletion)) {
                        EMatch current = (EMatch)it.next();
                        DifferenceKind kind = input.getCategoryManager().getDifferenceKind((IMatch)current);
                        if (kind.isAddition()) {
                            onLeft = onLeft || kind.isLeft(true);
                            onRight = onRight || kind.isRight(true);
                            continue;
                        }
                        onLeft = true;
                        onRight = true;
                        allowDeletion = false;
                    }
                    allowDeletion = allowDeletion && onLeft != onRight;
                } else {
                    IMatch match = (IMatch)matches.get(0);
                    if (input.getCategoryManager().representAsModification(match) || input.getCategoryManager().representAsMove(match) || input.getCategoryManager().getDifferenceKind(match) == DifferenceKind.COUNTED) {
                        onLeft = true;
                        onRight = true;
                        allowDeletion = false;
                    } else {
                        DifferenceKind kind = input.getCategoryManager().getDifferenceKind(match);
                        onLeft = this.canAddToTheRight(kind);
                        onRight = this.canAddToTheLeft(kind);
                        allowDeletion = true;
                    }
                }
            }
        }
        if (input != null) {
            this.firePropertyChangeEvent(PROPERTY_ACTIVATION_MERGE_TO_RIGHT, new Boolean(input.isEditable(false) && onLeft));
            this.firePropertyChangeEvent(PROPERTY_ACTIVATION_DELETE_LEFT, new Boolean(input.isEditable(true) && onLeft && allowDeletion));
            this.firePropertyChangeEvent(PROPERTY_ACTIVATION_MERGE_TO_LEFT, new Boolean(input.isEditable(true) && onRight));
            this.firePropertyChangeEvent(PROPERTY_ACTIVATION_DELETE_RIGHT, new Boolean(input.isEditable(false) && onRight && allowDeletion));
        }
        this.firePropertyChangeEvent(PROPERTY_ACTIVATION_IGNORE_LEFT, new Boolean(onLeft && allowIgnoring));
        this.firePropertyChangeEvent(PROPERTY_ACTIVATION_IGNORE_RIGHT, new Boolean(onRight && allowIgnoring));
        super.refreshTools();
    }

    protected void restart() {
        IEditorInput rawEditorInput;
        final EMFDiffNode input = this.getInput();
        IEditorInput iEditorInput = rawEditorInput = input == null ? null : input.getEditorInput();
        if (input != null && rawEditorInput instanceof EMFDiffMergeEditorInput) {
            final EMFDiffMergeEditorInput editorInput = (EMFDiffMergeEditorInput)rawEditorInput;
            IComparisonMethod origMethod = editorInput.getComparisonMethod();
            final IModelScopeDefinition origTrgScopeDef = origMethod.getModelScopeDefinition(Role.TARGET);
            ComparisonSetupManager manager = EMFDiffMergeUIPlugin.getDefault().getSetupManager();
            boolean confirmed = manager.updateEditorInputWithUI(this.getShell(), editorInput);
            if (confirmed) {
                final IComparisonMethod method = editorInput.getComparisonMethod();
                method.setVerbose(false);
                Job job = new Job(Messages.ComparisonViewer_RestartInProgress){

                    protected IStatus run(final IProgressMonitor monitor_p) {
                        MiscUtil.executeAndForget(ComparisonViewer.this.getEditingDomain(), new Runnable(){

                            @Override
                            public void run() {
                                boolean sidesSwapped = method.getModelScopeDefinition(Role.TARGET) != origTrgScopeDef;
                                input.getUIComparison().clear();
                                if (sidesSwapped) {
                                    input.setLeftRole(input.getRoleForSide(false));
                                    input.getActualComparison().swapScopes();
                                }
                                input.setReferenceRole(method.getTwoWayReferenceRole());
                                input.setDrivingRole(method.getTwoWayReferenceRole());
                                boolean leftEditable = method.getModelScopeDefinition(input.getRoleForSide(true)).isEditable();
                                boolean rightEditable = method.getModelScopeDefinition(input.getRoleForSide(false)).isEditable();
                                input.setEditionPossible(leftEditable, true);
                                input.setEditionPossible(rightEditable, false);
                                input.getActualComparison().compute(method.getMatchPolicy(), method.getDiffPolicy(), method.getMergePolicy(), monitor_p);
                                input.getCategoryManager().update();
                            }
                        });
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ComparisonViewer.this.firePropertyChangeEvent("PROPERTY_CURRENT_INPUT", null);
                                ComparisonViewer.this.refresh();
                            }
                        });
                        editorInput.checkInconsistency((IComparison)input.getActualComparison());
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        }
    }

    public void setDelegateLabelProvider(ILabelProvider labelProvider_p) {
        for (Viewer viewer : this.getInnerViewers()) {
            IBaseLabelProvider rawLP;
            if (!(viewer instanceof ContentViewer) || !((rawLP = ((ContentViewer)viewer).getLabelProvider()) instanceof DelegatingLabelProvider)) continue;
            DelegatingLabelProvider delegatingLP = (DelegatingLabelProvider)rawLP;
            delegatingLP.setDelegate(labelProvider_p);
        }
    }

    public void setSelection(ISelection selection_p, boolean reveal_p) {
        this.setSelection(selection_p, reveal_p, this);
    }

    protected void setSelection(ISelection selection_p, boolean reveal_p, Viewer source_p) {
        ComparisonSelection newSelection = selection_p instanceof ComparisonSelection && (source_p == this || this.getInnerViewers().contains(source_p)) ? (ComparisonSelection)selection_p : (selection_p instanceof IStructuredSelection ? this.asComparisonSelection((IStructuredSelection)selection_p) : new ComparisonSelectionImpl(null, null, this.getInput()));
        this._lastUserSelection = newSelection;
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)source_p, (ISelection)this.getSelection()));
    }

    protected void setupColumns(final SashForm upperRow_p, final SashForm lowerRow_p) {
        int[] horizontalWeights = this.getDefaultColumnWeights();
        upperRow_p.setWeights(horizontalWeights);
        lowerRow_p.setWeights(horizontalWeights);
        Control upperMiddleControl = upperRow_p.getChildren()[1];
        upperMiddleControl.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e_p) {
                int[] weights = upperRow_p.getWeights();
                lowerRow_p.setWeights(weights);
            }

            public void controlMoved(ControlEvent e_p) {
            }
        });
        Control lowerMiddleControl = lowerRow_p.getChildren()[1];
        lowerMiddleControl.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e_p) {
                int[] weights = lowerRow_p.getWeights();
                upperRow_p.setWeights(weights);
            }

            public void controlMoved(ControlEvent e_p) {
            }
        });
    }

    protected Menu setupMenuDetails(ToolBar toolbar_p) {
        new ToolItem(toolbar_p, 2);
        Menu result = UIUtil.createMenuTool(this._viewerFeatures.getToolbar());
        this.createItemShowDiffValues(result);
        this.createItemShowAllValues(result);
        this.createItemShowAllFeatures(result);
        new MenuItem(result, 2);
        this.createItemUseTechnicalRepresentation(result);
        return result;
    }

    protected Menu setupMenuSynthesis(ToolBar toolbar_p) {
        Menu synthesisMenu = UIUtil.createMenuTool(toolbar_p);
        this.createItemRestart(synthesisMenu);
        new MenuItem(synthesisMenu, 2);
        this.createItemShowUncounted(synthesisMenu);
        this.createItemFilter((Widget)synthesisMenu);
        new MenuItem(synthesisMenu, 2);
        this.createItemSync(synthesisMenu);
        this.createItemSort(synthesisMenu);
        new MenuItem(synthesisMenu, 2);
        this.setupMenuSynthesisMisc(synthesisMenu);
        return synthesisMenu;
    }

    protected void setupMenuSynthesisMisc(Menu synthesisMenu_p) {
        this.createItemUseCustomIcons(synthesisMenu_p);
        this.createItemUseCustomLabels(synthesisMenu_p);
        new MenuItem(synthesisMenu_p, 2);
        this.createItemShowSides(synthesisMenu_p);
        this.createItemShowDifferenceNumbers(synthesisMenu_p);
        this.createItemShowImpact(synthesisMenu_p);
        new MenuItem(synthesisMenu_p, 2);
        this.createItemSupportUndoRedo(synthesisMenu_p);
        this.createItemLogEvents(synthesisMenu_p);
    }

    protected void setupToolBars() {
        this.setupToolsSynthesis(this._viewerSynthesisMain.getToolbar());
        this.setupToolsSynthesisSide(this._viewerSynthesisLeft.getToolbar(), true);
        this.setupToolsSynthesisSide(this._viewerSynthesisRight.getToolbar(), false);
        this.setupToolsDetails(this._viewerFeatures.getToolbar());
        this.setupToolsDetailsSide(this._viewerValuesLeft.getToolbar(), true);
        this.setupToolsDetailsSide(this._viewerValuesRight.getToolbar(), false);
        this.setupMenuSynthesis(this._viewerSynthesisMain.getToolbar());
        this.setupMenuDetails(this._viewerFeatures.getToolbar());
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ComparisonViewer.this.refreshTools();
            }
        });
        this.refreshTools();
    }

    protected void setupToolsDetails(ToolBar toolbar_p) {
    }

    protected void setupToolsDetailsSide(ToolBar toolbar_p, boolean onLeft_p) {
        this.createItemMerge(toolbar_p, !onLeft_p);
        this.createItemIgnore(toolbar_p, onLeft_p);
        this.createItemDelete(toolbar_p, onLeft_p);
    }

    protected void setupToolsSynthesis(ToolBar toolbar_p) {
        new ToolItem(toolbar_p, 2);
        this.createItemInconsistency(toolbar_p);
        new ToolItem(toolbar_p, 2);
        this.createItemNavigationNext(toolbar_p);
        this.createItemNavigationPrevious(toolbar_p);
        new ToolItem(toolbar_p, 2);
        this.createItemExpand(toolbar_p);
        this.createItemCollapse(toolbar_p);
        new ToolItem(toolbar_p, 2);
        this.createItemFilter((Widget)toolbar_p);
    }

    protected void setupToolsSynthesisSide(ToolBar toolbar_p, boolean onLeft_p) {
        this.createItemLock(toolbar_p, onLeft_p);
    }

    protected boolean showMergeImpact(Collection<IDifference> toMerge_p, boolean toLeft_p, EMFDiffNode input_p) {
        boolean result = true;
        final MergeImpactViewer.ImpactInput mergeInput = new MergeImpactViewer.ImpactInput(toMerge_p, toLeft_p, input_p);
        IProgressService progress = PlatformUI.getWorkbench().getProgressService();
        try {
            progress.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                    mergeInput.compute(monitor_p);
                }
            });
            MergeImpactMessageDialog dialog = new MergeImpactMessageDialog(this.getShell(), mergeInput, this.getResourceManager(), ((ComparisonTreeViewer)((Object)this._viewerSynthesisMain.getInnerViewer())).getLabelProvider());
            result = dialog.openAndConfirm();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected void showSides(boolean show_p) {
        Control leftControl = this._viewerSynthesisLeft.getControl();
        if (leftControl != null && !leftControl.isDisposed() && show_p != leftControl.isVisible()) {
            leftControl.setVisible(show_p);
            this._viewerSynthesisRight.getControl().setVisible(show_p);
            leftControl.getParent().layout();
        }
    }

    @Override
    protected void undoRedoPerformed(boolean undo_p) {
        super.undoRedoPerformed(undo_p);
        if (this.getInput() != null) {
            this.getInput().updateDifferenceNumbers();
        }
    }

    protected class FilterSelectionListener
    extends SelectionAdapter {
        protected final Set<Item> _filterItems = new HashSet<Item>();
        protected CategoryDialog _lastDialog = null;

        public void addItem(Item item_p) {
            this._filterItems.add(item_p);
            UIUtil.itemAddSelectionListener(item_p, (SelectionListener)this);
            UIUtil.itemAddDisposeListener(item_p, new DisposeListener(){

                public void widgetDisposed(DisposeEvent e_p) {
                    if (FilterSelectionListener.this._lastDialog != null && !FilterSelectionListener.this._lastDialog.getShell().isDisposed()) {
                        FilterSelectionListener.this._lastDialog.close();
                    }
                }
            });
        }

        protected void setSelectionForAll(boolean selected_p) {
            for (Item item : this._filterItems) {
                if (item.isDisposed() || UIUtil.itemGetSelection(item) == selected_p) continue;
                UIUtil.itemSetSelection(item, selected_p);
            }
        }

        public void widgetSelected(SelectionEvent event_p) {
            Item item = (Item)event_p.getSource();
            boolean selected = UIUtil.itemGetSelection(item);
            if (selected) {
                this._lastDialog = new CategoryDialog(ComparisonViewer.this.getShell(), ComparisonViewer.this.getInput());
                this._lastDialog.open();
                this._lastDialog.getShell().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e_p) {
                        FilterSelectionListener.this._lastDialog = null;
                        FilterSelectionListener.this.setSelectionForAll(false);
                    }
                });
            } else if (this._lastDialog != null) {
                this._lastDialog.close();
            }
            this.setSelectionForAll(selected);
        }
    }
}

