/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethodFactory;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.specification.ext.AbstractComparisonMethod;

public class DefaultComparisonMethod
extends AbstractComparisonMethod {
    private final Map<Role, IModelScopeDefinition> _roleToScopeDefinition;
    private Role _twoWayReferenceRole;
    protected IMatchPolicy _matchPolicy;
    protected IDiffPolicy _diffPolicy;
    protected IMergePolicy _mergePolicy;

    public DefaultComparisonMethod(IModelScopeDefinition leftScopeDef_p, IModelScopeDefinition rightScopeDef_p, IModelScopeDefinition ancestorScopeDef_p, IComparisonMethodFactory factory_p) {
        Role leftRole = this.getLeftRole();
        this._factory = factory_p;
        this._roleToScopeDefinition = new HashMap<Role, IModelScopeDefinition>();
        this._roleToScopeDefinition.put(leftRole, leftScopeDef_p);
        this._roleToScopeDefinition.put(leftRole.opposite(), rightScopeDef_p);
        this._roleToScopeDefinition.put(Role.ANCESTOR, ancestorScopeDef_p);
        this._twoWayReferenceRole = null;
        this._matchPolicy = this.createMatchPolicy();
        this._diffPolicy = this.createDiffPolicy();
        this._mergePolicy = this.createMergePolicy();
    }

    protected IDiffPolicy createDiffPolicy() {
        return null;
    }

    protected IMatchPolicy createMatchPolicy() {
        return null;
    }

    protected IMergePolicy createMergePolicy() {
        return null;
    }

    @Override
    public IModelScopeDefinition getModelScopeDefinition(Role role_p) {
        return this._roleToScopeDefinition.get(role_p);
    }

    public IDiffPolicy getDiffPolicy() {
        return this._diffPolicy;
    }

    public IMatchPolicy getMatchPolicy() {
        return this._matchPolicy;
    }

    public IMergePolicy getMergePolicy() {
        return this._mergePolicy;
    }

    @Override
    public Role getTwoWayReferenceRole() {
        return this._twoWayReferenceRole;
    }

    @Override
    public void setTwoWayReferenceRole(Role role_p) {
        if (!this.isThreeWay()) {
            this._twoWayReferenceRole = role_p;
        }
    }

    @Override
    public boolean swapScopeDefinitions(Role role1_p, Role role2_p) {
        boolean result = false;
        IModelScopeDefinition scope1 = this.getModelScopeDefinition(role1_p);
        IModelScopeDefinition scope2 = this.getModelScopeDefinition(role2_p);
        if (scope1 != null && scope2 != null) {
            this._roleToScopeDefinition.put(role1_p, scope2);
            this._roleToScopeDefinition.put(role2_p, scope1);
            result = true;
        }
        return result;
    }
}

