/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.aspectj.asm.AsmManager;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Version;
import org.aspectj.tools.ajdoc.CompilerWrapper;
import org.aspectj.tools.ajdoc.Config;
import org.aspectj.tools.ajdoc.DocException;
import org.aspectj.tools.ajdoc.HtmlDecorator;
import org.aspectj.tools.ajdoc.JavadocRunner;
import org.aspectj.tools.ajdoc.StructureUtil;
import org.aspectj.tools.ajdoc.StubFileGenerator;
import org.aspectj.util.FileUtil;
import org.aspectj.util.LangUtil;

public class Main
implements Config {
    private static final String FAIL_MESSAGE = "> compile failed, exiting ajdoc";
    static Vector<String> options;
    static Vector<String> ajcOptions;
    static Vector<String> filenames;
    static Vector<String> fileList;
    static Vector<String> packageList;
    static String docModifier;
    static Vector<String> sourcepath;
    static boolean verboseMode;
    static boolean packageMode;
    static boolean authorStandardDocletSwitch;
    static boolean versionStandardDocletSwitch;
    static File rootDir;
    static Hashtable declIDTable;
    static String docDir;
    private static boolean deleteTempFilesOnExit;
    private static boolean aborted;
    private static IMessage[] errors;
    private static boolean shownAjdocUsageMessage;
    private static String outputWorkingDir;
    static final String internalErrorMessage = "                                                                  \nIf this has not already been logged as a bug raised please raise  \na new AspectJ bug at https://bugs.eclipse.org/bugs including the  \ntext below. To make the bug a priority, please also include a test\nprogram that can reproduce this problem.\n ";

    static {
        docModifier = "package";
        verboseMode = false;
        packageMode = false;
        authorStandardDocletSwitch = false;
        versionStandardDocletSwitch = false;
        rootDir = null;
        declIDTable = new Hashtable();
        docDir = ".";
        deleteTempFilesOnExit = true;
        aborted = false;
        shownAjdocUsageMessage = false;
        outputWorkingDir = "ajdocworkingdir";
    }

    public static void clearState() {
        options = new Vector();
        ajcOptions = new Vector();
        filenames = new Vector();
        fileList = new Vector();
        packageList = new Vector();
        docModifier = "package";
        sourcepath = new Vector();
        verboseMode = false;
        packageMode = false;
        rootDir = null;
        declIDTable = new Hashtable();
        docDir = ".";
        aborted = false;
        deleteTempFilesOnExit = true;
    }

    public static void main(String[] args) {
        Main.clearState();
        if (!JavadocRunner.has14ToolsAvailable()) {
            System.err.println("ajdoc requires a JDK 1.4 or later tools jar - exiting");
            aborted = true;
            return;
        }
        sourcepath.addElement(".");
        Main.parseCommandLine(args);
        rootDir = Main.getRootDir();
        File[] inputFiles = new File[filenames.size()];
        File[] signatureFiles = new File[filenames.size()];
        try {
            if (!new File(outputWorkingDir).isDirectory()) {
                File dir = new File(outputWorkingDir);
                dir.mkdir();
                if (deleteTempFilesOnExit) {
                    dir.deleteOnExit();
                }
            }
            int i = 0;
            while (i < filenames.size()) {
                inputFiles[i] = new File(filenames.elementAt(i));
                ++i;
            }
            AsmManager model = Main.callAjc(inputFiles);
            if (CompilerWrapper.hasErrors()) {
                System.out.println(FAIL_MESSAGE);
                aborted = true;
                errors = CompilerWrapper.getErrors();
                return;
            }
            int ii = 0;
            while (ii < filenames.size()) {
                signatureFiles[ii] = Main.createSignatureFile(model, inputFiles[ii]);
                ++ii;
            }
            System.out.println("> Building signature files...");
            try {
                StubFileGenerator.doFiles(model, declIDTable, inputFiles, signatureFiles);
                Main.packageHTML(model, inputFiles);
            }
            catch (DocException d) {
                System.err.println(d.getMessage());
                return;
            }
            Main.callJavadoc(signatureFiles);
            Main.decorateHtmlFiles(model, inputFiles);
            System.out.println("> Finished.");
        }
        catch (Throwable e) {
            Main.handleInternalError(e);
            Main.exit(-2);
        }
    }

    private static void packageHTML(AsmManager model, File[] inputFiles) throws IOException {
        ArrayList<String> dirList = new ArrayList<String>();
        int i = 0;
        while (i < inputFiles.length) {
            block2: {
                String docFiles;
                String filename;
                File inDir;
                File input;
                block6: {
                    block4: {
                        String packageName;
                        block5: {
                            block3: {
                                packageName = StructureUtil.getPackageDeclarationFromFile(model, inputFiles[i]);
                                if (dirList.contains(packageName)) break block2;
                                String dir = inputFiles[i].getAbsolutePath().substring(0, inputFiles[i].getAbsolutePath().lastIndexOf(File.separator));
                                input = new File(String.valueOf(dir) + "/" + "package.html");
                                inDir = new File(String.valueOf(dir) + "/" + "doc-files");
                                if (input.exists()) break block3;
                                dirList.add(packageName);
                                break block2;
                            }
                            filename = "";
                            docFiles = "";
                            if (packageName == null) break block4;
                            String pathName = String.valueOf(outputWorkingDir) + File.separator + packageName.replace('.', File.separatorChar);
                            File packageDir = new File(pathName);
                            if (packageDir.exists()) break block5;
                            dirList.add(packageName);
                            break block2;
                        }
                        packageName = packageName.replace('.', '/');
                        filename = String.valueOf(outputWorkingDir) + "/" + packageName + "/" + "package.html";
                        docFiles = String.valueOf(rootDir.getAbsolutePath()) + "/" + packageName + "/" + "doc-files";
                        break block6;
                    }
                    filename = String.valueOf(outputWorkingDir) + "/" + "package.html";
                    docFiles = String.valueOf(rootDir.getAbsolutePath()) + "/" + "doc-files";
                }
                File output = new File(filename);
                FileUtil.copyFile((File)input, (File)output);
                if (inDir.exists()) {
                    File outDir = new File(docFiles);
                    System.out.println("> Copying folder " + outDir);
                    FileUtil.copyFile((File)inDir, (File)outDir);
                }
            }
            ++i;
        }
    }

    private static AsmManager callAjc(File[] inputFiles) {
        ajcOptions.addElement("-noExit");
        ajcOptions.addElement("-XjavadocsInModel");
        ajcOptions.addElement("-d");
        ajcOptions.addElement(rootDir.getAbsolutePath());
        String[] argsToCompiler = new String[ajcOptions.size() + inputFiles.length];
        int i = 0;
        while (i < ajcOptions.size()) {
            argsToCompiler[i] = ajcOptions.elementAt(i);
            ++i;
        }
        int j = 0;
        while (j < inputFiles.length) {
            argsToCompiler[i] = inputFiles[j].getAbsolutePath();
            ++i;
            ++j;
        }
        System.out.println("> Calling ajc...");
        return CompilerWrapper.executeMain(argsToCompiler);
    }

    private static void callJavadoc(File[] signatureFiles) throws IOException {
        System.out.println("> Calling javadoc...");
        String[] javadocargs = null;
        ArrayList<String> files = new ArrayList<String>();
        if (packageMode) {
            int numExtraArgs = 2;
            if (authorStandardDocletSwitch) {
                ++numExtraArgs;
            }
            if (versionStandardDocletSwitch) {
                ++numExtraArgs;
            }
            javadocargs = new String[numExtraArgs + options.size() + packageList.size() + fileList.size()];
            javadocargs[0] = "-sourcepath";
            javadocargs[1] = outputWorkingDir;
            int argIndex = 2;
            if (authorStandardDocletSwitch) {
                javadocargs[argIndex] = "-author";
                ++argIndex;
            }
            if (versionStandardDocletSwitch) {
                javadocargs[argIndex] = "-version";
            }
            int k = 0;
            while (k < options.size()) {
                javadocargs[numExtraArgs + k] = options.elementAt(k);
                ++k;
            }
            k = 0;
            while (k < packageList.size()) {
                javadocargs[numExtraArgs + Main.options.size() + k] = packageList.elementAt(k);
                ++k;
            }
            k = 0;
            while (k < fileList.size()) {
                javadocargs[numExtraArgs + Main.options.size() + Main.packageList.size() + k] = fileList.elementAt(k);
                ++k;
            }
            if (LangUtil.is19VMOrGreater()) {
                options = new Vector();
                String[] stringArray = javadocargs;
                int n = javadocargs.length;
                int n2 = 0;
                while (n2 < n) {
                    String a = stringArray[n2];
                    options.add(a);
                    ++n2;
                }
            }
        } else {
            javadocargs = new String[options.size() + signatureFiles.length];
            int k = 0;
            while (k < options.size()) {
                javadocargs[k] = options.elementAt(k);
                ++k;
            }
            k = 0;
            while (k < signatureFiles.length) {
                javadocargs[Main.options.size() + k] = StructureUtil.translateAjPathName(signatureFiles[k].getCanonicalPath());
                ++k;
            }
            k = 0;
            while (k < signatureFiles.length) {
                files.add(StructureUtil.translateAjPathName(signatureFiles[k].getCanonicalPath()));
                ++k;
            }
        }
        if (LangUtil.is19VMOrGreater()) {
            JavadocRunner.callJavadocViaToolProvider(options, files);
        } else {
            JavadocRunner.callJavadoc(javadocargs);
        }
    }

    private static void decorateHtmlFiles(AsmManager model, File[] inputFiles) throws IOException {
        System.out.println("> Decorating html files...");
        HtmlDecorator.decorateHTMLFromInputFiles(model, declIDTable, rootDir, inputFiles, docModifier);
        System.out.println("> Removing generated tags...");
        Main.removeDeclIDsFromFile("index-all.html", true);
        Main.removeDeclIDsFromFile("serialized-form.html", true);
        if (packageList.size() > 0) {
            int p = 0;
            while (p < packageList.size()) {
                Main.removeDeclIDsFromFile(String.valueOf(packageList.elementAt(p).replace('.', '/')) + "/" + "package-summary.html", true);
                ++p;
            }
        } else {
            File[] files = rootDir.listFiles();
            if (files == null) {
                System.err.println("Destination directory is not a directory: " + rootDir.toString());
                return;
            }
            files = FileUtil.listFiles((File)rootDir, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().equals("package-summary.html");
                }
            });
            int j = 0;
            while (j < files.length) {
                Main.removeDeclIDsFromFile(files[j].getAbsolutePath(), false);
                ++j;
            }
        }
    }

    private static void removeDeclIDsFromFile(String filename, boolean relativePath) {
        File indexFile = relativePath ? new File(String.valueOf(docDir) + "/" + filename) : new File(filename);
        try {
            if (indexFile.exists()) {
                BufferedReader indexFileReader = new BufferedReader(new FileReader(indexFile));
                StringBuffer indexFileBuffer = new StringBuffer((int)indexFile.length());
                String line = indexFileReader.readLine();
                while (line != null) {
                    int indexStart = line.indexOf("__AJDECLID:");
                    int indexEnd = line.indexOf(":__");
                    if (indexStart != -1 && indexEnd != -1) {
                        line = String.valueOf(line.substring(0, indexStart)) + line.substring(indexEnd + ":__".length());
                    }
                    indexFileBuffer.append(line);
                    line = indexFileReader.readLine();
                }
                FileOutputStream fos = new FileOutputStream(indexFile);
                fos.write(indexFileBuffer.toString().getBytes());
                indexFileReader.close();
                fos.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static Vector<String> getSourcePath() {
        Vector<String> sourcePath = new Vector<String>();
        boolean found = false;
        int i = 0;
        while (i < options.size()) {
            String currOption = options.elementAt(i);
            if (found && !currOption.startsWith("-")) {
                sourcePath.add(currOption);
            }
            if (currOption.equals("-sourcepath")) {
                found = true;
            }
            ++i;
        }
        return sourcePath;
    }

    static File getRootDir() {
        File rootDir = new File(".");
        int i = 0;
        while (i < options.size()) {
            if (options.elementAt(i).equals("-d") && !(rootDir = new File(options.elementAt(i + 1))).exists()) {
                rootDir.mkdir();
            }
            ++i;
        }
        return rootDir;
    }

    static File createSignatureFile(AsmManager model, File inputFile) throws IOException {
        String packageName = StructureUtil.getPackageDeclarationFromFile(model, inputFile);
        String filename = "";
        if (packageName != null) {
            String pathName = String.valueOf(outputWorkingDir) + '/' + packageName.replace('.', '/');
            File packageDir = new File(pathName);
            if (!packageDir.exists()) {
                packageDir.mkdirs();
                if (deleteTempFilesOnExit) {
                    packageDir.deleteOnExit();
                }
            }
            packageName = packageName.replace('.', '/');
            filename = String.valueOf(outputWorkingDir) + "/" + packageName + "/" + inputFile.getName();
        } else {
            filename = String.valueOf(outputWorkingDir) + "/" + inputFile.getName();
        }
        File signatureFile = new File(filename);
        if (deleteTempFilesOnExit) {
            signatureFile.deleteOnExit();
        }
        return signatureFile;
    }

    static void parseCommandLine(String[] args) {
        if (args.length == 0) {
            Main.displayHelpAndExit(null);
        } else if (args.length == 1 && args[0].startsWith("@")) {
            String argFile = args[0].substring(1);
            System.out.println("> Using arg file: " + argFile);
            try {
                BufferedReader br = new BufferedReader(new FileReader(argFile));
                String line = "";
                line = br.readLine();
                StringTokenizer st = new StringTokenizer(line, " ");
                ArrayList<String> argList = new ArrayList<String>();
                while (st.hasMoreElements()) {
                    argList.add(st.nextToken());
                }
                args = new String[argList.size()];
                int counter = 0;
                Iterator it = argList.iterator();
                while (it.hasNext()) {
                    args[counter] = (String)it.next();
                    ++counter;
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("> could not read arg file: " + argFile);
                e.printStackTrace();
            }
            catch (IOException ioe) {
                System.err.println("> could not read arg file: " + argFile);
                ioe.printStackTrace();
            }
        }
        LinkedList<String> vargs = new LinkedList<String>(Arrays.asList(args));
        vargs.add("-Xset:minimalModel=false");
        Main.parseArgs(vargs, new File("."));
        if (filenames.size() == 0) {
            Main.displayHelpAndExit("ajdoc: No packages or classes specified");
        }
    }

    static void setSourcepath(String arg) {
        sourcepath.clear();
        arg = String.valueOf(arg) + File.pathSeparator;
        StringTokenizer tokenizer = new StringTokenizer(arg, File.pathSeparator);
        while (tokenizer.hasMoreElements()) {
            sourcepath.addElement(tokenizer.nextToken());
        }
    }

    static String getSourcepathAsString() {
        String cPath = "";
        int i = 0;
        while (i < sourcepath.size()) {
            cPath = String.valueOf(cPath) + sourcepath.elementAt(i) + "/" + outputWorkingDir;
            if (i != sourcepath.size() - 1) {
                cPath = String.valueOf(cPath) + File.pathSeparator;
            }
            ++i;
        }
        return cPath;
    }

    /*
     * Unable to fully structure code
     */
    static void parseArgs(List vargs, File currentWorkingDir) {
        addNextAsOption = false;
        addNextAsArgFile = false;
        addNextToAJCOptions = false;
        addNextAsDocDir = false;
        addNextAsClasspath = false;
        ignoreArg = false;
        addNextAsSourcePath = false;
        if (vargs.size() == 0) {
            Main.displayHelpAndExit(null);
        }
        i = 0;
        while (i < vargs.size()) {
            block20: {
                block36: {
                    block47: {
                        block46: {
                            block45: {
                                block44: {
                                    block43: {
                                        block42: {
                                            block41: {
                                                block40: {
                                                    block39: {
                                                        block38: {
                                                            block37: {
                                                                block35: {
                                                                    block34: {
                                                                        block33: {
                                                                            block32: {
                                                                                block31: {
                                                                                    block30: {
                                                                                        block29: {
                                                                                            block28: {
                                                                                                block27: {
                                                                                                    block26: {
                                                                                                        block25: {
                                                                                                            block24: {
                                                                                                                block23: {
                                                                                                                    block22: {
                                                                                                                        block21: {
                                                                                                                            block19: {
                                                                                                                                arg = (String)vargs.get(i);
                                                                                                                                ignoreArg = false;
                                                                                                                                if (addNextAsDocDir) {
                                                                                                                                    Main.docDir = arg;
                                                                                                                                    addNextAsDocDir = false;
                                                                                                                                }
                                                                                                                                if (addNextAsClasspath) {
                                                                                                                                    addNextAsClasspath = false;
                                                                                                                                }
                                                                                                                                if (addNextAsSourcePath) {
                                                                                                                                    Main.setSourcepath(arg);
                                                                                                                                    addNextAsSourcePath = false;
                                                                                                                                    ignoreArg = true;
                                                                                                                                }
                                                                                                                                if (!arg.startsWith("@")) break block19;
                                                                                                                                Main.expandAtSignFile(arg.substring(1), currentWorkingDir);
                                                                                                                                break block20;
                                                                                                                            }
                                                                                                                            if (!arg.equals("-argfile")) break block21;
                                                                                                                            addNextAsArgFile = true;
                                                                                                                            break block20;
                                                                                                                        }
                                                                                                                        if (!addNextAsArgFile) break block22;
                                                                                                                        Main.expandAtSignFile(arg, currentWorkingDir);
                                                                                                                        addNextAsArgFile = false;
                                                                                                                        break block20;
                                                                                                                    }
                                                                                                                    if (!arg.equals("-d")) break block23;
                                                                                                                    addNextAsOption = true;
                                                                                                                    Main.options.addElement(arg);
                                                                                                                    addNextAsDocDir = true;
                                                                                                                    break block20;
                                                                                                                }
                                                                                                                if (!arg.equals("-bootclasspath")) break block24;
                                                                                                                addNextAsOption = true;
                                                                                                                addNextToAJCOptions = true;
                                                                                                                Main.options.addElement(arg);
                                                                                                                Main.ajcOptions.addElement(arg);
                                                                                                                break block20;
                                                                                                            }
                                                                                                            if (!arg.equals("-source")) break block25;
                                                                                                            addNextAsOption = true;
                                                                                                            addNextToAJCOptions = true;
                                                                                                            addNextAsClasspath = true;
                                                                                                            Main.options.addElement(arg);
                                                                                                            Main.ajcOptions.addElement(arg);
                                                                                                            break block20;
                                                                                                        }
                                                                                                        if (!arg.equals("-classpath")) break block26;
                                                                                                        addNextAsOption = true;
                                                                                                        addNextToAJCOptions = true;
                                                                                                        addNextAsClasspath = true;
                                                                                                        Main.options.addElement(arg);
                                                                                                        Main.ajcOptions.addElement(arg);
                                                                                                        break block20;
                                                                                                    }
                                                                                                    if (!arg.equals("-encoding")) break block27;
                                                                                                    addNextAsOption = true;
                                                                                                    addNextToAJCOptions = false;
                                                                                                    Main.options.addElement(arg);
                                                                                                    break block20;
                                                                                                }
                                                                                                if (!arg.equals("-docencoding")) break block28;
                                                                                                addNextAsOption = true;
                                                                                                addNextToAJCOptions = false;
                                                                                                Main.options.addElement(arg);
                                                                                                break block20;
                                                                                            }
                                                                                            if (!arg.equals("-charset")) break block29;
                                                                                            addNextAsOption = true;
                                                                                            addNextToAJCOptions = false;
                                                                                            Main.options.addElement(arg);
                                                                                            break block20;
                                                                                        }
                                                                                        if (!arg.equals("-sourcepath")) break block30;
                                                                                        addNextAsSourcePath = true;
                                                                                        break block20;
                                                                                    }
                                                                                    if (!arg.equals("-link")) break block31;
                                                                                    addNextAsOption = true;
                                                                                    Main.options.addElement(arg);
                                                                                    break block20;
                                                                                }
                                                                                if (!arg.equals("-bottom")) break block32;
                                                                                addNextAsOption = true;
                                                                                Main.options.addElement(arg);
                                                                                break block20;
                                                                            }
                                                                            if (!arg.equals("-windowtitle")) break block33;
                                                                            addNextAsOption = true;
                                                                            Main.options.addElement(arg);
                                                                            break block20;
                                                                        }
                                                                        if (!arg.equals("-XajdocDebug")) break block34;
                                                                        Main.deleteTempFilesOnExit = false;
                                                                        break block20;
                                                                    }
                                                                    if (!arg.equals("-use")) break block35;
                                                                    System.out.println("> Ignoring unsupported option: -use");
                                                                    break block20;
                                                                }
                                                                if (arg.equals("-splitindex")) break block20;
                                                                if (!arg.startsWith("-") && !addNextAsOption && !addNextToAJCOptions) break block36;
                                                                if (!arg.equals("-private")) break block37;
                                                                Main.docModifier = "private";
                                                                ** GOTO lbl169
                                                            }
                                                            if (!arg.equals("-package")) break block38;
                                                            Main.docModifier = "package";
                                                            ** GOTO lbl169
                                                        }
                                                        if (!arg.equals("-protected")) break block39;
                                                        Main.docModifier = "protected";
                                                        ** GOTO lbl169
                                                    }
                                                    if (!arg.equals("-public")) break block40;
                                                    Main.docModifier = "public";
                                                    ** GOTO lbl169
                                                }
                                                if (!arg.equals("-verbose")) break block41;
                                                Main.verboseMode = true;
                                                ** GOTO lbl169
                                            }
                                            if (!arg.equals("-author")) break block42;
                                            Main.authorStandardDocletSwitch = true;
                                            ** GOTO lbl169
                                        }
                                        if (!arg.equals("-version")) break block43;
                                        Main.versionStandardDocletSwitch = true;
                                        ** GOTO lbl169
                                    }
                                    if (!arg.equals("-v")) break block44;
                                    System.out.println(Main.getVersion());
                                    Main.exit(0);
                                    ** GOTO lbl169
                                }
                                if (!arg.equals("-help")) break block45;
                                Main.displayHelpAndExit(null);
                                ** GOTO lbl169
                            }
                            if (!arg.equals("-doclet") && !arg.equals("-docletpath")) break block46;
                            System.out.println("The doclet and docletpath options are not currently supported    \nsince ajdoc makes assumptions about the behavior of the standard \ndoclet. If you would find this option useful please email us at: \n                                                                 \n       aspectj-dev@eclipse.org                            \n                                                                 \n");
                            Main.exit(0);
                            ** GOTO lbl169
                        }
                        if (arg.equals("-nonavbar") || arg.equals("-noindex")) ** GOTO lbl169
                        if (!addNextToAJCOptions && !addNextAsOption) break block47;
                        if (!addNextToAJCOptions) ** GOTO lbl169
                        Main.ajcOptions.addElement(arg);
                        if (!arg.startsWith("-")) {
                            addNextToAJCOptions = false;
                        }
                        if (addNextAsOption) ** GOTO lbl169
                        break block20;
                    }
                    if (arg.startsWith("-")) {
                        Main.ajcOptions.addElement(arg);
                        addNextToAJCOptions = true;
                    } else {
                        System.err.println("> unrecognized argument: " + arg);
                        Main.displayHelpAndExit(null);
lbl169:
                        // 14 sources

                        Main.options.addElement(arg);
                        addNextAsOption = false;
                    }
                    break block20;
                }
                if (FileUtil.hasSourceSuffix((String)arg) || arg.endsWith(".lst") && arg != null) {
                    f = new File(arg);
                    if (f.isAbsolute()) {
                        Main.filenames.addElement(arg);
                    } else {
                        Main.filenames.addElement(currentWorkingDir + "/" + arg);
                    }
                    Main.fileList.addElement(arg);
                } else if (!ignoreArg) {
                    Main.packageMode = true;
                    Main.packageList.addElement(arg);
                    arg = arg.replace('.', '/');
                    c = 0;
                    while (c < Main.sourcepath.size()) {
                        path = String.valueOf(Main.sourcepath.elementAt(c)) + "/" + arg;
                        pkg = new File(path);
                        if (pkg.isDirectory()) {
                            files = pkg.list(new FilenameFilter(){

                                @Override
                                public boolean accept(File dir, String name) {
                                    int index1 = name.lastIndexOf(".");
                                    int index2 = name.length();
                                    return index1 >= 0 && index2 >= 0 && (name.substring(index1, index2).equals(".java") || name.substring(index1, index2).equals(".aj"));
                                }
                            });
                            j = 0;
                            while (j < files.length) {
                                Main.filenames.addElement(String.valueOf(Main.sourcepath.elementAt(c)) + "/" + arg + "/" + files[j]);
                                ++j;
                            }
                        } else if (c == Main.sourcepath.size()) {
                            System.out.println("ajdoc: No package, class, or source file found named " + arg + ".");
                        }
                        ++c;
                    }
                }
            }
            ++i;
        }
        if (!(Main.options.contains("-private") || Main.options.contains("-package") || Main.options.contains("-protected") || Main.options.contains("-public"))) {
            Main.options.addElement("-package");
        }
    }

    static void expandAtSignFile(String filename, File currentWorkingDir) {
        LinkedList<String> result = new LinkedList<String>();
        File atFile = Main.qualifiedFile(filename, currentWorkingDir);
        String atFileParent = atFile.getParent();
        File myWorkingDir = null;
        if (atFileParent != null) {
            myWorkingDir = new File(atFileParent);
        }
        try {
            BufferedReader stream = new BufferedReader(new FileReader(atFile));
            String line = null;
            while ((line = stream.readLine()) != null) {
                int commentStart = line.indexOf("//");
                if (commentStart != -1) {
                    line = line.substring(0, commentStart);
                }
                if ((line = line.trim()).length() == 0) continue;
                result.add(line);
            }
            stream.close();
        }
        catch (IOException e) {
            System.err.println("Error while reading the @ file " + atFile.getPath() + ".\n" + e);
            System.exit(-1);
        }
        Main.parseArgs(result, myWorkingDir);
    }

    static File qualifiedFile(String name, File currentWorkingDir) {
        File file = new File(name = name.replace('/', File.separatorChar));
        if (!file.isAbsolute() && currentWorkingDir != null) {
            file = new File(currentWorkingDir, name);
        }
        return file;
    }

    static void displayHelpAndExit(String message) {
        shownAjdocUsageMessage = true;
        if (message != null) {
            System.err.println(message);
            System.err.println();
            System.err.println("Usage: ajdoc <options> <source files>\n\nwhere <options> includes:\n  -public                   Show only public classes and members\n  -protected                Show protected/public classes and members\n  -package                  Show package/protected/public classes and members\n  -private                  Show all classes and members\n  -help                     Display command line options\n  -sourcepath <pathlist>    Specify where to find source files\n  -classpath <pathlist>     Specify where to find user class files\n  -bootclasspath <pathlist> Override location of class files loaded\n  -d <directory>            Destination directory for output files\n  -windowtitle <text>       Browser window title for the documenation  -bottom <html-code>       Include bottom text for each page  -link <url>               Create links to javadoc output at <url>  -argfile <file>           Build config file (wildcards not supported)\n  -verbose                  Output messages about what Javadoc is doing\n  -v                        Print out the version of ajdoc\n  -source <version>         set source level (1.3, 1.4 or 1.5)\n\nas well as the AspectJ Compiler options.\n\nIf an argument is of the form @<filename>, the file will be interpreted as\na line delimited set of arguments to insert into the argument list.\n");
        } else {
            System.out.println("Usage: ajdoc <options> <source files>\n\nwhere <options> includes:\n  -public                   Show only public classes and members\n  -protected                Show protected/public classes and members\n  -package                  Show package/protected/public classes and members\n  -private                  Show all classes and members\n  -help                     Display command line options\n  -sourcepath <pathlist>    Specify where to find source files\n  -classpath <pathlist>     Specify where to find user class files\n  -bootclasspath <pathlist> Override location of class files loaded\n  -d <directory>            Destination directory for output files\n  -windowtitle <text>       Browser window title for the documenation  -bottom <html-code>       Include bottom text for each page  -link <url>               Create links to javadoc output at <url>  -argfile <file>           Build config file (wildcards not supported)\n  -verbose                  Output messages about what Javadoc is doing\n  -v                        Print out the version of ajdoc\n  -source <version>         set source level (1.3, 1.4 or 1.5)\n\nas well as the AspectJ Compiler options.\n\nIf an argument is of the form @<filename>, the file will be interpreted as\na line delimited set of arguments to insert into the argument list.\n");
            Main.exit(0);
        }
    }

    protected static void exit(int value) {
        System.out.flush();
        System.err.flush();
        System.exit(value);
    }

    public static void handleInternalError(Throwable uncaughtThrowable) {
        System.err.println("An internal error occured in ajdoc");
        System.err.println(internalErrorMessage);
        System.err.println(uncaughtThrowable.toString());
        uncaughtThrowable.printStackTrace();
        System.err.println();
    }

    static String getVersion() {
        return "ajdoc version " + Version.getText();
    }

    public static boolean hasAborted() {
        return aborted;
    }

    public static IMessage[] getErrors() {
        return errors;
    }

    public static boolean hasShownAjdocUsageMessage() {
        return shownAjdocUsageMessage;
    }

    public static void setOutputWorkingDir(String fullyQulifiedOutputDir) {
        if (fullyQulifiedOutputDir == null) {
            Main.resetOutputWorkingDir();
        } else {
            outputWorkingDir = String.valueOf(fullyQulifiedOutputDir) + File.separatorChar + "ajdocworkingdir";
        }
    }

    public static void resetOutputWorkingDir() {
        outputWorkingDir = "ajdocworkingdir";
    }
}

