/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.antlr;

import fr.inria.aoste.timesquare.vcd.antlr.ScopeTree;
import fr.inria.aoste.timesquare.vcd.antlr.ValueChangeTree;
import fr.inria.aoste.timesquare.vcd.antlr.VarTree;
import fr.inria.aoste.timesquare.vcd.model.Comment;
import fr.inria.aoste.timesquare.vcd.model.IDeclarationCommand;
import fr.inria.aoste.timesquare.vcd.model.IScopeCommand;
import fr.inria.aoste.timesquare.vcd.model.ISimulationCommand;
import fr.inria.aoste.timesquare.vcd.model.Uposition;
import fr.inria.aoste.timesquare.vcd.model.VCDDefinitions;
import fr.inria.aoste.timesquare.vcd.model.command.DateCommand;
import fr.inria.aoste.timesquare.vcd.model.command.ScopeCommand;
import fr.inria.aoste.timesquare.vcd.model.command.TimeScaleCommand;
import fr.inria.aoste.timesquare.vcd.model.command.VersionCommand;
import fr.inria.aoste.timesquare.vcd.model.keyword.ScopeType;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.Tree;

public class VcdTreeAdaptor
extends CommonTreeAdaptor {
    private int state = 0;
    private VCDDefinitions vcd = new VCDDefinitions();
    private int level;
    private Tree tree;
    private int time = -1;
    private int pulse = -1;
    private Uposition up = null;
    private boolean inComment = false;
    private Comment comment = null;
    private ScopeCommand scope = null;

    public int convertSimulationDate(Token arg0) {
        try {
            return Integer.valueOf(arg0.getText().substring(1));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private void processPosition(Token token) {
        int state = token.getType();
        switch (state) {
            case 6: {
                String time = token.getText().substring(1);
                this.up = new Uposition(Integer.parseInt(time), Uposition.Enumblocktype.SimulationTime);
                break;
            }
            case 13: {
                this.up = new Uposition(0, Uposition.Enumblocktype.Date);
                break;
            }
            case 12: {
                this.up = new Uposition(0, Uposition.Enumblocktype.EndDef);
                break;
            }
            case 14: {
                this.up = new Uposition(0, Uposition.Enumblocktype.Scope);
                break;
            }
            case 17: {
                this.up = new Uposition(0, Uposition.Enumblocktype.TimeScale);
                break;
            }
            case 21: {
                this.up = new Uposition(0, Uposition.Enumblocktype.Var);
                break;
            }
            case 24: {
                this.up = new Uposition(0, Uposition.Enumblocktype.Version);
                break;
            }
            case 7: {
                this.up = new Uposition(0, Uposition.Enumblocktype.DumpAll);
                break;
            }
            case 11: {
                this.up = new Uposition(0, Uposition.Enumblocktype.DumpOff);
                break;
            }
            case 10: {
                this.up = new Uposition(0, Uposition.Enumblocktype.DumpOn);
                break;
            }
            case 9: {
                this.up = new Uposition(0, Uposition.Enumblocktype.DumpVars);
            }
        }
    }

    private void processEndPosition() {
        this.state = 0;
        if (this.up != null) {
            this.up.setTheEnd(true);
        }
    }

    public Tree create(Token arg0) {
        if (arg0 == null) {
            return (Tree)super.create(null);
        }
        switch (this.state) {
            case 0: {
                this.state = arg0.getType();
                this.processPosition(arg0);
                if (this.state == 6) {
                    this.time = this.convertSimulationDate(arg0);
                    this.vcd.setOffSet(this.time);
                    ValueChangeTree vct = new ValueChangeTree(arg0);
                    this.vcd.addSimulation((ISimulationCommand)vct.getCommand());
                    return vct;
                }
                if (this.state == 14) {
                    this.level = 1;
                    this.tree = new ScopeTree(arg0);
                    return this.tree;
                }
                if (this.state == 21) {
                    this.tree = new VarTree(arg0);
                    return this.tree;
                }
                this.tree = (Tree)super.create(arg0);
                return this.tree;
            }
            case 13: {
                if (arg0.getType() != 8) break;
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < this.tree.getChildCount()) {
                    if (i > 0) {
                        buf.append(' ');
                    }
                    buf.append(this.tree.getChild(i).getText());
                    ++i;
                }
                this.vcd.addDefinition((IDeclarationCommand)new DateCommand(buf.toString()));
                this.processEndPosition();
                break;
            }
            case 24: {
                if (arg0.getType() != 8) break;
                this.vcd.addDefinition((IDeclarationCommand)new VersionCommand(this.tree.getChild(0).getText(), this.tree.getChild(1).getText()));
                this.processEndPosition();
                break;
            }
            case 17: {
                if (arg0.getType() != 8) break;
                this.vcd.addDefinition((IDeclarationCommand)new TimeScaleCommand(this.tree.getChild(0).getText(), this.tree.getChild(1).getText()));
                this.processEndPosition();
                break;
            }
            case 14: {
                if (arg0.getType() == 21) {
                    return new VarTree(arg0);
                }
                if (arg0.getType() == 14) {
                    ++this.level;
                    return new ScopeTree(arg0);
                }
                if (arg0.getType() != 20) break;
                --this.level;
                if (this.level == 0) {
                    this.state = 0;
                    this.vcd.setScope(((ScopeTree)this.tree).getScope());
                }
                this.up = new Uposition(0, Uposition.Enumblocktype.UpScope);
                break;
            }
            case 6: {
                if (this.inComment) {
                    if (arg0.getType() == 8) {
                        System.out.println("Comment: is it used ?" + this.comment);
                        this.comment = null;
                        this.inComment = false;
                        break;
                    }
                    if (this.comment == null) {
                        this.comment = new Comment(arg0.getText(), this.up);
                        break;
                    }
                    this.comment.addPart(arg0.getText());
                    break;
                }
                if (arg0.getType() == 6) {
                    this.processPosition(arg0);
                    int newtime = this.convertSimulationDate(arg0);
                    if (this.time != -1) {
                        if (this.pulse == -1) {
                            this.pulse = newtime - this.time;
                        } else if (newtime - this.time < this.pulse) {
                            this.pulse = newtime - this.time;
                        }
                    }
                    this.time = newtime;
                    ValueChangeTree vct = new ValueChangeTree(arg0);
                    this.vcd.addSimulation((ISimulationCommand)vct.getCommand());
                    return vct;
                }
                if (arg0.getType() == 9 || arg0.getType() == 10 || arg0.getType() == 11 || arg0.getType() == 7) {
                    this.processPosition(arg0);
                    this.state = arg0.getType();
                    return new ValueChangeTree(arg0);
                }
                if (arg0.getType() != 26) break;
                this.inComment = true;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                if (arg0.getType() != 8) break;
                this.state = 6;
                break;
            }
            case 21: {
                if (arg0.getType() == 8) {
                    this.processEndPosition();
                    if (this.scope == null) {
                        this.scope = new ScopeCommand(ScopeType.module, null);
                        this.vcd.setScope(this.scope);
                    }
                    this.scope.addChild((IScopeCommand)((VarTree)this.tree).getVar());
                }
                return (Tree)super.create(arg0);
            }
            case 26: {
                if (arg0.getType() == 8) {
                    this.vcd.addDefinition((IDeclarationCommand)this.comment.convert());
                    this.comment = null;
                    this.processEndPosition();
                    break;
                }
                String s = arg0.getText();
                if (this.comment == null) {
                    this.comment = new Comment(s, this.up);
                    break;
                }
                this.comment.addPart(s);
                break;
            }
            default: {
                if (arg0.getType() != 8) break;
                this.processEndPosition();
            }
        }
        return (Tree)super.create(arg0);
    }

    public VCDDefinitions getVcd() {
        return this.vcd;
    }
}

