/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.instantrelation.generator.metier.activation;

import fr.inria.aoste.timesquare.trace.util.HelperFactory;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.FiredStateKind;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.Reference;

public class ActivationCreator {
    LogicalStep currentstep = null;
    boolean mustinit = false;
    boolean active = true;
    boolean mustFinish = false;
    boolean lastActive4init = false;
    boolean lastActive4finish = false;

    public void updateStep(LogicalStep stepTrace) {
        if (this.currentstep != stepTrace) {
            this.currentstep = stepTrace;
            this.active = this.evalIsActive();
            this.mustinit = this.evalMustInit();
            this.mustFinish = this.evalMustFinish();
        }
    }

    protected boolean evalIsActive() {
        return true;
    }

    protected boolean evalMustInit() {
        if (this.active && !this.lastActive4init) {
            this.lastActive4init = true;
            return true;
        }
        this.lastActive4init = this.active;
        return false;
    }

    protected boolean evalMustFinish() {
        if (!this.active && this.lastActive4finish) {
            return true;
        }
        if (this.active) {
            this.lastActive4finish = this.active;
        }
        return false;
    }

    public final boolean mustInit() {
        return this.mustinit;
    }

    public final boolean isActive() {
        return this.active;
    }

    public final boolean mustFinish() {
        return this.mustFinish;
    }

    public boolean clockTick(ModelElementReference clock) {
        return this.clockTick(this.getEventOccurrenceOnStepTrace(clock));
    }

    public boolean clockisDead(ModelElementReference clock) {
        return this.clockisDead(this.getEventOccurrenceOnStepTrace(clock));
    }

    public boolean clockwasBorn(ModelElementReference clock) {
        return this.clockwasBorn(this.getEventOccurrenceOnStepTrace(clock));
    }

    public boolean clockTick(EventOccurrence cs) {
        if (cs != null) {
            return cs.getFState() == FiredStateKind.TICK;
        }
        return false;
    }

    public boolean clockisDead(EventOccurrence cs) {
        if (cs != null) {
            return cs.isIsClockDead();
        }
        return true;
    }

    public boolean clockwasBorn(EventOccurrence cs) {
        if (cs != null) {
            return cs.isWasBorn();
        }
        return false;
    }

    public final EventOccurrence getEventOccurrenceOnStepTrace(ModelElementReference clk) {
        return HelperFactory.getEventOccurence((LogicalStep)this.currentstep, (Reference)clk);
    }
}

