/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.buddywrapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "fr.inria.aoste.timesquare.buddywrapper.runtime";
    private static Activator plugin;
    public static String os;
    public static String arch;
    public static final String bdd = "bdd";

    static {
        os = "linux";
        arch = "x86_64";
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ServiceReference sr = context.getServiceReference(EnvironmentInfo.class);
        EnvironmentInfo ei = (EnvironmentInfo)context.getService(sr);
        os = ei.getOS();
        arch = ei.getOSArch();
        context.ungetService(sr);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static boolean loadNativeLibrary(String libname) {
        return Activator.loadLibrary("buddy-" + os + "-" + arch);
    }

    public static boolean loadLibrary(String libvname) {
        String libname = null;
        String filename = null;
        try {
            System.loadLibrary(libvname);
            return true;
        }
        catch (Throwable x) {
            System.out.println("M1 " + x);
            try {
                EquinoxBundle bundleImpl = (EquinoxBundle)Activator.getDefault().getBundle();
                BundleInfo.Generation generation = (BundleInfo.Generation)bundleImpl.getModule().getCurrentRevision().getRevisionInfo();
                String s = generation.findLibrary(libvname);
                System.load(new File(s).toString());
                return true;
            }
            catch (Throwable x2) {
                System.out.println("M2 " + x2);
                try {
                    libname = System.mapLibraryName(libvname);
                    System.loadLibrary(libname);
                    return true;
                }
                catch (Throwable e) {
                    System.out.println("M3 " + e);
                    try {
                        InputStream fis = FileLocator.openStream((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("/" + libname), (boolean)false);
                        File f2 = File.createTempFile(libvname, ".dll");
                        if (!f2.exists()) {
                            Activator.copyFile(fis, f2);
                        }
                        System.load(f2.getAbsolutePath());
                        return true;
                    }
                    catch (Throwable y) {
                        System.out.println("M4 " + y);
                        File f = null;
                        try {
                            libname = System.mapLibraryName(libvname);
                            String currentdir = Activator.getProperty("user.dir", ".");
                            String sep = Activator.getProperty("file.separator", "/");
                            filename = String.valueOf(currentdir) + sep + libname;
                            f = new File(filename);
                            System.load(f.toString());
                            return true;
                        }
                        catch (Throwable e2) {
                            System.out.println("M5 " + e2);
                            try {
                                File f2 = File.createTempFile(libvname, ".dll");
                                Activator.copyFile(f, f2);
                                f2.deleteOnExit();
                                System.load(f2.toString());
                                return true;
                            }
                            catch (Throwable z) {
                                System.out.println("M6 " + z);
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    private static final String getProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (AccessControlException _) {
            return def;
        }
    }

    private static void copyFile(InputStream fis, File out) throws IOException {
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    private static void copyFile(File in, File out) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }
}

