/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.obeoviewpointanimator;

import fr.inria.aoste.timesquare.backend.manager.datastructure.Entity;
import fr.inria.aoste.timesquare.backend.manager.datastructure.assertion.AssertActivationState;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorConfigurator;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManager;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockBehavior;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.ConfigurationHelper;
import fr.inria.aoste.timesquare.backend.manager.visible.DeleteHelper;
import fr.inria.aoste.timesquare.backend.manager.visible.PersistentOptions;
import fr.inria.aoste.timesquare.backend.manager.visible.RelationBehavior;
import fr.inria.aoste.timesquare.backend.obeoviewpointanimator.AnimateAssertBehaviour;
import fr.inria.aoste.timesquare.backend.obeoviewpointanimator.AnimateTicksBehaviour;
import fr.inria.aoste.timesquare.backend.obeoviewpointanimator.ObeoViewpointAnimatorBehaviorConfigurator;
import fr.inria.aoste.timesquare.backend.obeoviewpointanimator.ObeoViewpointAnimatorPersistentOptions;
import fr.inria.aoste.timesquare.backend.obeoviewpointanimator.ObeoViewpointAnimatorPluginPersistentOptions;
import fr.inria.aoste.timesquare.launcher.core.inter.CCSLInfo;
import fr.inria.aoste.timesquare.launcher.core.inter.ISolverForBackend;
import fr.inria.aoste.timesquare.launcher.debug.model.output.ReportMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.swt.widgets.Display;

public class ObeoViewpointAnimatorBehaviorManager
extends BehaviorManager {
    private String _iardFilePath = null;
    private IFile _airdIFile = null;
    private Session _createdSession = null;
    private final List<AnimateTicksBehaviour> behaviorList = new ArrayList<AnimateTicksBehaviour>();
    private final List<AnimateAssertBehaviour> assertBehaviorList = new ArrayList<AnimateAssertBehaviour>();
    private CCSLInfo ccslhelper = null;
    private HashMap<String, Boolean> cachevalidation = new HashMap();

    public boolean isActivable(ReportMessage rm, CCSLInfo _ccslhelper) {
        return true;
    }

    public String validate() {
        if (this._airdIFile == null) {
            return "No *.aird File  ";
        }
        if (!this._airdIFile.exists()) {
            return "File not found :" + this._airdIFile.getName();
        }
        if (!this.isValidAirdFile(this._airdIFile)) {
            return "File aird doesn't have any link with the specification";
        }
        return super.validate();
    }

    public String getDiFileString() {
        return this._iardFilePath;
    }

    public IFile getAirdIFile() {
        return this._airdIFile;
    }

    public void setAird(String s) {
        this._iardFilePath = s;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = iWorkspaceRoot.findMember(this._iardFilePath);
        this._airdIFile = resource instanceof IFile ? (IFile)resource : null;
    }

    public void setAird(IFile f) {
        this._airdIFile = f;
        if (f == null) {
            this._iardFilePath = null;
            return;
        }
        this._iardFilePath = f.getFullPath().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidAirdFile(String file) {
        try {
            URI _uri;
            if (this.cachevalidation.containsKey(file)) {
                return this.cachevalidation.get(file);
            }
            ResourceSetImpl rs = new ResourceSetImpl();
            URI uri = URI.createPlatformResourceURI((String)file, (boolean)true);
            Resource r = rs.getResource(uri, true);
            r.load(Collections.EMPTY_MAP);
            try {
                EcoreUtil.resolveAll((ResourceSet)rs);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Iterator iterator = rs.getResources().iterator();
            do {
                if (!iterator.hasNext()) {
                    this.cachevalidation.put(file, false);
                    return false;
                }
                Resource resource = (Resource)iterator.next();
                _uri = resource.getURI();
            } while (!this.ccslhelper.getMappingURIReferencedObject().keySet().contains(_uri));
            this.cachevalidation.put(file, true);
            return true;
        }
        catch (Exception e) {
            this.cachevalidation.put(file, false);
            return false;
        }
    }

    public boolean isValidAirdFile(IFile file) {
        if (file != null) {
            return true;
        }
        return true;
    }

    public void end(ConfigurationHelper helper) {
        try {
            Display.getDefault().syncExec((Runnable)new RunnableEnd());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void deleteEntity(Entity entity, DeleteHelper deletehelper) {
        this.behaviorList.remove(entity.getBehavior());
    }

    public void clear() {
        this.behaviorList.clear();
        this._iardFilePath = null;
        this._airdIFile = null;
    }

    public String _getid() {
        return "obeoviewpointanimator";
    }

    public String getPluginName() {
        return "Obeo ViewPoint Animator";
    }

    public PersistentOptions getPluginOptions() {
        if (this._iardFilePath != null) {
            return new ObeoViewpointAnimatorPluginPersistentOptions(this._iardFilePath);
        }
        return null;
    }

    public void beforeExecution(ConfigurationHelper helper, IPath folderin, String namefilein, ISolverForBackend solver) {
        try {
            Display.getDefault().syncExec((Runnable)new RunnableStart());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void manageBehavior(ConfigurationHelper helper) {
        try {
            block2: for (ClockEntity ce : helper.getClocks()) {
                if (ce.getModelElementReference().getElementRef().size() != 3) continue;
                for (AnimateTicksBehaviour b : this.behaviorList) {
                    if (b._ce == ce) continue block2;
                }
                AnimateTicksBehaviour atb = new AnimateTicksBehaviour(ce);
                this.behaviorList.add(atb);
                helper.addBehavior(ce, helper.getTicksState(), this.getPluginName(), (ClockBehavior)atb, (PersistentOptions)new ObeoViewpointAnimatorPersistentOptions(ce.getID()));
            }
            for (ClockEntity ae : helper.getAssert()) {
                AnimateAssertBehaviour aab = new AnimateAssertBehaviour(ae);
                this.assertBehaviorList.add(aab);
                boolean[] blArray = new boolean[2];
                blArray[1] = true;
                boolean[] assertState = blArray;
                helper.addBehavior(ae, new AssertActivationState(assertState), this.getPluginName(), (ClockBehavior)aab, (PersistentOptions)new ObeoViewpointAnimatorPersistentOptions(ae.getID()));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public BehaviorConfigurator<?> getConfigurator(ConfigurationHelper configurationHelper) {
        return new ObeoViewpointAnimatorBehaviorConfigurator(configurationHelper, this);
    }

    public void receivePluginOptions(ConfigurationHelper helper, PersistentOptions persistentOptions) throws Throwable {
        if (persistentOptions instanceof ObeoViewpointAnimatorPluginPersistentOptions) {
            this.setAird(((ObeoViewpointAnimatorPluginPersistentOptions)persistentOptions).get_di2FilePath());
        }
    }

    public AnimateTicksBehaviour redoClockBehavior(ConfigurationHelper helper, PersistentOptions persistentOptions) {
        AnimateTicksBehaviour cl = null;
        if (persistentOptions instanceof ObeoViewpointAnimatorPersistentOptions) {
            ClockEntity ce = helper.getClock(((ObeoViewpointAnimatorPersistentOptions)persistentOptions).getID());
            cl = new AnimateTicksBehaviour(ce);
            this.behaviorList.add(cl);
        }
        return cl;
    }

    public ClockBehavior redoAssertBehavior(ConfigurationHelper helper, PersistentOptions persistentOptions) {
        AnimateAssertBehaviour aab = null;
        if (persistentOptions instanceof ObeoViewpointAnimatorPersistentOptions) {
            ClockEntity ae = null;
            for (ClockEntity anAe : helper.getAssert()) {
                if (anAe.getID().compareTo(((ObeoViewpointAnimatorPersistentOptions)persistentOptions).getID()) != 0) continue;
                ae = anAe;
            }
            aab = new AnimateAssertBehaviour(ae);
            this.assertBehaviorList.add(aab);
        }
        return aab;
    }

    public RelationBehavior redoRelationBehavior(ConfigurationHelper helper, PersistentOptions persistentOptions) {
        return null;
    }

    protected boolean[] test_ElementUMLFound() {
        boolean[] tb = new boolean[this.behaviorList.size()];
        int i = 0;
        while (i < this.behaviorList.size()) {
            tb[i] = this.behaviorList.get(i).get_ce().getReferencedElement().size() > 0;
            ++i;
        }
        return tb;
    }

    private class RunnableEnd
    implements Runnable {
        private RunnableEnd() {
        }

        @Override
        public void run() {
            for (AnimateTicksBehaviour behavior : ObeoViewpointAnimatorBehaviorManager.this.behaviorList) {
                behavior.finish();
            }
        }
    }

    private final class RunnableStart
    implements Runnable {
        private RunnableStart() {
        }

        @Override
        public void run() {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            ObeoViewpointAnimatorBehaviorManager.this._airdIFile = (IFile)iWorkspaceRoot.findMember(ObeoViewpointAnimatorBehaviorManager.this._iardFilePath);
            if (ObeoViewpointAnimatorBehaviorManager.this._airdIFile == null) {
                return;
            }
            URI sessionResourceURI = URI.createPlatformResourceURI((String)ObeoViewpointAnimatorBehaviorManager.this._iardFilePath, (boolean)true);
            ObeoViewpointAnimatorBehaviorManager.this._createdSession = SessionManager.INSTANCE.getExistingSession(sessionResourceURI);
            ObeoViewpointAnimatorBehaviorManager.this._createdSession.open((IProgressMonitor)new NullProgressMonitor());
            for (AnimateTicksBehaviour behavior : ObeoViewpointAnimatorBehaviorManager.this.behaviorList) {
                DRepresentationDescriptor rd2;
                List fromCCSL_semanticObjects = behavior._ce.getReferencedElement();
                ArrayList<DRepresentation> allRepresentations = new ArrayList<DRepresentation>();
                for (DView v : ObeoViewpointAnimatorBehaviorManager.this._createdSession.getOwnedViews()) {
                    for (DRepresentationDescriptor rd2 : v.getOwnedRepresentationDescriptors()) {
                        allRepresentations.add(rd2.getRepresentation());
                    }
                }
                ArrayList allRepresentationElements = new ArrayList();
                rd2 = allRepresentations.iterator();
                while (rd2.hasNext()) {
                    DRepresentation dRepresentation = (DRepresentation)rd2.next();
                    allRepresentationElements.addAll(dRepresentation.getRepresentationElements());
                }
                ArrayList<DRepresentationElement> semanticObjectRepresentationElements = new ArrayList<DRepresentationElement>();
                for (EObject semanticObject : fromCCSL_semanticObjects) {
                    if (semanticObject instanceof EOperation) continue;
                    for (DRepresentationElement dRepresentationElement : allRepresentationElements) {
                        for (EObject reprObject : dRepresentationElement.getSemanticElements()) {
                            String reprObjectString = "";
                            int indexOfSpace = reprObject.toString().indexOf(" ");
                            if (indexOfSpace != -1) {
                                reprObjectString = (String)reprObject.toString().subSequence(indexOfSpace, reprObject.toString().length() - 1);
                            }
                            String semanticObjectString = "";
                            int indexOfSpace2 = semanticObject.toString().indexOf(" ");
                            if (indexOfSpace2 != -1) {
                                semanticObjectString = (String)semanticObject.toString().subSequence(indexOfSpace2, semanticObject.toString().length() - 1);
                            }
                            if (reprObjectString.compareTo(semanticObjectString) != 0) continue;
                            semanticObjectRepresentationElements.add(dRepresentationElement);
                        }
                    }
                }
                behavior.setRepresentation(semanticObjectRepresentationElements);
                behavior.start(ObeoViewpointAnimatorBehaviorManager.this._createdSession.getTransactionalEditingDomain());
            }
        }
    }
}

