/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.wizards.ResizableWizardDialog;
import org.eclipse.pde.internal.ui.wizards.exports.FeatureExportWizard;
import org.eclipse.ui.PlatformUI;

public class EditorBuildFeatureAction
extends Action {
    private FeatureEditor activeEditor;
    private IFile featureFile;

    public EditorBuildFeatureAction() {
        this.setText(PDEUIMessages.FeatureEditor_BuildAction_label);
    }

    private void ensureContentSaved() {
        if (this.activeEditor.isDirty()) {
            try {
                IRunnableWithProgress op = monitor -> this.activeEditor.doSave(monitor);
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PDEPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void run() {
        this.ensureContentSaved();
        FeatureExportWizard wizard = new FeatureExportWizard();
        StructuredSelection selection = this.featureFile != null ? new StructuredSelection((Object)this.featureFile) : new StructuredSelection();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
        ResizableWizardDialog wd = new ResizableWizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        wd.create();
        wd.open();
    }

    public void setActiveEditor(FeatureEditor editor) {
        this.activeEditor = editor;
        IFeatureModel model = (IFeatureModel)editor.getAggregateModel();
        this.featureFile = (IFile)model.getUnderlyingResource();
        this.setEnabled(model.isEditable());
    }
}

