/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.generator.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.Rule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gemoc.trace.commons.EcoreCraftingUtil;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class ExtensionFilter {
    private final Set<EClass> chosenClasses;
    private final Set<? extends EStructuralFeature> chosenProperties;
    private final OperationalSemanticsView executionExtension;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PRIVATE_SETTER})
    private boolean didFilterSomething = false;
    private final Set<EClass> retainedClasses = new HashSet<EClass>();
    private final Set<EStructuralFeature> retainedProperties = new HashSet<EStructuralFeature>();
    private final Set<Rule> retainedRules = new HashSet<Rule>();

    public ExtensionFilter(OperationalSemanticsView executionExtension, Set<EClass> chosenClasses, Set<? extends EStructuralFeature> chosenProperties) {
        boolean _notEquals = !Objects.equal(chosenClasses, null);
        this.chosenClasses = _notEquals ? chosenClasses : Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new EClass[0]));
        boolean _notEquals_1 = !Objects.equal(chosenProperties, null);
        this.chosenProperties = _notEquals_1 ? chosenProperties : Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new EStructuralFeature[0]));
        this.executionExtension = executionExtension;
    }

    public void execute() {
        if (!this.chosenClasses.isEmpty() || !this.chosenProperties.isEmpty()) {
            Functions.Function1<EClass, String> _function = new Functions.Function1<EClass, String>(){

                public String apply(EClass c) {
                    return EcoreCraftingUtil.getFQN((EClassifier)c, (String)".");
                }
            };
            Iterable _map = IterableExtensions.map(this.chosenClasses, (Functions.Function1)_function);
            Set chosenClassesFQNs = IterableExtensions.toSet((Iterable)_map);
            Functions.Function1<EStructuralFeature, String> _function_1 = new Functions.Function1<EStructuralFeature, String>(){

                public String apply(EStructuralFeature p) {
                    EClass _eContainingClass = p.getEContainingClass();
                    String _fQN = EcoreCraftingUtil.getFQN((EClassifier)_eContainingClass, (String)".");
                    String _plus = String.valueOf(_fQN) + ".";
                    String _name = p.getName();
                    return String.valueOf(_plus) + _name;
                }
            };
            Iterable _map_1 = IterableExtensions.map(this.chosenProperties, (Functions.Function1)_function_1);
            Set chosenPropertiesFQNs = IterableExtensions.toSet((Iterable)_map_1);
            EList _dynamicClasses = this.executionExtension.getDynamicClasses();
            for (EClass element : _dynamicClasses) {
                String fqn = EcoreCraftingUtil.getFQN((EClassifier)element, (String)".");
                boolean _contains = chosenClassesFQNs.contains(fqn);
                if (!_contains) continue;
                this.retainedClasses.add(element);
                CollectionExtensions.addAll(this.retainedClasses, (Object[])new EClass[]{element});
                EList _eStructuralFeatures = element.getEStructuralFeatures();
                this.retainedProperties.addAll((Collection<EStructuralFeature>)_eStructuralFeatures);
            }
            EList _dynamicProperties = this.executionExtension.getDynamicProperties();
            for (EStructuralFeature element_1 : _dynamicProperties) {
                EClass _eContainingClass = element_1.getEContainingClass();
                String _fQN = EcoreCraftingUtil.getFQN((EClassifier)_eContainingClass, (String)".");
                String _plus = String.valueOf(_fQN) + ".";
                String _name = element_1.getName();
                String fqn = String.valueOf(_plus) + _name;
                boolean _contains = chosenPropertiesFQNs.contains(fqn);
                if (!_contains) continue;
                this.retainedProperties.add(element_1);
                EClass _eContainingClass_1 = element_1.getEContainingClass();
                this.retainedClasses.add(_eContainingClass_1);
                EClass _eContainingClass_2 = element_1.getEContainingClass();
                CollectionExtensions.addAll(this.retainedClasses, (Object[])new EClass[]{_eContainingClass_2});
                if (!(element_1 instanceof EReference)) continue;
                EClass _eReferenceType = ((EReference)element_1).getEReferenceType();
                this.retainedClasses.add(_eReferenceType);
                EClass _eReferenceType_1 = ((EReference)element_1).getEReferenceType();
                CollectionExtensions.addAll(this.retainedClasses, (Object[])new EClass[]{_eReferenceType_1});
            }
            EList _rules = this.executionExtension.getRules();
            for (Rule element_2 : _rules) {
                boolean _isStepRule = element_2.isStepRule();
                if (!_isStepRule) continue;
                this.retainedRules.add(element_2);
                EOperation _operation = element_2.getOperation();
                EList _eParameters = _operation.getEParameters();
                Iterator _function_2 = new Functions.Function1<EParameter, EClassifier>(){

                    public EClassifier apply(EParameter p) {
                        return p.getEType();
                    }
                };
                List _map_2 = ListExtensions.map((List)_eParameters, (Functions.Function1)_function_2);
                Iterable _filter = Iterables.filter((Iterable)_map_2, EClass.class);
                for (EClass paramClass : _filter) {
                    this.retainedClasses.add(paramClass);
                }
                EOperation _operation_1 = element_2.getOperation();
                EClassifier _eType = _operation_1.getEType();
                if (_eType instanceof EClass) {
                    EOperation _operation_2 = element_2.getOperation();
                    EClassifier _eType_1 = _operation_2.getEType();
                    this.retainedClasses.add((EClass)_eType_1);
                }
                EClass _containingClass = element_2.getContainingClass();
                this.retainedClasses.add(_containingClass);
            }
            for (final EClass c1 : this.retainedClasses) {
                Functions.Function1<EClass, Boolean> _function_3 = new Functions.Function1<EClass, Boolean>(){

                    public Boolean apply(EClass c) {
                        return !Objects.equal((Object)c, (Object)c1);
                    }
                };
                Iterable _filter_1 = IterableExtensions.filter(this.retainedClasses, (Functions.Function1)_function_3);
                for (EClass c2 : _filter_1) {
                    boolean _not;
                    EList _eAllSuperTypes = c1.getEAllSuperTypes();
                    boolean _contains = _eAllSuperTypes.contains((Object)c2);
                    if (!_contains) continue;
                    boolean _hasSuperTypePathContainedIn = ExtensionFilter.hasSuperTypePathContainedIn(c1, c2, this.retainedClasses);
                    boolean bl = _not = !_hasSuperTypePathContainedIn;
                    if (!_not) continue;
                    EList _eSuperTypes = c1.getESuperTypes();
                    _eSuperTypes.add((Object)c2);
                }
            }
            for (final Rule r1 : this.retainedRules) {
                Functions.Function1<Rule, Boolean> _function_4 = new Functions.Function1<Rule, Boolean>(){

                    public Boolean apply(Rule r) {
                        return !Objects.equal((Object)r, (Object)r1);
                    }
                };
                Iterable _filter_2 = IterableExtensions.filter(this.retainedRules, (Functions.Function1)_function_4);
                for (Rule r2 : _filter_2) {
                    HashSet<Rule> _hashSet;
                    boolean _callsIndirectly = this.callsIndirectly(r1, r2, _hashSet = new HashSet<Rule>());
                    if (!_callsIndirectly) continue;
                    EList _calledRules = r1.getCalledRules();
                    _calledRules.add((Object)r2);
                }
            }
            for (final Rule r : this.retainedRules) {
                boolean _not_1;
                EList _calledRules_1 = r.getCalledRules();
                Predicate<Rule> _function_5 = new Predicate<Rule>(){

                    @Override
                    public boolean test(Rule r2) {
                        boolean _contains = ExtensionFilter.this.retainedRules.contains(r);
                        return !_contains;
                    }
                };
                _calledRules_1.removeIf((Predicate)_function_5);
                EList _overridenBy = r.getOverridenBy();
                Predicate<Rule> _function_6 = new Predicate<Rule>(){

                    @Override
                    public boolean test(Rule r2) {
                        boolean _contains = ExtensionFilter.this.retainedRules.contains(r);
                        return !_contains;
                    }
                };
                _overridenBy.removeIf((Predicate)_function_6);
                Rule _overrides = r.getOverrides();
                boolean _contains_1 = this.retainedRules.contains(_overrides);
                boolean bl = _not_1 = !_contains_1;
                if (!_not_1) continue;
                r.setOverrides(null);
            }
            TreeIterator _eAllContents = this.executionExtension.eAllContents();
            Set _set = IteratorExtensions.toSet((Iterator)_eAllContents);
            for (EObject element_3 : _set) {
                this.tryRemove(element_3);
            }
        }
    }

    public boolean callsIndirectly(Rule origin, Rule destination, Set<Rule> visited) {
        boolean _not;
        boolean _contains = visited.contains(origin);
        boolean bl = _not = !_contains;
        if (_not) {
            boolean _equals = Objects.equal((Object)origin, (Object)destination);
            if (_equals) {
                return true;
            }
            EList _calledRules = origin.getCalledRules();
            for (Rule r : _calledRules) {
                boolean result = this.callsIndirectly(r, destination, visited);
                if (!result) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<CallPath> findCallPaths(Rule origin, Rule destination, Set<Rule> mustBeContainedIn, Set<Rule> visited, boolean containedSoFar) {
        boolean _not;
        HashSet<CallPath> result = new HashSet<CallPath>();
        boolean _contains = visited.contains(origin);
        boolean bl = _not = !_contains;
        if (_not) {
            visited.add(origin);
            boolean _equals = Objects.equal((Object)origin, (Object)destination);
            if (_equals) {
                CallPath path = new CallPath();
                path.isContainedInSet = containedSoFar;
                result.add(path);
            }
            EList _calledRules = origin.getCalledRules();
            for (Rule s : _calledRules) {
                boolean containedSoFarNext = containedSoFar && mustBeContainedIn.contains(s);
                Set<CallPath> interResult = ExtensionFilter.findCallPaths(s, destination, mustBeContainedIn, visited, containedSoFarNext);
                result.addAll(interResult);
            }
        }
        return result;
    }

    private static boolean hasSuperTypePathContainedIn(EClass origin, EClass destination, final Set<EClass> containedIn) {
        boolean _equals = Objects.equal((Object)origin, (Object)destination);
        if (_equals) {
            return true;
        }
        EList _eSuperTypes = origin.getESuperTypes();
        Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass s) {
                return containedIn.contains(s);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_eSuperTypes, (Functions.Function1)_function);
        for (EClass s : _filter) {
            boolean result = ExtensionFilter.hasSuperTypePathContainedIn(s, destination, containedIn);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private Set<EObject> tryRemove(EObject element) {
        return null;
    }

    @Pure
    public boolean isDidFilterSomething() {
        return this.didFilterSomething;
    }

    private void setDidFilterSomething(boolean didFilterSomething) {
        this.didFilterSomething = didFilterSomething;
    }

    public static class CallPath {
        public boolean isContainedInSet = false;
    }
}

