/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.stategraph.views;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import org.eclipse.gemoc.addon.stategraph.logic.alg.IHullAlgorithm;
import org.eclipse.gemoc.addon.stategraph.logic.alg.JarvisMarch;

public class CycleView
extends Polygon {
    private static final IHullAlgorithm HULL_ALGORITHM = new JarvisMarch();

    public CycleView(List<Node> nodes, int cycleIndex, double hueInterval) {
        Color p = Color.hsb((double)((double)cycleIndex * hueInterval), (double)0.75, (double)0.7, (double)0.25);
        this.setFill((Paint)p);
        this.setStroke((Paint)p);
        this.setStrokeWidth(20.0);
        this.setStrokeLineJoin(StrokeLineJoin.ROUND);
        this.setStrokeType(StrokeType.OUTSIDE);
        this.updateHull(nodes, HULL_ALGORITHM);
        ChangeListener listener = (_0, _1, _2) -> this.updateHull(nodes, HULL_ALGORITHM);
        for (Node n : nodes) {
            n.translateXProperty().addListener(listener);
            n.translateYProperty().addListener(listener);
        }
    }

    private void updateHull(List<Node> nodes, IHullAlgorithm hullAlgo) {
        ArrayList<double[]> points = new ArrayList<double[]>();
        for (Node n : nodes) {
            points.add(new double[]{n.getTranslateX(), n.getTranslateY()});
        }
        ArrayList<Double> coordinates = new ArrayList<Double>();
        if (points.size() <= 3) {
            for (double[] point : points) {
                coordinates.add(point[0]);
                coordinates.add(point[1]);
            }
        } else {
            for (double[] point : hullAlgo.convexHull(points)) {
                coordinates.add(point[0]);
                coordinates.add(point[1]);
            }
        }
        this.getPoints().clear();
        this.getPoints().addAll(coordinates);
    }
}

