/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelsUtil {
    private ModelsUtil() {
    }

    private static List<EObject> getAllContentsDF(Collection<? extends EObject> elements_p, IElementFilter filter_p) {
        FOrderedSet<EObject> result = new FOrderedSet<EObject>();
        for (EObject eObject : elements_p) {
            result.addAll(ModelsUtil.getAllContentsDF(eObject, filter_p));
        }
        return result;
    }

    private static List<EObject> getAllContentsDF(EObject element_p, IElementFilter filter_p) {
        FOrderedSet<EObject> result = new FOrderedSet<EObject>();
        if (filter_p == null || filter_p.accepts(element_p)) {
            result.add(element_p);
        }
        TreeIterator it = element_p.eAllContents();
        while (it.hasNext()) {
            EObject current = (EObject)it.next();
            if (filter_p != null && !filter_p.accepts(current)) continue;
            result.add(current);
        }
        return result;
    }

    private static void getAllContentsBF(LinkedList<EObject> elements_p, List<EObject> result_p, IElementFilter filter_p) {
        if (!elements_p.isEmpty()) {
            EObject current = elements_p.poll();
            if (filter_p == null || filter_p.accepts(current)) {
                result_p.add(current);
                elements_p.addAll((Collection<EObject>)current.eContents());
            }
            ModelsUtil.getAllContentsBF(elements_p, result_p, filter_p);
        }
    }

    public static List<EObject> getAllContents(EObject element_p, boolean depthFirst_p, IElementFilter filter_p) {
        return ModelsUtil.getAllContents(Collections.singletonList(element_p), depthFirst_p, filter_p);
    }

    public static List<EObject> getAllContents(Collection<? extends EObject> elements_p, boolean depthFirst_p, IElementFilter filter_p) {
        Collection<Object> result;
        if (depthFirst_p) {
            result = ModelsUtil.getAllContentsDF(elements_p, filter_p);
        } else {
            result = new FOrderedSet();
            ModelsUtil.getAllContentsBF(new LinkedList<EObject>(elements_p), result, filter_p);
        }
        return result;
    }

    public static List<EObject> getAncestors(EObject element_p) {
        if (element_p == null) {
            return new FOrderedSet();
        }
        List<EObject> containerList = ModelsUtil.getAncestors(element_p.eContainer());
        containerList.add(element_p);
        return containerList;
    }

    public static EObject getCommonAncestor(Collection<? extends EObject> elements_p, boolean acceptSelf_p) {
        if (elements_p == null || elements_p.isEmpty()) {
            return null;
        }
        Iterator<? extends EObject> it = elements_p.iterator();
        List<EObject> commonHierarchy = ModelsUtil.getAncestors(it.next());
        while (it.hasNext()) {
            List<EObject> currentHierarchy = ModelsUtil.getAncestors(it.next());
            commonHierarchy.retainAll(currentHierarchy);
        }
        if (!acceptSelf_p) {
            commonHierarchy.removeAll(elements_p);
        }
        if (commonHierarchy.isEmpty()) {
            return null;
        }
        return commonHierarchy.get(commonHierarchy.size() - 1);
    }

    public static EObject getCommonAncestor(EObject first_p, EObject second_p) {
        if (first_p == null || second_p == null) {
            return null;
        }
        return ModelsUtil.getCommonAncestor(Arrays.asList(first_p, second_p), true);
    }

    public static EClass getCommonType(Collection<? extends EObject> elements_p) {
        EClass result = null;
        if (!elements_p.isEmpty()) {
            ArrayList<EClass> common = new ArrayList<EClass>(ModelsUtil.getSuperTypes(elements_p.iterator().next().eClass()));
            for (EObject eObject : elements_p) {
                common.retainAll(ModelsUtil.getSuperTypes(eObject.eClass()));
            }
            if (!common.isEmpty()) {
                result = (EClass)common.get(common.size() - 1);
            }
        }
        return result;
    }

    public static int getDepth(EObject element_p) {
        if (element_p == null) {
            return 0;
        }
        return 1 + ModelsUtil.getDepth(element_p.eContainer());
    }

    public static int getDepth(Iterable<? extends EObject> elements_p, boolean max_p) {
        int result = max_p ? 0 : Integer.MAX_VALUE;
        for (EObject eObject : elements_p) {
            int depth = ModelsUtil.getDepth(eObject);
            int n = result = max_p ? Math.max(result, depth) : Math.min(result, depth);
        }
        return result;
    }

    public static List<EObject> getLeaves(Collection<? extends EObject> elements_p) {
        FOrderedSet<EObject> result = new FOrderedSet<EObject>();
        for (EObject eObject : elements_p) {
            result.addAll(ModelsUtil.getLeaves(eObject));
        }
        return result;
    }

    public static List<EObject> getLeaves(EObject element_p) {
        List<EObject> result = element_p.eContents().isEmpty() ? Collections.singletonList(element_p) : ModelsUtil.getLeaves((Collection<? extends EObject>)element_p.eContents());
        return result;
    }

    public static <T extends EObject> List<T> getRoots(Collection<? extends T> elements_p) {
        FOrderedSet<EObject> result = new FOrderedSet<EObject>();
        FOrderedSet<T> elements = new FOrderedSet<T>(elements_p, null);
        for (EObject element : elements) {
            if (result.contains(element) || !ModelsUtil.isRootAmong(element, elements)) continue;
            result.add(element);
        }
        return result;
    }

    private static List<EClass> getSuperTypes(EClass class_p) {
        EList allButSelf = class_p.getEAllSuperTypes();
        ArrayList<EClass> result = new ArrayList<EClass>(allButSelf.size() + 1);
        result.addAll((Collection<EClass>)allButSelf);
        result.add(class_p);
        return Collections.unmodifiableList(result);
    }

    private static boolean isRootAmong(EObject element_p, Collection<? extends EObject> elements_p) {
        FOrderedSet<? extends EObject> filtered = new FOrderedSet<EObject>(elements_p, null);
        filtered.remove(element_p);
        return !EcoreUtil.isAncestor(filtered, (EObject)element_p);
    }

    public static interface IElementFilter {
        public boolean accepts(EObject var1);
    }
}

